/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.searchsubs;

import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;

public class ColumnSearchSubResultSize
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "size";

    public ColumnSearchSubResultSize(TableColumn column) {
        column.initialize(2, -2, 80);
        column.addListeners(this);
        column.setRefreshInterval(-3);
        column.setType(3);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase rc = (SearchSubsResultBase)cell.getDataSource();
        if (rc == null) {
            return;
        }
        long size = rc.getSize();
        if (size > 0L && cell.setSortValue(size)) {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(size));
            TableColumnSWTUtils.setSizeAlpha(cell, size);
        }
    }
}

