/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.searchsubs;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.search.SBC_SearchResultsView;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.util.StringCompareUtils;
import java.net.URL;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ColumnSearchSubResultActions
implements TableCellSWTPaintListener,
TableCellRefreshListener,
TableCellMouseMoveListener,
TableCellAddedListener {
    public static final String COLUMN_ID = "actions";
    private Color colorLinkNormal;
    private Color colorLinkHover;
    private static Font font = null;
    boolean bMouseDowned = false;

    public ColumnSearchSubResultActions(TableColumn column) {
        column.initialize(1, -2, 180);
        column.addListeners(this);
        column.setRefreshInterval(-3);
        column.setType(2);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
        }
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        SearchSubsResultBase entry = (SearchSubsResultBase)cell.getDataSource();
        if (entry == null) {
            return;
        }
        TableRow row = cell.getTableRow();
        if (row == null) {
            return;
        }
        String text = (String)row.getData("text");
        if (text != null && text.length() > 0) {
            if (font == null) {
                FontData[] fontData = gc.getFont().getFontData();
                fontData[0].setStyle(1);
                font = new Font(gc.getDevice(), fontData);
            }
            gc.setFont(font);
            Rectangle bounds = this.getDrawBounds(cell);
            GCStringPrinter sp = new GCStringPrinter(gc, text, bounds, true, true, 0x1000040);
            sp.calculateMetrics();
            if (sp.hasHitUrl()) {
                GCStringPrinter.URLInfo[] hitUrlInfo = sp.getHitUrlInfo();
                int i = 0;
                while (i < hitUrlInfo.length) {
                    GCStringPrinter.URLInfo info = hitUrlInfo[i];
                    info.urlUnderline = cell.getTableRow() == null || cell.getTableRow().isSelected();
                    info.urlColor = info.urlUnderline ? null : this.colorLinkNormal;
                    ++i;
                }
                int[] mouseOfs = cell.getMouseOffset();
                if (mouseOfs != null) {
                    Rectangle realBounds = cell.getBounds();
                    GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(mouseOfs[0] + realBounds.x, mouseOfs[1] + realBounds.y);
                    if (hitUrl != null) {
                        hitUrl.urlColor = this.colorLinkHover;
                    }
                }
            }
            sp.printString();
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase entry = (SearchSubsResultBase)cell.getDataSource();
        if (entry == null) {
            return;
        }
        String link = entry.getTorrentLink();
        String details = entry.getDetailsLink();
        if (!cell.setSortValue((Comparable)((Object)link)) && cell.isValid()) {
            return;
        }
        boolean canDL = link != null && link.length() > 0;
        boolean canDetails = details != null && details.length() > 0;
        StringBuilder sb = new StringBuilder();
        if (canDL) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            String action = link.startsWith("chat:") ? MessageText.getString("label.view") : (link.startsWith("azplug:?id=subscription") ? MessageText.getString("subscriptions.listwindow.subscribe") : MessageText.getString("label.download"));
            sb.append("<A HREF=\"download\">" + action + "</A>");
        }
        if (canDetails) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("<A HREF=\"details\">" + MessageText.getString("label.details") + "</A>");
        }
        cell.getTableRow().setData("text", sb.toString());
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String oldTooltip;
        Object o;
        GCStringPrinter sp;
        Rectangle bounds;
        boolean invalidateAndRefresh;
        String tooltip;
        SearchSubsResultBase entry;
        block23: {
            entry = (SearchSubsResultBase)event2.cell.getDataSource();
            tooltip = null;
            invalidateAndRefresh = false;
            bounds = ((TableCellSWT)event2.cell).getBounds();
            String text = (String)event2.cell.getTableRow().getData("text");
            if (text == null) {
                return;
            }
            sp = null;
            GC gc = new GC((Drawable)Display.getDefault());
            try {
                try {
                    if (font != null) {
                        gc.setFont(font);
                    }
                    Rectangle drawBounds = this.getDrawBounds((TableCellSWT)event2.cell);
                    sp = new GCStringPrinter(gc, text, drawBounds, true, true, 0x1000040);
                    sp.calculateMetrics();
                }
                catch (Exception e) {
                    Debug.out(e);
                    gc.dispose();
                    break block23;
                }
            }
            catch (Throwable throwable) {
                gc.dispose();
                throw throwable;
            }
            gc.dispose();
        }
        if (sp != null) {
            int newCursor;
            GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(event2.x + bounds.x, event2.y + bounds.y);
            if (hitUrl != null) {
                if (event2.eventType == 1 && event2.button == 1) {
                    if (hitUrl.url.equals("download")) {
                        SBC_SearchResultsView.downloadAction(entry);
                    } else if (hitUrl.url.equals("details")) {
                        String details_url = entry.getDetailsLink();
                        try {
                            Utils.launch(new URL(details_url));
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                } else if (hitUrl.url.equals("download")) {
                    tooltip = entry.getTorrentLink();
                } else if (hitUrl.url.equals("details")) {
                    tooltip = entry.getDetailsLink();
                }
                newCursor = 21;
            } else {
                newCursor = 0;
            }
            int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
            if (oldCursor != newCursor) {
                invalidateAndRefresh = true;
                ((TableCellSWT)event2.cell).setCursorID(newCursor);
            }
        }
        if (((o = event2.cell.getToolTip()) == null || o instanceof String) && !StringCompareUtils.equals(oldTooltip = (String)o, tooltip)) {
            invalidateAndRefresh = true;
            event2.cell.setToolTip(tooltip);
        }
        if (invalidateAndRefresh) {
            event2.cell.invalidate();
            ((TableCellSWT)event2.cell).redraw();
        }
    }

    private Rectangle getDrawBounds(TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        bounds.height -= 12;
        bounds.y += 6;
        bounds.x += 4;
        bounds.width -= 4;
        return bounds;
    }
}

