/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.browser.listener;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.messenger.ClientMessageContext;
import com.biglybt.core.messenger.browser.BrowserMessage;
import com.biglybt.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.ui.selectedcontent.DownloadUrlInfo;
import com.biglybt.ui.swt.utils.TorrentUIUtilsV3;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.gudy.bouncycastle.util.encoders.Base64;

public class TorrentListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "torrent";
    public static final String OP_LOAD_TORRENT_OLD = "loadTorrent";
    public static final String OP_LOAD_TORRENT = "load-torrent";
    private ClientMessageContext.torrentURLHandler torrentURLHandler;

    public TorrentListener(String id) {
        super(id);
    }

    public TorrentListener() {
        this(DEFAULT_LISTENER_ID);
    }

    public void setTorrentURLHandler(ClientMessageContext.torrentURLHandler handler) {
        this.torrentURLHandler = handler;
    }

    public void setShell(Shell shell) {
    }

    @Override
    public void handleMessage(final BrowserMessage message) {
        String opid = message.getOperationId();
        if (OP_LOAD_TORRENT.equals(opid) || OP_LOAD_TORRENT_OLD.equals(opid)) {
            final Map decodedMap = message.getDecodedMap();
            String url = MapUtils.getMapString(decodedMap, "url", null);
            final boolean playNow = MapUtils.getMapBoolean(decodedMap, "play-now", false);
            final boolean playPrepare = MapUtils.getMapBoolean(decodedMap, "play-prepare", false);
            final boolean bringToFront = MapUtils.getMapBoolean(decodedMap, "bring-to-front", true);
            if (url != null) {
                if (this.torrentURLHandler != null) {
                    try {
                        this.torrentURLHandler.handleTorrentURL(url);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                final DownloadUrlInfo dlInfo = new DownloadUrlInfo(url);
                dlInfo.setReferer(message.getReferer());
                CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, playPrepare, bringToFront);
                    }
                });
            } else {
                CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        TorrentListener.loadTorrentByB64(core, message, MapUtils.getMapString(decodedMap, "b64", null));
                    }
                });
            }
        } else {
            throw new IllegalArgumentException("Unknown operation: " + opid);
        }
    }

    public static boolean loadTorrentByB64(Core core, String b64) {
        return TorrentListener.loadTorrentByB64(core, null, b64);
    }

    private static boolean loadTorrentByB64(Core core, BrowserMessage message, String b64) {
        String filename;
        block7: {
            if (b64 == null) {
                return false;
            }
            byte[] decodedTorrent = Base64.decode(b64);
            try {
                File tempTorrentFile = File.createTempFile("AZU", ".torrent");
                tempTorrentFile.deleteOnExit();
                filename = tempTorrentFile.getAbsolutePath();
                FileUtil.writeBytesAsFile(filename, decodedTorrent);
                TOTorrent torrent = TorrentUtils.readFromFile(tempTorrentFile, false);
                if (PlatformTorrentUtils.isPlatformTracker(torrent)) break block7;
                Debug.out("stopped loading torrent because it's not in whitelist");
                return false;
            }
            catch (Throwable t) {
                if (message != null) {
                    message.debug("loadUrl error", t);
                } else {
                    Debug.out(t);
                }
                return false;
            }
        }
        String savePath = COConfigurationManager.getStringParameter("Default save path");
        if (savePath == null || savePath.length() == 0) {
            savePath = ".";
        }
        core.getGlobalManager().addDownloadManager(filename, savePath);
        return true;
    }
}

