/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.browser.listener;

import com.biglybt.core.messenger.browser.BrowserMessage;
import com.biglybt.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.donations.DonationWindow;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.util.MapUtils;
import java.util.Map;

public class DisplayListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "display";
    public static final String OP_COPY_TO_CLIPBOARD = "copy-text";
    public static final String OP_BRING_TO_FRONT = "bring-to-front";
    public static final String OP_SHOW_DONATION_WINDOW = "show-donation-window";
    public static final String OP_OPEN_SEARCH = "open-search";

    public DisplayListener(String id) {
        super(id);
    }

    public DisplayListener() {
        this(DEFAULT_LISTENER_ID);
    }

    @Override
    public void handleMessage(BrowserMessage message) {
        String opid = message.getOperationId();
        if (OP_COPY_TO_CLIPBOARD.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            ClipboardCopy.copyToClipBoard(MapUtils.getMapString(decodedMap, "text", ""));
        } else if (OP_BRING_TO_FRONT.equals(opid)) {
            this.bringToFront();
        } else if (OP_SHOW_DONATION_WINDOW.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            DonationWindow.open(true, MapUtils.getMapString(decodedMap, "source-ref", "RPC"));
        } else if (OP_OPEN_SEARCH.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif != null) {
                uif.doSearch(MapUtils.getMapString(decodedMap, "search-text", ""));
            }
        } else {
            throw new IllegalArgumentException("Unknown operation: " + opid);
        }
    }

    private void bringToFront() {
        UIFunctions functions = UIFunctionsManager.getUIFunctions();
        if (functions != null) {
            functions.bringToFront();
        }
    }
}

