/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.associations;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class AssociationChecker {
    protected PlatformManager platform;
    protected Display display;
    protected Shell shell;

    public static void checkAssociations() {
        try {
            PlatformManager platform = PlatformManagerFactory.getPlatformManager();
            if (platform.hasCapability(PlatformManagerCapabilities.RegisterFileAssociations) && COConfigurationManager.getBooleanParameter("config.interface.checkassoc") && !platform.isApplicationRegistered()) {
                new AssociationChecker(platform);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected AssociationChecker(PlatformManager _platform) {
        this.platform = _platform;
        this.display = Utils.getDisplay();
        if (this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                AssociationChecker.this.check();
            }
        });
    }

    protected void check() {
        if (this.display.isDisposed()) {
            return;
        }
        this.shell = ShellFactory.createMainShell(2144);
        Utils.setShellIcon(this.shell);
        this.shell.setText(MessageText.getString("dialog.associations.title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        Label user_label = new Label((Composite)this.shell, 0);
        Messages.setLanguageText((Widget)user_label, "dialog.associations.prompt");
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        user_label.setLayoutData((Object)gridData);
        final Button checkBox = new Button((Composite)this.shell, 32);
        checkBox.setSelection(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        checkBox.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)checkBox, "dialog.associations.askagain");
        Label labelSeparator = new Label((Composite)this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        new Label((Composite)this.shell, 0);
        Button bYes = new Button((Composite)this.shell, 8);
        bYes.setText(MessageText.getString("Button.yes"));
        gridData = new GridData(896);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 70;
        bYes.setLayoutData((Object)gridData);
        bYes.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AssociationChecker.this.close(true, checkBox.getSelection());
            }
        });
        Button bNo = new Button((Composite)this.shell, 8);
        bNo.setText(MessageText.getString("Button.no"));
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        bNo.setLayoutData((Object)gridData);
        bNo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AssociationChecker.this.close(false, checkBox.getSelection());
            }
        });
        bYes.setFocus();
        this.shell.setDefaultButton(bYes);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    AssociationChecker.this.close(false, true);
                }
            }
        });
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    protected void close(boolean ok, boolean check_on_startup) {
        if (check_on_startup != COConfigurationManager.getBooleanParameter("config.interface.checkassoc")) {
            COConfigurationManager.setParameter("config.interface.checkassoc", check_on_startup);
            COConfigurationManager.save();
        }
        if (ok) {
            try {
                this.platform.registerApplication();
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        this.shell.dispose();
    }
}

