/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.ui.swt.UISwitcherListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class UISwitcherUtil {
    private static final long UPTIME_NEWUSER = 3600L;
    private static ArrayList listeners = new ArrayList();
    private static String switchedToUI = null;

    public static void addListener(UISwitcherListener l) {
        listeners.add(l);
        if (switchedToUI != null) {
            UISwitcherUtil.triggerListeners(switchedToUI);
        }
    }

    public static void removeListener(UISwitcherListener l) {
        listeners.remove(l);
    }

    public static void openSwitcherWindow() {
        UISwitcherUtil._openSwitcherWindow();
    }

    public static void triggerListeners(String ui) {
        Object[] array = listeners.toArray();
        int i = 0;
        while (i < array.length) {
            UISwitcherListener l = (UISwitcherListener)array[i];
            l.uiSwitched(ui);
            ++i;
        }
    }

    public static String calcUIMode() {
        if ("1".equals(System.getProperty(SystemProperties.SYSPROP_SAFEMODE))) {
            return "az2";
        }
        String lastUI = COConfigurationManager.getStringParameter("ui", "az2");
        COConfigurationManager.setParameter("lastUI", lastUI);
        String forceUI = System.getProperty("force.ui");
        if (forceUI != null) {
            COConfigurationManager.setParameter("ui", forceUI);
            return forceUI;
        }
        boolean installLogExists = FileUtil.getApplicationFile("installer.log").exists();
        boolean alreadySwitched = COConfigurationManager.getBooleanParameter("installer.ui.alreadySwitched", false);
        if (!alreadySwitched && installLogExists) {
            COConfigurationManager.setParameter("installer.ui.alreadySwitched", true);
            COConfigurationManager.setParameter("ui", "az3");
            COConfigurationManager.setParameter("az3.virgin.switch", true);
            return "az3";
        }
        boolean asked = COConfigurationManager.getBooleanParameter("ui.asked", false);
        if (asked || COConfigurationManager.hasParameter("ui", true)) {
            return COConfigurationManager.getStringParameter("ui", "az3");
        }
        COConfigurationManager.setParameter("ui", "az3");
        return "az3";
    }

    public static void _openSwitcherWindow() {
        Class<?> uiswClass = null;
        try {
            uiswClass = Class.forName("com.biglybt.ui.swt.shells.uiswitcher.UISwitcherWindow");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (uiswClass == null) {
            return;
        }
        try {
            Constructor<?> constructor = uiswClass.getConstructor(new Class[0]);
            Object object = constructor.newInstance(new Object[0]);
            Method method = uiswClass.getMethod("open", new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }
}

