/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.speedmanager.SpeedLimitHandler;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.util.TRTrackerUtils;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HTTPUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.GraphicURI;
import com.biglybt.pif.ui.menus.MenuBuilder;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.ui.menus.MenuItemImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableStructureEventDispatcher;
import com.biglybt.ui.common.table.impl.TableContextMenuManager;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.swt.ListenerDMTask;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mainwindow.SelectableSpeedMenu;
import com.biglybt.ui.swt.minibar.DownloadBar;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.sharing.ShareUtils;
import com.biglybt.ui.swt.views.FilesViewMenuUtil;
import com.biglybt.ui.swt.views.columnsetup.TableColumnSetupWindow;
import com.biglybt.ui.swt.views.table.TableSelectedRowsListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TorrentMenuFancy {
    private static final String HEADER_MSG_PREFIX = "FancyMenu.Header.";
    protected static final boolean DEBUG_MENU = false;
    private static final int SHELL_MARGIN = 1;
    private List<FancyRowInfo> listRowInfos = new ArrayList<FancyRowInfo>();
    private List<HeaderInfo> listHeaders = new ArrayList<HeaderInfo>();
    private Composite topArea;
    private Composite detailArea;
    private Listener headerListener;
    private TableViewSWT<DownloadManager> tv;
    private boolean isSeedingView;
    private Shell parentShell;
    private DownloadManager[] dms;
    private String tableID;
    private boolean hasSelection;
    private Shell shell;
    private Listener listenerForTrigger;
    private Listener listenerRow;
    private PaintListener listenerRowPaint;
    private TableColumnCore column;
    private HeaderInfo activatedHeader;
    private Menu currentMenu;
    private FancyRowInfo currentRowInfo;
    private Point originalShellLocation;
    private boolean subMenuVisible;
    private PaintListener paintListenerArrow;

    public TorrentMenuFancy(TableViewSWT<DownloadManager> tv, boolean isSeedingView, Shell parentShell, DownloadManager[] dms, String tableID) {
        this.tv = tv;
        this.isSeedingView = isSeedingView;
        this.parentShell = parentShell;
        this.dms = dms;
        this.tableID = tableID;
        this.hasSelection = dms.length > 0;
        this.listenerForTrigger = new Listener(){

            public void handleEvent(Event event2) {
                FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo(event2.widget);
                if (rowInfo != null) {
                    Rectangle row_bounds = rowInfo.getRow().getBounds();
                    if (!rowInfo.keepMenu()) {
                        TorrentMenuFancy.this.shell.dispose();
                    }
                    if (rowInfo.getListener() != null) {
                        row_bounds.y = 0;
                        row_bounds.x = 0;
                        if (row_bounds.contains(event2.x, event2.y)) {
                            rowInfo.getListener().handleEvent(event2);
                        }
                    }
                } else {
                    TorrentMenuFancy.this.shell.dispose();
                }
            }
        };
        this.paintListenerArrow = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Control c = (Control)e.widget;
                Point size = c.getSize();
                int arrowSize = 8;
                int xStart = size.x - arrowSize;
                int yStart = size.y - (size.y + arrowSize) / 2;
                e.gc.setBackground(Colors.getSystemColor((Device)e.display, 21));
                e.gc.setAntialias(1);
                e.gc.fillPolygon(new int[]{xStart, yStart, xStart + arrowSize, yStart + arrowSize / 2, xStart, yStart + arrowSize});
            }
        };
        this.listenerRow = event2 -> {
            FancyRowInfo lastRowInfo = this.currentRowInfo;
            if (event2.type == 7) {
                this.currentRowInfo = null;
            } else if (event2.type == 6) {
                this.currentRowInfo = this.findRowInfo(event2.widget);
            }
            if (lastRowInfo != null) {
                lastRowInfo.redraw();
            }
            if (this.currentRowInfo != null && this.currentRowInfo != lastRowInfo) {
                this.currentRowInfo.redraw();
            }
        };
        this.listenerRowPaint = new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean isSelected;
                FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo(e.widget);
                if (rowInfo == null) {
                    return;
                }
                boolean bl = isSelected = TorrentMenuFancy.this.currentRowInfo == rowInfo;
                if (!isSelected) {
                    Control[] controlArray = ((Composite)e.widget).getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.setBackground(null);
                        if (!Utils.hasSkinnedForeground(control)) {
                            control.setForeground(null);
                        }
                        ++n2;
                    }
                    return;
                }
                Rectangle bounds = ((Control)e.widget).getBounds();
                Color bg = Colors.getSystemColor((Device)e.display, Utils.isDarkAppearanceNativeWindows() ? 19 : 25);
                int arc = bounds.height / 3;
                e.gc.setBackground(bg);
                e.gc.setForeground(Colors.getSystemColor((Device)e.display, 17));
                e.gc.setAntialias(1);
                e.gc.fillRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, arc, arc);
                e.gc.setAlpha(100);
                e.gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, arc, arc);
                Color fg = Colors.getSystemColor((Device)e.display, 24);
                Control[] controlArray = ((Composite)e.widget).getChildren();
                int n = controlArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Control control = controlArray[n3];
                    control.setBackground(bg);
                    if (!Utils.hasSkinnedForeground(control)) {
                        control.setForeground(fg);
                    }
                    ++n3;
                }
            }
        };
    }

    public void showMenu(Point locationOnDiplay, TableColumnCore acolumn, final Menu fallbackMenu) {
        this.column = acolumn;
        Display d = this.parentShell.getDisplay();
        this.shell = new Shell(this.parentShell, 0x20000008){

            protected void checkSubclass() {
            }

            public void dispose() {
                super.dispose();
            }
        };
        RowLayout shellLayout = new RowLayout(512);
        shellLayout.fill = true;
        shellLayout.marginTop = 0;
        shellLayout.marginRight = 0;
        shellLayout.marginLeft = 0;
        shellLayout.marginBottom = 0;
        shellLayout.marginHeight = 1;
        shellLayout.marginWidth = 1;
        this.shell.setLayout((Layout)shellLayout);
        this.topArea = new Composite((Composite)this.shell, 0x20000000);
        this.detailArea = new Composite((Composite)this.shell, 0x20000000);
        this.topArea.setBackground(Colors.getSystemColor((Device)d, 25));
        this.topArea.setForeground(Colors.getSystemColor((Device)d, 24));
        FormData fd = Utils.getFilledFormData();
        fd.bottom = null;
        RowLayout topLayout = new RowLayout(256);
        topLayout.spacing = 0;
        topLayout.pack = true;
        topLayout.marginRight = 0;
        topLayout.marginLeft = 0;
        topLayout.marginTop = 0;
        topLayout.marginBottom = 0;
        this.topArea.setLayout((Layout)topLayout);
        fd = Utils.getFilledFormData();
        fd.top = new FormAttachment((Control)this.topArea, 0, 1024);
        FormLayout layoutDetailsArea = new FormLayout();
        layoutDetailsArea.marginWidth = 2;
        layoutDetailsArea.marginBottom = 2;
        this.detailArea.setLayout((Layout)layoutDetailsArea);
        this.headerListener = new Listener(){

            public void handleEvent(Event e) {
                Object data;
                Control control = (Control)e.widget;
                if (e.type == 9) {
                    Rectangle bounds = control.getBounds();
                    int y = bounds.height - 2;
                    e.gc.drawLine(0, y, bounds.width, y);
                } else if ((e.type == 6 || e.type == 47) && (data = e.widget.getData("ID")) instanceof HeaderInfo) {
                    HeaderInfo header = (HeaderInfo)data;
                    TorrentMenuFancy.this.activateHeader(header);
                }
            }
        };
        HeaderInfo firstHeader = this.addHeader("Control", "FancyMenu.Header.Control", new AERunnable(){

            @Override
            public void runSupport() {
                TorrentMenuFancy.this.buildTorrentCustomMenu_Control(TorrentMenuFancy.this.detailArea, TorrentMenuFancy.this.dms);
            }
        });
        this.addHeader("Content", "FancyMenu.Header.Content", new AERunnable(){

            @Override
            public void runSupport() {
                TorrentMenuFancy.this.buildTorrentCustomMenu_Content(TorrentMenuFancy.this.detailArea, TorrentMenuFancy.this.dms);
            }
        });
        this.addHeader("Organize", "FancyMenu.Header.Organize", new AERunnable(){

            @Override
            public void runSupport() {
                TorrentMenuFancy.this.buildTorrentCustomMenu_Organize(TorrentMenuFancy.this.detailArea, TorrentMenuFancy.this.dms);
            }
        });
        this.addHeader("Social", "FancyMenu.Header.Social", new AERunnable(){

            @Override
            public void runSupport() {
                TorrentMenuFancy.this.buildTorrentCustomMenu_Social(TorrentMenuFancy.this.detailArea);
            }
        });
        List<com.biglybt.pif.ui.menus.MenuItem> listOtherItems = this.getPluginItems("Other");
        if (listOtherItems.size() > 0) {
            this.addHeader("Other", "FancyMenu.Header.Other", null);
        }
        this.originalShellLocation = locationOnDiplay;
        this.shell.setLocation(this.originalShellLocation);
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(Colors.getSystemColor((Device)e.display, 23));
                Rectangle clientArea = TorrentMenuFancy.this.shell.getClientArea();
                e.gc.drawRectangle(0, 0, clientArea.width - 1, clientArea.height - 1);
            }
        });
        this.shell.addListener(1, e -> {
            FancyRowInfo lastRowInfo = this.currentRowInfo;
            block0 : switch (e.keyCode) {
                case 0x1000002: {
                    if (this.currentRowInfo == null) {
                        this.currentRowInfo = this.listRowInfos.get(0);
                        break;
                    }
                    boolean next = false;
                    for (FancyRowInfo rowInfo : this.listRowInfos) {
                        if (next) {
                            this.currentRowInfo = rowInfo;
                            next = false;
                            break;
                        }
                        if (rowInfo != this.currentRowInfo) continue;
                        next = true;
                    }
                    if (!next) break;
                    this.currentRowInfo = this.listRowInfos.get(0);
                    break;
                }
                case 0x1000001: {
                    if (this.currentRowInfo == null) {
                        this.currentRowInfo = this.listRowInfos.get(this.listRowInfos.size() - 1);
                        break;
                    }
                    FancyRowInfo previous = this.listRowInfos.get(this.listRowInfos.size() - 1);
                    for (FancyRowInfo rowInfo : this.listRowInfos) {
                        if (rowInfo == this.currentRowInfo) {
                            this.currentRowInfo = previous;
                            break block0;
                        }
                        previous = rowInfo;
                    }
                    break;
                }
                case 0x1000003: {
                    HeaderInfo previous = this.listHeaders.get(this.listHeaders.size() - 1);
                    for (HeaderInfo header : this.listHeaders) {
                        if (header == this.activatedHeader) {
                            this.activateHeader(previous);
                            break block0;
                        }
                        previous = header;
                    }
                    break;
                }
                case 0x1000004: {
                    if (this.currentRowInfo != null && this.currentRowInfo.hasSubMenu()) {
                        Event event2 = new Event();
                        event2.display = e.display;
                        event2.widget = this.currentRowInfo.cRow;
                        this.listenerForTrigger.handleEvent(event2);
                        break;
                    }
                    boolean next = false;
                    for (HeaderInfo header : this.listHeaders) {
                        if (next) {
                            this.activateHeader(header);
                            next = false;
                            break;
                        }
                        if (header != this.activatedHeader) continue;
                        next = true;
                    }
                    if (!next) break;
                    this.activateHeader(this.listHeaders.get(0));
                }
            }
            if (lastRowInfo != null) {
                lastRowInfo.redraw();
            }
            if (this.currentRowInfo != null && lastRowInfo != this.currentRowInfo) {
                this.currentRowInfo.redraw();
            }
        });
        if (fallbackMenu != null) {
            firstHeader.composite.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    TorrentMenuFancy.this.shell.dispose();
                    fallbackMenu.setVisible(true);
                }
            });
        }
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    TorrentMenuFancy.this.shell.dispose();
                } else if (e.detail == 4 && TorrentMenuFancy.this.currentRowInfo != null) {
                    Event event2 = new Event();
                    event2.display = e.display;
                    event2.widget = TorrentMenuFancy.this.currentRowInfo.cRow;
                    TorrentMenuFancy.this.listenerForTrigger.handleEvent(event2);
                }
            }
        });
        this.shell.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
                Utils.execSWTThreadLater(0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (TorrentMenuFancy.this.subMenuVisible) {
                            return;
                        }
                        if (TorrentMenuFancy.this.shell.isDisposed()) {
                            return;
                        }
                        Shell[] shells = TorrentMenuFancy.this.shell.getShells();
                        if (shells != null && shells.length > 0) {
                            Shell[] shellArray = shells;
                            int n = shells.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Shell aShell = shellArray[n2];
                                if (!aShell.isDisposed()) {
                                    return;
                                }
                                ++n2;
                            }
                        }
                        TorrentMenuFancy.this.shell.dispose();
                    }
                });
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
            }
        });
        this.activateHeader(firstHeader);
        this.shell.open();
    }

    private List<com.biglybt.pif.ui.menus.MenuItem> getPluginItems(String headerID) {
        ArrayList<com.biglybt.pif.ui.menus.MenuItem> listPluginItems = new ArrayList<com.biglybt.pif.ui.menus.MenuItem>();
        com.biglybt.pif.ui.menus.MenuItem[] items = TableContextMenuManager.getInstance().getAllAsArray(Utils.getBaseViewID(this.tableID));
        listPluginItems.addAll(Arrays.asList(items));
        items = MenuItemManager.getInstance().getAllAsArray("download_context");
        listPluginItems.addAll(Arrays.asList(items));
        if (this.column != null) {
            items = this.column.getContextMenuItems(2);
            listPluginItems.addAll(Arrays.asList(items));
        }
        boolean isOther = headerID.equals("Other");
        ArrayList<com.biglybt.pif.ui.menus.MenuItem> result = new ArrayList<com.biglybt.pif.ui.menus.MenuItem>();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        for (com.biglybt.pif.ui.menus.MenuItem item : listPluginItems) {
            int minUserMode;
            String headerCategory = item.getHeaderCategory();
            if (!headerID.equals(headerCategory) && (!isOther || headerCategory != null) || userMode < (minUserMode = item.getMinUserMode())) continue;
            result.add(item);
        }
        return result;
    }

    protected void activateHeader(HeaderInfo header) {
        if (header == null || this.activatedHeader == header) {
            return;
        }
        if (this.currentMenu != null && !this.currentMenu.isDisposed()) {
            this.currentMenu.setVisible(false);
        }
        Display d = header.composite.getDisplay();
        header.composite.setBackground(Colors.getSystemColor((Device)d, 22));
        header.composite.setForeground(Colors.getSystemColor((Device)d, 21));
        Utils.disposeSWTObjects(this.detailArea.getChildren());
        this.listRowInfos.clear();
        this.currentRowInfo = null;
        if (header.runnable != null) {
            header.runnable.run();
        }
        List<com.biglybt.pif.ui.menus.MenuItem> pluginItems = this.getPluginItems(header.id);
        for (com.biglybt.pif.ui.menus.MenuItem item : pluginItems) {
            this.addPluginItem(this.detailArea, item);
        }
        Control lastControl = null;
        Control[] controlArray = this.detailArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            FormData fd = new FormData();
            fd.top = lastControl == null ? new FormAttachment(0) : new FormAttachment(lastControl);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            child.setLayoutData((Object)fd);
            lastControl = child;
            ++n2;
        }
        this.shell.setLocation(this.shell.getLocation().x, this.originalShellLocation.y);
        this.detailArea.moveBelow(null);
        this.shell.pack(true);
        this.detailArea.layout(true, true);
        Point shellSize = this.shell.getSize();
        Point ptBottomRight = this.shell.toDisplay(shellSize);
        Rectangle monitorArea = this.shell.getMonitor().getClientArea();
        if (ptBottomRight.x > monitorArea.x + monitorArea.width) {
            this.shell.setLocation(monitorArea.x + monitorArea.width - shellSize.x, this.shell.getLocation().y);
        }
        if (ptBottomRight.y > monitorArea.y + monitorArea.height && this.shell.getChildren()[0] != this.detailArea) {
            this.shell.setLocation(this.shell.getLocation().x, this.originalShellLocation.y - this.detailArea.getSize().y - 3);
            this.detailArea.moveAbove(null);
            lastControl = null;
            Control[] children = this.detailArea.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[children.length - i - 1];
                FormData fd = new FormData();
                fd.top = lastControl == null ? new FormAttachment(0) : new FormAttachment(lastControl);
                fd.left = new FormAttachment(0, 0);
                fd.right = new FormAttachment(100, 0);
                child.setLayoutData((Object)fd);
                lastControl = child;
                ++i;
            }
            this.shell.layout(true, true);
        }
        if (this.activatedHeader != null) {
            this.activatedHeader.composite.setBackground(Colors.getSystemColor((Device)d, 25));
            this.activatedHeader.composite.setForeground(Colors.getSystemColor((Device)d, 24));
        }
        this.activatedHeader = header;
    }

    public void buildTorrentCustomMenu_Control(Composite cParent, final DownloadManager[] dms) {
        Core core;
        SpeedLimitHandler slh;
        final int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean start = false;
        boolean stop = false;
        boolean pause = false;
        boolean recheck = false;
        boolean barsOpened = true;
        boolean bChangeDir = this.hasSelection;
        int i = 0;
        while (i < dms.length) {
            DownloadManager dm = dms[i];
            if (barsOpened && !DownloadBar.getManager().isOpen(dm)) {
                barsOpened = false;
            }
            stop = stop || ManagerUtils.isStopable(dm);
            start = start || ManagerUtils.isStartable(dm);
            pause = pause || ManagerUtils.isPauseable(dm);
            recheck = recheck || dm.canForceRecheck();
            boolean stopped = ManagerUtils.isStopped(dm);
            int state = dm.getState();
            if ((bChangeDir &= state == 100 || state == 70 || state == 75) && dms.length == 1) {
                bChangeDir = dm.isDataAlreadyAllocated();
                if (bChangeDir && state == 100) {
                    bChangeDir = !dm.filesExist(true);
                } else {
                    DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                    bChangeDir = false;
                    DiskManagerFileInfo[] diskManagerFileInfoArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DiskManagerFileInfo info = diskManagerFileInfoArray[n2];
                        if (!info.isSkipped()) {
                            bChangeDir = !info.getFile(true).exists();
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
        Composite cQuickCommands = new Composite(cParent, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.justify = true;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        cQuickCommands.setLayout((Layout)rowLayout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        cQuickCommands.setLayoutData((Object)gd);
        this.createActionButton(dms, cQuickCommands, "MyTorrentsView.menu.queue", "start", start, event2 -> TorrentUtil.queueDataSources(dms, false));
        if (TorrentUtil.isForceStartVisible(dms)) {
            boolean forceStart = false;
            boolean forceStartEnabled = false;
            int i2 = 0;
            while (i2 < dms.length) {
                DownloadManager dm = dms[i2];
                forceStartEnabled = forceStartEnabled || ManagerUtils.isForceStartable(dm);
                forceStart = forceStart || dm.isForceStart();
                ++i2;
            }
            final boolean newForceStart = !forceStart;
            this.createActionButton(dms, cQuickCommands, "MyTorrentsView.menu.forceStart", "forcestart", forceStartEnabled, !newForceStart, new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    if (ManagerUtils.isForceStartable(dm)) {
                        dm.setForceStart(newForceStart);
                    }
                }
            });
        }
        if (userMode > 0) {
            this.createActionButton(dms, cQuickCommands, "v3.MainWindow.button.pause", "pause", pause, event2 -> TorrentUtil.pauseDataSources(dms));
        }
        this.createActionButton(dms, cQuickCommands, "MyTorrentsView.menu.stop", "stop", stop, event2 -> TorrentUtil.stopDataSources(dms));
        this.createActionButton(dms, cQuickCommands, "MyTorrentsView.menu.recheck", "recheck", recheck, new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                if (dm.canForceRecheck()) {
                    dm.forceRecheck();
                }
            }
        });
        this.createActionButton(dms, cQuickCommands, "menu.delete.options", "delete", this.hasSelection, new Listener(){

            public void handleEvent(Event event2) {
                TorrentUtil.removeDownloads(dms, null, true);
            }
        });
        if (bChangeDir) {
            this.createRow(cParent, "MyTorrentsView.menu.changeDirectory", null, new Listener(){

                public void handleEvent(Event e) {
                    TorrentUtil.changeDirSelectedTorrents(dms, TorrentMenuFancy.this.parentShell);
                }
            });
        }
        if (this.hasSelection) {
            this.createRow(cParent, "MyTorrentsView.menu.showdetails", "details", new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                    }
                }
            });
        }
        if (this.hasSelection) {
            FancyRowInfo row = this.createRow(cParent, "MyTorrentsView.menu.showdownloadbar", "downloadBar", new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    if (DownloadBar.getManager().isOpen(dm)) {
                        DownloadBar.close(dm);
                    } else {
                        DownloadBar.open(dm, TorrentMenuFancy.this.parentShell);
                    }
                }
            });
            row.setSelection(barsOpened);
        }
        if (this.hasSelection) {
            FancyRowInfo rowSpeedDL = this.createRow(cParent, "MyTorrentsView.menu.downSpeedLimit", "image.torrentspeed.down", false, new Listener(){

                public void handleEvent(Event e) {
                    Event event2 = new Event();
                    event2.type = 4;
                    event2.widget = e.widget;
                    event2.stateMask = e.stateMask;
                    event2.button = e.button;
                    e.display.post(event2);
                    Core core = CoreFactory.getSingleton();
                    SelectableSpeedMenu.invokeSlider((Control)event2.widget, core, dms, false, TorrentMenuFancy.this.shell);
                    if (e.display.getActiveShell() != TorrentMenuFancy.this.shell) {
                        if (!TorrentMenuFancy.this.shell.isDisposed()) {
                            TorrentMenuFancy.this.shell.dispose();
                        }
                        return;
                    }
                    FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo(event2.widget);
                    if (rowInfo != null) {
                        TorrentMenuFancy.this.updateRowSpeed(rowInfo, false);
                    }
                }
            });
            rowSpeedDL.keepMenu = true;
            this.updateRowSpeed(rowSpeedDL, false);
        }
        if (this.hasSelection) {
            FancyRowInfo rowSpeedUL = this.createRow(cParent, "MyTorrentsView.menu.upSpeedLimit", "image.torrentspeed.up", false, new Listener(){

                public void handleEvent(Event e) {
                    Event event2 = new Event();
                    event2.type = 4;
                    event2.widget = e.widget;
                    event2.stateMask = e.stateMask;
                    event2.button = e.button;
                    e.display.post(event2);
                    Core core = CoreFactory.getSingleton();
                    SelectableSpeedMenu.invokeSlider((Control)e.widget, core, dms, true, TorrentMenuFancy.this.shell);
                    if (e.display.getActiveShell() != TorrentMenuFancy.this.shell) {
                        if (!TorrentMenuFancy.this.shell.isDisposed()) {
                            TorrentMenuFancy.this.shell.dispose();
                        }
                        return;
                    }
                    FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo(event2.widget);
                    if (rowInfo != null) {
                        TorrentMenuFancy.this.updateRowSpeed(rowInfo, true);
                    }
                }
            });
            rowSpeedUL.keepMenu = true;
            this.updateRowSpeed(rowSpeedUL, true);
        }
        if (this.hasSelection && userMode > 0) {
            this.createMenuRow(cParent, "MyTorrentsView.menu.tracker", null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu menu) {
                    boolean changeUrl = TorrentMenuFancy.this.hasSelection;
                    boolean manualUpdate = true;
                    boolean allStopped = true;
                    boolean canMove = true;
                    int userMode = COConfigurationManager.getIntParameter("User Mode");
                    boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
                    DownloadManager[] downloadManagerArray = dms;
                    int n = dms.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TRTrackerAnnouncer trackerClient;
                        DownloadManager dm = downloadManagerArray[n2];
                        boolean stopped = ManagerUtils.isStopped(dm);
                        allStopped &= stopped;
                        boolean bl = canMove = canMove && dm.canMoveDataFiles();
                        if (userMode < 2 && (trackerClient = dm.getTrackerClient()) != null) {
                            boolean update_state = SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L;
                            manualUpdate &= update_state;
                        }
                        ++n2;
                    }
                    TorrentUtil.addTrackerTorrentMenu(menu, dms, changeUrl, manualUpdate, allStopped, use_open_containing_folder, canMove);
                }
            });
        }
        if (this.hasSelection && (slh = SpeedLimitHandler.getSingleton(core = CoreFactory.getSingleton())).hasAnyProfiles()) {
            this.createMenuRow(cParent, "MainWindow.menu.speed_limits", null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu menu) {
                    TorrentUtil.addSpeedLimitsMenu(dms, menu);
                }
            });
        }
        if (userMode > 0 && this.hasSelection) {
            boolean can_pause_for = false;
            int i3 = 0;
            while (i3 < dms.length) {
                DownloadManager dm = dms[i3];
                if (dm.isPaused() || ManagerUtils.isPauseable(dm)) {
                    can_pause_for = true;
                    break;
                }
                ++i3;
            }
            if (can_pause_for) {
                this.createRow(this.detailArea, "MainWindow.menu.transfers.pausetransfersfor", null, new Listener(){

                    public void handleEvent(Event event2) {
                        TorrentUtil.pauseDownloadsFor(dms);
                    }
                });
            }
        }
        if (userMode > 0 && dms.length > 1) {
            this.createRow(cParent, "label.options.and.info", null, new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.getMDI().showEntryByID("TorrentOptionsView", dms);
                    }
                }
            });
        }
        if (userMode > 0) {
            this.createMenuRow(cParent, "MyTorrentsView.menu.peersource", null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu menu) {
                    TorrentUtil.addPeerSourceSubMenu(dms, menu);
                }
            });
        }
        boolean allSeq = true;
        boolean AllNonSeq = true;
        int j = 0;
        while (j < dms.length) {
            DownloadManager dm = dms[j];
            boolean seq = dm.getDownloadState().getFlag(8192L);
            if (seq) {
                AllNonSeq = false;
            } else {
                allSeq = false;
            }
            ++j;
        }
        boolean bChecked = allSeq ? true : (AllNonSeq ? false : false);
        final boolean newSeq = !bChecked;
        FancyRowInfo row = this.createRow(cParent, "menu.sequential.download", null, new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.getDownloadState().setFlag(8192L, newSeq);
            }
        });
        row.setSelection(bChecked);
        if (userMode > 0 && IpFilterManagerFactory.getSingleton().getIPFilter().isEnabled()) {
            boolean allEnabled = true;
            boolean allDisabled = true;
            j = 0;
            while (j < dms.length) {
                DownloadManager dm = dms[j];
                boolean filterDisabled = dm.getDownloadState().getFlag(256L);
                if (filterDisabled) {
                    allEnabled = false;
                } else {
                    allDisabled = false;
                }
                ++j;
            }
            bChecked = allEnabled ? true : (allDisabled ? false : false);
            final boolean newDisable = bChecked;
            row = this.createRow(cParent, "MyTorrentsView.menu.ipf_enable", null, new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    dm.getDownloadState().setFlag(256L, newDisable);
                }
            });
            row.setSelection(bChecked);
        }
        if (userMode > 1) {
            this.createMenuRow(cParent, "MyTorrentsView.menu.networks", null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu menu) {
                    TorrentUtil.addNetworksSubMenu(dms, menu);
                }
            });
        }
        if (userMode > 0) {
            this.createMenuRow(cParent, "MyTorrentsView.menu.advancedmenu", null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu menu) {
                    DownloadManagerState dmState;
                    List<DownloadManagerState.ResumeHistory> history;
                    boolean allStopped = true;
                    boolean allScanSelected = true;
                    boolean allScanNotSelected = true;
                    boolean fileMove = true;
                    boolean allResumeIncomplete = true;
                    boolean hasClearableLinks = false;
                    boolean hasRevertableFiles = false;
                    boolean lrrecheck = false;
                    boolean allAllocatable = true;
                    boolean allMaskDC = true;
                    boolean globalMask = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece");
                    DownloadManager[] downloadManagerArray = dms;
                    int n = dms.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DownloadManager dm = downloadManagerArray[n2];
                        boolean stopped = ManagerUtils.isStopped(dm);
                        allStopped &= stopped;
                        fileMove = fileMove && dm.canMoveDataFiles();
                        boolean scan = dm.getDownloadState().getFlag(2L);
                        boolean incomplete = !dm.isDownloadComplete(true);
                        allScanSelected = incomplete && allScanSelected && scan;
                        allScanNotSelected = incomplete && allScanNotSelected && !scan;
                        DownloadManagerState dms2 = dm.getDownloadState();
                        if (dms2.isResumeDataComplete()) {
                            allResumeIncomplete = false;
                        }
                        if (stopped && !hasClearableLinks && dm.getDiskManagerFileInfoSet().nbFiles() > 1 && dms2.getFileLinks().hasLinks()) {
                            hasClearableLinks = true;
                        }
                        if (dm.getDownloadState().getFileLinks().size() > 0) {
                            hasRevertableFiles = true;
                        }
                        lrrecheck = lrrecheck || ManagerUtils.canLowResourceRecheck(dm);
                        allAllocatable &= stopped && !dm.isDataAlreadyAllocated() && !dm.isDownloadComplete(false);
                        Boolean dmmask = dms2.getOptionalBooleanAttribute("mdlc");
                        boolean mask = dmmask == null ? globalMask : dmmask;
                        allMaskDC = allMaskDC && mask;
                        ++n2;
                    }
                    boolean fileRescan = allScanSelected || allScanNotSelected;
                    final MenuItem itemFileRescan = new MenuItem(menu, 32);
                    Messages.setLanguageText((Widget)itemFileRescan, "MyTorrentsView.menu.rescanfile");
                    itemFileRescan.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            dm.getDownloadState().setFlag(2L, itemFileRescan.getSelection());
                        }
                    });
                    itemFileRescan.setSelection(allScanSelected);
                    itemFileRescan.setEnabled(fileRescan);
                    MenuItem itemLowResourceRecheck = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemLowResourceRecheck, "MyTorrentsView.menu.lowresourcerecheck");
                    itemLowResourceRecheck.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            ManagerUtils.lowResourceRecheck(dm);
                        }
                    });
                    itemLowResourceRecheck.setEnabled(lrrecheck);
                    MenuItem itemRevertFiles = new MenuItem(menu, 8);
                    itemRevertFiles.setText(String.valueOf(MessageText.getString("MyTorrentsView.menu.revertfiles")) + "...");
                    itemRevertFiles.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager[] dms) {
                            FilesViewMenuUtil.revertFiles(TorrentMenuFancy.this.tv, dms);
                        }
                    });
                    itemRevertFiles.setEnabled(hasRevertableFiles);
                    MenuItem itemViewLinks = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemViewLinks, "menu.view.links");
                    itemViewLinks.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager[] dms) {
                            ManagerUtils.viewLinks(dms);
                        }
                    });
                    MenuItem itemClearLinks = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemClearLinks, "FilesView.menu.clear.links");
                    itemClearLinks.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            DiskManagerFileInfoSet fis;
                            if (ManagerUtils.isStopped(dm) && dm.getDownloadState().getFileLinks().hasLinks() && (fis = dm.getDiskManagerFileInfoSet()).nbFiles() > 1) {
                                DiskManagerFileInfo[] files;
                                DiskManagerFileInfo[] diskManagerFileInfoArray = files = fis.getFiles();
                                int n = files.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DiskManagerFileInfo file_info = diskManagerFileInfoArray[n2];
                                    File file_link = file_info.getFile(true);
                                    File file_nolink = file_info.getFile(false);
                                    if (!file_nolink.getAbsolutePath().equals(file_link.getAbsolutePath())) {
                                        file_info.setLink(null, true);
                                    }
                                    ++n2;
                                }
                            }
                        }
                    });
                    itemClearLinks.setEnabled(hasClearableLinks);
                    MenuItem itemFileAlloc = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemFileAlloc, "label.allocate");
                    itemFileAlloc.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            dm.getDownloadState().setLongAttribute("fas", 2L);
                            dm.getDownloadState().setFlag(16384L, false);
                            ManagerUtils.queue(dm, null);
                        }
                    });
                    itemFileAlloc.setEnabled(allAllocatable);
                    MenuItem itemFileClearAlloc = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemFileClearAlloc, "MyTorrentsView.menu.clear_alloc_data");
                    itemFileClearAlloc.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            dm.setDataAlreadyAllocated(false);
                        }
                    });
                    itemFileClearAlloc.setEnabled(allStopped);
                    MenuItem itemFileClearResume = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemFileClearResume, "MyTorrentsView.menu.clear_resume_data");
                    itemFileClearResume.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            dm.getDownloadState().clearResumeData();
                        }
                    });
                    itemFileClearResume.setEnabled(allStopped);
                    MenuItem itemFileSetResumeComplete = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemFileSetResumeComplete, "MyTorrentsView.menu.set.resume.complete");
                    itemFileSetResumeComplete.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            TorrentUtils.setResumeDataCompletelyValid(dm.getDownloadState());
                        }
                    });
                    itemFileSetResumeComplete.setEnabled(allStopped && allResumeIncomplete);
                    Menu restore_menu = new Menu((Decorations)menu.getShell(), 4);
                    MenuItem itemRestoreResume = new MenuItem(menu, 64);
                    Messages.setLanguageText((Widget)itemRestoreResume, "MyTorrentsView.menu.restore.resume.data");
                    itemRestoreResume.setMenu(restore_menu);
                    boolean restoreEnabled = false;
                    if (dms.length == 1 && allStopped && !(history = (dmState = dms[0].getDownloadState()).getResumeDataHistory()).isEmpty()) {
                        restoreEnabled = true;
                        for (DownloadManagerState.ResumeHistory h : history) {
                            MenuItem itemHistory = new MenuItem(restore_menu, 8);
                            itemHistory.setText(new SimpleDateFormat().format(new Date(h.getDate())));
                            itemHistory.addListener(13, ev -> dmState.restoreResumeData(h));
                        }
                    }
                    itemRestoreResume.setEnabled(restoreEnabled);
                    final MenuItem itemMaskDLComp = new MenuItem(menu, 32);
                    if (dms.length > 0) {
                        itemMaskDLComp.setSelection(allMaskDC);
                    }
                    Messages.setLanguageText((Widget)itemMaskDLComp, "ConfigView.label.hap");
                    itemMaskDLComp.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            dm.getDownloadState().setOptionalBooleanAttribute("mdlc", itemMaskDLComp.getSelection());
                        }
                    });
                    itemMaskDLComp.setEnabled(dms.length > 0);
                    if (userMode > 1 && TorrentMenuFancy.this.isSeedingView) {
                        boolean canSetSuperSeed = false;
                        boolean superSeedAllYes = true;
                        boolean superSeedAllNo = true;
                        DownloadManager[] downloadManagerArray2 = dms;
                        int n3 = dms.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            DownloadManager dm = downloadManagerArray2[n4];
                            PEPeerManager pm = dm.getPeerManager();
                            if (pm != null) {
                                if (pm.canToggleSuperSeedMode()) {
                                    canSetSuperSeed = true;
                                }
                                if (pm.isSuperSeedMode()) {
                                    superSeedAllYes = false;
                                } else {
                                    superSeedAllNo = false;
                                }
                            } else {
                                superSeedAllYes = false;
                                superSeedAllNo = false;
                            }
                            ++n4;
                        }
                        MenuItem itemSuperSeed = new MenuItem(menu, 32);
                        Messages.setLanguageText((Widget)itemSuperSeed, "ManagerItem.superseeding");
                        boolean enabled = canSetSuperSeed && (superSeedAllNo || superSeedAllYes);
                        itemSuperSeed.setEnabled(enabled);
                        final boolean selected = superSeedAllNo;
                        if (enabled) {
                            itemSuperSeed.setSelection(selected);
                            itemSuperSeed.addListener(13, (Listener)new ListenerDMTask(dms){

                                @Override
                                public void run(DownloadManager dm) {
                                    PEPeerManager pm = dm.getPeerManager();
                                    if (pm != null && pm.isSuperSeedMode() == selected && pm.canToggleSuperSeedMode()) {
                                        pm.setSuperSeedMode(!selected);
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    private void updateRowSpeed(FancyRowInfo row, boolean isUpload) {
        int dlRate = isUpload ? this.dms[0].getStats().getUploadRateLimitBytesPerSecond() : this.dms[0].getStats().getDownloadRateLimitBytesPerSecond();
        DownloadManager[] downloadManagerArray = this.dms;
        int n = this.dms.length;
        int n2 = 0;
        while (n2 < n) {
            int dlRate2;
            DownloadManager dm = downloadManagerArray[n2];
            int n3 = dlRate2 = isUpload ? dm.getStats().getUploadRateLimitBytesPerSecond() : dm.getStats().getDownloadRateLimitBytesPerSecond();
            if (dlRate != dlRate2) {
                dlRate = -2;
                break;
            }
            ++n2;
        }
        if (dlRate != -2) {
            String currentSpeed = dlRate == 0 ? MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited") : (dlRate < 0 ? MessageText.getString("label.disabled") : DisplayFormatters.formatByteCountToKiBEtcPerSec(dlRate));
            row.setRightLabelText(currentSpeed);
            row.cRow.layout();
        }
    }

    private FancyMenuRowInfo createMenuRow(Composite cParent, String keyTitle, String keyImage, final FancyMenuRowInfoListener listener) {
        Listener showSWTMenuListener = new Listener(){
            int lastX = 0;
            int lastY = 0;

            public void handleEvent(final Event event2) {
                if (event2.type == 32 && this.lastX == event2.x && this.lastY == event2.y) {
                    return;
                }
                this.lastX = event2.x;
                this.lastY = event2.y;
                FancyRowInfo findRowInfo = TorrentMenuFancy.this.findRowInfo(event2.widget);
                if (!(findRowInfo instanceof FancyMenuRowInfo)) {
                    return;
                }
                FancyMenuRowInfo rowInfo = (FancyMenuRowInfo)findRowInfo;
                TorrentMenuFancy.this.currentMenu = rowInfo.getMenu();
                if (TorrentMenuFancy.this.currentMenu != null && !TorrentMenuFancy.this.currentMenu.isDisposed()) {
                    return;
                }
                TorrentMenuFancy.this.currentMenu = new Menu((Decorations)TorrentMenuFancy.this.parentShell, 8);
                rowInfo.setMenu(TorrentMenuFancy.this.currentMenu);
                TorrentMenuFancy.this.currentMenu.addMenuListener(new MenuListener(){

                    public void menuShown(MenuEvent arg0) {
                        TorrentMenuFancy.this.subMenuVisible = true;
                    }

                    public void menuHidden(final MenuEvent arg0) {
                        TorrentMenuFancy.this.subMenuVisible = false;
                        TorrentMenuFancy.this.currentMenu = null;
                        Utils.execSWTThreadLater(0, new Runnable(){

                            @Override
                            public void run() {
                                arg0.widget.dispose();
                            }
                        });
                    }
                });
                listener.buildMenu(TorrentMenuFancy.this.currentMenu);
                Composite rowComposite = rowInfo.getRow();
                if (rowComposite != null) {
                    Point size = rowComposite.getSize();
                    Point menuLocation = rowComposite.toDisplay(size.x - 3, -3);
                    TorrentMenuFancy.this.currentMenu.setLocation(menuLocation);
                }
                if (TorrentMenuFancy.this.currentMenu.getItemCount() > 0) {
                    TorrentMenuFancy.this.currentMenu.setVisible(true);
                    TorrentMenuFancy.this.addMenuItemListener(TorrentMenuFancy.this.currentMenu, TorrentMenuFancy.this.listenerForTrigger);
                    final FancyMenuRowInfo currentRow = rowInfo;
                    final Point currentMousePos = event2.display.getCursorLocation();
                    Utils.execSWTThreadLater(300, new Runnable(){

                        @Override
                        public void run() {
                            Menu submenu;
                            Object data;
                            Point cursorLocation = event2.display.getCursorLocation();
                            if (currentMousePos.equals((Object)cursorLocation)) {
                                Utils.execSWTThreadLater(300, this);
                                return;
                            }
                            Control control = Utils.getCursorControl();
                            if (control != null && (data = control.getData("ID")) instanceof HeaderInfo) {
                                HeaderInfo header = (HeaderInfo)data;
                                TorrentMenuFancy.this.activateHeader(header);
                            }
                            if ((submenu = currentRow.getMenu()) == null || submenu.isDisposed() || !submenu.isVisible()) {
                                return;
                            }
                            FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo((Widget)control);
                            if (rowInfo != null && rowInfo != currentRow) {
                                submenu.setVisible(false);
                                return;
                            }
                            Utils.execSWTThreadLater(300, this);
                        }
                    });
                } else {
                    TorrentMenuFancy.this.currentMenu.dispose();
                    TorrentMenuFancy.this.currentMenu = null;
                }
            }
        };
        FancyMenuRowInfo row = new FancyMenuRowInfo();
        this.createRow(cParent, keyTitle, keyImage, true, showSWTMenuListener, row);
        row.setHasSubMenu(true);
        Composite cRow = row.getRow();
        Utils.addListenerAndChildren(cRow, 32, showSWTMenuListener);
        row.setKeepMenu(true);
        Label rightLabel = row.getRightLabel();
        GridData gd = new GridData(12, -1);
        rightLabel.setLayoutData((Object)gd);
        row.getRightLabel().addPaintListener(this.paintListenerArrow);
        return row;
    }

    protected void addMenuItemListener(Menu menu, Listener l) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.getStyle() == 64) {
                this.addMenuItemListener(item.getMenu(), l);
            } else {
                item.addListener(13, l);
            }
            ++n2;
        }
    }

    private FancyRowInfo createRow(Composite cParent, String keyTitle, String keyImage, Listener triggerListener) {
        return this.createRow(cParent, keyTitle, keyImage, true, triggerListener, new FancyRowInfo(null, null));
    }

    private FancyRowInfo createRow(Composite cParent, String keyTitle, String keyImage, boolean triggerOnUp, Listener triggerListener) {
        return this.createRow(cParent, keyTitle, keyImage, triggerOnUp, triggerListener, new FancyRowInfo(null, null));
    }

    private FancyRowInfo createRow(Composite cParent, String keyTitle, String keyImage, boolean triggerOnUp, Listener triggerListener, FancyRowInfo rowInfo) {
        Composite cRow = new Composite(cParent, 0);
        cRow.setData("ID", (Object)rowInfo);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 3;
        gridLayout.marginRight = 4;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        cRow.setLayout((Layout)gridLayout);
        Label lblIcon = new Label(cRow, 0x1000000);
        GridData gridData = new GridData();
        gridData.widthHint = 20;
        lblIcon.setLayoutData((Object)gridData);
        if (keyImage != null) {
            ImageLoader.getInstance().setLabelImage(lblIcon, keyImage);
        }
        Label item = new Label(cRow, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 2;
        item.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)item, keyTitle);
        Utils.setSkinnedControlType((Control)item, 2);
        Label lblCheck = new Label(cRow, 0x1000000);
        gridData = new GridData();
        gridData.widthHint = 13;
        lblCheck.setLayoutData((Object)gridData);
        if (triggerListener != null) {
            Utils.addListenerAndChildren(cRow, triggerOnUp ? 4 : 3, this.listenerForTrigger);
        }
        Utils.addListenerAndChildren(cRow, 6, this.listenerRow);
        Utils.addListenerAndChildren(cRow, 7, this.listenerRow);
        cRow.addPaintListener(this.listenerRowPaint);
        rowInfo.setListener(triggerListener);
        rowInfo.setRow(cRow);
        rowInfo.setIconLabel(lblIcon);
        rowInfo.setText(item);
        rowInfo.setRightLabel(null);
        rowInfo.setCheckLabel(lblCheck);
        this.listRowInfos.add(rowInfo);
        return rowInfo;
    }

    private FancyRowInfo findRowInfo(Widget widget) {
        Object findData = this.findData(widget, "ID");
        if (findData instanceof FancyRowInfo) {
            return (FancyRowInfo)findData;
        }
        return null;
    }

    protected Object findData(Widget widget, String id) {
        if (widget == null || widget.isDisposed()) {
            return null;
        }
        Object o = widget.getData(id);
        if (o != null) {
            return o;
        }
        if (widget instanceof Control) {
            Composite control = ((Control)widget).getParent();
            while (control != null) {
                o = control.getData(id);
                if (o != null) {
                    return o;
                }
                control = control.getParent();
            }
        }
        return null;
    }

    private Control createActionButton(DownloadManager[] dms, Composite cParent, String keyToolTip, String keyImage, boolean enable, Listener listener) {
        return this.createActionButton(dms, cParent, keyToolTip, keyImage, enable, false, listener);
    }

    private Control createActionButton(DownloadManager[] dms, Composite cParent, String keyToolTip, final String keyImage, boolean enable, final boolean selected, final Listener listener) {
        Canvas item = new Canvas(cParent, 0x20040000);
        Listener l = new Listener(){
            private boolean inWidget;

            public void handleEvent(Event e) {
                Control c = (Control)e.widget;
                if (e.type == 9) {
                    Point size = c.getSize();
                    GC gc = e.gc;
                    gc.fillRectangle(0, 0, size.x, size.y);
                    if (this.inWidget) {
                        gc.setBackground(Colors.getSystemColor((Device)e.display, 20));
                    } else {
                        gc.setBackground(Colors.getSystemColor((Device)e.display, 19));
                    }
                    gc.setAdvanced(true);
                    gc.setAntialias(1);
                    gc.fillRoundRectangle(0, 0, size.x - 1, size.y - 1, 6, 6);
                    gc.setForeground(Colors.getSystemColor((Device)e.display, 17));
                    gc.drawRoundRectangle(0, 0, size.x - 1, size.y - 1, 6, 6);
                    gc.setForeground(Colors.getSystemColor((Device)e.display, 20));
                    gc.drawRoundRectangle(1, 1, size.x - 3, size.y - 3, 6, 6);
                    Image image = ImageLoader.getInstance().getImage(c.isEnabled() ? keyImage : String.valueOf(keyImage) + "-disabled");
                    Rectangle bounds = image.getBounds();
                    int x = size.x / 2 - bounds.width / 2;
                    int y = size.y / 2 - bounds.height / 2;
                    gc.drawImage(image, x, y);
                    if (selected && c.isEnabled()) {
                        image = ImageLoader.getInstance().getImage("blacktick");
                        bounds = image.getBounds();
                        x = 2;
                        y = size.y / 2 - bounds.height / 2;
                        gc.drawImage(image, x, y);
                    }
                } else if (e.type == 6) {
                    this.inWidget = true;
                    c.redraw();
                } else if (e.type == 7) {
                    this.inWidget = false;
                    c.redraw();
                }
            }
        };
        item.addListener(6, l);
        item.addListener(7, l);
        item.addListener(9, l);
        Messages.setLanguageTooltip((Widget)item, keyToolTip);
        item.addListener(4, new Listener(){

            public void handleEvent(Event event2) {
                listener.handleEvent(event2);
                TorrentMenuFancy.this.shell.dispose();
            }
        });
        item.setEnabled(enable);
        RowData rowData = new RowData(30, 21);
        item.setLayoutData((Object)rowData);
        return item;
    }

    public void buildTorrentCustomMenu_Organize(Composite detailArea, final DownloadManager[] dms) {
        if (!this.hasSelection) {
            return;
        }
        this.createMenuRow(detailArea, "MyTorrentsView.menu.setCategory", "image.sidebar.library", new FancyMenuRowInfoListener(){

            @Override
            public void buildMenu(Menu menu) {
                TorrentUtil.addCategorySubMenu(dms, menu);
            }
        });
        this.createMenuRow(detailArea, "label.tags", "image.sidebar.tag-overview", new FancyMenuRowInfoListener(){

            @Override
            public void buildMenu(Menu menu) {
                TagUIUtils.addLibraryViewTagsSubMenu(dms, menu);
            }
        });
        final ArrayList<Download> ar_dms = new ArrayList<Download>();
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            Download stub = PluginCoreUtils.wrap(dm);
            if (stub.canStubbify()) {
                ar_dms.add(stub);
            }
            ++n2;
        }
        if (ar_dms.size() > 0) {
            this.createRow(detailArea, "MyTorrentsView.menu.archive", "image.sidebar.archive", new Listener(){

                public void handleEvent(Event event2) {
                    ManagerUtils.moveToArchive(ar_dms, null);
                }
            });
        }
        this.createRow(detailArea, "MyTorrentsView.menu.rename", null, event2 -> ManagerUtils.advancedRename(dms));
        this.createRow(detailArea, "MyTorrentsView.menu.reposition.manual", null, new Listener(){

            public void handleEvent(Event event2) {
                TorrentUtil.repositionManual(TorrentMenuFancy.this.tv, dms, TorrentMenuFancy.this.parentShell, TorrentMenuFancy.this.isSeedingView);
            }
        });
        this.createRow(detailArea, "Button.selectAll", null, new Listener(){

            public void handleEvent(Event event2) {
                TorrentMenuFancy.this.tv.selectAll();
            }
        });
        if (this.tv.getSWTFilter() != null) {
            this.createRow(detailArea, "MyTorrentsView.menu.filter", null, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentMenuFancy.this.tv.openFilterDialog();
                }
            });
        }
        this.createRow(detailArea, "MyTorrentsView.menu.editTableColumns", "columns", new Listener(){

            public void handleEvent(Event event2) {
                TableRowCore focusedRow = TorrentMenuFancy.this.tv.getFocusedRow();
                if (focusedRow == null || focusedRow.isRowDisposed()) {
                    focusedRow = TorrentMenuFancy.this.tv.getRow(0);
                }
                String tableID = TorrentMenuFancy.this.tv.getTableID();
                new TableColumnSetupWindow(TorrentMenuFancy.this.tv.getDataSourceType(), tableID, TorrentMenuFancy.this.column, focusedRow, TableStructureEventDispatcher.getInstance(tableID)).open();
            }
        });
    }

    public void buildTorrentCustomMenu_Social(Composite detailArea) {
        boolean isTrackerOn = TRTrackerUtils.isTrackerEnabled();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (this.hasSelection) {
            this.createMenuRow(detailArea, "ConfigView.section.interface.alerts", null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu menu) {
                    MenuFactory.addAlertsMenu(menu, false, TorrentMenuFancy.this.dms);
                }
            });
        }
        if (userMode > 0 && isTrackerOn && this.hasSelection) {
            this.createRow(detailArea, "MyTorrentsView.menu.host", "host", new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.hostTorrents(TorrentMenuFancy.this.dms);
                }
            });
            this.createRow(detailArea, "MyTorrentsView.menu.publish", "publish", new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.publishTorrents(TorrentMenuFancy.this.dms);
                }
            });
        }
        if (userMode > 0) {
            FancyRowInfo row;
            String title;
            if (this.dms.length == 1) {
                title = String.valueOf(MessageText.getString("MyTorrentsView.menu.exportmenu")) + ": " + MessageText.getString("MyTorrentsView.menu.export");
                row = this.createRow(detailArea, null, null, new ListenerDMTask(this.dms){

                    @Override
                    public void run(DownloadManager dm) {
                        if (dm != null) {
                            new ExportTorrentWizard(TorrentMenuFancy.this.parentShell.getDisplay(), dm);
                        }
                    }
                });
                row.getText().setText(title);
                TOTorrent torrent = this.dms[0].getTorrent();
                row.setEnabled(torrent != null && torrent.isExportable());
            }
            title = String.valueOf(MessageText.getString("MyTorrentsView.menu.exportmenu")) + ": " + MessageText.getString("MyTorrentsView.menu.exporttorrent");
            row = this.createRow(detailArea, null, null, new ListenerDMTask(this.dms){

                @Override
                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportTorrent(dms, TorrentMenuFancy.this.parentShell);
                }
            });
            row.getText().setText(title);
            boolean canExport = true;
            DownloadManager[] downloadManagerArray = this.dms;
            int n = this.dms.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager dm = downloadManagerArray[n2];
                if (!dm.getTorrent().isExportable()) {
                    canExport = false;
                }
                ++n2;
            }
            row.setEnabled(canExport);
            this.createRow(detailArea, "MyTorrentsView.menu.exporthttpseeds", null, new ListenerDMTask(this.dms){

                @Override
                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportHTTPSeeds(dms);
                }
            });
        }
        if (this.isSeedingView) {
            boolean can_share_pers = this.dms.length > 0;
            DownloadManager[] downloadManagerArray = this.dms;
            int n = this.dms.length;
            int n3 = 0;
            while (n3 < n) {
                DownloadManager dm = downloadManagerArray[n3];
                File file = dm.getSaveLocation();
                if (!file.exists()) {
                    can_share_pers = false;
                    break;
                }
                ++n3;
            }
            if (can_share_pers) {
                this.createRow(detailArea, "MyTorrentsView.menu.create_personal_share", null, new ListenerDMTask(this.dms, false){

                    @Override
                    public void run(DownloadManager dm) {
                        File file = dm.getSaveLocation();
                        HashMap<String, String> properties = new HashMap<String, String>();
                        if (Utils.setPeronalShare(properties)) {
                            if (file.isFile()) {
                                ShareUtils.shareFile(file.getAbsolutePath(), properties);
                            } else if (file.isDirectory()) {
                                ShareUtils.shareDir(file.getAbsolutePath(), properties);
                            }
                        }
                    }
                });
            }
        }
    }

    private Object[] getTarget(com.biglybt.pif.ui.menus.MenuItem item) {
        if ("table".equals(item.getMenuID())) {
            TableRowCore[] rows = this.tv.getSelectedRows();
            ArrayList<TableRowCore> result = new ArrayList<TableRowCore>(rows.length);
            TableRowCore[] tableRowCoreArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowCore row = tableRowCoreArray[n2];
                if (row.getDataSource(false) instanceof Download) {
                    result.add(row);
                }
                ++n2;
            }
            return result.toArray(new TableRowCore[result.size()]);
        }
        Object[] dataSources = this.tv.getSelectedDataSources(false);
        ArrayList<Download> result = new ArrayList<Download>(dataSources.length);
        Object[] objectArray = dataSources;
        int n = dataSources.length;
        int n3 = 0;
        while (n3 < n) {
            Object ds = objectArray[n3];
            if (ds instanceof Download) {
                result.add((Download)ds);
            }
            ++n3;
        }
        return result.toArray(new Download[result.size()]);
    }

    private void addPluginItem(Composite detailArea, final com.biglybt.pif.ui.menus.MenuItem item) {
        FancyRowInfo row;
        MenuItemImpl menuImpl = (MenuItemImpl)item;
        menuImpl.invokeMenuWillBeShownListeners(this.getTarget(item));
        if (!item.isVisible()) {
            return;
        }
        if (!item.isEnabled()) {
            return;
        }
        Graphic graphic = item.getGraphic();
        final int style = item.getStyle();
        if (style == 5) {
            row = this.createMenuRow(detailArea, item.getResourceKey(), null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu menu) {
                    if (TorrentMenuFancy.this.dms.length != 0) {
                        MenuBuilder submenuBuilder = ((MenuItemImpl)item).getSubmenuBuilder();
                        if (submenuBuilder != null) {
                            try {
                                item.removeAllChildItems();
                                submenuBuilder.buildSubmenu(item, TorrentMenuFancy.this.getTarget(item));
                            }
                            catch (Throwable t) {
                                Debug.out(t);
                            }
                        }
                        MenuBuildUtils.addPluginMenuItems(item.getItems(), menu, false, true, new MenuBuildUtils.PluginMenuController(){

                            @Override
                            public Listener makeSelectionListener(final com.biglybt.pif.ui.menus.MenuItem plugin_menu_item) {
                                return new TableSelectedRowsListener(TorrentMenuFancy.this.tv, false){

                                    @Override
                                    public boolean run(TableRowCore[] rows) {
                                        if (rows.length != 0) {
                                            ((MenuItemImpl)plugin_menu_item).invokeListenersMulti(TorrentMenuFancy.this.getTarget(item));
                                        }
                                        return true;
                                    }
                                };
                            }

                            @Override
                            public void notifyFillListeners(com.biglybt.pif.ui.menus.MenuItem menu_item) {
                                ((MenuItemImpl)menu_item).invokeMenuWillBeShownListeners(TorrentMenuFancy.this.getTarget(item));
                            }

                            @Override
                            public void buildSubmenu(com.biglybt.pif.ui.menus.MenuItem parent) {
                                MenuBuilder submenuBuilder = ((MenuItemImpl)parent).getSubmenuBuilder();
                                if (submenuBuilder != null) {
                                    try {
                                        parent.removeAllChildItems();
                                        submenuBuilder.buildSubmenu(parent, TorrentMenuFancy.this.getTarget(item));
                                    }
                                    catch (Throwable t) {
                                        Debug.out(t);
                                    }
                                }
                            }

                            @Override
                            public void buildStarts(Menu menu) {
                            }

                            @Override
                            public void buildComplete(Menu menu) {
                                TorrentMenuFancy.this.addMenuItemListener(menu, TorrentMenuFancy.this.listenerForTrigger);
                            }
                        });
                    }
                }
            });
        } else {
            row = this.createRow(detailArea, item.getResourceKey(), null, new TableSelectedRowsListener(this.tv, false){

                @Override
                public boolean run(TableRowCore[] rows) {
                    if (style == 2) {
                        Boolean b = (Boolean)item.getData();
                        boolean newSel = b == null || b == false;
                        item.setData(newSel);
                    }
                    if (rows.length != 0) {
                        ((MenuItemImpl)item).invokeListenersMulti(TorrentMenuFancy.this.getTarget(item));
                    }
                    return true;
                }
            });
            if (style == 2) {
                Boolean b = (Boolean)item.getData();
                row.setSelection(b != null && b != false);
            }
        }
        row.setEnabled(item.isEnabled());
        if (graphic instanceof UISWTGraphic) {
            row.getIconLabel().setImage(((UISWTGraphic)graphic).getImage());
        } else if (graphic instanceof GraphicURI) {
            ImageLoader.getInstance().setLabelImage(row.getIconLabel(), ((GraphicURI)graphic).getURI().toString());
        }
    }

    protected void buildTorrentCustomMenu_Content(Composite detailArea, final DownloadManager[] dms) {
        if (this.hasSelection) {
            this.createRow(detailArea, "MyTorrentsView.menu.open", "run", new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    TorrentUtil.runDataSources(dms);
                }
            });
        }
        if (this.hasSelection) {
            final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            this.createRow(detailArea, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"), null, new ListenerDMTask(dms, false){

                @Override
                public void run(DownloadManager dm) {
                    ManagerUtils.open(dm, use_open_containing_folder);
                }
            });
        }
        if (this.hasSelection) {
            this.createMenuRow(detailArea, "MyTorrentsView.menu.browse", null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu menuBrowse) {
                    MenuItem itemBrowsePublic = new MenuItem(menuBrowse, 8);
                    itemBrowsePublic.setText(String.valueOf(MessageText.getString("label.public")) + "...");
                    itemBrowsePublic.addListener(13, (Listener)new ListenerDMTask(dms, false){

                        @Override
                        public void run(DownloadManager dm) {
                            ManagerUtils.browse(dm, false, true);
                        }
                    });
                    MenuItem itemBrowseAnon = new MenuItem(menuBrowse, 8);
                    itemBrowseAnon.setText(String.valueOf(MessageText.getString("label.anon")) + "...");
                    itemBrowseAnon.addListener(13, (Listener)new ListenerDMTask(dms, false){

                        @Override
                        public void run(DownloadManager dm) {
                            ManagerUtils.browse(dm, true, true);
                        }
                    });
                    new MenuItem(menuBrowse, 2);
                    MenuItem itemBrowseURL = new MenuItem(menuBrowse, 8);
                    Messages.setLanguageText((Widget)itemBrowseURL, "label.copy.url.to.clip");
                    itemBrowseURL.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            Utils.getOffOfSWTThread(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    String url = ManagerUtils.browse(dms[0], true, false);
                                    if (url != null) {
                                        ClipboardCopy.copyToClipBoard(url);
                                    }
                                }
                            });
                        }
                    });
                    itemBrowseURL.setEnabled(dms.length == 1);
                    new MenuItem(menuBrowse, 2);
                    final MenuItem itemBrowseDir = new MenuItem(menuBrowse, 32);
                    Messages.setLanguageText((Widget)itemBrowseDir, "library.launch.web.in.browser.dir.list");
                    itemBrowseDir.setSelection(COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList"));
                    itemBrowseDir.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            COConfigurationManager.setParameter("Library.LaunchWebsiteInBrowserDirList", itemBrowseDir.getSelection());
                        }
                    });
                }
            });
        }
        this.createRow(detailArea, "MyTorrentsView.menu.torrent.set.thumb", null, new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                FileDialog fDialog = new FileDialog(TorrentMenuFancy.this.parentShell, 4098);
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.thumb"));
                String path = fDialog.open();
                if (path == null) {
                    return;
                }
                File file = new File(path);
                try {
                    byte[] thumbnail = FileUtil.readFileAsByteArray(file);
                    String name = file.getName();
                    int pos = name.lastIndexOf(".");
                    String ext = pos != -1 ? name.substring(pos + 1) : "";
                    String type = HTTPUtils.guessContentTypeFromFileType(ext);
                    DownloadManager[] downloadManagerArray = dms;
                    int n = dms.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DownloadManager dm = downloadManagerArray[n2];
                        try {
                            TOTorrent torrent = dm.getTorrent();
                            PlatformTorrentUtils.setContentThumbnail(torrent, thumbnail, type);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        boolean fileMove = true;
        boolean locateFiles = false;
        boolean exportFiles = true;
        boolean canSetMOC = dms.length > 0;
        boolean canClearMOC = false;
        int i = 0;
        while (i < dms.length) {
            DownloadManager dm = dms[i];
            if (!dm.canMoveDataFiles()) {
                fileMove = false;
            }
            if (!dm.canExportDownload()) {
                exportFiles = false;
            }
            int state = dm.getState();
            if (!dm.isDownloadComplete(false) || state == 100 || state == 70) {
                locateFiles = true;
            }
            boolean incomplete = !dm.isDownloadComplete(true);
            DownloadManagerState dm_state = dm.getDownloadState();
            String moc_dir = dm_state.getAttribute("moc.dir");
            canSetMOC &= incomplete;
            canClearMOC |= moc_dir != null && moc_dir.length() > 0;
            ++i;
        }
        if (fileMove) {
            this.createRow(detailArea, "MyTorrentsView.menu.movedata", null, new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    TorrentUtil.moveDataFiles(TorrentMenuFancy.this.parentShell, dms, false);
                }
            });
            int userMode = COConfigurationManager.getIntParameter("User Mode");
            if (userMode > 0) {
                this.createRow(detailArea, "MyTorrentsView.menu.movedata.batch", null, new ListenerDMTask(dms){

                    @Override
                    public void run(DownloadManager[] dms) {
                        TorrentUtil.moveDataFiles(TorrentMenuFancy.this.parentShell, dms, true);
                    }
                });
            }
        }
        if (canSetMOC || canClearMOC) {
            final boolean f_canSetMOC = canSetMOC;
            final boolean f_canClearMOC = canClearMOC;
            this.createMenuRow(detailArea, "label.move.on.comp", null, new FancyMenuRowInfoListener(){

                @Override
                public void buildMenu(Menu moc_menu) {
                    MenuItem clear_item = new MenuItem(moc_menu, 8);
                    Messages.setLanguageText((Widget)clear_item, "Button.clear");
                    clear_item.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager[] dms) {
                            TorrentUtil.clearMOC(dms);
                        }
                    });
                    clear_item.setEnabled(f_canClearMOC);
                    MenuItem set_item = new MenuItem(moc_menu, 8);
                    Messages.setLanguageText((Widget)set_item, "label.set");
                    set_item.addListener(13, (Listener)new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager[] dms) {
                            TorrentUtil.setMOC(TorrentMenuFancy.this.parentShell, dms);
                        }
                    });
                    set_item.setEnabled(f_canSetMOC);
                }
            });
        }
        if (exportFiles) {
            this.createRow(detailArea, "MyTorrentsView.menu.exportdownload", null, new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportDownloads(TorrentMenuFancy.this.parentShell, dms);
                }
            });
        }
        this.createRow(detailArea, "MyTorrentsView.menu.checkfilesexist", null, new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.filesExist(true);
            }
        });
        if (locateFiles) {
            this.createRow(detailArea, "MyTorrentsView.menu.locatefiles", null, new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    ManagerUtils.locateFiles(dms, TorrentMenuFancy.this.parentShell);
                }
            });
        }
        if (dms.length == 1 && ManagerUtils.canFindMoreLikeThis()) {
            this.createRow(detailArea, "MyTorrentsView.menu.findmorelikethis", null, new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    ManagerUtils.findMoreLikeThis(dms[0], TorrentMenuFancy.this.parentShell);
                }
            });
        }
        this.createRow(detailArea, "MyTorrentsView.menu.thisColumn.toClipboard", null, new Listener(){

            public void handleEvent(Event event2) {
                TableRowCore[] rows;
                String sToClipboard = "";
                if (TorrentMenuFancy.this.column == null) {
                    return;
                }
                String columnName = TorrentMenuFancy.this.column.getName();
                if (columnName == null) {
                    return;
                }
                TableRowCore[] tableRowCoreArray = rows = TorrentMenuFancy.this.tv.getSelectedRows();
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableCellCore cell;
                    TableRowCore row = tableRowCoreArray[n2];
                    if (row != rows[0]) {
                        sToClipboard = String.valueOf(sToClipboard) + "\n";
                    }
                    if ((cell = row.getTableCellCore(columnName)) != null) {
                        sToClipboard = String.valueOf(sToClipboard) + cell.getClipboardText();
                    }
                    ++n2;
                }
                if (sToClipboard.length() == 0) {
                    return;
                }
                new Clipboard(Display.getDefault()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
    }

    private HeaderInfo addHeader(String id, String title, AERunnable runnable) {
        Composite composite = new Composite(this.topArea, 0);
        HeaderInfo headerInfo = new HeaderInfo(id, runnable, composite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 6;
        fillLayout.marginHeight = 2;
        composite.setLayout((Layout)fillLayout);
        Display d = composite.getDisplay();
        composite.setBackground(Colors.getSystemColor((Device)d, 25));
        composite.setForeground(Colors.getSystemColor((Device)d, 24));
        Label control = new Label(composite, 0);
        Messages.setLanguageText((Widget)control, title);
        control.setData("ID", (Object)headerInfo);
        control.addListener(6, this.headerListener);
        control.addListener(47, this.headerListener);
        control.addListener(7, this.headerListener);
        control.addListener(9, this.headerListener);
        this.listHeaders.add(headerInfo);
        return headerInfo;
    }

    private static class FancyMenuRowInfo
    extends FancyRowInfo {
        private Menu menu;

        private FancyMenuRowInfo() {
        }

        public Menu getMenu() {
            return this.menu;
        }

        public void setMenu(Menu menu) {
            this.menu = menu;
        }
    }

    private static interface FancyMenuRowInfoListener {
        public void buildMenu(Menu var1);
    }

    private static class FancyRowInfo {
        private Listener listener;
        private Label lblText;
        private Label lblRight;
        private Label lblIcon;
        private Label lblCheck;
        private Composite cRow;
        private boolean keepMenu;
        private boolean isSelected;
        private boolean hasSubMenu;

        private FancyRowInfo() {
        }

        public void setEnabled(boolean enabled) {
            this.cRow.setEnabled(enabled);
        }

        public Label getRightLabel() {
            if (this.lblRight == null) {
                this.lblRight = new Label(this.cRow, 0);
                GridData gd = new GridData();
                gd.horizontalIndent = 10;
                this.lblRight.setLayoutData((Object)gd);
                this.lblRight.setEnabled(false);
            }
            return this.lblRight;
        }

        public Listener getListener() {
            return this.listener;
        }

        public void setListener(Listener listener) {
            this.listener = listener;
        }

        public Label getText() {
            return this.lblText;
        }

        public void setText(Label lblText) {
            this.lblText = lblText;
        }

        public void setRightLabel(Label lblRight) {
            this.lblRight = lblRight;
        }

        public void setRightLabelText(String s) {
            this.getRightLabel().setText(s);
        }

        public Label getIconLabel() {
            return this.lblIcon;
        }

        public void setIconLabel(Label lblIcon) {
            this.lblIcon = lblIcon;
        }

        public Composite getRow() {
            return this.cRow;
        }

        public void setRow(Composite cRow) {
            this.cRow = cRow;
        }

        public boolean keepMenu() {
            return this.keepMenu;
        }

        public void setKeepMenu(boolean keepMenu) {
            this.keepMenu = keepMenu;
        }

        public void setSelection(boolean isSelected) {
            this.isSelected = isSelected;
            ImageLoader.getInstance().setLabelImage(this.lblCheck, isSelected ? "check_yes" : "check_no");
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setCheckLabel(Label lblCheck) {
            this.lblCheck = lblCheck;
        }

        public boolean hasSubMenu() {
            return this.hasSubMenu;
        }

        public void setHasSubMenu(boolean hasSubMenu) {
            this.hasSubMenu = hasSubMenu;
        }

        public void redraw() {
            if (this.cRow == null || this.cRow.isDisposed()) {
                return;
            }
            Rectangle bounds = this.cRow.getBounds();
            this.cRow.redraw(0, 0, bounds.width, bounds.height, true);
        }

        /* synthetic */ FancyRowInfo(FancyRowInfo fancyRowInfo, FancyRowInfo fancyRowInfo2) {
            this();
        }
    }

    private static class HeaderInfo {
        private Runnable runnable;
        private Composite composite;
        private String id;

        public HeaderInfo(String id, Runnable runnable, Composite composite) {
            this.id = id;
            this.runnable = runnable;
            this.composite = composite;
        }
    }
}

