/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.mainwindow.SWTThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextViewerWindow {
    private boolean reuseWindow;
    private Consumer<TextViewerWindow> refresher;
    private boolean modal;
    private boolean defer_modal;
    private final Shell shell;
    private final Text txtInfo;
    private final Composite buttonArea;
    private Button refresh;
    private Button ok;
    private Button cancel;
    private boolean ok_is_apply;
    private boolean cancel_enabled;
    private Font np_font;
    private boolean ok_pressed;
    private List<TextViewerWindowListener> listeners = new ArrayList<TextViewerWindowListener>();

    public TextViewerWindow(String sTitleID, String sMessageID, String sText) {
        this(sTitleID, sMessageID, sText, true);
    }

    public TextViewerWindow(String sTitleID, String sMessageID, String sText, boolean modal) {
        this(sTitleID, sMessageID, sText, modal, false);
    }

    public TextViewerWindow(String sTitleID, String sMessageID, String sText, boolean modal, boolean defer_modal) {
        this(null, sTitleID, sMessageID, sText, modal, defer_modal);
    }

    public TextViewerWindow(Shell parent_shell, String sTitleID, String sMessageID, String sText, boolean _modal, boolean _defer_modal) {
        this(parent_shell, sTitleID, sMessageID, sText, null, _modal, _defer_modal);
    }

    public TextViewerWindow(Shell parent_shell, String sTitleID, String sMessageID, String sText, Consumer<TextViewerWindow> _refresher, boolean _modal, boolean _defer_modal) {
        this.refresher = _refresher;
        this.modal = _modal;
        this.defer_modal = _defer_modal;
        this.shell = this.modal ? (parent_shell == null ? ShellFactory.createMainShell(68848) : ShellFactory.createShell(parent_shell, 68848)) : (parent_shell == null ? ShellFactory.createMainShell(3312) : ShellFactory.createShell(parent_shell, 3312));
        if (sTitleID != null) {
            this.shell.setText(MessageText.keyExists(sTitleID) ? MessageText.getString(sTitleID) : sTitleID);
        }
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        if (sMessageID != null) {
            label.setText(MessageText.keyExists(sMessageID) ? MessageText.getString(sMessageID) : sMessageID);
        }
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.txtInfo = new Text((Composite)this.shell, 2882);
        gridData = new GridData(1808);
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        gridData.horizontalSpan = 3;
        this.txtInfo.setLayoutData((Object)gridData);
        this.txtInfo.setText(sText);
        this.np_font = new Font((Device)this.shell.getDisplay(), "Courier", this.txtInfo.getFont().getFontData()[0].getHeight(), 0);
        this.txtInfo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int key = e.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if (key == 97 && e.stateMask == SWT.MOD1 && TextViewerWindow.this.txtInfo != null) {
                    TextViewerWindow.this.txtInfo.selectAll();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.buttonArea = new Composite((Composite)this.shell, 0);
        this.buttonArea.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.buttonArea.setLayoutData((Object)gridData);
        this.buildButtons();
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b' && TextViewerWindow.this.ok.isEnabled()) {
                    TextViewerWindow.this.closeWindow();
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (TextViewerWindow.this.reuseWindow && !SWTThread.getInstance().isTerminated()) {
                    Debug.out("What?");
                }
                if (TextViewerWindow.this.np_font != null) {
                    TextViewerWindow.this.np_font.dispose();
                    TextViewerWindow.this.np_font = null;
                }
                for (TextViewerWindowListener l : TextViewerWindow.this.listeners) {
                    l.closed();
                }
            }
        });
        boolean pack = true;
        if (sTitleID != null && Utils.linkShellMetricsToConfig(this.shell, "TextViewerWindow:" + sTitleID)) {
            pack = false;
        }
        if (pack) {
            this.shell.pack();
            Utils.centreWindow(this.shell);
        }
        this.shell.open();
        if (this.modal && !this.defer_modal) {
            this.goModal();
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setReuseWindow() {
        this.reuseWindow = true;
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event2) {
                event2.doit = false;
                TextViewerWindow.this.closeWindow();
            }
        });
    }

    public void reset() {
        this.listeners.clear();
        this.txtInfo.setText("");
        this.shell.setVisible(true);
        Utils.centreWindow(this.shell);
        if (this.modal && !this.defer_modal) {
            this.goModal();
        }
    }

    private void buildButtons() {
        Utils.disposeComposite(this.buttonArea, false);
        Label label = new Label(this.buttonArea, 0);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        if (this.refresher != null) {
            this.refresh = new Button(this.buttonArea, 8);
            this.refresh.setText(MessageText.getString("upnp.refresh.button"));
            this.refresh.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TextViewerWindow.this.refresher.accept(TextViewerWindow.this);
                }
            });
        }
        if (this.cancel_enabled) {
            if (Constants.isOSX) {
                this.cancel = new Button(this.buttonArea, 8);
                this.ok = new Button(this.buttonArea, 8);
            } else {
                this.ok = new Button(this.buttonArea, 8);
                this.cancel = new Button(this.buttonArea, 8);
            }
            this.cancel.setText(MessageText.getString("Button.cancel"));
        } else {
            this.cancel = null;
            this.ok = new Button(this.buttonArea, 8);
        }
        this.ok.setText(MessageText.getString(this.ok_is_apply ? "Button.apply" : "Button.ok"));
        Utils.makeButtonsEqualWidth(Arrays.asList(this.refresh, this.ok, this.cancel));
        this.shell.setDefaultButton(this.ok);
        this.ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    TextViewerWindow.this.ok_pressed = true;
                    TextViewerWindow.this.closeWindow();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        if (this.cancel != null) {
            this.cancel.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    try {
                        TextViewerWindow.this.closeWindow();
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
        }
        this.buttonArea.layout(true, true);
    }

    private void closeWindow() {
        if (this.reuseWindow) {
            this.shell.setVisible(false);
            for (TextViewerWindowListener l : this.listeners) {
                l.closed();
            }
        } else if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public void goModal() {
        Utils.readAndDispatchLoop((Control)this.shell, true);
    }

    public void append(String str) {
        this.txtInfo.setText(String.valueOf(this.txtInfo.getText()) + str);
        this.txtInfo.setSelection(this.txtInfo.getTextLimit());
    }

    public void append2(String str) {
        this.txtInfo.append(str);
        if (str.contains("\n")) {
            this.txtInfo.setSelection(this.txtInfo.getTextLimit());
        }
    }

    public boolean getOKPressed() {
        return this.ok_pressed;
    }

    public String getText() {
        return this.txtInfo.getText();
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean scrollToBottom) {
        this.txtInfo.setText(text);
        if (scrollToBottom) {
            this.txtInfo.setSelection(this.txtInfo.getTextLimit());
        }
    }

    public void setEditable(boolean editable) {
        this.txtInfo.setEditable(editable);
        if (editable) {
            this.cancel_enabled = true;
        }
        this.buildButtons();
    }

    public void setOKEnabled(boolean enabled) {
        this.ok.setEnabled(enabled);
    }

    public void setCancelEnabled(boolean enabled) {
        this.cancel_enabled = true;
        if (this.cancel != null) {
            this.cancel.setEnabled(enabled);
        } else {
            this.buildButtons();
        }
    }

    public void setOKisApply(boolean b) {
        this.ok_is_apply = b;
        this.buildButtons();
    }

    public void setNonProportionalFont() {
        this.txtInfo.setFont(this.np_font);
    }

    public void addListener(TextViewerWindowListener l) {
        this.listeners.add(l);
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public void close() {
        this.closeWindow();
    }

    public static interface TextViewerWindowListener {
        public void closed();
    }
}

