/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.UrlUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;

public class FixedURLTransfer
extends ByteArrayTransfer {
    private String[] supportedTypeNames;
    private int[] supportedTypeIDs;
    private boolean bCheckingString = false;
    private static boolean DEBUG = false;
    private static boolean DISABLED = Constants.isUnix;
    private static final String[] ourSupportedTypeNames = new String[]{"CF_UNICODETEXT", "CF_TEXT", "OEM_TEXT"};
    private static final int[] ourSupportedTypeIds = new int[]{13, 1, 17};
    private static FixedURLTransfer _instance = new FixedURLTransfer();
    private static Field field_TransferData_result;
    URLTransfer urlTransfer = URLTransfer.getInstance();

    static {
        try {
            field_TransferData_result = TransferData.class.getField("result");
        }
        catch (Throwable e) {
            field_TransferData_result = null;
        }
    }

    public static FixedURLTransfer getInstance() {
        return _instance;
    }

    private FixedURLTransfer() {
        try {
            Method m_getTypeIDs = this.urlTransfer.getClass().getDeclaredMethod("getTypeIds", new Class[0]);
            m_getTypeIDs.setAccessible(true);
            int[] superIDs = (int[])m_getTypeIDs.invoke((Object)this.urlTransfer, new Object[0]);
            this.supportedTypeIDs = new int[superIDs.length + ourSupportedTypeIds.length];
            System.arraycopy(superIDs, 0, this.supportedTypeIDs, 0, superIDs.length);
            System.arraycopy(ourSupportedTypeIds, 0, this.supportedTypeIDs, superIDs.length, ourSupportedTypeIds.length);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.supportedTypeIDs = ourSupportedTypeIds;
        }
        try {
            Method m_getTypeNames = this.urlTransfer.getClass().getDeclaredMethod("getTypeNames", new Class[0]);
            m_getTypeNames.setAccessible(true);
            String[] superNames = (String[])m_getTypeNames.invoke((Object)this.urlTransfer, new Object[0]);
            this.supportedTypeNames = new String[superNames.length + ourSupportedTypeNames.length];
            System.arraycopy(superNames, 0, this.supportedTypeNames, 0, superNames.length);
            System.arraycopy(ourSupportedTypeNames, 0, this.supportedTypeNames, superNames.length, ourSupportedTypeNames.length);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.supportedTypeNames = ourSupportedTypeNames;
        }
    }

    public void javaToNative(Object object, TransferData transferData) {
        boolean superDidTheJob;
        block10: {
            try {
                this.urlTransfer.javaToNative(object, transferData);
            }
            catch (SWTException swtException) {
                if (!DISABLED) break block10;
                throw swtException;
            }
        }
        if (DISABLED) {
            return;
        }
        if (DEBUG) {
            System.out.println("javaToNative called");
        }
        if (superDidTheJob = FixedURLTransfer.isResultOk(transferData)) {
            return;
        }
        FixedURLTransfer.setResultField(transferData, false);
        if (object == null || !(object instanceof URLType[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            URLType[] myTypes = (URLType[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                int i = 0;
                int length = myTypes.length;
                while (i < length) {
                    writeOut.writeBytes(myTypes[i].linkURL);
                    writeOut.writeBytes("\n");
                    writeOut.writeBytes(myTypes[i].linkText);
                    ++i;
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
                FixedURLTransfer.setResultField(transferData, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        Object result = this.urlTransfer.nativeToJava(transferData);
        if (DISABLED || result != null) {
            return result;
        }
        if (DEBUG) {
            System.out.println("nativeToJava called");
        }
        try {
            if (this.isSupportedType(transferData)) {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                return this.bytebufferToJava(buffer);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    private URLType bytebufferToJava(byte[] buffer) {
        if (buffer == null) {
            if (DEBUG) {
                System.out.println("buffer null");
            }
            return null;
        }
        if (buffer.length < 2) {
            if (DEBUG) {
                System.out.println("buffer too small");
            }
            return null;
        }
        URLType myData = null;
        try {
            int iPos;
            boolean bSecond0;
            if (DEBUG) {
                int i = 0;
                while (i < buffer.length) {
                    if (buffer[i] >= 32) {
                        System.out.print((char)buffer[i]);
                    } else {
                        System.out.print("#");
                    }
                    ++i;
                }
                System.out.println();
            }
            boolean bFirst0 = buffer[0] == 0;
            boolean bl = bSecond0 = buffer[1] == 0;
            String data = bFirst0 && bSecond0 ? new String(buffer) : (bFirst0 ? new String(buffer, "UTF-16BE") : (bSecond0 ? new String(buffer, "UTF-16LE") : (buffer[0] == -17 && buffer[1] == -69 && buffer.length > 3 && buffer[2] == -65 ? new String(buffer, 3, buffer.length - 3, "UTF-8") : (buffer[0] == -1 || buffer[0] == -2 ? new String(buffer, "UTF-16") : new String(buffer)))));
            int posNull = data.indexOf(0);
            if (posNull >= 0) {
                data = data.substring(0, posNull);
            }
            if ((iPos = data.indexOf("\nURL=")) > 0) {
                int iEndPos = data.indexOf("\r", iPos);
                if (iEndPos < 0) {
                    iEndPos = data.length();
                }
                myData = new URLType();
                myData.linkURL = data.substring(iPos + 5, iEndPos);
                myData.linkText = "";
            } else {
                String[] split = data.split("[\r\n]+", 2);
                myData = new URLType();
                myData.linkURL = split.length > 0 ? split[0] : "";
                myData.linkText = split.length > 1 ? split[1] : "";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return myData;
    }

    protected String[] getTypeNames() {
        return this.supportedTypeNames;
    }

    protected int[] getTypeIds() {
        return this.supportedTypeIDs;
    }

    public boolean isSupportedType(TransferData transferData) {
        URLType url;
        block14: {
            if (DISABLED) {
                return this.urlTransfer.isSupportedType(transferData);
            }
            if (this.bCheckingString) {
                return true;
            }
            if (transferData == null) {
                return false;
            }
            url = null;
            if (DEBUG) {
                System.out.println("Checking if type #" + transferData.type + " is URL");
            }
            this.bCheckingString = true;
            try {
                try {
                    byte[] buffer = (byte[])super.nativeToJava(transferData);
                    url = this.bytebufferToJava(buffer);
                }
                catch (Exception e) {
                    Debug.out(e);
                    this.bCheckingString = false;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.bCheckingString = false;
                throw throwable;
            }
            this.bCheckingString = false;
        }
        if (url == null) {
            if (DEBUG) {
                System.out.println("no, Null URL for type #" + transferData.type);
            }
            return false;
        }
        if (UrlUtils.isURL(url.linkURL, false)) {
            if (DEBUG) {
                System.out.println("Yes, " + url.linkURL + " of type #" + transferData.type);
            }
            return true;
        }
        if (DEBUG) {
            System.out.println("no, " + url.linkURL + " not URL for type #" + transferData.type);
        }
        return false;
    }

    public TransferData[] getSupportedTypes() {
        if (DISABLED) {
            return this.urlTransfer.getSupportedTypes();
        }
        return super.getSupportedTypes();
    }

    public static TransferData pickBestType(TransferData[] dataTypes, TransferData def) {
        if (Constants.isUnix) {
            return def;
        }
        int bestTypeIndex = -1;
        int j = 0;
        while (j < dataTypes.length) {
            try {
                TransferData data = dataTypes[j];
                Object o = _instance.nativeToJava(data);
                if (o instanceof URLType) {
                    if (((URLType)o).linkText.length() > 0) {
                        return data;
                    }
                    bestTypeIndex = j;
                }
            }
            catch (Throwable t) {
                Debug.out("Picking Best Type", t);
            }
            ++j;
        }
        if (bestTypeIndex >= 0) {
            return dataTypes[bestTypeIndex];
        }
        return def;
    }

    public static void main(String[] args) {
        LinkedHashMap<String, byte[]> map = new LinkedHashMap<String, byte[]>();
        map.put("UTF-8", new byte[]{-17, -69, -65, 72, 105});
        byte[] byArray = new byte[12];
        byArray[2] = -2;
        byArray[3] = -1;
        byArray[4] = 72;
        byArray[8] = 105;
        map.put("UTF-32BE BOM", byArray);
        byte[] byArray2 = new byte[6];
        byArray2[0] = -1;
        byArray2[1] = -2;
        byArray2[2] = 72;
        byArray2[4] = 105;
        map.put("UTF-16LE BOM", byArray2);
        byte[] byArray3 = new byte[6];
        byArray3[0] = -2;
        byArray3[1] = -1;
        byArray3[3] = 72;
        byArray3[5] = 105;
        map.put("UTF-16BE BOM", byArray3);
        byte[] byArray4 = new byte[4];
        byArray4[0] = 72;
        byArray4[2] = 105;
        map.put("UTF-16LE", byArray4);
        byte[] byArray5 = new byte[4];
        byArray5[1] = 72;
        byArray5[3] = 105;
        map.put("UTF-16BE", byArray5);
        for (String element : map.keySet()) {
            System.out.println(String.valueOf(element) + ":");
            byte[] buffer = (byte[])map.get(element);
            try {
                System.out.println("byte array would be " + Arrays.toString("Hi".getBytes(element)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                System.out.println("toString(UTF8) would be " + new String(buffer, "utf8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            boolean bFirst0 = buffer[0] == 0;
            boolean bSecond0 = buffer[1] == 0;
            String data = "";
            try {
                data = bFirst0 && bSecond0 ? new String(buffer) : (bFirst0 ? new String(buffer, "UTF-16BE") : (bSecond0 ? new String(buffer, "UTF-16LE") : (buffer[0] == -17 && buffer[1] == -69 && buffer.length > 3 && buffer[2] == -65 ? new String(buffer, 3, buffer.length - 3, "UTF-8") : (buffer[0] == -1 || buffer[0] == -2 ? new String(buffer, "UTF-16") : new String(buffer)))));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println(data);
        }
    }

    private static boolean isResultOk(TransferData transferData) {
        if (field_TransferData_result == null) {
            return true;
        }
        try {
            int val = field_TransferData_result.getInt(transferData);
            return val == (Constants.isWindows ? 0 : 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static void setResultField(TransferData transferData, boolean ok) {
        if (field_TransferData_result == null) {
            return;
        }
        try {
            int val = ok ? (Constants.isWindows ? 0 : 1) : (Constants.isWindows ? -2147467259 : 0);
            field_TransferData_result.setInt(transferData, val);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class URLType {
        public String linkURL;
        public String linkText;

        public String toString() {
            return String.valueOf(this.linkURL) + "\n" + this.linkText;
        }
    }
}

