/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.Core;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.BadIp;
import com.biglybt.core.ipfilter.BadIps;
import com.biglybt.core.ipfilter.BannedIp;
import com.biglybt.core.ipfilter.BlockedIp;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BlockedIpsWindow {
    static Core core;
    static Shell instance;

    private BlockedIpsWindow() {
    }

    public static void show(Core _core, Display display, String ipsBlocked, String ipsBanned) {
        if (instance == null || instance.isDisposed()) {
            instance = BlockedIpsWindow.create(_core, display, ipsBlocked, ipsBanned);
            instance.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event2) {
                    instance = null;
                }
            });
        } else {
            instance.open();
        }
    }

    private static Shell create(Core _core, Display display, String ipsBlocked, String ipsBanned) {
        core = _core;
        int styles = Constants.isOSX ? 1264 : 68720;
        Shell window = ShellFactory.createShell(display, styles);
        Messages.setLanguageText((Widget)window, "ConfigView.section.ipfilter.list.title");
        Utils.setShellIcon(window);
        FormLayout layout = new FormLayout();
        try {
            layout.spacing = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        window.setLayout((Layout)layout);
        StyledText textBlocked = new StyledText((Composite)window, 2816);
        textBlocked.setEditable(false);
        Button btnClear = new Button((Composite)window, 8);
        Messages.setLanguageText((Widget)btnClear, "Button.clear");
        btnClear.addListener(13, e -> {
            core.getIpFilterManager().getIPFilter().clearBlockedIPs();
            textBlocked.setText("");
        });
        StyledText textBanned = new StyledText((Composite)window, 2816);
        textBanned.setEditable(false);
        textBanned.setText(ipsBanned);
        Label blockedInfo = new Label((Composite)window, 0);
        Messages.setLanguageText((Widget)blockedInfo, "ConfigView.section.ipfilter.blockedinfo");
        Label bannedInfo = new Label((Composite)window, 0);
        Messages.setLanguageText((Widget)bannedInfo, "ConfigView.section.ipfilter.bannedinfo");
        Label lblUnban = new Label((Composite)window, 0);
        Messages.setLanguageText((Widget)lblUnban, "ConfigView.section.ipfilter.unban");
        Text textUnban = new Text((Composite)window, 2048);
        Button btnUnban = new Button((Composite)window, 8);
        Messages.setLanguageText((Widget)btnUnban, "Button.unban");
        btnUnban.addListener(13, ev -> {
            String[] ips;
            IpFilter filter2 = core.getIpFilterManager().getIPFilter();
            BadIps badIPs = core.getIpFilterManager().getBadIps();
            String[] stringArray = ips = textUnban.getText().replace(';', ',').split(",");
            int n = ips.length;
            int n2 = 0;
            while (n2 < n) {
                String ip = stringArray[n2];
                if (!(ip = ip.trim()).isEmpty()) {
                    if (filter2.unban(ip)) {
                        textBanned.append(String.valueOf(ip) + " " + MessageText.getString("ConfigView.section.ipfilter.list.unbanned") + "\n");
                    } else {
                        textBanned.append(String.valueOf(ip) + " " + MessageText.getString("ConfigView.section.ipfilter.list.not.banned") + "\n");
                    }
                    badIPs.removeBadIp(ip);
                }
                ++n2;
            }
            textBanned.setSelection(textBanned.getText().length());
        });
        textUnban.addListener(24, ev -> btnUnban.setEnabled(!textUnban.getText().trim().isEmpty()));
        btnUnban.setEnabled(false);
        Button btnReset = new Button((Composite)window, 8);
        Messages.setLanguageText((Widget)btnReset, "Button.unban.all");
        btnReset.addListener(13, e -> {
            core.getIpFilterManager().getIPFilter().clearBannedIps();
            core.getIpFilterManager().getBadIps().clearBadIps();
            textBanned.setText("");
        });
        Button btnOk = new Button((Composite)window, 8);
        Messages.setLanguageText((Widget)btnOk, "Button.ok");
        btnOk.addListener(13, e -> window.dispose());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(40, 0);
        textBlocked.setLayoutData((Object)formData);
        textBlocked.setText(ipsBlocked);
        formData = new FormData();
        formData.top = new FormAttachment((Control)btnClear, 0, 0x1000000);
        formData.right = new FormAttachment((Control)btnClear);
        formData.left = new FormAttachment(0, 0);
        blockedInfo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)textBlocked);
        formData.right = new FormAttachment(100, 0);
        btnClear.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)btnClear);
        formData.bottom = new FormAttachment((Control)btnUnban);
        textBanned.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)btnUnban, 0, 0x1000000);
        lblUnban.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)lblUnban);
        formData.right = new FormAttachment((Control)btnUnban);
        formData.top = new FormAttachment((Control)btnUnban, 0, 0x1000000);
        textUnban.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment((Control)btnOk);
        formData.bottom = new FormAttachment((Control)btnOk);
        btnUnban.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment((Control)btnReset);
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)btnOk, 0, 0x1000000);
        bannedInfo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment((Control)btnOk);
        formData.bottom = new FormAttachment(100, 0);
        btnReset.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        btnOk.setLayoutData((Object)formData);
        textBlocked.setSelection(textBlocked.getText().length());
        textBanned.setSelection(textBanned.getText().length());
        Utils.makeButtonsEqualWidth(btnUnban, btnClear, btnReset, btnOk);
        window.setDefaultButton(btnOk);
        window.addListener(31, e -> {
            if (e.character == '\u001b') {
                window.dispose();
            }
        });
        if (!Utils.linkShellMetricsToConfig(window, "BlockedIpsWindow")) {
            window.setSize(620, 450);
            if (!Constants.isOSX) {
                Utils.centreWindow(window);
            }
        }
        window.layout();
        window.open();
        return window;
    }

    public static void showBlockedIps(Core core, Shell mainWindow) {
        StringBuilder sbBlocked = new StringBuilder();
        StringBuilder sbBanned = new StringBuilder();
        BlockedIp[] blocked = core.getIpFilterManager().getIPFilter().getBlockedIps();
        String inRange = MessageText.getString("ConfigView.section.ipfilter.list.inrange");
        String notInRange = MessageText.getString("ConfigView.section.ipfilter.list.notinrange");
        String bannedMessage = MessageText.getString("ConfigView.section.ipfilter.list.banned");
        String badDataMessage = MessageText.getString("ConfigView.section.ipfilter.list.baddata");
        int i = 0;
        while (i < blocked.length) {
            BlockedIp bIp = blocked[i];
            if (bIp.isLoggable()) {
                sbBlocked.append(DisplayFormatters.formatTimeStamp(bIp.getBlockedTime()));
                sbBlocked.append("\t[");
                sbBlocked.append(bIp.getTorrentName());
                sbBlocked.append("] \t");
                sbBlocked.append(bIp.getBlockedIp());
                IpRange range = bIp.getBlockingRange();
                if (range == null) {
                    sbBlocked.append(' ');
                    sbBlocked.append(notInRange);
                    sbBlocked.append('\n');
                } else {
                    sbBlocked.append(' ');
                    sbBlocked.append(inRange);
                    sbBlocked.append(range.getStringSlow());
                    sbBlocked.append('\n');
                }
            }
            ++i;
        }
        BannedIp[] banned_ips = core.getIpFilterManager().getIPFilter().getBannedIps();
        Arrays.sort(banned_ips, new Comparator<BannedIp>(){

            @Override
            public int compare(BannedIp o1, BannedIp o2) {
                long l2;
                long l1 = o1.getBanningTime();
                if (l1 == (l2 = o2.getBanningTime())) {
                    return 0;
                }
                if (l1 < l2) {
                    return -1;
                }
                return 1;
            }
        });
        int i2 = 0;
        while (i2 < banned_ips.length) {
            BannedIp bIp = banned_ips[i2];
            sbBanned.append(DisplayFormatters.formatTimeStamp(bIp.getBanningTime()));
            sbBanned.append("\t[");
            sbBanned.append(bIp.getTorrentName());
            sbBanned.append("] \t");
            sbBanned.append(bIp.getIp());
            sbBanned.append(" ");
            sbBanned.append(bannedMessage);
            sbBanned.append("\n");
            ++i2;
        }
        BadIp[] bad_ips = core.getIpFilterManager().getBadIps().getBadIps();
        int i3 = 0;
        while (i3 < bad_ips.length) {
            BadIp bIp = bad_ips[i3];
            sbBanned.append(DisplayFormatters.formatTimeStamp(bIp.getLastTime()));
            sbBanned.append("\t");
            sbBanned.append(bIp.getIp());
            sbBanned.append(" ");
            sbBanned.append(badDataMessage);
            sbBanned.append(" ");
            sbBanned.append(bIp.getNumberOfWarnings());
            sbBanned.append("\n");
            ++i3;
        }
        if (mainWindow == null || mainWindow.isDisposed()) {
            return;
        }
        BlockedIpsWindow.show(core, mainWindow.getDisplay(), sbBlocked.toString(), sbBanned.toString());
    }
}

