/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.skin;

import com.biglybt.core.internat.IntegratedResourceBundle;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.ui.skin.SkinProperties;
import com.biglybt.ui.swt.Utils;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SkinPropertiesImpl
implements SkinProperties {
    private static final boolean DARK_MODE = Utils.isDarkAppearanceNative();
    public static final String PATH_SKIN_DEFS = "com/biglybt/ui/skin/";
    private static final String FILE_SKIN_DEFS = "skin3.properties";
    private static final Pattern PAT_PARAM_ALPHA = Pattern.compile("\\{([^0-9].+?)\\}");
    private static final Pattern PAT_PARAM_NUM = Pattern.compile("\\{([0-9]+?)\\}");
    private final String skin_id;
    private final IntegratedResourceBundle rb;
    private final ClassLoader classLoader;
    private int emHeightPX = 15;

    public SkinPropertiesImpl() {
        this(SkinPropertiesImpl.class.getClassLoader(), PATH_SKIN_DEFS, FILE_SKIN_DEFS);
    }

    public SkinPropertiesImpl(ClassLoader classLoader, String skinPath, String mainSkinFile) {
        this.classLoader = classLoader;
        skinPath = skinPath.replaceAll("/", ".");
        if (!skinPath.endsWith(".")) {
            skinPath = String.valueOf(skinPath) + ".";
        }
        if (mainSkinFile.endsWith(".properties")) {
            mainSkinFile = mainSkinFile.substring(0, mainSkinFile.length() - 11);
        }
        this.skin_id = String.valueOf(skinPath) + mainSkinFile;
        ResourceBundle bundle = ResourceBundle.getBundle(this.skin_id, Locale.getDefault(), classLoader);
        this.rb = new IntegratedResourceBundle(bundle, Collections.EMPTY_MAP, 1200);
        this.rb.setUseNullList(true);
        String sFiles = this.rb.getString("skin.include", null);
        if (sFiles != null) {
            String[] sFilesArray = sFiles.split(",");
            int i = 0;
            while (i < sFilesArray.length) {
                String sFile = sFilesArray[i].startsWith("/") ? sFilesArray[i].substring(1) : String.valueOf(skinPath) + sFilesArray[i];
                sFile = sFile.replaceAll("/", ".");
                try {
                    ResourceBundle subBundle = ResourceBundle.getBundle(sFile, Locale.getDefault(), classLoader);
                    this.rb.addResourceMessages(subBundle);
                }
                catch (Throwable t) {
                    Debug.out("Err loading skin include: " + sFile, t);
                }
                ++i;
            }
        }
    }

    public String getSkinID() {
        return this.skin_id;
    }

    @Override
    public void addResourceBundle(ResourceBundle subBundle, String skinPath) {
        this.addResourceBundle(subBundle, skinPath, this.classLoader);
    }

    @Override
    public void addResourceBundle(ResourceBundle subBundle, String skinPath, ClassLoader loader) {
        block7: {
            try {
                this.clearCache();
                this.rb.addResourceMessages(subBundle);
                try {
                    String sFiles = subBundle.getString("skin.include");
                    if (sFiles == null || skinPath == null) break block7;
                    String[] sFilesArray = RegExUtil.PAT_SPLIT_COMMA.split(sFiles);
                    int i = 0;
                    while (i < sFilesArray.length) {
                        String sFile = sFilesArray[i].startsWith("/") ? sFilesArray[i].substring(1) : String.valueOf(skinPath) + sFilesArray[i];
                        sFile = sFile.replaceAll("/", ".");
                        try {
                            ResourceBundle incBundle = ResourceBundle.getBundle(sFile, Locale.getDefault(), loader);
                            this.rb.addResourceMessages(incBundle);
                        }
                        catch (Throwable t) {
                            Debug.out("Err loading skin include: " + sFile, t);
                        }
                        ++i;
                    }
                }
                catch (MissingResourceException sFiles) {}
            }
            catch (Throwable t) {
                Debug.out("Err loading skin include: " + subBundle, t);
            }
        }
    }

    @Override
    public void addProperty(String name, String value) {
        this.rb.addString(name, value);
    }

    @Override
    public boolean hasKey(String name) {
        if (name == null) {
            return false;
        }
        String osName = null;
        if (Constants.isWindows) {
            osName = String.valueOf(name) + "._windows";
        } else if (Constants.isOSX) {
            osName = String.valueOf(name) + "._mac";
        } else if (Constants.isUnix) {
            osName = String.valueOf(name) + "._unix";
        } else if (Constants.isFreeBSD) {
            osName = String.valueOf(name) + "._freebsd";
        } else if (Constants.isLinux) {
            osName = String.valueOf(name) + "._linux";
        } else if (Constants.isSolaris) {
            osName = String.valueOf(name) + "._solaris";
        }
        String themeSuffix = null;
        if (DARK_MODE) {
            themeSuffix = "._dark";
        }
        boolean contains = false;
        if (osName != null) {
            if (themeSuffix != null) {
                contains = this.rb.getString(String.valueOf(osName) + themeSuffix, null) != null;
            }
            boolean bl = contains = contains || this.rb.getString(osName, null) != null;
        }
        if (!contains) {
            if (themeSuffix != null) {
                contains = this.rb.getString(String.valueOf(name) + themeSuffix, null) != null;
            }
            contains = contains || this.rb.getString(name, null) != null;
        }
        return contains;
    }

    @Override
    public String getReferenceID(String name) {
        String value = this.getValue(name, null, false);
        if (value == null || value.length() < 2) {
            return null;
        }
        if (value.charAt(0) == '{' && value.charAt(value.length() - 1) == '}') {
            return value.substring(1, value.length() - 1);
        }
        return null;
    }

    protected String getValue(String name, String[] params) {
        return this.getValue(name, params, true);
    }

    private String getValue(String name, String[] params, boolean expandReferences) {
        String value = null;
        String osName = null;
        if (name == null) {
            return null;
        }
        String themeSuffix = null;
        if (DARK_MODE) {
            themeSuffix = "._dark";
        }
        if (Constants.isWindows) {
            osName = String.valueOf(name) + "._windows";
        } else if (Constants.isOSX) {
            osName = String.valueOf(name) + "._mac";
        } else if (Constants.isUnix) {
            osName = String.valueOf(name) + "._unix";
        } else if (Constants.isFreeBSD) {
            osName = String.valueOf(name) + "._freebsd";
        } else if (Constants.isLinux) {
            osName = String.valueOf(name) + "._linux";
        } else if (Constants.isSolaris) {
            osName = String.valueOf(name) + "._solaris";
        }
        if (osName != null) {
            if (themeSuffix != null) {
                value = this.rb.getString(String.valueOf(osName) + themeSuffix, null);
                if (value == null) {
                    value = this.rb.getString(osName, null);
                }
            } else {
                value = this.rb.getString(osName, null);
            }
        }
        if (value == null) {
            if (themeSuffix != null) {
                value = this.rb.getString(String.valueOf(name) + themeSuffix, null);
                if (value == null) {
                    value = this.rb.getString(name, null);
                }
            } else {
                value = this.rb.getString(name, null);
            }
        }
        if (expandReferences && value != null && value.indexOf(125) > 0) {
            String key;
            Matcher matcher;
            if (params != null) {
                matcher = PAT_PARAM_NUM.matcher(value);
                while (matcher.find()) {
                    key = matcher.group(1);
                    try {
                        int i = Integer.parseInt(key);
                        if (i < params.length) {
                            value = value.replaceAll("\\Q{" + key + "}\\E", Matcher.quoteReplacement(params[i]));
                            continue;
                        }
                        value = value.replaceAll("\\Q{" + key + "}\\E", "");
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
            }
            matcher = PAT_PARAM_ALPHA.matcher(value);
            while (matcher.find()) {
                key = matcher.group(1);
                String text = this.getValue(key, params);
                if (text == null) {
                    text = MessageText.getString(key);
                }
                value = value.replaceAll("\\Q{" + key + "}\\E", Matcher.quoteReplacement(text));
            }
        }
        return value;
    }

    @Override
    public int getIntValue(String name, int def) {
        String value = this.getValue(name, null);
        if (value == null) {
            return def;
        }
        int result = def;
        try {
            if (value.endsWith("rem")) {
                float em = Float.parseFloat(value.substring(0, value.length() - 3));
                result = (int)((float)this.emHeightPX * em);
            } else {
                result = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public int[] getColorValue(String name) {
        int[] colors = new int[4];
        String value = this.getValue(name, null);
        if (value == null || value.length() == 0 || value.startsWith("COLOR_")) {
            colors[2] = -1;
            colors[1] = -1;
            colors[0] = -1;
            return colors;
        }
        try {
            if (value.charAt(0) == '#') {
                long l = Long.parseLong(value.substring(1), 16);
                if (value.length() == 9) {
                    colors = new int[]{(int)(l >> 24 & 0xFFL), (int)(l >> 16 & 0xFFL), (int)(l >> 8 & 0xFFL), (int)(l & 0xFFL)};
                } else {
                    colors[0] = (int)(l >> 16 & 0xFFL);
                    colors[1] = (int)(l >> 8 & 0xFFL);
                    colors[2] = (int)(l & 0xFFL);
                    colors[3] = 255;
                }
            } else if (value.contains(",")) {
                StringTokenizer st = new StringTokenizer(value, ",");
                colors[0] = Integer.parseInt(st.nextToken());
                colors[1] = Integer.parseInt(st.nextToken());
                colors[2] = Integer.parseInt(st.nextToken());
                colors[3] = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 255;
            } else {
                colors[2] = -1;
                colors[1] = -1;
                colors[0] = -1;
            }
        }
        catch (Exception e) {
            colors[2] = -1;
            colors[1] = -1;
            colors[0] = -1;
        }
        return colors;
    }

    @Override
    public String getStringValue(String name) {
        return this.getStringValue(name, (String[])null);
    }

    @Override
    public String getStringValue(String name, String def) {
        return this.getStringValue(name, null, def);
    }

    @Override
    public String[] getStringArray(String name) {
        return this.getStringArray(name, null);
    }

    @Override
    public String[] getStringArray(String name, String[] params) {
        String s = this.getValue(name, params);
        if (s == null) {
            return null;
        }
        String[] values = RegExUtil.PAT_SPLIT_COMMAWORDS.split(s);
        if (values == null) {
            return new String[]{s};
        }
        return values;
    }

    @Override
    public String getStringValue(String name, String[] params) {
        return this.getValue(name, params, true);
    }

    @Override
    public String getStringValue(String name, String[] params, String def) {
        String s = this.getValue(name, params, true);
        return s == null ? def : s;
    }

    @Override
    public boolean getBooleanValue(String name, boolean def) {
        String s = this.getStringValue(name, (String)null);
        if (s == null) {
            return def;
        }
        return s.toLowerCase().equals("true") || s.equals("1");
    }

    @Override
    public void clearCache() {
        this.rb.clearUsedMessagesMap(1);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void setEmHeightPX(int fontHeightInPX) {
        this.emHeightPX = fontHeightInPX;
    }

    @Override
    public int getEmHeightPX() {
        return this.emHeightPX;
    }
}

