/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.selectedcontent;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.download.Download;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;

public class SelectedContentManager {
    private static CopyOnWriteList<SelectedContentListener> listeners = new CopyOnWriteList();
    private static volatile ISelectedContent[] currentlySelectedContent = new ISelectedContent[0];
    private static volatile String viewID = null;
    private static volatile TableView tv = null;

    public static void destroyStatic() {
        listeners.clear();
        currentlySelectedContent = new ISelectedContent[0];
        tv = null;
    }

    public static String getCurrentySelectedViewID() {
        return viewID;
    }

    public static void addCurrentlySelectedContentListener(SelectedContentListener l) {
        if (listeners.contains(l)) {
            return;
        }
        listeners.add(l);
        l.currentlySelectedContentChanged(currentlySelectedContent, viewID);
    }

    public static void removeCurrentlySelectedContentListener(SelectedContentListener l) {
        listeners.remove(l);
    }

    public static void clearCurrentlySelectedContent() {
        SelectedContentManager.changeCurrentlySelectedContentNoTrigger(null, null, null);
        SelectedContentManager.triggerSelectedContentListeners();
    }

    public static void changeCurrentlySelectedContent(String viewID, ISelectedContent[] currentlySelectedContent) {
        SelectedContentManager.changeCurrentlySelectedContent(viewID, currentlySelectedContent, null);
    }

    public static void changeCurrentlySelectedContent(String viewID, ISelectedContent[] currentlySelectedContent, TableView tv) {
        if (SelectedContentManager.changeCurrentlySelectedContentNoTrigger(viewID, currentlySelectedContent, tv)) {
            SelectedContentManager.triggerSelectedContentListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean changeCurrentlySelectedContentNoTrigger(String viewID, ISelectedContent[] currentlySelectedContent, TableView tv) {
        if (currentlySelectedContent == null) {
            currentlySelectedContent = new ISelectedContent[]{};
        }
        if (currentlySelectedContent.length == 0 && SelectedContentManager.viewID != null && viewID != null && !viewID.equals(SelectedContentManager.viewID)) {
            return false;
        }
        Class<SelectedContentManager> clazz = SelectedContentManager.class;
        synchronized (SelectedContentManager.class) {
            block7: {
                boolean same;
                boolean bl = same = SelectedContentManager.tv == tv;
                if (!same) break block7;
                boolean bl2 = same = SelectedContentManager.viewID == viewID || SelectedContentManager.viewID != null && viewID != null && SelectedContentManager.viewID.equals(viewID);
                if (!same || SelectedContentManager.currentlySelectedContent.length != currentlySelectedContent.length) break block7;
                int i = 0;
                while (i < currentlySelectedContent.length && same) {
                    same = currentlySelectedContent[i].sameAs(SelectedContentManager.currentlySelectedContent[i]);
                    ++i;
                }
                if (!same) break block7;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            SelectedContentManager.tv = tv;
            SelectedContentManager.currentlySelectedContent = currentlySelectedContent;
            SelectedContentManager.viewID = viewID;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    public static void triggerSelectedContentListeners() {
        for (SelectedContentListener l : listeners) {
            try {
                l.currentlySelectedContentChanged(currentlySelectedContent, viewID);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public static ISelectedContent[] getCurrentlySelectedContent() {
        return currentlySelectedContent;
    }

    public static DownloadManager[] getDMSFromSelectedContent() {
        ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
        if (sc.length > 0) {
            int x = 0;
            DownloadManager[] dms = new DownloadManager[sc.length];
            int i = 0;
            while (i < sc.length) {
                ISelectedContent selectedContent = sc[i];
                if (selectedContent != null) {
                    dms[x] = selectedContent.getDownloadManager();
                    if (dms[x] != null) {
                        ++x;
                    }
                }
                ++i;
            }
            if (x > 0) {
                System.arraycopy(dms, 0, dms, 0, x);
                return dms;
            }
        }
        return null;
    }

    public static TableView getCurrentlySelectedTableView() {
        return tv;
    }

    public static Object convertSelectedContentToObject(ISelectedContent[] contents) {
        if (contents == null) {
            contents = SelectedContentManager.getCurrentlySelectedContent();
        }
        if (contents.length == 0) {
            TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
            if (tv != null) {
                return tv.getSelectedDataSources(false);
            }
            return null;
        }
        if (contents.length == 1) {
            return SelectedContentManager.selectedContentToObject(contents[0]);
        }
        Object[] objects = new Object[contents.length];
        int i = 0;
        while (i < contents.length) {
            ISelectedContent content = contents[i];
            objects[i] = SelectedContentManager.selectedContentToObject(content);
            ++i;
        }
        return objects;
    }

    private static Object selectedContentToObject(ISelectedContent content) {
        DownloadManager dm = content.getDownloadManager();
        if (dm == null) {
            return null;
        }
        Download dl = PluginCoreUtils.wrap(dm);
        if (dl == null) {
            return null;
        }
        int i = content.getFileIndex();
        if (i < 0) {
            return dl;
        }
        return dl.getDiskManagerFileInfo(i);
    }

    public static String getCurrentlySelectedContentDetails() {
        ISelectedContent[] contents = SelectedContentManager.getCurrentlySelectedContent();
        if (contents.length == 0) {
            TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
            if (tv != null) {
                Object[] ds = tv.getSelectedDataSources(false);
                String str = "";
                Object[] objectArray = ds;
                int n = ds.length;
                int n2 = 0;
                while (n2 < n) {
                    Object d = objectArray[n2];
                    str = String.valueOf(str) + (str.isEmpty() ? "" : ", ") + d;
                    ++n2;
                }
                return String.valueOf(tv.getTableID()) + " -> " + str;
            }
            return "None";
        }
        String str = "";
        ISelectedContent[] iSelectedContentArray = contents;
        int n = contents.length;
        int n3 = 0;
        while (n3 < n) {
            ISelectedContent ic = iSelectedContentArray[n3];
            str = String.valueOf(str) + (str.isEmpty() ? "" : "\n") + ic.getString();
            ++n3;
        }
        return str;
    }
}

