/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.OptionsConsoleCommand;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;

public class Priority
extends OptionsConsoleCommand {
    private static final int NORMAL = 1;
    private static final int HIGH = 2;
    private static final int DONOTDOWNLOAD = 3;
    private static final int DELETE = 4;
    private static final String[] priostr = new String[]{"Normal", "High", "DoNotDownload", "Delete"};
    private int newprio;

    public Priority() {
        super("prio");
    }

    @Override
    public String getCommandDescriptions() {
        return "prio [#torrent] [#file|range(i.e. 1-2,5)|all] [normal|high|dnd|del]";
    }

    @Override
    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("Usage: prio [torrent] [file(s)] [priority]");
        out.println("Options:");
        out.println("\t[torrent]\tThe torrent number from 'show torrents'");
        out.println("\t[file(s)] is one of:");
        out.println("\t\t\t#file:\tthe file number from 'show [#torrent]',");
        out.println("\t\t\trange:\ta range of file numbers, i.e. 1-3 or 1-10,12-15 or 1,3,5-8 ,");
        out.println("\t\t\tall:\t 'all' applies priority to all files of the torrent");
        out.println("\t[priority] is one of:");
        out.println("\t\t\tnormal\tNormal priority");
        out.println("\t\t\thigh  \tHigh priority");
        out.println("\t\t\tdnd   \tDo not download (skip)");
        out.println("\t\t\tdel   \tDo not download & delete file");
        out.println("> -----");
    }

    @Override
    public void execute(String commandName, ConsoleInput console, CommandLine commandLine) {
        int end;
        int start;
        DiskManagerFileInfo[] files;
        DownloadManager dm;
        int tnumber;
        List<String> args = commandLine.getArgList();
        if (args.isEmpty()) {
            console.out.println("Torrent # required!");
            return;
        }
        String tnumstr = args.remove(0);
        if (args.isEmpty()) {
            console.out.println("File # required!");
            return;
        }
        String fnumstr = args.remove(0);
        if (console.torrents == null || console.torrents.isEmpty()) {
            console.out.println("> Command 'prio': No torrents in list (try 'show torrents' first).");
            return;
        }
        try {
            tnumber = Integer.parseInt(tnumstr);
            if (tnumber == 0 || tnumber > console.torrents.size()) {
                console.out.println("> Command 'prio': Torrent #" + tnumber + " unknown.");
                return;
            }
            dm = (DownloadManager)console.torrents.get(tnumber - 1);
            files = dm.getDiskManagerFileInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            console.out.println("> Command 'prio': Torrent # '" + tnumstr + "' unknown.");
            return;
        }
        if (args.isEmpty()) {
            console.out.println("> Command 'prio': missing parameter for new priority");
            return;
        }
        String newpriostr = args.remove(0);
        if (newpriostr.equalsIgnoreCase("normal")) {
            this.newprio = 1;
        } else if (newpriostr.equalsIgnoreCase("high")) {
            this.newprio = 2;
        } else if (newpriostr.equalsIgnoreCase("dnd")) {
            this.newprio = 3;
        } else if (newpriostr.equalsIgnoreCase("del")) {
            this.newprio = 4;
        } else {
            console.out.println("> Command 'prio': unknown priority " + newpriostr);
            return;
        }
        String[] sections = fnumstr.equalsIgnoreCase("all") ? new String[]{"1-" + files.length} : fnumstr.split(",");
        LinkedList<Integer> fs = new LinkedList<Integer>();
        LinkedList<Integer> fe = new LinkedList<Integer>();
        int i = 0;
        while (i < sections.length) {
            try {
                int dash = sections[i].indexOf(45);
                if (dash != -1) {
                    start = Integer.parseInt(sections[i].substring(0, dash));
                    end = Integer.parseInt(sections[i].substring(dash + 1));
                } else {
                    start = end = Integer.parseInt(sections[i]);
                }
                if (start == 0 || end > files.length) {
                    console.out.println("> Command 'prio': Invalid file range " + sections[i]);
                    return;
                }
                if (start > end) {
                    console.out.println("> Command 'prio': Invalid file range '" + sections[i] + "'");
                }
                fs.add(new Integer(start - 1));
                fe.add(new Integer(end - 1));
            }
            catch (Exception e) {
                console.out.println("> Command 'prio': File # '" + sections[i] + "' unknown.");
                return;
            }
            ++i;
        }
        if (this.newprio == 4 && dm.getState() != 70) {
            try {
                dm.stopIt(70, false, false);
            }
            catch (Exception e) {
                console.out.println("Failed to stop torrent " + tnumber);
                return;
            }
        }
        int nummod = 0;
        while (fs.size() > 0) {
            start = (Integer)fs.removeFirst();
            end = (Integer)fe.removeFirst();
            int i2 = start;
            while (i2 <= end) {
                ++nummod;
                if (this.newprio == 1) {
                    files[i2].setPriority(0);
                    files[i2].setSkipped(false);
                } else if (this.newprio == 2) {
                    files[i2].setPriority(1);
                    files[i2].setSkipped(false);
                } else if (this.newprio == 3) {
                    files[i2].setPriority(0);
                    files[i2].setSkipped(true);
                } else if (this.newprio == 4) {
                    int st = files[i2].getStorageType();
                    int target_st = -1;
                    if (st == 1) {
                        target_st = 2;
                    } else if (st == 3) {
                        target_st = 4;
                    }
                    if (target_st != -1 && files[i2].setStorageType(target_st)) {
                        files[i2].setPriority(0);
                        files[i2].setSkipped(true);
                    } else {
                        console.out.println("> Command 'prio': Failed to delete file " + (i2 + 1));
                        --nummod;
                    }
                }
                ++i2;
            }
        }
        if (this.newprio == 4 && dm.getState() == 70) {
            try {
                dm.stopIt(75, false, false);
            }
            catch (Exception e) {
                console.out.println("Failed to restart torrent " + tnumber);
                return;
            }
        }
        console.out.println(String.valueOf(nummod) + " file(s) priority set to " + priostr[this.newprio - 1]);
    }
}

