/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.IConsoleCommand;
import java.io.PrintStream;
import java.util.List;

public class Archive
extends IConsoleCommand {
    public Archive() {
        super("archive", "ar");
    }

    @Override
    public String getCommandDescriptions() {
        return "archive\t\tar\tLists, and allows the restoration of, archived downloads.";
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("Subcommands:");
        out.println("list\t\tl\t\tList archived downloads");
        out.println("show <num>\ts\t\tShow archived download");
        out.println("restore <num>\tres\t\tRestore archived download");
        out.println("delete <num>\tdel\t\tDelete archived download");
        out.println("> -----");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        if (args.size() <= 0) ** GOTO lbl71
        pi = ci.getCore().getPluginManager().getDefaultPluginInterface();
        stubs = pi.getDownloadManager().getDownloadStubs();
        sub = args.get(0);
        index = -1;
        if (args.size() > 1) {
            index_str = args.get(1);
            try {
                index = Integer.parseInt(index_str);
                if (--index < 0 || index >= stubs.length) {
                    index = -1;
                }
            }
            catch (Throwable var9_13) {
                // empty catch block
            }
            if (index == -1) {
                ci.out.println("Invalid archive index: " + index_str);
            }
        }
        if (sub.equals("list") || sub.equals("l")) {
            pos = 1;
            ci.out.println("> -----");
            var12_17 = stubs;
            var11_19 = stubs.length;
            var10_21 = 0;
            while (var10_21 < var11_19) {
                stub = var12_17[var10_21];
                System.out.println(" " + pos++ + "\t" + stub.getName() + " (" + DisplayFormatters.formatByteCountToKiBEtc(stub.getTorrentSize()) + ")");
                ++var10_21;
            }
            ci.out.println("> -----");
        } else if (index != -1 && (sub.equals("show") || sub.equals("s"))) {
            try {
                stub = stubs[index];
                ci.out.println("> -----");
                ci.out.println("  " + stub.getName() + " - hash=" + ByteFormatter.encodeString(stub.getTorrentHash()));
                files = stub.getStubFiles();
                ci.out.println("  Files: " + files.length);
                var13_23 = files;
                var12_18 = files.length;
                var11_20 = 0;
                while (var11_20 < var12_18) {
                    file = var13_23[var11_20];
                    length = file.getLength();
                    ci.out.println("    " + file.getFile() + " - " + (length < 0L ? "Not downloaded" : DisplayFormatters.formatByteCountToKiBEtc(length)));
                    ++var11_20;
                }
                ci.out.println("> -----");
            }
            catch (Throwable e) {
                ci.out.print(e);
            }
        } else if (index != -1 && (sub.equals("restore") || sub.equals("res"))) {
            try {
                d = stubs[index].destubbify();
                ci.out.println("> Restore of " + d.getName() + " succeeded.");
            }
            catch (Throwable e) {
                ci.out.print(e);
            }
        } else if (index != -1 && (sub.equals("delete") || sub.equals("del"))) {
            try {
                stub = stubs[index];
                name = stub.getName();
                stub.remove();
                ci.out.println("> Delete of " + name + " succeeded.");
            }
            catch (Throwable e) {
                ci.out.print(e);
            }
        } else {
            ci.out.println("Unsupported sub-command: " + sub);
            return;
lbl71:
            // 1 sources

            this.printHelp(ci.out, args);
        }
    }
}

