/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.common.table;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableStructureModificationListener;
import java.util.HashMap;
import java.util.Map;

public class TableStructureEventDispatcher
implements TableStructureModificationListener {
    private static Map<String, TableStructureEventDispatcher> instances = new HashMap<String, TableStructureEventDispatcher>();
    private static AEMonitor class_mon = new AEMonitor("TableStructureEventDispatcher:class");
    private CopyOnWriteList listeners;
    private AEMonitor listeners_mon = new AEMonitor("TableStructureEventDispatcher:L");

    private TableStructureEventDispatcher() {
        this.listeners = new CopyOnWriteList(2);
    }

    public static TableStructureEventDispatcher getInstance(String tableID) {
        try {
            class_mon.enter();
            TableStructureEventDispatcher instance = instances.get(tableID);
            if (instance == null) {
                instance = new TableStructureEventDispatcher();
                instances.put(tableID, instance);
            }
            TableStructureEventDispatcher tableStructureEventDispatcher = instance;
            return tableStructureEventDispatcher;
        }
        finally {
            class_mon.exit();
        }
    }

    public void addListener(TableStructureModificationListener listener) {
        try {
            this.listeners_mon.enter();
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void removeListener(TableStructureModificationListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void tableStructureChanged(boolean columnAddedOrRemoved, Class forPluginDataSourceType) {
        for (TableStructureModificationListener listener : this.listeners) {
            try {
                listener.tableStructureChanged(columnAddedOrRemoved, forPluginDataSourceType);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void columnSizeChanged(TableColumnCore tableColumn, int diff) {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.columnSizeChanged(tableColumn, diff);
        }
    }

    @Override
    public void columnInvalidate(TableColumnCore tableColumn) {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.columnInvalidate(tableColumn);
        }
    }

    public void cellInvalidate(TableColumnCore tableColumn, Object data_source) {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.cellInvalidate(tableColumn, data_source);
        }
    }

    @Override
    public void columnOrderChanged(int[] iPositions) {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.columnOrderChanged(iPositions);
        }
    }

    @Override
    public void sortOrderChanged() {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.sortOrderChanged();
        }
    }
}

