/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.upnp;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.net.natpmp.NATPMPDeviceAdapter;
import com.biglybt.net.natpmp.NatPMPDeviceFactory;
import com.biglybt.net.natpmp.upnp.NatPMPUPnP;
import com.biglybt.net.natpmp.upnp.NatPMPUPnPFactory;
import com.biglybt.net.upnp.UPnP;
import com.biglybt.net.upnp.UPnPAdapter;
import com.biglybt.net.upnp.UPnPDevice;
import com.biglybt.net.upnp.UPnPException;
import com.biglybt.net.upnp.UPnPFactory;
import com.biglybt.net.upnp.UPnPListener;
import com.biglybt.net.upnp.UPnPLogListener;
import com.biglybt.net.upnp.UPnPRootDevice;
import com.biglybt.net.upnp.UPnPRootDeviceListener;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.services.UPnPWANConnection;
import com.biglybt.net.upnp.services.UPnPWANConnectionListener;
import com.biglybt.net.upnp.services.UPnPWANConnectionPortMapping;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginConfig;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.logging.LoggerChannelListener;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.LabelParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.UTTimer;
import com.biglybt.pif.utils.UTTimerEvent;
import com.biglybt.pif.utils.UTTimerEventPerformer;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocument;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import com.biglybt.plugin.upnp.UPnPMapping;
import com.biglybt.plugin.upnp.UPnPMappingListener;
import com.biglybt.plugin.upnp.UPnPMappingManager;
import com.biglybt.plugin.upnp.UPnPMappingManagerListener;
import com.biglybt.plugin.upnp.UPnPPluginService;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class UPnPPlugin
implements Plugin,
UPnPListener,
UPnPMappingListener,
UPnPWANConnectionListener,
AEDiagnosticsEvidenceGenerator {
    private static final String UPNP_PLUGIN_CONFIGSECTION_ID = "UPnP";
    private static final String NATPMP_PLUGIN_CONFIGSECTION_ID = "NATPMP";
    private static final String STATS_DISCOVER = "discover";
    private static final String STATS_FOUND = "found";
    private static final String STATS_READ_OK = "read_ok";
    private static final String STATS_READ_BAD = "read_bad";
    private static final String STATS_MAP_OK = "map_ok";
    private static final String STATS_MAP_BAD = "map_bad";
    private static final String[] STATS_KEYS = new String[]{"discover", "found", "read_ok", "read_bad", "map_ok", "map_bad"};
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private UPnPMappingManager mapping_manager = UPnPMappingManager.getSingleton(this);
    private UPnP upnp;
    private UPnPLogListener upnp_log_listener;
    private NatPMPUPnP nat_pmp_upnp;
    private BooleanParameter natpmp_enable_param;
    private StringParameter nat_pmp_router;
    private BooleanParameter upnp_enable_param;
    private BooleanParameter trace_to_log;
    private StringParameter desc_prefix_param;
    private BooleanParameter alert_success_param;
    private BooleanParameter grab_ports_param;
    private BooleanParameter alert_other_port_param;
    private BooleanParameter alert_device_probs_param;
    private BooleanParameter release_mappings_param;
    private StringParameter selected_interfaces_param;
    private StringParameter selected_addresses_param;
    private BooleanParameter ignore_bad_devices;
    private LabelParameter ignored_devices_list;
    private List<UPnPMapping> mappings = new ArrayList<UPnPMapping>();
    private List<UPnPPluginService> services = new ArrayList<UPnPPluginService>();
    private Map<URL, String> root_info_map = new HashMap<URL, String>();
    private Map<String, String> log_no_repeat_map = new HashMap<String, String>();
    protected AEMonitor this_mon = new AEMonitor("UPnPPlugin");

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Universal Plug and Play (UPnP)");
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(UPNP_PLUGIN_CONFIGSECTION_ID);
        this.log.setDiagnostic();
        this.log.setForce(true);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(UPNP_PLUGIN_CONFIGSECTION_ID);
        model.setConfigSectionID(UPNP_PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel upnp_config = ui_manager.createBasicPluginConfigModel("plugins", UPNP_PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel natpmp_config = ui_manager.createBasicPluginConfigModel(UPNP_PLUGIN_CONFIGSECTION_ID, NATPMP_PLUGIN_CONFIGSECTION_ID);
        natpmp_config.addLabelParameter2("natpmp.info");
        ActionParameter natpmp_wiki = natpmp_config.addActionParameter2("Utils.link.visit", "MainWindow.about.internet.wiki");
        natpmp_wiki.setStyle(2);
        natpmp_wiki.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                try {
                    UPnPPlugin.this.plugin_interface.getUIManager().openURL(new URL("https://wiki.biglybt.com/w/NATPMP"));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.natpmp_enable_param = natpmp_config.addBooleanParameter2("natpmp.enable", "natpmp.enable", false);
        this.nat_pmp_router = natpmp_config.addStringParameter2("natpmp.routeraddress", "natpmp.routeraddress", "");
        this.natpmp_enable_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                UPnPPlugin.this.setNATPMPEnableState();
            }
        });
        this.natpmp_enable_param.addEnabledOnSelection((Parameter)this.nat_pmp_router);
        upnp_config.addLabelParameter2("upnp.info");
        upnp_config.addLabelParameter2("upnp.info.ipv4");
        upnp_config.addHyperlinkParameter2("upnp.wiki_link", "https://wiki.biglybt.com/w/UPnP");
        this.upnp_enable_param = upnp_config.addBooleanParameter2("upnp.enable", "upnp.enable", true);
        this.grab_ports_param = upnp_config.addBooleanParameter2("upnp.grabports", "upnp.grabports", false);
        this.release_mappings_param = upnp_config.addBooleanParameter2("upnp.releasemappings", "upnp.releasemappings", true);
        ActionParameter refresh_param = upnp_config.addActionParameter2("upnp.refresh.label", "upnp.refresh.button");
        refresh_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                UPnPPlugin.this.refreshMappings();
            }
        });
        final BooleanParameter auto_refresh_on_bad_nat_param = upnp_config.addBooleanParameter2("upnp.refresh_on_bad_nat", "upnp.refresh_mappings_on_bad_nat", false);
        this.plugin_interface.getUtilities().createTimer("upnp mapping auto-refresh", true).addPeriodicEvent(60000L, new UTTimerEventPerformer(){
            private long last_bad_nat = 0L;

            @Override
            public void perform(UTTimerEvent event2) {
                long now;
                if (UPnPPlugin.this.upnp == null) {
                    return;
                }
                if (!auto_refresh_on_bad_nat_param.getValue()) {
                    return;
                }
                if (!UPnPPlugin.this.upnp_enable_param.getValue()) {
                    return;
                }
                int status = UPnPPlugin.this.plugin_interface.getConnectionManager().getNATStatus();
                if (status == 3 && this.last_bad_nat + 900000L < (now = UPnPPlugin.this.plugin_interface.getUtilities().getCurrentSystemTime())) {
                    this.last_bad_nat = now;
                    UPnPPlugin.this.log.log(2, "NAT status is firewalled - trying to refresh UPnP mappings");
                    UPnPPlugin.this.refreshMappings(true);
                }
            }
        });
        upnp_config.addLabelParameter2("blank.resource");
        this.alert_success_param = upnp_config.addBooleanParameter2("upnp.alertsuccess", "upnp.alertsuccess", false);
        this.alert_other_port_param = upnp_config.addBooleanParameter2("upnp.alertothermappings", "upnp.alertothermappings", true);
        this.alert_device_probs_param = upnp_config.addBooleanParameter2("upnp.alertdeviceproblems", "upnp.alertdeviceproblems", true);
        this.selected_interfaces_param = upnp_config.addStringParameter2("upnp.selectedinterfaces", "upnp.selectedinterfaces", "");
        this.selected_interfaces_param.setGenerateIntermediateEvents(false);
        this.selected_addresses_param = upnp_config.addStringParameter2("upnp.selectedaddresses", "upnp.selectedaddresses", "");
        this.selected_addresses_param.setGenerateIntermediateEvents(false);
        this.desc_prefix_param = upnp_config.addStringParameter2("upnp.descprefix", "upnp.descprefix", String.valueOf(Constants.APP_NAME) + " UPnP");
        this.desc_prefix_param.setGenerateIntermediateEvents(false);
        this.ignore_bad_devices = upnp_config.addBooleanParameter2("upnp.ignorebaddevices", "upnp.ignorebaddevices", true);
        this.ignored_devices_list = upnp_config.addLabelParameter2("upnp.ignorebaddevices.info");
        ActionParameter reset_param = upnp_config.addActionParameter2("upnp.ignorebaddevices.reset", "upnp.ignorebaddevices.reset.action");
        reset_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                PluginConfig pc = UPnPPlugin.this.plugin_interface.getPluginconfig();
                int i = 0;
                while (i < STATS_KEYS.length) {
                    String key = "upnp.device.stats." + STATS_KEYS[i];
                    pc.setPluginMapParameter(key, new HashMap());
                    ++i;
                }
                pc.setPluginMapParameter("upnp.device.ignorelist", new HashMap());
                UPnPPlugin.this.updateIgnoreList();
            }
        });
        this.trace_to_log = upnp_config.addBooleanParameter2("upnp.trace_to_log", "upnp.trace_to_log", false);
        final boolean enabled = this.upnp_enable_param.getValue();
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.alert_success_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.grab_ports_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)refresh_param);
        auto_refresh_on_bad_nat_param.addEnabledOnSelection((Parameter)refresh_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.alert_other_port_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.alert_device_probs_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.release_mappings_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.selected_interfaces_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.selected_addresses_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.desc_prefix_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.ignore_bad_devices);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.ignored_devices_list);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)reset_param);
        this.upnp_enable_param.addEnabledOnSelection((Parameter)this.trace_to_log);
        this.natpmp_enable_param.setEnabled(enabled);
        model.getStatus().setText(enabled ? "Running" : "Disabled");
        this.upnp_enable_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter p) {
                boolean e = UPnPPlugin.this.upnp_enable_param.getValue();
                UPnPPlugin.this.natpmp_enable_param.setEnabled(e);
                model.getStatus().setText(e ? "Running" : "Disabled");
                if (e) {
                    UPnPPlugin.this.startUp();
                } else {
                    UPnPPlugin.this.closeDown(true);
                }
                UPnPPlugin.this.setNATPMPEnableState();
            }
        });
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(String.valueOf(message) + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(String.valueOf(error.toString()) + "\n");
            }
        });
        DelayedTask dt = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                if (enabled) {
                    UPnPPlugin.this.updateIgnoreList();
                    UPnPPlugin.this.startUp();
                }
            }
        });
        dt.queue();
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
            }

            @Override
            public void closedownInitiated() {
                if (UPnPPlugin.this.services.size() == 0) {
                    UPnPPlugin.this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", "");
                }
            }

            @Override
            public void closedownComplete() {
                UPnPPlugin.this.closeDown(true);
            }
        });
    }

    protected void updateIgnoreList() {
        try {
            String param = "";
            if (this.ignore_bad_devices.getValue()) {
                PluginConfig pc = this.plugin_interface.getPluginconfig();
                Map ignored = pc.getPluginMapParameter("upnp.device.ignorelist", new HashMap());
                for (Map.Entry entry : ignored.entrySet()) {
                    Map value = (Map)entry.getValue();
                    param = String.valueOf(param) + "\n    " + entry.getKey() + ": " + new String((byte[])value.get("Location"));
                }
                if (ignored.size() > 0) {
                    this.log.log("Devices currently being ignored: " + param);
                }
            }
            String text = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("upnp.ignorebaddevices.info", new String[]{param});
            this.ignored_devices_list.setLabelText(text);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void ignoreDevice(String USN, URL location) {
        if (this.ignore_bad_devices.getValue()) {
            try {
                PluginConfig pc = this.plugin_interface.getPluginconfig();
                Map ignored = pc.getPluginMapParameter("upnp.device.ignorelist", new HashMap());
                HashMap<String, byte[]> entry = (HashMap<String, byte[]>)ignored.get(USN);
                if (entry == null) {
                    entry = new HashMap<String, byte[]>();
                    entry.put("Location", location.toString().getBytes());
                    ignored.put(USN, entry);
                    pc.setPluginMapParameter("upnp.device.ignorelist", ignored);
                    this.updateIgnoreList();
                    String text = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("upnp.ignorebaddevices.alert", new String[]{location.toString()});
                    this.log.logAlertRepeatable(2, text);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void startUp() {
        if (this.upnp != null) {
            this.refreshMappings();
            return;
        }
        final LoggerChannel core_log = this.plugin_interface.getLogger().getChannel("UPnP Core");
        try {
            this.upnp = UPnPFactory.getSingleton(new UPnPAdapter(){
                Set exception_traces = new HashSet();

                @Override
                public SimpleXMLParserDocument parseXML(String data) throws SimpleXMLParserDocumentException {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(data);
                }

                @Override
                public ResourceDownloaderFactory getResourceDownloaderFactory() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                }

                @Override
                public UTTimer createTimer(String name) {
                    return UPnPPlugin.this.plugin_interface.getUtilities().createTimer(name, true);
                }

                @Override
                public void createThread(String name, Runnable runnable) {
                    UPnPPlugin.this.plugin_interface.getUtilities().createThread(name, runnable);
                }

                @Override
                public Comparator getAlphanumericComparator() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
                }

                @Override
                public void trace(String str) {
                    core_log.log(str);
                    if (UPnPPlugin.this.trace_to_log.getValue()) {
                        UPnPPlugin.this.upnp_log_listener.log(str);
                    }
                }

                @Override
                public void log(Throwable e) {
                    String nested = Debug.getNestedExceptionMessage(e);
                    if (!this.exception_traces.contains(nested)) {
                        this.exception_traces.add(nested);
                        if (this.exception_traces.size() > 128) {
                            this.exception_traces.clear();
                        }
                        core_log.log(e);
                    } else {
                        core_log.log(nested);
                    }
                }

                @Override
                public void log(String str) {
                    UPnPPlugin.this.log.log(str);
                }

                @Override
                public String getTraceDir() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getUserDir();
                }
            }, this.getSelectedInterfaces());
            this.upnp.addRootDeviceListener(this);
            this.upnp_log_listener = new UPnPLogListener(){

                @Override
                public void log(String str) {
                    UPnPPlugin.this.log.log(str);
                }

                @Override
                public void logAlert(String str, boolean error, int type) {
                    boolean logged = false;
                    if (UPnPPlugin.this.alert_device_probs_param.getValue()) {
                        if (type == 1) {
                            UPnPPlugin.this.log.logAlertRepeatable(error ? 3 : 2, str);
                            logged = true;
                        } else {
                            boolean do_it = false;
                            if (type == 3) {
                                byte[] fp = UPnPPlugin.this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(str.getBytes());
                                String key = "upnp.alert.fp." + UPnPPlugin.this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(fp);
                                PluginConfig pc = UPnPPlugin.this.plugin_interface.getPluginconfig();
                                if (!pc.getPluginBooleanParameter(key, false)) {
                                    pc.setPluginParameter(key, true);
                                    do_it = true;
                                }
                            } else {
                                do_it = true;
                            }
                            if (do_it) {
                                UPnPPlugin.this.log.logAlert(error ? 3 : 2, str);
                                logged = true;
                            }
                        }
                    }
                    if (!logged) {
                        UPnPPlugin.this.log.log(str);
                    }
                }
            };
            this.upnp.addLogListener(this.upnp_log_listener);
            this.mapping_manager.addListener(new UPnPMappingManagerListener(){

                @Override
                public void mappingAdded(UPnPMapping mapping2) {
                    UPnPPlugin.this.addMapping(mapping2);
                }
            });
            UPnPMapping[] upnp_mappings = this.mapping_manager.getMappings();
            int i = 0;
            while (i < upnp_mappings.length) {
                this.addMapping(upnp_mappings[i]);
                ++i;
            }
            this.setNATPMPEnableState();
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    protected void closeDown(final boolean end_of_day) {
        final AESemaphore sem = new AESemaphore("UPnPPlugin:closeTimeout");
        new AEThread2("UPnPPlugin:closeTimeout"){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < UPnPPlugin.this.mappings.size()) {
                        UPnPMapping mapping2 = (UPnPMapping)UPnPPlugin.this.mappings.get(i);
                        if (mapping2.isEnabled()) {
                            int j = 0;
                            while (j < UPnPPlugin.this.services.size()) {
                                UPnPPluginService service = (UPnPPluginService)UPnPPlugin.this.services.get(j);
                                service.removeMapping(UPnPPlugin.this.log, mapping2, end_of_day);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    sem.release();
                }
            }
        }.start();
        if (!sem.reserve(end_of_day ? 15000 : 0)) {
            String msg = "A UPnP device is taking a long time to release its port mappings, consider disabling this via the UPnP configuration.";
            if (this.upnp_log_listener != null) {
                this.upnp_log_listener.logAlert(msg, false, 2);
            } else {
                this.log.logAlertRepeatable(2, msg);
            }
        }
    }

    @Override
    public boolean deviceDiscovered(String USN, URL location) {
        String[] addresses = this.getSelectedAddresses();
        if (addresses.length > 0) {
            String address = location.getHost();
            boolean found = false;
            boolean all_exclude = true;
            int i = 0;
            while (i < addresses.length) {
                String this_address = addresses[i];
                boolean include = true;
                if (this_address.startsWith("+")) {
                    this_address = this_address.substring(1);
                    all_exclude = false;
                } else if (this_address.startsWith("-")) {
                    this_address = this_address.substring(1);
                    include = false;
                } else {
                    all_exclude = false;
                }
                if (this_address.equals(address)) {
                    if (!include) {
                        this.logNoRepeat(USN, "Device '" + location + "' is being ignored as excluded in address list", "");
                        return false;
                    }
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found && !all_exclude) {
                this.logNoRepeat(USN, "Device '" + location + "' is being ignored as not in address list", "");
                return false;
            }
        }
        if (!this.ignore_bad_devices.getValue()) {
            return true;
        }
        this.incrementDeviceStats(USN, STATS_DISCOVER);
        boolean ok = this.checkDeviceStats(USN, location);
        String stats2 = "";
        int i = 0;
        while (i < STATS_KEYS.length) {
            stats2 = String.valueOf(stats2) + (i == 0 ? "" : ",") + STATS_KEYS[i] + "=" + this.getDeviceStats(USN, STATS_KEYS[i]);
            ++i;
        }
        if (!ok) {
            this.logNoRepeat(USN, "Device '" + location + "' is being ignored: ", stats2);
        } else {
            this.logNoRepeat(USN, "Device '" + location + "' is ok: ", stats2);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logNoRepeat(String usn, String msg, String suffix) {
        Map<String, String> map = this.log_no_repeat_map;
        synchronized (map) {
            String last = this.log_no_repeat_map.get(usn);
            if (last != null && last.equals(msg)) {
                return;
            }
            this.log_no_repeat_map.put(usn, msg);
        }
        this.log.log(String.valueOf(msg) + suffix);
    }

    @Override
    public void rootDeviceFound(UPnPRootDevice device) {
        block7: {
            this.incrementDeviceStats(device.getUSN(), STATS_FOUND);
            this.checkDeviceStats(device);
            try {
                int interesting = this.processDevice(device.getDevice());
                if (interesting <= 0) break block7;
                try {
                    this.this_mon.enter();
                    this.root_info_map.put(device.getLocation(), device.getInfo());
                    Iterator<String> it = this.root_info_map.values().iterator();
                    String all_info = "";
                    ArrayList<String> reported_info = new ArrayList<String>();
                    while (it.hasNext()) {
                        String info = it.next();
                        if (info == null || reported_info.contains(info)) continue;
                        reported_info.add(info);
                        all_info = String.valueOf(all_info) + (all_info.length() == 0 ? "" : ",") + info;
                    }
                    if (all_info.length() > 0) {
                        this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", all_info);
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            catch (Throwable e) {
                this.log.log("Root device processing fails", e);
            }
        }
    }

    protected boolean checkDeviceStats(UPnPRootDevice root) {
        return this.checkDeviceStats(root.getUSN(), root.getLocation());
    }

    protected boolean checkDeviceStats(String USN, URL location) {
        long discovers = this.getDeviceStats(USN, STATS_DISCOVER);
        long founds = this.getDeviceStats(USN, STATS_FOUND);
        if (discovers > 3L && founds == 0L) {
            this.ignoreDevice(USN, location);
            return false;
        }
        if (founds > 0L) {
            this.setDeviceStats(USN, STATS_DISCOVER, 0L);
            this.setDeviceStats(USN, STATS_FOUND, 0L);
        }
        long map_ok = this.getDeviceStats(USN, STATS_MAP_OK);
        long map_bad = this.getDeviceStats(USN, STATS_MAP_BAD);
        if (map_bad > 5L && map_ok == 0L) {
            this.ignoreDevice(USN, location);
            return false;
        }
        if (map_ok > 0L) {
            this.setDeviceStats(USN, STATS_MAP_OK, 0L);
            this.setDeviceStats(USN, STATS_MAP_BAD, 0L);
        }
        return true;
    }

    protected long incrementDeviceStats(String USN, String stat_key) {
        String key = "upnp.device.stats." + stat_key;
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        Map counts = pc.getPluginMapParameter(key, new HashMap());
        Long count = (Long)counts.get(USN);
        count = count == null ? new Long(1L) : new Long(count + 1L);
        counts.put(USN, count);
        pc.getPluginMapParameter(key, counts);
        return count;
    }

    protected long getDeviceStats(String USN, String stat_key) {
        String key = "upnp.device.stats." + stat_key;
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        Map counts = pc.getPluginMapParameter(key, new HashMap());
        Long count = (Long)counts.get(USN);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    protected void setDeviceStats(String USN, String stat_key, long value) {
        String key = "upnp.device.stats." + stat_key;
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        Map counts = pc.getPluginMapParameter(key, new HashMap());
        counts.put(USN, new Long(value));
        pc.getPluginMapParameter(key, counts);
    }

    @Override
    public void mappingResult(UPnPWANConnection connection, boolean ok) {
        UPnPRootDevice root = connection.getGenericService().getDevice().getRootDevice();
        this.incrementDeviceStats(root.getUSN(), ok ? STATS_MAP_OK : STATS_MAP_BAD);
        this.checkDeviceStats(root);
    }

    @Override
    public void mappingsReadResult(UPnPWANConnection connection, boolean ok) {
        UPnPRootDevice root = connection.getGenericService().getDevice().getRootDevice();
        this.incrementDeviceStats(root.getUSN(), ok ? STATS_READ_OK : STATS_READ_BAD);
    }

    protected String[] getSelectedInterfaces() {
        String si = this.selected_interfaces_param.getValue().trim();
        StringTokenizer tok = new StringTokenizer(si, ";");
        ArrayList<String> res = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().trim();
            if (s.length() <= 0) continue;
            res.add(s);
        }
        return res.toArray(new String[res.size()]);
    }

    protected String[] getSelectedAddresses() {
        String si = this.selected_addresses_param.getValue().trim();
        StringTokenizer tok = new StringTokenizer(si, ";");
        ArrayList<String> res = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().trim();
            if (s.length() <= 0) continue;
            res.add(s);
        }
        return res.toArray(new String[res.size()]);
    }

    protected int processDevice(UPnPDevice device) throws UPnPException {
        int interesting = this.processServices(device, device.getServices());
        UPnPDevice[] kids = device.getSubDevices();
        int i = 0;
        while (i < kids.length) {
            interesting += this.processDevice(kids[i]);
            ++i;
        }
        return interesting;
    }

    protected int processServices(UPnPDevice device, UPnPService[] device_services) throws UPnPException {
        int interesting = 0;
        int i = 0;
        while (i < device_services.length) {
            UPnPService s = device_services[i];
            String service_type = s.getServiceType();
            if (GeneralUtils.startsWithIgnoreCase(service_type, "urn:schemas-upnp-org:service:WANIPConnection:") || GeneralUtils.startsWithIgnoreCase(service_type, "urn:schemas-upnp-org:service:WANPPPConnection:")) {
                final UPnPWANConnection wan_service = (UPnPWANConnection)s.getSpecificService();
                device.getRootDevice().addListener(new UPnPRootDeviceListener(){

                    @Override
                    public void lost(UPnPRootDevice root, boolean replaced) {
                        UPnPPlugin.this.removeService(wan_service, replaced);
                    }
                });
                this.addService(wan_service);
                ++interesting;
            } else {
                GeneralUtils.startsWithIgnoreCase(service_type, "urn:schemas-upnp-org:service:WANCommonInterfaceConfig:");
            }
            ++i;
        }
        return interesting;
    }

    protected void addService(UPnPWANConnection wan_service) throws UPnPException {
        UPnPWANConnectionPortMapping[] ports;
        wan_service.addListener(this);
        this.mapping_manager.serviceFound(wan_service);
        this.log.log("    Found " + (!wan_service.getGenericService().getServiceType().contains("PPP") ? "WANIPConnection" : "WANPPPConnection"));
        String usn = wan_service.getGenericService().getDevice().getRootDevice().getUSN();
        if (this.getDeviceStats(usn, STATS_READ_OK) == 0L && this.getDeviceStats(usn, STATS_READ_BAD) > 2L) {
            ports = new UPnPWANConnectionPortMapping[]{};
            wan_service.periodicallyRecheckMappings(false);
            this.log.log("    Not reading port mappings from device due to previous failures");
        } else {
            ports = wan_service.getPortMappings();
        }
        int j = 0;
        while (j < ports.length) {
            this.log.log("      mapping [" + j + "] " + ports[j].getExternalPort() + "/" + (ports[j].isTCP() ? "TCP" : "UDP") + " [" + ports[j].getDescription() + "] -> " + ports[j].getInternalHost());
            ++j;
        }
        try {
            this.this_mon.enter();
            this.services.add(new UPnPPluginService(wan_service, ports, this.desc_prefix_param, this.alert_success_param, this.grab_ports_param, this.alert_other_port_param, this.release_mappings_param));
            if (this.services.size() > 1) {
                PluginConfig pc;
                String new_usn = wan_service.getGenericService().getDevice().getRootDevice().getUSN();
                boolean multiple_found = false;
                int i = 0;
                while (i < this.services.size() - 1) {
                    UPnPPluginService service = this.services.get(i);
                    String existing_usn = service.getService().getGenericService().getDevice().getRootDevice().getUSN();
                    if (!new_usn.equals(existing_usn)) {
                        multiple_found = true;
                        break;
                    }
                    ++i;
                }
                if (multiple_found && !(pc = this.plugin_interface.getPluginconfig()).getPluginBooleanParameter("upnp.device.multipledevices.warned", false)) {
                    pc.setPluginParameter("upnp.device.multipledevices.warned", true);
                    String text = MessageText.getString("upnp.alert.multipledevice.warning");
                    this.log.logAlertRepeatable(2, text);
                }
            }
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removeService(UPnPWANConnection wan_service, boolean replaced) {
        try {
            this.this_mon.enter();
            String name = !wan_service.getGenericService().getServiceType().contains("PPP") ? "WANIPConnection" : "WANPPPConnection";
            String text = MessageText.getString("upnp.alert.lostdevice", new String[]{name, wan_service.getGenericService().getDevice().getRootDevice().getLocation().getHost()});
            this.log.log(text);
            if (!replaced && this.alert_device_probs_param.getValue()) {
                this.log.logAlertRepeatable(2, text);
            }
            int i = 0;
            while (i < this.services.size()) {
                UPnPPluginService ps = this.services.get(i);
                if (ps.getService() == wan_service) {
                    this.services.remove(i);
                    break;
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void addMapping(UPnPMapping mapping2) {
        try {
            this.this_mon.enter();
            this.mappings.add(mapping2);
            this.log.log("Mapping request: " + mapping2.getString() + ", enabled = " + mapping2.isEnabled());
            mapping2.addListener(this);
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void mappingChanged(UPnPMapping mapping2) {
        this.checkState();
    }

    @Override
    public void mappingDestroyed(UPnPMapping mapping2) {
        try {
            this.this_mon.enter();
            this.mappings.remove(mapping2);
            this.log.log("Mapping request removed: " + mapping2.getString());
            int j = 0;
            while (j < this.services.size()) {
                UPnPPluginService service = this.services.get(j);
                service.removeMapping(this.log, mapping2, false);
                ++j;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void checkState() {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.mappings.size()) {
                UPnPMapping mapping2 = this.mappings.get(i);
                int j = 0;
                while (j < this.services.size()) {
                    UPnPPluginService service = this.services.get(j);
                    service.checkMapping(this.log, mapping2);
                    ++j;
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public String[] getExternalIPAddresses() {
        ArrayList<String> res = new ArrayList<String>();
        try {
            this.this_mon.enter();
            int j = 0;
            while (j < this.services.size()) {
                UPnPPluginService service = this.services.get(j);
                try {
                    String address = service.getService().getExternalIPAddress();
                    if (address != null) {
                        res.add(address);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++j;
            }
        }
        finally {
            this.this_mon.exit();
        }
        return res.toArray(new String[res.size()]);
    }

    public UPnPPluginService[] getServices() {
        try {
            this.this_mon.enter();
            UPnPPluginService[] uPnPPluginServiceArray = this.services.toArray(new UPnPPluginService[this.services.size()]);
            return uPnPPluginServiceArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public UPnPPluginService[] getServices(UPnPDevice device) {
        String target_usn = device.getRootDevice().getUSN();
        ArrayList<UPnPPluginService> res = new ArrayList<UPnPPluginService>();
        try {
            this.this_mon.enter();
            for (UPnPPluginService service : this.services) {
                String this_usn = service.getService().getGenericService().getDevice().getRootDevice().getUSN();
                if (!this_usn.equals(target_usn)) continue;
                res.add(service);
            }
        }
        finally {
            this.this_mon.exit();
        }
        return res.toArray(new UPnPPluginService[res.size()]);
    }

    public UPnPMapping addMapping(String desc_resource, boolean tcp, int port, boolean enabled) {
        return this.mapping_manager.addMapping(desc_resource, tcp, port, enabled);
    }

    public UPnPMapping getMapping(boolean tcp, int port) {
        return this.mapping_manager.getMapping(tcp, port);
    }

    public UPnPMapping[] getMappings() {
        return this.mapping_manager.getMappings();
    }

    public boolean isEnabled() {
        return this.upnp_enable_param.getValue();
    }

    protected void setNATPMPEnableState() {
        boolean enabled = this.natpmp_enable_param.getValue() && this.upnp_enable_param.getValue();
        try {
            if (enabled) {
                if (this.nat_pmp_upnp == null) {
                    this.nat_pmp_upnp = NatPMPUPnPFactory.create(this.upnp, NatPMPDeviceFactory.getSingleton(new NATPMPDeviceAdapter(){

                        @Override
                        public String getRouterAddress() {
                            return UPnPPlugin.this.nat_pmp_router.getValue();
                        }

                        @Override
                        public void log(String str) {
                            UPnPPlugin.this.log.log("NAT-PMP: " + str);
                        }
                    }));
                    this.nat_pmp_upnp.addListener(this);
                }
                this.nat_pmp_upnp.setEnabled(true);
            } else if (this.nat_pmp_upnp != null) {
                this.nat_pmp_upnp.setEnabled(false);
            }
        }
        catch (Throwable e) {
            this.log.log("Failed to initialise NAT-PMP subsystem", e);
        }
    }

    protected void logAlert(int type, String resource, String[] params) {
        String text = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText(resource, params);
        this.log.logAlertRepeatable(type, text);
    }

    public void refreshMappings() {
        this.refreshMappings(false);
    }

    public void refreshMappings(boolean force) {
        if (force) {
            this.closeDown(true);
            this.startUp();
        } else {
            this.upnp.reset();
        }
    }

    @Override
    public void generate(IndentWriter writer) {
        ArrayList<UPnPPluginService> services_copy;
        ArrayList<UPnPMapping> mappings_copy;
        try {
            this.this_mon.enter();
            mappings_copy = new ArrayList<UPnPMapping>(this.mappings);
            services_copy = new ArrayList<UPnPPluginService>(this.services);
        }
        finally {
            this.this_mon.exit();
        }
        writer.println("Mappings");
        try {
            writer.indent();
            for (UPnPMapping mapping2 : mappings_copy) {
                if (!mapping2.isEnabled()) continue;
                writer.println(mapping2.getString());
            }
        }
        finally {
            writer.exdent();
        }
        writer.println("Services");
        try {
            writer.indent();
            for (UPnPPluginService service : services_copy) {
                writer.println(service.getString());
            }
        }
        finally {
            writer.exdent();
        }
    }
}

