/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.tracker.dht;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.TrackerPeerSourceAdapter;
import com.biglybt.core.tracker.protocol.PRHelpers;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadAnnounceResultPeer;
import com.biglybt.pif.download.DownloadAttributeListener;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadTrackerListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.logging.LoggerChannelListener;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.UTTimerEvent;
import com.biglybt.pif.utils.UTTimerEventPerformer;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.plugin.dht.DHTPluginContact;
import com.biglybt.plugin.dht.DHTPluginOperationListener;
import com.biglybt.plugin.dht.DHTPluginValue;
import com.biglybt.plugin.tracker.dht.DHTTrackerPluginAlt;
import com.biglybt.util.StringCompareUtils;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class DHTTrackerPlugin
implements Plugin,
DownloadListener,
DownloadAttributeListener,
DownloadTrackerListener {
    public static Object DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY = new Object();
    private static final String PLUGIN_NAME = "Distributed Tracker";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.dhttracker";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.dhttracker";
    private static final int ANNOUNCE_TIMEOUT = 120000;
    private static final int ANNOUNCE_DERIVED_TIMEOUT = 60000;
    private static final int SCRAPE_TIMEOUT = 30000;
    private static final int ANNOUNCE_MIN_DEFAULT = 120000;
    private static final int ANNOUNCE_MAX = 3600000;
    private static final int ANNOUNCE_MAX_DERIVED_ONLY = 1800000;
    private static final int INTERESTING_CHECK_PERIOD = 14400000;
    private static final int INTERESTING_INIT_RAND_OURS = 300000;
    private static final int INTERESTING_INIT_MIN_OURS = 120000;
    private static final int INTERESTING_INIT_RAND_OTHERS = 1800000;
    private static final int INTERESTING_INIT_MIN_OTHERS = 300000;
    private static final int INTERESTING_DHT_CHECK_PERIOD = 3600000;
    private static final int INTERESTING_DHT_INIT_RAND = 300000;
    private static final int INTERESTING_DHT_INIT_MIN = 120000;
    private static final int INTERESTING_AVAIL_MAX = 8;
    private static final int INTERESTING_PUB_MAX_DEFAULT = 30;
    private static final int REG_TYPE_NONE = 1;
    private static final int REG_TYPE_FULL = 2;
    private static final int REG_TYPE_DERIVED = 3;
    private static final int LIMITED_TRACK_SIZE = 16;
    private static final boolean TRACK_NORMAL_DEFAULT = true;
    private static final boolean TRACK_LIMITED_DEFAULT = true;
    private static final boolean TEST_ALWAYS_TRACK = false;
    public static final int NUM_WANT = 30;
    private static final long start_time = SystemTime.getCurrentTime();
    private static final Object DL_DERIVED_METRIC_KEY = new Object();
    private static final int DL_DERIVED_MIN_TRACK = 5;
    private static final int DL_DERIVED_MAX_TRACK = 20;
    private static final int DIRECT_INJECT_PEER_MAX = 5;
    private static final Object LATEST_REGISTER_REASON = new Object();
    private static URL DEFAULT_URL;
    private PluginInterface plugin_interface;
    private BasicPluginViewModel model;
    private DHTPlugin dht;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_peer_sources;
    private Map<Download, Long> interesting_downloads = new HashMap<Download, Long>();
    private int interesting_published = 0;
    private int interesting_pub_max = 30;
    private Map<Download, int[]> running_downloads = new HashMap<Download, int[]>();
    private Map<Download, int[]> run_data_cache = new HashMap<Download, int[]>();
    private Map<Download, RegistrationDetails> registered_downloads = new HashMap<Download, RegistrationDetails>();
    private Map<Download, Boolean> limited_online_tracking = new HashMap<Download, Boolean>();
    private Map<Download, Long> query_map = new HashMap<Download, Long>();
    private Map<Download, Integer> in_progress = new HashMap<Download, Integer>();
    private boolean track_only_decentralsed = COConfigurationManager.getBooleanParameter("dhtplugin.track.only.decentralised", false);
    private BooleanParameter track_normal_when_offline;
    private BooleanParameter track_limited_when_online;
    private long current_announce_interval = 120000L;
    private LoggerChannel log;
    private Map<Download, int[]> scrape_injection_map = new WeakHashMap<Download, int[]>();
    private Random random = new Random();
    private boolean is_running;
    private AEMonitor this_mon = new AEMonitor("DHTTrackerPlugin");
    private AESemaphore initialised_sem = new AESemaphore("DHTTrackerPlugin:init");
    private DHTTrackerPluginAlt alt_lookup_handler;
    private boolean disable_put;

    static {
        try {
            DEFAULT_URL = new URL("dht:");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public DHTTrackerPlugin() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable.Proxy", "Enable.SOCKS"}, new com.biglybt.core.config.ParameterListener(){

            @Override
            public void parameterChanged(String parameter_name) {
                boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                DHTTrackerPlugin.this.disable_put = enable_proxy && enable_socks;
            }
        });
    }

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
        this.ta_peer_sources = this.plugin_interface.getTorrentManager().getAttribute("PeerSources");
        UIManager ui_manager = this.plugin_interface.getUIManager();
        this.model = ui_manager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        this.model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        this.track_normal_when_offline = config.addBooleanParameter2("dhttracker.tracknormalwhenoffline", "dhttracker.tracknormalwhenoffline", true);
        this.track_limited_when_online = config.addBooleanParameter2("dhttracker.tracklimitedwhenonline", "dhttracker.tracklimitedwhenonline", true);
        this.track_limited_when_online.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                DHTTrackerPlugin.this.configChanged();
            }
        });
        this.track_normal_when_offline.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                DHTTrackerPlugin.this.track_limited_when_online.setEnabled(DHTTrackerPlugin.this.track_normal_when_offline.getValue());
                DHTTrackerPlugin.this.configChanged();
            }
        });
        if (!this.track_normal_when_offline.getValue()) {
            this.track_limited_when_online.setEnabled(false);
        }
        this.interesting_pub_max = this.plugin_interface.getPluginconfig().getPluginIntParameter("dhttracker.presencepubmax", 30);
        BooleanParameter enable_alt = config.addBooleanParameter2("dhttracker.enable_alt", "dhttracker.enable_alt", true);
        IntParameter alt_port = config.addIntParameter2("dhttracker.alt_port", "dhttracker.alt_port", 0, 0, 65535);
        enable_alt.addEnabledOnSelection((Parameter)alt_port);
        config.createGroup("dhttracker.alt_group", enable_alt, alt_port);
        if (enable_alt.getValue()) {
            this.alt_lookup_handler = new DHTTrackerPluginAlt(alt_port.getValue());
        }
        this.model.getActivity().setVisible(false);
        this.model.getProgress().setVisible(false);
        this.model.getLogArea().setMaximumSize(80000);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String message) {
                DHTTrackerPlugin.this.model.getLogArea().appendText(String.valueOf(message) + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                DHTTrackerPlugin.this.model.getLogArea().appendText(String.valueOf(error.toString()) + "\n");
            }
        });
        this.model.getStatus().setText(MessageText.getString("ManagerItem.initializing"));
        this.log.log("Waiting for Distributed Database initialisation");
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                boolean release_now = true;
                try {
                    PluginInterface dht_pi = DHTTrackerPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (dht_pi != null) {
                        DHTTrackerPlugin.this.dht = (DHTPlugin)dht_pi.getPlugin();
                        DelayedTask dt = DHTTrackerPlugin.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                            @Override
                            public void run() {
                                AEThread2 t = new AEThread2("DHTTrackerPlugin:init", true){

                                    @Override
                                    public void run() {
                                        block6: {
                                            try {
                                                try {
                                                    if (DHTTrackerPlugin.this.dht.isEnabled()) {
                                                        DHTTrackerPlugin.this.log.log("DDB Available");
                                                        DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.activity.status.false"));
                                                        DHTTrackerPlugin.this.initialise();
                                                        break block6;
                                                    }
                                                    DHTTrackerPlugin.this.log.log("DDB Disabled");
                                                    DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("dht.status.disabled"));
                                                    DHTTrackerPlugin.this.notRunning();
                                                }
                                                catch (Throwable e) {
                                                    DHTTrackerPlugin.this.log.log("DDB Failed", e);
                                                    DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.operations.failed"));
                                                    DHTTrackerPlugin.this.notRunning();
                                                    DHTTrackerPlugin.this.initialised_sem.releaseForever();
                                                }
                                            }
                                            finally {
                                                DHTTrackerPlugin.this.initialised_sem.releaseForever();
                                            }
                                        }
                                    }
                                };
                                t.start();
                            }
                        });
                        dt.queue();
                        release_now = false;
                    } else {
                        DHTTrackerPlugin.this.log.log("DDB Plugin missing");
                        DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.operations.failed"));
                        DHTTrackerPlugin.this.notRunning();
                    }
                }
                finally {
                    if (release_now) {
                        DHTTrackerPlugin.this.initialised_sem.releaseForever();
                    }
                }
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    protected void notRunning() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            @Override
            public void downloadAdded(Download download) {
                DHTTrackerPlugin.this.addDownload(download);
            }

            @Override
            public void downloadRemoved(Download download) {
                DHTTrackerPlugin.this.removeDownload(download);
            }
        });
    }

    protected void initialise() {
        this.is_running = true;
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            @Override
            public void downloadAdded(Download download) {
                DHTTrackerPlugin.this.addDownload(download);
            }

            @Override
            public void downloadRemoved(Download download) {
                DHTTrackerPlugin.this.removeDownload(download);
            }
        });
        this.plugin_interface.getUtilities().createTimer("DHT Tracker", true).addPeriodicEvent(15000L, new UTTimerEventPerformer(){
            private int ticks;
            private String prev_alt_status = "";

            @Override
            public void perform(UTTimerEvent event2) {
                String alt_status;
                ++this.ticks;
                DHTTrackerPlugin.this.processRegistrations(this.ticks % 8 == 0);
                if (this.ticks == 2 || this.ticks % 4 == 0) {
                    DHTTrackerPlugin.this.processNonRegistrations();
                }
                if (DHTTrackerPlugin.this.alt_lookup_handler != null && this.ticks % 4 == 0 && !(alt_status = DHTTrackerPlugin.this.alt_lookup_handler.getString()).equals(this.prev_alt_status)) {
                    DHTTrackerPlugin.this.log.log("Alternative stats: " + alt_status);
                    this.prev_alt_status = alt_status;
                }
            }
        });
    }

    public void waitUntilInitialised() {
        this.initialised_sem.reserve();
    }

    public boolean isRunning() {
        return this.is_running;
    }

    public void addDownload(final Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        URL announce_url = torrent.getAnnounceURL();
        boolean is_decentralised = TorrentUtils.isDecentralised(announce_url);
        if (download.getFlag(16L) && !is_decentralised && !announce_url.getHost().endsWith(".amazonaws.com")) {
            return;
        }
        if (this.track_only_decentralsed && !is_decentralised) {
            return;
        }
        if (this.is_running) {
            String[] networks = download.getListAttribute(this.ta_networks);
            if (networks != null) {
                boolean public_net = false;
                int i = 0;
                while (i < networks.length) {
                    if (networks[i].equalsIgnoreCase("Public")) {
                        public_net = true;
                        break;
                    }
                    ++i;
                }
                if (public_net && !torrent.isPrivate()) {
                    long delay;
                    boolean our_download = torrent.wasCreatedByUs();
                    if (our_download) {
                        delay = download.getCreationTime() > start_time ? 0L : this.plugin_interface.getUtilities().getCurrentSystemTime() + 120000L + (long)this.random.nextInt(300000);
                    } else {
                        int rand;
                        int min;
                        if (TorrentUtils.isDecentralised(torrent.getAnnounceURL())) {
                            min = 120000;
                            rand = 300000;
                        } else {
                            min = 300000;
                            rand = 1800000;
                        }
                        delay = this.plugin_interface.getUtilities().getCurrentSystemTime() + (long)min + (long)this.random.nextInt(rand);
                    }
                    try {
                        this.this_mon.enter();
                        this.interesting_downloads.put(download, new Long(delay));
                    }
                    finally {
                        this.this_mon.exit();
                    }
                }
            }
            download.addAttributeListener(this, this.ta_networks, 1);
            download.addAttributeListener(this, this.ta_peer_sources, 1);
            download.addTrackerListener(this);
            download.addListener(this);
            this.checkDownloadForRegistration(download, true);
        } else if (torrent.isDecentralised()) {
            download.addListener(new DownloadListener(){

                @Override
                public void stateChanged(final Download download, int old_state, int new_state) {
                    int state = download.getState();
                    if (state == 4 || state == 5) {
                        download.setAnnounceResult(new DownloadAnnounceResult(){

                            @Override
                            public Download getDownload() {
                                return download;
                            }

                            @Override
                            public int getResponseType() {
                                return 2;
                            }

                            @Override
                            public int getReportedPeerCount() {
                                return 0;
                            }

                            @Override
                            public int getSeedCount() {
                                return 0;
                            }

                            @Override
                            public int getNonSeedCount() {
                                return 0;
                            }

                            @Override
                            public String getError() {
                                return "Distributed Database Offline";
                            }

                            @Override
                            public URL getURL() {
                                return download.getTorrent().getAnnounceURL();
                            }

                            @Override
                            public DownloadAnnounceResultPeer[] getPeers() {
                                return new DownloadAnnounceResultPeer[0];
                            }

                            @Override
                            public long getTimeToWait() {
                                return 0L;
                            }

                            @Override
                            public Map getExtensions() {
                                return null;
                            }
                        });
                    }
                }

                @Override
                public void positionChanged(Download download, int oldPosition, int newPosition) {
                }
            });
            download.setScrapeResult(new DownloadScrapeResult(){

                @Override
                public Download getDownload() {
                    return download;
                }

                @Override
                public int getResponseType() {
                    return 2;
                }

                @Override
                public int getSeedCount() {
                    return -1;
                }

                @Override
                public int getNonSeedCount() {
                    return -1;
                }

                @Override
                public long getScrapeStartTime() {
                    return SystemTime.getCurrentTime();
                }

                @Override
                public void setNextScrapeStartTime(long nextScrapeStartTime) {
                }

                @Override
                public long getNextScrapeStartTime() {
                    return -1L;
                }

                @Override
                public String getStatus() {
                    return "Distributed Database Offline";
                }

                @Override
                public URL getURL() {
                    return download.getTorrent().getAnnounceURL();
                }
            });
        }
    }

    public void removeDownload(Download download) {
        if (this.is_running) {
            download.removeTrackerListener(this);
            download.removeListener(this);
            try {
                this.this_mon.enter();
                this.interesting_downloads.remove(download);
                this.running_downloads.remove(download);
                this.run_data_cache.remove(download);
                this.limited_online_tracking.remove(download);
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void attributeEventOccurred(Download download, TorrentAttribute attr, int event_type) {
        this.checkDownloadForRegistration(download, false);
    }

    @Override
    public void scrapeResult(DownloadScrapeResult result) {
        this.checkDownloadForRegistration(result.getDownload(), false);
    }

    @Override
    public void announceResult(DownloadAnnounceResult result) {
        this.checkDownloadForRegistration(result.getDownload(), false);
    }

    protected void checkDownloadForRegistration(Download download, boolean first_time) {
        String register_reason;
        if (download == null) {
            return;
        }
        boolean skip_log = false;
        int state = download.getState();
        int register_type = 1;
        Random random = new Random();
        if (state == 4 || state == 5 || download.isPaused()) {
            String[] networks = download.getListAttribute(this.ta_networks);
            Torrent torrent = download.getTorrent();
            if (torrent != null && networks != null) {
                boolean public_net = false;
                int i = 0;
                while (i < networks.length) {
                    if (networks[i].equalsIgnoreCase("Public")) {
                        public_net = true;
                        break;
                    }
                    ++i;
                }
                if (public_net && !torrent.isPrivate()) {
                    if (torrent.isDecentralised()) {
                        register_type = 2;
                        register_reason = "Decentralised";
                    } else if (torrent.isDecentralisedBackupEnabled()) {
                        String[] sources = download.getListAttribute(this.ta_peer_sources);
                        boolean ok = false;
                        if (sources != null) {
                            int i2 = 0;
                            while (i2 < sources.length) {
                                if (sources[i2].equalsIgnoreCase("DHT")) {
                                    ok = true;
                                    break;
                                }
                                ++i2;
                            }
                        }
                        if (!ok) {
                            register_reason = "Decentralised peer source disabled";
                        } else {
                            boolean is_active;
                            boolean bl = is_active = state == 4 || state == 5 || download.isPaused();
                            if (is_active) {
                                register_type = 3;
                            }
                            if (torrent.isDecentralisedBackupRequested()) {
                                register_type = 2;
                                register_reason = "Torrent requests decentralised tracking";
                            } else if (this.track_normal_when_offline.getValue()) {
                                Object result;
                                if (is_active) {
                                    result = download.getLastAnnounceResult();
                                    if (result == null || result.getResponseType() == 2 || TorrentUtils.isDecentralised(result.getURL())) {
                                        register_type = 2;
                                        register_reason = "Tracker unavailable (announce)";
                                    } else {
                                        register_reason = "Tracker available (announce: " + result.getURL() + ")";
                                    }
                                } else {
                                    result = download.getLastScrapeResult();
                                    if (result == null || result.getResponseType() == 2 || TorrentUtils.isDecentralised(result.getURL())) {
                                        register_type = 2;
                                        register_reason = "Tracker unavailable (scrape)";
                                    } else {
                                        register_reason = "Tracker available (scrape: " + result.getURL() + ")";
                                    }
                                }
                                if (register_type != 2 && this.track_limited_when_online.getValue()) {
                                    Boolean existing = this.limited_online_tracking.get(download);
                                    boolean track_it = false;
                                    if (existing != null) {
                                        track_it = existing;
                                    } else {
                                        DownloadScrapeResult result2 = download.getLastScrapeResult();
                                        if (result2 != null && result2.getResponseType() == 1) {
                                            int leechers;
                                            int seeds = result2.getSeedCount();
                                            int swarm_size = seeds + (leechers = result2.getNonSeedCount());
                                            if (swarm_size <= 16) {
                                                track_it = true;
                                            } else {
                                                boolean bl2 = track_it = random.nextInt(swarm_size) < 16;
                                            }
                                            if (track_it) {
                                                this.limited_online_tracking.put(download, track_it);
                                            }
                                        }
                                    }
                                    if (track_it) {
                                        register_type = 2;
                                        register_reason = "Limited online tracking";
                                    }
                                }
                            } else {
                                register_type = 2;
                                register_reason = "Peer source enabled";
                            }
                        }
                    } else {
                        register_reason = "Decentralised backup disabled for the torrent";
                    }
                } else {
                    register_reason = public_net ? MessageText.getString("label.private") : MessageText.getString("Scrape.status.networkdisabled");
                }
            } else {
                register_reason = "Torrent is broken";
            }
            if (register_type == 3) {
                register_reason = register_reason.length() == 0 ? "Derived" : "Derived (overriding ' " + register_reason + "')";
            }
        } else if (state == 7 || state == 8) {
            register_reason = "Not running";
            skip_log = true;
        } else {
            register_reason = state == 9 ? "" : "";
        }
        download.setUserData(LATEST_REGISTER_REASON, register_reason);
        if (register_reason.length() > 0) {
            try {
                this.this_mon.enter();
                int[] run_data = this.running_downloads.get(download);
                if (register_type != 1) {
                    if (run_data == null) {
                        this.log(download, "Monitoring: " + register_reason);
                        int[] cache = this.run_data_cache.remove(download);
                        if (cache == null) {
                            int[] nArray = new int[5];
                            nArray[0] = register_type;
                            this.running_downloads.put(download, nArray);
                        } else {
                            cache[0] = register_type;
                            this.running_downloads.put(download, cache);
                        }
                        this.query_map.put(download, new Long(SystemTime.getCurrentTime()));
                    } else {
                        Integer existing_type = run_data[0];
                        if (existing_type == 3 && register_type == 2) {
                            run_data[0] = register_type;
                        }
                    }
                } else if (run_data != null) {
                    if (!skip_log) {
                        this.log(download, "Not monitoring: " + register_reason);
                    }
                    this.running_downloads.remove(download);
                    this.run_data_cache.put(download, run_data);
                    this.interesting_downloads.put(download, new Long(this.plugin_interface.getUtilities().getCurrentSystemTime() + 300000L));
                } else if (first_time && !skip_log) {
                    this.log(download, "Not monitoring: " + register_reason);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void processRegistrations(boolean full_processing) {
        ArrayList<Download> rds;
        int tcp_port = this.plugin_interface.getPluginconfig().getUnsafeIntParameter("TCP.Listen.Port");
        String port_override = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
        if (!port_override.equals("")) {
            try {
                tcp_port = Integer.parseInt(port_override);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (tcp_port == 0) {
            this.log.log("TCP port=0, registration not performed");
            return;
        }
        String override_ips = COConfigurationManager.getStringParameter("Override Ip", "");
        String override_ip = null;
        if (override_ips.length() > 0) {
            StringTokenizer tok = new StringTokenizer(override_ips, ";");
            while (tok.hasMoreTokens()) {
                String cat;
                String this_address = tok.nextToken().trim();
                if (this_address.length() <= 0 || (cat = AENetworkClassifier.categoriseAddress(this_address)) != "Public") continue;
                override_ip = this_address;
                break;
            }
        }
        if (override_ip != null) {
            try {
                override_ip = PRHelpers.DNSToIPAddress(override_ip);
            }
            catch (UnknownHostException e) {
                this.log.log("    Can't resolve IP override '" + override_ip + "'");
                override_ip = null;
            }
        }
        try {
            this.this_mon.enter();
            rds = new ArrayList<Download>(this.running_downloads.keySet());
        }
        finally {
            this.this_mon.exit();
        }
        long now = SystemTime.getCurrentTime();
        if (full_processing) {
            Iterator<Download> rds_it = rds.iterator();
            ArrayList<Object[]> interesting = new ArrayList<Object[]>();
            while (rds_it.hasNext()) {
                Download dl = rds_it.next();
                int reg_type = 1;
                try {
                    this.this_mon.enter();
                    int[] run_data = this.running_downloads.get(dl);
                    if (run_data != null) {
                        reg_type = run_data[0];
                    }
                }
                finally {
                    this.this_mon.exit();
                }
                if (reg_type == 1) continue;
                long metric = this.getDerivedTrackMetric(dl);
                interesting.add(new Object[]{dl, new Long(metric)});
            }
            Collections.sort(interesting, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] entry1, Object[] entry2) {
                    long res = (Long)entry2[1] - (Long)entry1[1];
                    if (res < 0L) {
                        return -1;
                    }
                    if (res > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            Iterator it = interesting.iterator();
            int num = 0;
            while (it.hasNext()) {
                Object[] entry = (Object[])it.next();
                Download dl = (Download)entry[0];
                long metric = (Long)entry[1];
                if (metric > 0L && ++num > 5) {
                    metric = num <= 20 ? metric * (long)(20 - num) / 15L : 0L;
                }
                if (metric > 0L) {
                    dl.setUserData(DL_DERIVED_METRIC_KEY, new Long(metric));
                    continue;
                }
                dl.setUserData(DL_DERIVED_METRIC_KEY, null);
            }
        }
        for (Download dl : rds) {
            int dht_port;
            int udp_port;
            int reg_type = 1;
            try {
                this.this_mon.enter();
                int[] run_data = this.running_downloads.get(dl);
                if (run_data != null) {
                    reg_type = run_data[0];
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (reg_type == 1) continue;
            String value_to_put = override_ip == null ? "" : String.valueOf(override_ip) + ":";
            value_to_put = String.valueOf(value_to_put) + tcp_port;
            String put_flags = ";";
            if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE) {
                put_flags = String.valueOf(put_flags) + "C";
            }
            String[] networks = dl.getListAttribute(this.ta_networks);
            boolean i2p = false;
            if (networks != null) {
                String[] stringArray = networks;
                int n = networks.length;
                int n2 = 0;
                while (n2 < n) {
                    String net = stringArray[n2];
                    if (net == "I2P") {
                        if (I2PHelpers.isI2PInstalled()) {
                            put_flags = String.valueOf(put_flags) + "I";
                        }
                        i2p = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (put_flags.length() > 1) {
                value_to_put = String.valueOf(value_to_put) + put_flags;
            }
            if ((udp_port = this.plugin_interface.getPluginconfig().getUnsafeIntParameter("UDP.Listen.Port")) != (dht_port = this.dht.getLocalAddress().getAddress().getPort())) {
                value_to_put = String.valueOf(value_to_put) + ";" + udp_port;
            }
            putDetails put_details = new putDetails(value_to_put, override_ip, tcp_port, udp_port, i2p);
            byte dht_flags = this.isComplete(dl) ? (byte)2 : 1;
            RegistrationDetails registration = this.registered_downloads.get(dl);
            boolean do_it = false;
            if (registration == null) {
                this.log(dl, "Registering as " + (dht_flags == 2 ? "Seeding" : "Downloading"));
                registration = new RegistrationDetails(dl, reg_type, put_details, dht_flags);
                this.registered_downloads.put(dl, registration);
                do_it = true;
            } else {
                boolean targets_changed = false;
                if (full_processing) {
                    targets_changed = registration.updateTargets(dl, reg_type);
                }
                if (targets_changed || registration.getFlags() != dht_flags || !registration.getPutDetails().sameAs(put_details)) {
                    this.log(dl, String.valueOf(registration == null ? "Registering" : "Re-registering") + " as " + (dht_flags == 2 ? "Seeding" : "Downloading"));
                    registration.update(put_details, dht_flags);
                    do_it = true;
                }
            }
            if (!do_it) continue;
            try {
                this.this_mon.enter();
                this.query_map.put(dl, new Long(now));
            }
            finally {
                this.this_mon.exit();
            }
            this.trackerPut(dl, registration);
        }
        Iterator<Map.Entry<Download, RegistrationDetails>> rd_it = this.registered_downloads.entrySet().iterator();
        while (rd_it.hasNext()) {
            boolean unregister;
            Map.Entry<Download, RegistrationDetails> entry = rd_it.next();
            Download dl = entry.getKey();
            try {
                this.this_mon.enter();
                unregister = !this.running_downloads.containsKey(dl);
            }
            finally {
                this.this_mon.exit();
            }
            if (!unregister) continue;
            this.log(dl, "Unregistering download");
            rd_it.remove();
            try {
                this.this_mon.enter();
                this.query_map.remove(dl);
            }
            finally {
                this.this_mon.exit();
            }
            this.trackerRemove(dl, entry.getValue());
        }
        for (Download dl : rds) {
            RegistrationDetails registration;
            boolean skip;
            Long next_time;
            try {
                this.this_mon.enter();
                next_time = this.query_map.get(dl);
            }
            finally {
                this.this_mon.exit();
            }
            if (next_time == null || now < next_time) continue;
            int reg_type = 1;
            try {
                this.this_mon.enter();
                this.query_map.remove(dl);
                int[] run_data = this.running_downloads.get(dl);
                if (run_data != null) {
                    reg_type = run_data[0];
                }
            }
            finally {
                this.this_mon.exit();
            }
            long start = SystemTime.getCurrentTime();
            PeerManager pm = dl.getPeerManager();
            boolean bl = skip = this.isActive(dl) || reg_type == 1;
            if (skip) {
                this.log(dl, "Deferring announce as activity outstanding");
            }
            if ((registration = this.registered_downloads.get(dl)) == null) {
                Debug.out("Inconsistent, registration should be non-null");
                continue;
            }
            boolean derived_only = false;
            if (pm != null && !skip) {
                int con = pm.getStats().getConnectedLeechers() + pm.getStats().getConnectedSeeds();
                boolean bl2 = derived_only = con >= 30;
            }
            if (!skip) {
                boolean bl3 = skip = this.trackerGet(dl, registration, derived_only) == 0;
            }
            if (!skip) continue;
            try {
                this.this_mon.enter();
                if (!this.running_downloads.containsKey(dl)) continue;
                this.query_map.put(dl, new Long(start + 120000L));
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected long getDerivedTrackMetric(Download download) {
        Torrent t = download.getTorrent();
        if (t == null) {
            return -100L;
        }
        if (t.getSize() < 0xA00000L) {
            return -99L;
        }
        DownloadAnnounceResult announce = download.getLastAnnounceResult();
        if (announce == null || announce.getResponseType() != 1) {
            return -98L;
        }
        DownloadScrapeResult scrape = download.getLastScrapeResult();
        if (scrape == null || scrape.getResponseType() != 1) {
            return -97L;
        }
        int leechers = scrape.getNonSeedCount();
        int total = leechers;
        if (total >= 2000) {
            return 100L;
        }
        if (total <= 200) {
            return 0L;
        }
        return (total - 200) / 4;
    }

    protected void trackerPut(final Download download, RegistrationDetails details) {
        final long start = SystemTime.getCurrentTime();
        trackerTarget[] targets = details.getTargets(true);
        byte flags = details.getFlags();
        int i = 0;
        while (i < targets.length) {
            final trackerTarget target = targets[i];
            int target_type = target.getType();
            String encoded = details.getPutDetails().getEncoded();
            byte[] encoded_bytes = encoded.getBytes();
            DHTPluginValue existing = this.dht.getLocalValue(target.getHash());
            if (existing == null || existing.getFlags() != flags || !Arrays.equals(existing.getValue(), encoded_bytes)) {
                if (this.disable_put) {
                    if (target_type == 2) {
                        this.log(download, String.valueOf(target.getDesc("Registration")) + " skipped as disabled due to use of SOCKS proxy");
                    }
                } else if (download.getFlag(512L)) {
                    this.log(download, String.valueOf(target.getDesc("Registration")) + " skipped as metadata download");
                } else if (target_type == 3 && this.dht.isSleeping()) {
                    this.log(download, String.valueOf(target.getDesc("Registration")) + " skipped as sleeping");
                } else {
                    this.dht.put(target.getHash(), String.valueOf(download.getName()) + ": " + target.getDesc("Put") + " -> " + encoded, encoded_bytes, flags, false, new DHTPluginOperationListener(){

                        @Override
                        public boolean diversified() {
                            return true;
                        }

                        @Override
                        public void starts(byte[] key) {
                        }

                        @Override
                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        }

                        @Override
                        public void valueWritten(DHTPluginContact target2, DHTPluginValue value) {
                        }

                        @Override
                        public void complete(byte[] key, boolean timeout_occurred) {
                            if (target.getType() == 2) {
                                DHTTrackerPlugin.this.log(download, String.valueOf(target.getDesc("Registration")) + " completed (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + ")");
                            }
                        }
                    });
                }
            }
            ++i;
        }
    }

    protected int trackerGet(final Download download, final RegistrationDetails details, final boolean derived_only) {
        final long start = SystemTime.getCurrentTime();
        final Torrent torrent = download.getTorrent();
        final URL url_to_report = torrent.isDecentralised() ? torrent.getAnnounceURL() : DEFAULT_URL;
        trackerTarget[] targets = details.getTargets(false);
        final long[] max_retry = new long[1];
        final boolean metadata_download = download.getFlag(512L);
        boolean do_alt = this.alt_lookup_handler != null && (metadata_download || !download.getFlag(16L) && !download.getFlag(1024L));
        int num_done = 0;
        int i = 0;
        while (i < targets.length) {
            final trackerTarget target = targets[i];
            int target_type = target.getType();
            if (!(target_type == 2 && derived_only || target_type == 3 && this.dht.isSleeping())) {
                this.increaseActive(download);
                ++num_done;
                boolean is_complete = this.isComplete(download);
                this.dht.get(target.getHash(), String.valueOf(download.getName()) + ": " + target.getDesc("Announce"), is_complete ? (byte)2 : 1, 30, target_type == 2 ? 120000 : 60000, false, false, new DHTPluginOperationListener(do_alt, is_complete){
                    List<String> addresses = new ArrayList<String>();
                    List<Integer> ports = new ArrayList<Integer>();
                    List<Integer> udp_ports = new ArrayList<Integer>();
                    List<Boolean> is_seeds = new ArrayList<Boolean>();
                    List<String> flags = new ArrayList<String>();
                    int seed_count;
                    int leecher_count;
                    int i2p_seed_count;
                    int i2p_leecher_count;
                    volatile boolean complete;
                    {
                        if (bl) {
                            DHTTrackerPlugin.this.alt_lookup_handler.get(trackerTarget2.getHash(), bl2, new DHTTrackerPluginAlt.LookupListener(){

                                @Override
                                public void foundPeer(InetSocketAddress address) {
                                    this.alternativePeerRead(address);
                                }

                                @Override
                                public boolean isComplete() {
                                    return complete && addresses.size() > 5;
                                }

                                @Override
                                public void completed() {
                                }
                            });
                        }
                    }

                    @Override
                    public boolean diversified() {
                        return true;
                    }

                    @Override
                    public void starts(byte[] key) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void alternativePeerRead(InetSocketAddress peer) {
                        PeerManager pm;
                        boolean try_injection = metadata_download;
                        13 var3_3 = this;
                        synchronized (var3_3) {
                            if (this.complete) {
                                try_injection |= this.addresses.size() < 5;
                            } else {
                                try {
                                    this.addresses.add(peer.getAddress().getHostAddress());
                                    this.ports.add(peer.getPort());
                                    this.udp_ports.add(peer.getPort());
                                    this.flags.add(null);
                                    this.is_seeds.add(false);
                                    ++this.leecher_count;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        if (try_injection && (pm = download.getPeerManager()) != null) {
                            pm.peerDiscovered("DHT", peer.getAddress().getHostAddress(), peer.getPort(), peer.getPort(), NetworkManager.getCryptoRequired(0));
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        PeerManager pm;
                        String peer_ip = null;
                        int peer_tcp_port = 0;
                        int peer_udp_port = 0;
                        13 var6_6 = this;
                        synchronized (var6_6) {
                            block21: {
                                if (this.complete) {
                                    return;
                                }
                                try {
                                    String tcp_port_str;
                                    String[] tokens = new String(value.getValue()).split(";");
                                    String tcp_part = tokens[0].trim();
                                    int sep = tcp_part.indexOf(58);
                                    String ip_str = null;
                                    if (sep == -1) {
                                        tcp_port_str = tcp_part;
                                    } else {
                                        ip_str = tcp_part.substring(0, sep);
                                        tcp_port_str = tcp_part.substring(sep + 1);
                                    }
                                    int tcp_port = Integer.parseInt(tcp_port_str);
                                    if (tcp_port <= 0 || tcp_port >= 65536) break block21;
                                    String flag_str = null;
                                    int udp_port = -1;
                                    boolean has_i2p = false;
                                    try {
                                        int i = 1;
                                        while (i < tokens.length) {
                                            String token = tokens[i].trim();
                                            if (token.length() > 0) {
                                                if (Character.isDigit(token.charAt(0))) {
                                                    udp_port = Integer.parseInt(token);
                                                    if (udp_port <= 0 || udp_port >= 65536) {
                                                        udp_port = -1;
                                                    }
                                                } else {
                                                    flag_str = token;
                                                    if (flag_str.contains("I")) {
                                                        has_i2p = true;
                                                    }
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    peer_ip = ip_str == null ? originator.getAddress().getAddress().getHostAddress() : ip_str;
                                    peer_tcp_port = tcp_port;
                                    peer_udp_port = udp_port == -1 ? originator.getAddress().getPort() : udp_port;
                                    this.addresses.add(peer_ip);
                                    this.ports.add(peer_tcp_port);
                                    this.udp_ports.add(peer_udp_port);
                                    this.flags.add(flag_str);
                                    if ((value.getFlags() & 1) == 1) {
                                        ++this.leecher_count;
                                        this.is_seeds.add(Boolean.FALSE);
                                        if (has_i2p) {
                                            ++this.i2p_leecher_count;
                                        }
                                    } else {
                                        this.is_seeds.add(Boolean.TRUE);
                                        ++this.seed_count;
                                        if (has_i2p) {
                                            ++this.i2p_seed_count;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        if (metadata_download && peer_ip != null && (pm = download.getPeerManager()) != null) {
                            pm.peerDiscovered("DHT", peer_ip, peer_tcp_port, peer_udp_port, NetworkManager.getCryptoRequired(0));
                        }
                    }

                    @Override
                    public void valueWritten(DHTPluginContact target2, DHTPluginValue value) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void complete(byte[] key, boolean timeout_occurred) {
                        PeerManager pm;
                        13 var3_3 = this;
                        synchronized (var3_3) {
                            if (this.complete) {
                                return;
                            }
                            this.complete = true;
                        }
                        if (target.getType() == 2 || target.getType() == 3 && this.seed_count + this.leecher_count > 1) {
                            DHTTrackerPlugin.this.log(download, String.valueOf(target.getDesc("Announce")) + " completed (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + "), addresses=" + this.addresses.size() + ", seeds=" + this.seed_count + ", leechers=" + this.leecher_count);
                        }
                        DHTTrackerPlugin.this.decreaseActive(download);
                        int peers_found = this.addresses.size();
                        ArrayList<2> peers_for_announce = new ArrayList<2>();
                        int announce_per_min = 4;
                        int num_active = DHTTrackerPlugin.this.query_map.size();
                        int announce_min = Math.max(120000, num_active / announce_per_min * 60 * 1000);
                        int announce_max = derived_only ? 1800000 : 3600000;
                        announce_min = Math.min(announce_min, announce_max);
                        DHTTrackerPlugin.this.current_announce_interval = announce_min;
                        final long retry = (long)announce_min + (long)peers_found * (long)(announce_max - announce_min) / 30L;
                        int download_state = download.getState();
                        boolean we_are_seeding = download_state == 5;
                        try {
                            DHTTrackerPlugin.this.this_mon.enter();
                            int[] run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(download);
                            if (run_data != null) {
                                Long existing;
                                boolean full = target.getType() == 2;
                                int peer_count = we_are_seeding ? this.leecher_count : this.seed_count + this.leecher_count;
                                run_data[1] = full ? this.seed_count : Math.max(run_data[1], this.seed_count);
                                run_data[2] = full ? this.leecher_count : Math.max(run_data[2], this.leecher_count);
                                run_data[3] = full ? peer_count : Math.max(run_data[3], peer_count);
                                run_data[4] = (int)(SystemTime.getCurrentTime() / 1000L);
                                long absolute_retry = SystemTime.getCurrentTime() + retry;
                                if (absolute_retry > max_retry[0] && ((existing = (Long)DHTTrackerPlugin.this.query_map.get(download)) == null || existing == max_retry[0])) {
                                    max_retry[0] = absolute_retry;
                                    DHTTrackerPlugin.this.query_map.put(download, new Long(absolute_retry));
                                }
                            }
                        }
                        finally {
                            DHTTrackerPlugin.this.this_mon.exit();
                        }
                        putDetails put_details = details.getPutDetails();
                        String ext_address = put_details.getIPOverride();
                        if (ext_address == null) {
                            ext_address = DHTTrackerPlugin.this.dht.getLocalAddress().getAddress().getAddress().getHostAddress();
                        }
                        if (put_details.hasI2P()) {
                            if (we_are_seeding) {
                                if (this.i2p_seed_count > 0) {
                                    --this.i2p_seed_count;
                                }
                            } else if (this.i2p_leecher_count > 0) {
                                --this.i2p_leecher_count;
                            }
                        }
                        if (this.i2p_seed_count + this.i2p_leecher_count > 0) {
                            download.setUserData(DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY, new int[]{this.i2p_seed_count, this.i2p_leecher_count});
                        } else {
                            download.setUserData(DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY, null);
                        }
                        int i = 0;
                        while (i < this.addresses.size()) {
                            String ip;
                            if (!(we_are_seeding && this.is_seeds.get(i).booleanValue() || (ip = this.addresses.get(i)).equals(ext_address) && this.ports.get(i).intValue() == put_details.getTCPPort() && this.udp_ports.get(i).intValue() == put_details.getUDPPort())) {
                                final int f_i = i;
                                peers_for_announce.add(new DownloadAnnounceResultPeer(){

                                    @Override
                                    public String getSource() {
                                        return "DHT";
                                    }

                                    @Override
                                    public String getAddress() {
                                        return addresses.get(f_i);
                                    }

                                    @Override
                                    public int getPort() {
                                        return ports.get(f_i);
                                    }

                                    @Override
                                    public int getUDPPort() {
                                        return udp_ports.get(f_i);
                                    }

                                    @Override
                                    public byte[] getPeerID() {
                                        return null;
                                    }

                                    @Override
                                    public short getProtocol() {
                                        String flag = flags.get(f_i);
                                        int protocol = 1;
                                        if (flag != null && flag.contains("C")) {
                                            protocol = 2;
                                        }
                                        return (short)protocol;
                                    }
                                });
                            }
                            ++i;
                        }
                        if (target.getType() == 3 && peers_for_announce.size() > 0 && (pm = download.getPeerManager()) != null) {
                            ArrayList temp = new ArrayList(peers_for_announce);
                            Random rand = new Random();
                            int i2 = 0;
                            while (i2 < 5 && temp.size() > 0) {
                                DownloadAnnounceResultPeer peer = (DownloadAnnounceResultPeer)temp.remove(rand.nextInt(temp.size()));
                                DHTTrackerPlugin.this.log(download, "Injecting derived peer " + peer.getAddress());
                                HashMap<Object, Object> user_data = new HashMap<Object, Object>();
                                user_data.put(Peer.PR_PRIORITY_CONNECTION, Boolean.TRUE);
                                pm.addPeer(peer.getAddress(), peer.getPort(), peer.getUDPPort(), peer.getProtocol() == 2, user_data);
                                ++i2;
                            }
                        }
                        if (download_state == 4 || download_state == 5) {
                            final DownloadAnnounceResultPeer[] peers = new DownloadAnnounceResultPeer[peers_for_announce.size()];
                            peers_for_announce.toArray(peers);
                            download.setAnnounceResult(new DownloadAnnounceResult(){

                                @Override
                                public Download getDownload() {
                                    return download;
                                }

                                @Override
                                public int getResponseType() {
                                    return 1;
                                }

                                @Override
                                public int getReportedPeerCount() {
                                    return peers.length;
                                }

                                @Override
                                public int getSeedCount() {
                                    return seed_count;
                                }

                                @Override
                                public int getNonSeedCount() {
                                    return leecher_count;
                                }

                                @Override
                                public String getError() {
                                    return null;
                                }

                                @Override
                                public URL getURL() {
                                    return url_to_report;
                                }

                                @Override
                                public DownloadAnnounceResultPeer[] getPeers() {
                                    return peers;
                                }

                                @Override
                                public long getTimeToWait() {
                                    return retry / 1000L;
                                }

                                @Override
                                public Map getExtensions() {
                                    return null;
                                }
                            });
                        }
                        boolean inject_scrape = this.leecher_count > 0;
                        DownloadScrapeResult result = download.getLastScrapeResult();
                        if (result != null && result.getResponseType() != 2) {
                            Map rand = DHTTrackerPlugin.this.scrape_injection_map;
                            synchronized (rand) {
                                int[] prev = (int[])DHTTrackerPlugin.this.scrape_injection_map.get(download);
                                if (prev != null && prev[0] == result.getSeedCount() && prev[1] == result.getNonSeedCount()) {
                                    inject_scrape = true;
                                }
                            }
                        }
                        if (torrent.isDecentralised() || inject_scrape) {
                            Object dl_peer;
                            PeerManager pm2 = download.getPeerManager();
                            int local_seeds = 0;
                            int local_leechers = 0;
                            if (pm2 != null) {
                                Peer[] dl_peers = pm2.getPeers();
                                int i3 = 0;
                                while (i3 < dl_peers.length) {
                                    dl_peer = dl_peers[i3];
                                    if (dl_peer.getPercentDoneInThousandNotation() == 1000) {
                                        ++local_seeds;
                                    } else {
                                        ++local_leechers;
                                    }
                                    ++i3;
                                }
                            }
                            final int f_adj_seeds = Math.max(this.seed_count, local_seeds);
                            final int f_adj_leechers = Math.max(this.leecher_count, local_leechers);
                            dl_peer = DHTTrackerPlugin.this.scrape_injection_map;
                            synchronized (dl_peer) {
                                DHTTrackerPlugin.this.scrape_injection_map.put(download, new int[]{f_adj_seeds, f_adj_leechers});
                            }
                            try {
                                DHTTrackerPlugin.this.this_mon.enter();
                                int[] run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(download);
                                if (run_data == null) {
                                    run_data = (int[])DHTTrackerPlugin.this.run_data_cache.get(download);
                                }
                                if (run_data != null) {
                                    run_data[1] = f_adj_seeds;
                                    run_data[2] = f_adj_leechers;
                                    run_data[4] = (int)(SystemTime.getCurrentTime() / 1000L);
                                }
                            }
                            finally {
                                DHTTrackerPlugin.this.this_mon.exit();
                            }
                            download.setScrapeResult(new DownloadScrapeResult(){

                                @Override
                                public Download getDownload() {
                                    return download;
                                }

                                @Override
                                public int getResponseType() {
                                    return 1;
                                }

                                @Override
                                public int getSeedCount() {
                                    return f_adj_seeds;
                                }

                                @Override
                                public int getNonSeedCount() {
                                    return f_adj_leechers;
                                }

                                @Override
                                public long getScrapeStartTime() {
                                    return start;
                                }

                                @Override
                                public void setNextScrapeStartTime(long nextScrapeStartTime) {
                                }

                                @Override
                                public long getNextScrapeStartTime() {
                                    return SystemTime.getCurrentTime() + retry;
                                }

                                @Override
                                public String getStatus() {
                                    return "OK";
                                }

                                @Override
                                public URL getURL() {
                                    return url_to_report;
                                }
                            });
                        }
                    }
                });
            }
            ++i;
        }
        return num_done;
    }

    protected boolean isComplete(Download download) {
        PEPeerManager core_pm;
        PeerManager pm;
        boolean is_complete = download.isComplete();
        if (is_complete && (pm = download.getPeerManager()) != null && (core_pm = PluginCoreUtils.unwrap(pm)) != null && core_pm.getHiddenBytes() > 0L) {
            is_complete = false;
        }
        return is_complete;
    }

    protected void trackerRemove(final Download download, RegistrationDetails details) {
        if (this.disable_put) {
            return;
        }
        if (download.getFlag(512L)) {
            return;
        }
        final long start = SystemTime.getCurrentTime();
        trackerTarget[] targets = details.getTargets(true);
        int i = 0;
        while (i < targets.length) {
            final trackerTarget target = targets[i];
            if (this.dht.hasLocalKey(target.getHash())) {
                this.increaseActive(download);
                this.dht.remove(target.getHash(), String.valueOf(download.getName()) + ": " + target.getDesc("Remove"), new DHTPluginOperationListener(){

                    @Override
                    public boolean diversified() {
                        return true;
                    }

                    @Override
                    public void starts(byte[] key) {
                    }

                    @Override
                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    }

                    @Override
                    public void valueWritten(DHTPluginContact target2, DHTPluginValue value) {
                    }

                    @Override
                    public void complete(byte[] key, boolean timeout_occurred) {
                        if (target.getType() == 2) {
                            DHTTrackerPlugin.this.log(download, String.valueOf(target.getDesc("Unregistration")) + " completed (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + ")");
                        }
                        DHTTrackerPlugin.this.decreaseActive(download);
                    }
                });
            }
            ++i;
        }
    }

    protected void trackerRemove(final Download download, final trackerTarget target) {
        if (this.disable_put) {
            return;
        }
        if (download.getFlag(512L)) {
            return;
        }
        final long start = SystemTime.getCurrentTime();
        if (this.dht.hasLocalKey(target.getHash())) {
            this.increaseActive(download);
            this.dht.remove(target.getHash(), String.valueOf(download.getName()) + ": " + target.getDesc("Remove"), new DHTPluginOperationListener(){

                @Override
                public boolean diversified() {
                    return true;
                }

                @Override
                public void starts(byte[] key) {
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                @Override
                public void valueWritten(DHTPluginContact target2, DHTPluginValue value) {
                }

                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    if (target.getType() == 2) {
                        DHTTrackerPlugin.this.log(download, String.valueOf(target.getDesc("Unregistration")) + " completed (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + ")");
                    }
                    DHTTrackerPlugin.this.decreaseActive(download);
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processNonRegistrations() {
        Download download;
        Torrent torrent;
        Download ready_download = null;
        long ready_download_next_check = -1L;
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        ArrayList<Download> to_scrape = new ArrayList<Download>();
        try {
            this.this_mon.enter();
            Iterator<Download> it = this.interesting_downloads.keySet().iterator();
            while (it.hasNext() && ready_download == null) {
                int[] run_data;
                Download download2 = it.next();
                torrent = download2.getTorrent();
                if (torrent == null || (run_data = this.running_downloads.get(download2)) != null && run_data[0] != 3) continue;
                to_scrape.add(download2);
            }
        }
        finally {
            this.this_mon.exit();
        }
        HashMap<Download, DownloadScrapeResult> scrapes = new HashMap<Download, DownloadScrapeResult>();
        int i = 0;
        while (i < to_scrape.size()) {
            download = (Download)to_scrape.get(i);
            scrapes.put(download, download.getLastScrapeResult());
            ++i;
        }
        try {
            this.this_mon.enter();
            Iterator<Download> it = this.interesting_downloads.keySet().iterator();
            while (it.hasNext() && ready_download == null) {
                DownloadScrapeResult scrape;
                boolean force;
                int[] run_data;
                download = it.next();
                Torrent torrent2 = download.getTorrent();
                if (torrent2 == null || (run_data = this.running_downloads.get(download)) != null && run_data[0] != 3 || !(force = torrent2.wasCreatedByUs()) && (this.interesting_pub_max > 0 && this.interesting_published > this.interesting_pub_max || (scrape = (DownloadScrapeResult)scrapes.get(download)) == null || scrape.getSeedCount() + scrape.getNonSeedCount() > 30)) continue;
                long target = this.interesting_downloads.get(download);
                long check_period = TorrentUtils.isDecentralised(torrent2.getAnnounceURL()) ? 3600000 : 14400000;
                if (target <= now) {
                    ready_download = download;
                    ready_download_next_check = now + check_period;
                    this.interesting_downloads.put(download, new Long(ready_download_next_check));
                    continue;
                }
                if (target - now <= check_period) continue;
                this.interesting_downloads.put(download, new Long(now + target % check_period));
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (ready_download == null) return;
        final Download f_ready_download = ready_download;
        torrent = ready_download.getTorrent();
        if (ready_download.getFlag(512L)) {
            try {
                this.this_mon.enter();
                this.interesting_downloads.remove(f_ready_download);
                return;
            }
            finally {
                this.this_mon.exit();
            }
        }
        if (!this.dht.isDiversified(torrent.getHash())) {
            final long start = now;
            final long f_next_check = ready_download_next_check;
            this.dht.get(torrent.getHash(), "Presence query for '" + ready_download.getName() + "'", (byte)0, 8, 120000L, false, false, new DHTPluginOperationListener(){
                private boolean diversified;
                private int leechers = 0;
                private int seeds = 0;
                private int i2p_leechers = 0;
                private int i2p_seeds = 0;

                @Override
                public boolean diversified() {
                    this.diversified = true;
                    return false;
                }

                @Override
                public void starts(byte[] key) {
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    boolean is_leecher;
                    boolean bl = is_leecher = (value.getFlags() & 1) == 1;
                    if (is_leecher) {
                        ++this.leechers;
                    } else {
                        ++this.seeds;
                    }
                    try {
                        String[] tokens = new String(value.getValue()).split(";");
                        int i = 1;
                        while (i < tokens.length) {
                            String flag_str;
                            String token = tokens[i].trim();
                            if (token.length() > 0 && !Character.isDigit(token.charAt(0)) && (flag_str = token).contains("I")) {
                                if (is_leecher) {
                                    ++this.i2p_leechers;
                                } else {
                                    ++this.i2p_seeds;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    int total = this.leechers + this.seeds;
                    DHTTrackerPlugin.this.log(f_ready_download, "Presence query: availability=" + (total == 8 ? "8+" : String.valueOf(total)) + ",div=" + this.diversified + " (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + ")");
                    if (this.diversified) {
                        try {
                            DHTTrackerPlugin.this.this_mon.enter();
                            DHTTrackerPlugin.this.interesting_downloads.remove(f_ready_download);
                        }
                        finally {
                            DHTTrackerPlugin.this.this_mon.exit();
                        }
                    }
                    if (total < 8) {
                        try {
                            DHTTrackerPlugin.this.this_mon.enter();
                            DHTTrackerPlugin.this.interesting_downloads.remove(f_ready_download);
                        }
                        finally {
                            DHTTrackerPlugin.this.this_mon.exit();
                        }
                        DHTTrackerPlugin dHTTrackerPlugin = DHTTrackerPlugin.this;
                        dHTTrackerPlugin.interesting_published = dHTTrackerPlugin.interesting_published + 1;
                        if (!DHTTrackerPlugin.this.disable_put) {
                            DHTTrackerPlugin.this.dht.put(torrent.getHash(), "Presence store for '" + f_ready_download.getName() + "'", "0".getBytes(), (byte)0, new DHTPluginOperationListener(){

                                @Override
                                public boolean diversified() {
                                    return true;
                                }

                                @Override
                                public void starts(byte[] key) {
                                }

                                @Override
                                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                }

                                @Override
                                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                }

                                @Override
                                public void complete(byte[] key, boolean timeout_occurred) {
                                }
                            });
                        }
                    }
                    try {
                        DHTTrackerPlugin.this.this_mon.enter();
                        int[] run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(f_ready_download);
                        if (run_data == null) {
                            run_data = (int[])DHTTrackerPlugin.this.run_data_cache.get(f_ready_download);
                        }
                        if (run_data != null) {
                            if (total < 8) {
                                run_data[1] = this.seeds;
                                run_data[2] = this.leechers;
                                run_data[3] = total;
                            } else {
                                run_data[1] = Math.max(run_data[1], this.seeds);
                                run_data[2] = Math.max(run_data[2], this.leechers);
                            }
                            run_data[4] = (int)(SystemTime.getCurrentTime() / 1000L);
                        }
                    }
                    finally {
                        DHTTrackerPlugin.this.this_mon.exit();
                    }
                    if (this.i2p_seeds + this.i2p_leechers > 0) {
                        int[] details = (int[])f_ready_download.getUserData(DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY);
                        if (details == null) {
                            details = new int[]{this.i2p_seeds, this.i2p_leechers};
                            f_ready_download.setUserData(DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY, details);
                        } else {
                            details[0] = Math.max(details[0], this.i2p_seeds);
                            details[1] = Math.max(details[1], this.i2p_leechers);
                        }
                    }
                    f_ready_download.setScrapeResult(new DownloadScrapeResult(){

                        @Override
                        public Download getDownload() {
                            return null;
                        }

                        @Override
                        public int getResponseType() {
                            return 1;
                        }

                        @Override
                        public int getSeedCount() {
                            return seeds;
                        }

                        @Override
                        public int getNonSeedCount() {
                            return leechers;
                        }

                        @Override
                        public long getScrapeStartTime() {
                            return SystemTime.getCurrentTime();
                        }

                        @Override
                        public void setNextScrapeStartTime(long nextScrapeStartTime) {
                        }

                        @Override
                        public long getNextScrapeStartTime() {
                            return f_next_check;
                        }

                        @Override
                        public String getStatus() {
                            return "OK";
                        }

                        @Override
                        public URL getURL() {
                            URL url_to_report = torrent.isDecentralised() ? torrent.getAnnounceURL() : DEFAULT_URL;
                            return url_to_report;
                        }
                    });
                }
            });
            return;
        }
        try {
            this.this_mon.enter();
            this.interesting_downloads.remove(f_ready_download);
            return;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void stateChanged(Download download, int old_state, int new_state) {
        int state = download.getState();
        try {
            this.this_mon.enter();
            if ((state == 4 || state == 5 || state == 9) && this.running_downloads.containsKey(download)) {
                this.query_map.put(download, new Long(SystemTime.getCurrentTime()));
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (!download.isPaused()) {
            this.checkDownloadForRegistration(download, false);
        }
    }

    public void announceAll() {
        this.log.log("Announce-all requested");
        Long now = new Long(SystemTime.getCurrentTime());
        try {
            this.this_mon.enter();
            for (Map.Entry<Download, Long> entry : this.query_map.entrySet()) {
                entry.setValue(now);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void announce(Download download) {
        this.log.log("Announce requested for " + download.getName());
        try {
            this.this_mon.enter();
            this.query_map.put(download, SystemTime.getCurrentTime());
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void positionChanged(Download download, int oldPosition, int newPosition) {
    }

    protected void configChanged() {
        Download[] downloads = this.plugin_interface.getDownloadManager().getDownloads();
        int i = 0;
        while (i < downloads.length) {
            this.checkDownloadForRegistration(downloads[i], false);
            ++i;
        }
    }

    public DownloadScrapeResult scrape(byte[] hash) {
        final int[] seeds = new int[1];
        final int[] leechers = new int[1];
        final AESemaphore sem = new AESemaphore("DHTTrackerPlugin:scrape");
        this.dht.get(hash, "Scrape for " + ByteFormatter.encodeString(hash).substring(0, 16), (byte)1, 30, 30000L, false, false, new DHTPluginOperationListener(){

            @Override
            public boolean diversified() {
                return true;
            }

            @Override
            public void starts(byte[] key) {
            }

            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                if ((value.getFlags() & 1) == 1) {
                    leechers[0] = leechers[0] + 1;
                } else {
                    seeds[0] = seeds[0] + 1;
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] key, boolean timeout_occurred) {
                sem.release();
            }
        });
        sem.reserve();
        return new DownloadScrapeResult(){

            @Override
            public Download getDownload() {
                return null;
            }

            @Override
            public int getResponseType() {
                return 1;
            }

            @Override
            public int getSeedCount() {
                return seeds[0];
            }

            @Override
            public int getNonSeedCount() {
                return leechers[0];
            }

            @Override
            public long getScrapeStartTime() {
                return 0L;
            }

            @Override
            public void setNextScrapeStartTime(long nextScrapeStartTime) {
            }

            @Override
            public long getNextScrapeStartTime() {
                return 0L;
            }

            @Override
            public String getStatus() {
                return "OK";
            }

            @Override
            public URL getURL() {
                return null;
            }
        };
    }

    protected void increaseActive(Download dl) {
        try {
            this.this_mon.enter();
            Integer active_i = this.in_progress.get(dl);
            int active = active_i == null ? 0 : active_i;
            this.in_progress.put(dl, new Integer(active + 1));
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void decreaseActive(Download dl) {
        try {
            this.this_mon.enter();
            Integer active_i = this.in_progress.get(dl);
            if (active_i == null) {
                Debug.out("active count inconsistent");
            } else {
                int active = active_i - 1;
                if (active == 0) {
                    this.in_progress.remove(dl);
                } else {
                    this.in_progress.put(dl, new Integer(active));
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected boolean isActive(Download dl) {
        try {
            this.this_mon.enter();
            boolean bl = this.in_progress.get(dl) != null;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void log(Download download, String str) {
        this.log.log((Object)download, 1, str);
    }

    public TrackerPeerSource getTrackerPeerSource(final Download download) {
        return new TrackerPeerSourceAdapter(){
            private long last_fixup;
            private boolean updating;
            private int status = 0;
            private String status_str;
            private long next_time = -1L;
            private int[] run_data;

            private void fixup() {
                long now = SystemTime.getMonotonousTime();
                if (now - this.last_fixup > 5000L) {
                    String new_status_str = null;
                    try {
                        DHTTrackerPlugin.this.this_mon.enter();
                        this.updating = false;
                        this.next_time = -1L;
                        this.run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(download);
                        if (this.run_data != null) {
                            if (DHTTrackerPlugin.this.in_progress.containsKey(download)) {
                                this.updating = true;
                            }
                            this.status = DHTTrackerPlugin.this.initialised_sem.isReleasedForever() ? 5 : 2;
                            Long l_next_time = (Long)DHTTrackerPlugin.this.query_map.get(download);
                            if (l_next_time != null) {
                                this.next_time = l_next_time;
                            }
                        } else if (DHTTrackerPlugin.this.interesting_downloads.containsKey(download)) {
                            this.status = 2;
                        } else {
                            int dl_state = download.getState();
                            if (dl_state == 4 || dl_state == 5 || dl_state == 9) {
                                this.status = 1;
                                String reason = (String)download.getUserData(LATEST_REGISTER_REASON);
                                if (reason != null && !reason.isEmpty()) {
                                    new_status_str = reason;
                                }
                            } else {
                                this.status = 2;
                            }
                        }
                        if (this.run_data == null) {
                            this.run_data = (int[])DHTTrackerPlugin.this.run_data_cache.get(download);
                        }
                    }
                    finally {
                        DHTTrackerPlugin.this.this_mon.exit();
                    }
                    String[] sources = download.getListAttribute(DHTTrackerPlugin.this.ta_peer_sources);
                    boolean ok = false;
                    if (sources != null) {
                        int i = 0;
                        while (i < sources.length) {
                            if (sources[i].equalsIgnoreCase("DHT")) {
                                ok = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!ok) {
                        this.status = 1;
                        boolean done = false;
                        try {
                            if (download.getTorrent().isPrivate()) {
                                new_status_str = MessageText.getString("label.private");
                                done = true;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!done) {
                            new_status_str = MessageText.getString("label.peer.source.disabled");
                        }
                    }
                    this.status_str = new_status_str;
                    this.last_fixup = now;
                }
            }

            @Override
            public int getType() {
                return 3;
            }

            @Override
            public String getName() {
                return "DHT: " + DHTTrackerPlugin.this.model.getStatus().getText();
            }

            @Override
            public int getStatus() {
                this.fixup();
                return this.status;
            }

            @Override
            public String getStatusString() {
                this.fixup();
                return this.status_str;
            }

            @Override
            public int getSeedCount() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[1];
            }

            @Override
            public int getLeecherCount() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[2];
            }

            @Override
            public int getPeers() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[3];
            }

            @Override
            public int getLastUpdate() {
                this.fixup();
                if (this.run_data == null) {
                    return 0;
                }
                return this.run_data[4];
            }

            @Override
            public int getSecondsToUpdate() {
                this.fixup();
                if (this.next_time < 0L) {
                    return Integer.MIN_VALUE;
                }
                return (int)((this.next_time - SystemTime.getCurrentTime()) / 1000L);
            }

            @Override
            public int getInterval() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return (int)(DHTTrackerPlugin.this.current_announce_interval / 1000L);
            }

            @Override
            public int getMinInterval() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return 120;
            }

            @Override
            public boolean isUpdating() {
                return this.updating;
            }

            @Override
            public boolean canManuallyUpdate() {
                this.fixup();
                return this.run_data != null;
            }

            @Override
            public void manualUpdate() {
                DHTTrackerPlugin.this.announce(download);
            }

            @Override
            public long[] getReportedStats() {
                return null;
            }
        };
    }

    public TrackerPeerSource[] getTrackerPeerSources(final Torrent torrent) {
        TrackerPeerSourceAdapter vuze_dht = new TrackerPeerSourceAdapter(){
            private volatile boolean query_done;
            private volatile int status = 9;
            private volatile int seeds = 0;
            private volatile int leechers = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fixup() {
                if (DHTTrackerPlugin.this.initialised_sem.isReleasedForever()) {
                    20 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.query_done) {
                            return;
                        }
                        this.query_done = true;
                        this.status = 4;
                    }
                    DHTTrackerPlugin.this.dht.get(torrent.getHash(), "Availability lookup for '" + torrent.getName() + "'", (byte)1, 30, 60000L, false, true, new DHTPluginOperationListener(){

                        @Override
                        public void starts(byte[] key) {
                        }

                        @Override
                        public boolean diversified() {
                            return true;
                        }

                        @Override
                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                            if ((value.getFlags() & 1) == 1) {
                                20 v0 = this;
                                v0.seeds = v0.seeds + 1;
                            } else {
                                20 v1 = this;
                                v1.leechers = v1.leechers + 1;
                            }
                        }

                        @Override
                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        @Override
                        public void complete(byte[] key, boolean timeout_occurred) {
                            status = 5;
                        }
                    });
                }
            }

            @Override
            public int getType() {
                return 3;
            }

            @Override
            public String getName() {
                return String.valueOf(Constants.APP_NAME) + " DHT";
            }

            @Override
            public int getStatus() {
                this.fixup();
                return this.status;
            }

            @Override
            public int getSeedCount() {
                this.fixup();
                int result = this.seeds;
                if (result == 0 && this.status != 5) {
                    return -1;
                }
                return result;
            }

            @Override
            public int getLeecherCount() {
                this.fixup();
                int result = this.leechers;
                if (result == 0 && this.status != 5) {
                    return -1;
                }
                return result;
            }

            @Override
            public int getPeers() {
                return -1;
            }

            @Override
            public boolean isUpdating() {
                return this.status == 4;
            }
        };
        if (this.alt_lookup_handler != null) {
            TrackerPeerSourceAdapter alt_dht = new TrackerPeerSourceAdapter(torrent){
                private volatile int status = 4;
                private volatile int peers = 0;
                {
                    DHTTrackerPlugin.this.alt_lookup_handler.get(torrent.getHash(), false, new DHTTrackerPluginAlt.LookupListener(){

                        @Override
                        public void foundPeer(InetSocketAddress address) {
                            21 v0 = this;
                            v0.peers = v0.peers + 1;
                        }

                        @Override
                        public boolean isComplete() {
                            return false;
                        }

                        @Override
                        public void completed() {
                            status = 5;
                        }
                    });
                }

                @Override
                public int getType() {
                    return 3;
                }

                @Override
                public String getName() {
                    return "Mainline DHT";
                }

                @Override
                public int getStatus() {
                    return this.status;
                }

                @Override
                public int getPeers() {
                    int result = this.peers;
                    if (result == 0 && this.status != 5) {
                        return -1;
                    }
                    return result;
                }

                @Override
                public boolean isUpdating() {
                    return this.status == 4;
                }
            };
            return new TrackerPeerSource[]{vuze_dht, alt_dht};
        }
        return new TrackerPeerSource[]{vuze_dht};
    }

    protected class RegistrationDetails {
        private putDetails put_details;
        private byte flags;
        private trackerTarget[] put_targets;
        private List<trackerTarget> not_put_targets;

        protected RegistrationDetails(Download _download, int _reg_type, putDetails _put_details, byte _flags) {
            this.put_details = _put_details;
            this.flags = _flags;
            this.getTrackerTargets(_download, _reg_type);
        }

        protected void update(putDetails _put_details, byte _flags) {
            this.put_details = _put_details;
            this.flags = _flags;
        }

        protected boolean updateTargets(Download _download, int _reg_type) {
            trackerTarget[] old_put_targets = this.put_targets;
            this.getTrackerTargets(_download, _reg_type);
            int i = 0;
            while (i < old_put_targets.length) {
                boolean found = false;
                byte[] old_hash = old_put_targets[i].getHash();
                int j = 0;
                while (j < this.put_targets.length) {
                    if (Arrays.equals(this.put_targets[j].getHash(), old_hash)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    DHTTrackerPlugin.this.trackerRemove(_download, old_put_targets[i]);
                }
                ++i;
            }
            boolean changed = false;
            int i2 = 0;
            while (i2 < this.put_targets.length) {
                byte[] new_hash = this.put_targets[i2].getHash();
                boolean found = false;
                int j = 0;
                while (j < old_put_targets.length) {
                    if (Arrays.equals(old_put_targets[j].getHash(), new_hash)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    changed = true;
                }
                ++i2;
            }
            return changed;
        }

        protected putDetails getPutDetails() {
            return this.put_details;
        }

        protected byte getFlags() {
            return this.flags;
        }

        protected trackerTarget[] getTargets(boolean for_put) {
            if (for_put || this.not_put_targets == null) {
                return this.put_targets;
            }
            ArrayList<trackerTarget> result = new ArrayList<trackerTarget>(Arrays.asList(this.put_targets));
            int i = 0;
            while (i < this.not_put_targets.size() && i < 2) {
                trackerTarget target = this.not_put_targets.remove(0);
                this.not_put_targets.add(target);
                result.add(target);
                ++i;
            }
            return result.toArray(new trackerTarget[result.size()]);
        }

        protected void getTrackerTargets(Download download, int type) {
            byte[] torrent_hash = download.getTorrent().getHash();
            ArrayList<trackerTarget> result = new ArrayList<trackerTarget>();
            if (type == 2) {
                result.add(new trackerTarget(torrent_hash, 2, ""));
            }
            this.put_targets = result.toArray(new trackerTarget[result.size()]);
        }
    }

    public static class TriangleSlicer {
        int width;
        private double w;
        private double w2;
        private double h;
        private double tan60;

        public TriangleSlicer(int width) {
            this.width = width;
            this.w = width;
            this.w2 = this.w / 2.0;
            this.h = Math.cos(0.5235987755982988) * this.w;
            this.tan60 = Math.tan(1.0471975511965976);
        }

        public int[] findVertices(double x, double y) {
            double v3y;
            double v3x;
            double v2y;
            double v2x;
            double v1y;
            double v1x;
            boolean upTriangle;
            int yN = (int)Math.floor(y / this.h);
            int xN = (int)Math.floor(x / this.w2);
            if ((xN + yN) % 2 == 0) {
                if (y - this.h * (double)yN > (x - this.w2 * (double)xN) * this.tan60) {
                    upTriangle = false;
                    v1x = this.w2 * (double)(xN - 1);
                    v1y = this.h * (double)(yN + 1);
                } else {
                    upTriangle = true;
                    v1x = this.w2 * (double)xN;
                    v1y = this.h * (double)yN;
                }
            } else if (y - this.h * (double)yN > (this.w2 - (x - this.w2 * (double)xN)) * this.tan60) {
                upTriangle = false;
                v1x = this.w2 * (double)xN;
                v1y = this.h * (double)(yN + 1);
            } else {
                upTriangle = true;
                v1x = this.w2 * (double)(xN - 1);
                v1y = this.h * (double)yN;
            }
            if (upTriangle) {
                v2x = v1x + this.w;
                v2y = v1y;
                v3x = v1x + this.w2;
                v3y = v1y + this.h;
            } else {
                v2x = v1x + this.w;
                v2y = v1y;
                v3x = v1x + this.w2;
                v3y = v1y - this.h;
            }
            int[] result = new int[]{(int)v1x, (int)v1y, (int)v2x, (int)v2y, (int)v3x, (int)v3y};
            return result;
        }
    }

    protected static class putDetails {
        private String encoded;
        private String ip_override;
        private int tcp_port;
        private int udp_port;
        private boolean i2p;

        private putDetails(String _encoded, String _ip, int _tcp_port, int _udp_port, boolean _i2p) {
            this.encoded = _encoded;
            this.ip_override = _ip;
            this.tcp_port = _tcp_port;
            this.udp_port = _udp_port;
            this.i2p = _i2p;
        }

        protected String getEncoded() {
            return this.encoded;
        }

        protected String getIPOverride() {
            return this.ip_override;
        }

        protected int getTCPPort() {
            return this.tcp_port;
        }

        protected int getUDPPort() {
            return this.udp_port;
        }

        private boolean hasI2P() {
            return this.i2p;
        }

        protected boolean sameAs(putDetails other) {
            if (!StringCompareUtils.equals(this.ip_override, other.ip_override)) {
                return false;
            }
            return this.tcp_port == other.tcp_port && this.udp_port == other.udp_port;
        }
    }

    public static class trackerTarget {
        private String desc;
        private byte[] hash;
        private int type;

        protected trackerTarget(byte[] _hash, int _type, String _desc) {
            this.hash = _hash;
            this.type = _type;
            this.desc = _desc;
        }

        public int getType() {
            return this.type;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public String getDesc(String prefix) {
            if (this.type != 2) {
                return String.valueOf(prefix) + " (" + this.desc + ")";
            }
            return prefix;
        }
    }
}

