/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.removerules;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadTrackerListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadRemoveRulesPlugin
implements Plugin,
DownloadManagerListener {
    public static final int INITIAL_DELAY = 60000;
    public static final int DELAYED_REMOVAL_PERIOD = 60000;
    public static final int AELITIS_BIG_TORRENT_SEED_LIMIT = 10000;
    public static final int AELITIS_SMALL_TORRENT_SEED_LIMIT = 1000;
    public static final int MAX_SEED_TO_PEER_RATIO = 10;
    protected PluginInterface plugin_interface;
    protected boolean closing;
    protected Map dm_listener_map = new HashMap(10);
    protected List monitored_downloads = new ArrayList();
    protected LoggerChannel log;
    protected BooleanParameter remove_unauthorised;
    protected BooleanParameter remove_unauthorised_seeding_only;
    protected BooleanParameter remove_unauthorised_data;
    protected BooleanParameter remove_update_torrents;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Download Remove Rules");
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getChannel("DLRemRules");
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("torrents", "download.removerules.name");
        config.addLabelParameter2("download.removerules.unauthorised.info");
        this.remove_unauthorised = config.addBooleanParameter2("download.removerules.unauthorised", "download.removerules.unauthorised", false);
        this.remove_unauthorised_seeding_only = config.addBooleanParameter2("download.removerules.unauthorised.seedingonly", "download.removerules.unauthorised.seedingonly", true);
        this.remove_unauthorised_data = config.addBooleanParameter2("download.removerules.unauthorised.data", "download.removerules.unauthorised.data", false);
        this.remove_unauthorised.addEnabledOnSelection((Parameter)this.remove_unauthorised_seeding_only);
        this.remove_unauthorised.addEnabledOnSelection((Parameter)this.remove_unauthorised_data);
        this.remove_update_torrents = config.addBooleanParameter2("download.removerules.updatetorrents", "download.removerules.updatetorrents", true);
        new DelayedEvent("DownloadRemovalRules", 60000L, new AERunnable(){

            @Override
            public void runSupport() {
                DownloadRemoveRulesPlugin.this.plugin_interface.getDownloadManager().addListener(DownloadRemoveRulesPlugin.this);
            }
        });
    }

    @Override
    public void downloadAdded(final Download download) {
        DiskManagerFileInfo file;
        DiskManagerFileInfo[] files;
        if (!download.isPersistent()) {
            return;
        }
        if (download.getFlag(16L) && (files = download.getDiskManagerFileInfo()).length == 1 && (file = files[0]).getDownloaded() == file.getLength() && !file.getFile().exists()) {
            this.log.log("Removing low-noise download '" + download.getName() + " as data missing");
            this.removeDownload(download, false);
        }
        DownloadTrackerListener listener = new DownloadTrackerListener(){

            @Override
            public void scrapeResult(DownloadScrapeResult response) {
                if (DownloadRemoveRulesPlugin.this.closing) {
                    return;
                }
                DownloadRemoveRulesPlugin.this.handleScrape(download, response);
            }

            @Override
            public void announceResult(DownloadAnnounceResult response) {
                if (DownloadRemoveRulesPlugin.this.closing) {
                    return;
                }
                DownloadRemoveRulesPlugin.this.handleAnnounce(download, response);
            }
        };
        this.monitored_downloads.add(download);
        this.dm_listener_map.put(download, listener);
        download.addTrackerListener(listener);
    }

    protected void handleScrape(Download download, DownloadScrapeResult response) {
        String status = response.getStatus();
        if (status == null) {
            status = "";
        }
        this.handleAnnounceScrapeStatus(download, status);
    }

    protected void handleAnnounce(Download download, DownloadAnnounceResult response) {
        String reason = "";
        if (response.getResponseType() == 2 && (reason = response.getError()) == null) {
            reason = "";
        }
        this.handleAnnounceScrapeStatus(download, reason);
    }

    protected void handleAnnounceScrapeStatus(Download download, String status) {
        if (!this.monitored_downloads.contains(download)) {
            return;
        }
        status = status.toLowerCase();
        boolean download_completed = download.isComplete();
        if ((status.contains("not authori") || status.toLowerCase().contains("unauthori")) && this.remove_unauthorised.getValue() && (!this.remove_unauthorised_seeding_only.getValue() || download_completed)) {
            this.log.log((Object)download.getTorrent(), 1, "Download '" + download.getName() + "' is unauthorised and removal triggered");
            this.removeDownload(download, this.remove_unauthorised_data.getValue());
            return;
        }
    }

    protected void removeDownloadDelayed(final Download download, final boolean remove_data) {
        this.monitored_downloads.remove(download);
        this.plugin_interface.getUtilities().createThread("delayedRemoval", new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    Thread.sleep(60000L);
                    DownloadRemoveRulesPlugin.this.removeDownload(download, remove_data);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    protected void removeDownload(Download download, final boolean remove_data) {
        this.monitored_downloads.remove(download);
        if (download.getState() == 7) {
            try {
                download.remove(false, remove_data);
            }
            catch (Throwable e) {
                this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", e);
            }
        } else {
            download.addListener(new DownloadListener(){

                @Override
                public void stateChanged(Download download, int old_state, int new_state) {
                    DownloadRemoveRulesPlugin.this.log.log((Object)download.getTorrent(), 1, "download state changed to '" + new_state + "'");
                    if (new_state == 7) {
                        try {
                            download.remove(false, remove_data);
                            String msg = DownloadRemoveRulesPlugin.this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("download.removerules.removed.ok", new String[]{download.getName()});
                            if (download.getFlag(16L)) {
                                DownloadRemoveRulesPlugin.this.log.log((Object)download.getTorrent(), 1, msg);
                            } else {
                                DownloadRemoveRulesPlugin.this.log.logAlert(1, msg);
                            }
                        }
                        catch (Throwable e) {
                            DownloadRemoveRulesPlugin.this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", e);
                        }
                    }
                }

                @Override
                public void positionChanged(Download download, int oldPosition, int newPosition) {
                }
            });
            try {
                download.stop();
            }
            catch (DownloadException e) {
                this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", e);
            }
        }
    }

    @Override
    public void downloadRemoved(Download download) {
        this.monitored_downloads.remove(download);
        DownloadTrackerListener listener = (DownloadTrackerListener)this.dm_listener_map.remove(download);
        if (listener != null) {
            download.removeTrackerListener(listener);
        }
    }

    public void destroyInitiated() {
        this.closing = true;
    }

    public void destroyed() {
    }
}

