/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.platform.unix;

import com.biglybt.core.Core;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerListener;
import com.biglybt.platform.PlatformManagerPingCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;

public class PlatformManagerImpl
implements PlatformManager {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static PlatformManagerImpl singleton;
    protected static AEMonitor class_mon;
    private final HashSet capabilitySet = new HashSet();
    private static final Object migrate_lock;

    static {
        class_mon = new AEMonitor("PlatformManager");
        migrate_lock = new Object();
        PlatformManagerImpl.initializeSingleton();
    }

    public static PlatformManagerImpl getSingleton() {
        return singleton;
    }

    private static void initializeSingleton() {
        try {
            try {
                class_mon.enter();
                singleton = new PlatformManagerImpl();
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "Failed to initialize platform manager for Unix Compatable OS", e));
                class_mon.exit();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public PlatformManagerImpl() {
        this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
        if (this.hasVMOptions()) {
            this.capabilitySet.add(PlatformManagerCapabilities.AccessExplicitVMOptions);
        }
    }

    private boolean hasVMOptions() {
        return System.getProperty(SystemProperties.SYSPROP_SCRIPT_VERSION, null) != null;
    }

    @Override
    public void copyFilePermissions(String from_file_name, String to_file_name) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void createProcess(String command_line, boolean inherit_handles) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getApplicationCommandLine() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public int getPlatformType() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserDataDirectory() throws PlatformManagerException {
        String userhome = System.getProperty("user.home");
        String temp_user_path = String.valueOf(userhome) + SystemProperties.SEP + "." + SystemProperties.getApplicationName().toLowerCase() + SystemProperties.SEP;
        Object object = migrate_lock;
        synchronized (object) {
            String old_home_path;
            File old_home;
            File home = new File(temp_user_path);
            if (!home.exists() && (old_home = new File(old_home_path = String.valueOf(userhome) + SystemProperties.SEP + "." + SystemProperties.getApplicationName() + SystemProperties.SEP)).exists()) {
                String msg = "Migrating unix user config dir [" + old_home_path + "] ===> [" + temp_user_path + "]";
                System.out.println(msg);
                Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Unix): " + msg));
                try {
                    old_home.renameTo(home);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Logger.log(new LogEvent(LOGID, "migration rename failed:", t));
                }
            }
        }
        return temp_user_path;
    }

    @Override
    public String getComputerName() {
        String host = System.getenv("HOST");
        if (host != null && host.length() > 0) {
            return host;
        }
        return null;
    }

    @Override
    public String getVersion() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public boolean hasCapability(PlatformManagerCapabilities capability) {
        return this.capabilitySet.contains(capability);
    }

    @Override
    public boolean isApplicationRegistered() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void performRecoverableFileDelete(String file_name) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void ping(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public int getMaxOpenFiles() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void registerApplication() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void addListener(PlatformManagerListener listener) {
    }

    @Override
    public void removeListener(PlatformManagerListener listener) {
    }

    @Override
    public File getVMOptionFile() throws PlatformManagerException {
        this.checkCapability(PlatformManagerCapabilities.AccessExplicitVMOptions);
        File local_options = new File(this.getLocation(1L), "java.vmoptions");
        if (!local_options.exists()) {
            try {
                local_options.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return local_options;
    }

    private void checkCapability(PlatformManagerCapabilities capability) throws PlatformManagerException {
        if (!this.hasCapability(capability)) {
            throw new PlatformManagerException("Capability " + capability + " not supported");
        }
    }

    @Override
    public String[] getExplicitVMOptions() throws PlatformManagerException {
        this.checkCapability(PlatformManagerCapabilities.AccessExplicitVMOptions);
        File local_options = this.getVMOptionFile();
        try {
            ArrayList<String> list = new ArrayList<String>();
            if (local_options.exists()) {
                try (LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(local_options), "UTF-8"));){
                    String line;
                    while ((line = lnr.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        list.add(line);
                    }
                }
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Throwable e) {
            throw new PlatformManagerException(MessageText.getString("platform.jvmopt.accesserror", new String[]{Debug.getNestedExceptionMessage(e)}));
        }
    }

    @Override
    public void setExplicitVMOptions(String[] options) throws PlatformManagerException {
        block12: {
            this.checkCapability(PlatformManagerCapabilities.AccessExplicitVMOptions);
            File local_options = this.getVMOptionFile();
            try {
                if (!local_options.exists()) break block12;
                File backup = new File(local_options.getParentFile(), String.valueOf(local_options.getName()) + ".bak");
                if (backup.exists()) {
                    backup.delete();
                }
                if (!local_options.renameTo(backup)) {
                    throw new Exception("Failed to move " + local_options + " to " + backup);
                }
                boolean ok = false;
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(local_options), "UTF-8"));){
                    String[] stringArray = options;
                    int n = options.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String option = stringArray[n2];
                        pw.println(option);
                        ++n2;
                    }
                    ok = true;
                }
                finally {
                    if (!ok) {
                        local_options.delete();
                        backup.renameTo(local_options);
                    }
                }
            }
            catch (Throwable e) {
                throw new PlatformManagerException(MessageText.getString("platform.jvmopt.accesserror", new String[]{Debug.getNestedExceptionMessage(e)}));
            }
        }
    }

    @Override
    public boolean getRunAtLogin() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void setRunAtLogin(boolean run) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void startup(Core core) throws PlatformManagerException {
    }

    @Override
    public int getShutdownTypes() {
        return 0;
    }

    @Override
    public void shutdown(int type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void setPreventComputerSleep(boolean b) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public boolean getPreventComputerSleep() {
        return false;
    }

    @Override
    public void setTCPTOSEnabled(boolean enabled) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public boolean testNativeAvailability(String name) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void traceRoute(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public File getLocation(long location_id) throws PlatformManagerException {
        switch ((int)location_id) {
            case 1: {
                return new File(this.getUserDataDirectory());
            }
            case 3: {
                return new File(System.getProperty("user.home"));
            }
            case 5: {
                return new File(System.getProperty("user.home"), "Downloads");
            }
        }
        return null;
    }

    @Override
    public boolean isAdditionalFileTypeRegistered(String name, String type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void registerAdditionalFileType(String name, String description, String type, String content_type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void showFile(String file_name) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void unregisterAdditionalFileType(String name, String type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public String getAzComputerID() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void requestUserAttention(int type, Object data) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public Class<?> loadClass(ClassLoader loader, String class_name) throws PlatformManagerException {
        try {
            return loader.loadClass(class_name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("load of '" + class_name + "' failed", e);
        }
    }
}

