/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.remote.download;

import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.disk.DiskManager;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadActivationEvent;
import com.biglybt.pif.download.DownloadActivationListener;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadAttributeListener;
import com.biglybt.pif.download.DownloadCompletionListener;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadPeerListener;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadStats;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.download.DownloadTrackerListener;
import com.biglybt.pif.download.DownloadWillBeRemovedListener;
import com.biglybt.pif.download.savelocation.SaveLocationChange;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.tag.Tag;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.remote.RPException;
import com.biglybt.pifimpl.remote.RPObject;
import com.biglybt.pifimpl.remote.RPReply;
import com.biglybt.pifimpl.remote.RPRequest;
import com.biglybt.pifimpl.remote.RPRequestDispatcher;
import com.biglybt.pifimpl.remote.disk.RPDiskManagerFileInfo;
import com.biglybt.pifimpl.remote.download.RPDownloadAnnounceResult;
import com.biglybt.pifimpl.remote.download.RPDownloadScrapeResult;
import com.biglybt.pifimpl.remote.download.RPDownloadStats;
import com.biglybt.pifimpl.remote.torrent.RPTorrent;
import java.io.File;
import java.util.List;
import java.util.Map;

public class RPDownload
extends RPObject
implements Download {
    protected transient Download delegate;
    public RPTorrent torrent;
    public RPDownloadStats stats;
    public RPDownloadAnnounceResult announce_result;
    public RPDownloadScrapeResult scrape_result;
    public int position;
    public boolean force_start;

    public static RPDownload create(Download _delegate) {
        RPDownload res = (RPDownload)RPDownload._lookupLocal(_delegate);
        if (res == null) {
            res = new RPDownload(_delegate);
        }
        return res;
    }

    protected RPDownload(Download _delegate) {
        super(_delegate);
        if (this.delegate.getTorrent() != null) {
            this.torrent = (RPTorrent)RPDownload._lookupLocal(this.delegate.getTorrent());
            if (this.torrent == null) {
                this.torrent = RPTorrent.create(this.delegate.getTorrent());
            }
        }
        this.stats = (RPDownloadStats)RPDownload._lookupLocal(this.delegate.getStats());
        if (this.stats == null) {
            this.stats = RPDownloadStats.create(this.delegate.getStats());
        }
        this.announce_result = (RPDownloadAnnounceResult)RPDownload._lookupLocal(this.delegate.getLastAnnounceResult());
        if (this.announce_result == null) {
            this.announce_result = RPDownloadAnnounceResult.create(this.delegate.getLastAnnounceResult());
        }
        this.scrape_result = (RPDownloadScrapeResult)RPDownload._lookupLocal(this.delegate.getLastScrapeResult());
        if (this.scrape_result == null) {
            this.scrape_result = RPDownloadScrapeResult.create(this.delegate.getLastScrapeResult());
        }
    }

    @Override
    protected void _setDelegate(Object _delegate) {
        this.delegate = (Download)_delegate;
        this.position = this.delegate.getPosition();
        this.force_start = this.delegate.isForceStart();
    }

    @Override
    public Object _setLocal() throws RPException {
        Object res = this._fixupLocal();
        if (this.torrent != null) {
            this.torrent._setLocal();
        }
        this.stats._setLocal();
        this.announce_result._setLocal();
        this.scrape_result._setLocal();
        return res;
    }

    @Override
    public void _setRemote(RPRequestDispatcher dispatcher) {
        super._setRemote(dispatcher);
        if (this.torrent != null) {
            this.torrent._setRemote(dispatcher);
        }
        this.stats._setRemote(dispatcher);
        this.announce_result._setRemote(dispatcher);
        this.scrape_result._setRemote(dispatcher);
    }

    @Override
    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        if (method.equals("initialize")) {
            try {
                this.delegate.initialize();
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("start")) {
            try {
                this.delegate.start();
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("restart")) {
            try {
                this.delegate.restart();
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("stop")) {
            try {
                this.delegate.stop();
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("remove")) {
            try {
                this.delegate.remove();
            }
            catch (Throwable e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("stopAndRemove")) {
            try {
                Object[] params = request2.getParams();
                this.delegate.stopAndRemove((Boolean)params[0], (Boolean)params[1]);
            }
            catch (Throwable e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("setForceStart[boolean]")) {
            boolean b = (Boolean)request2.getParams()[0];
            this.delegate.setForceStart(b);
            return null;
        }
        if (method.equals("setPosition[int]")) {
            int p = (Integer)request2.getParams()[0];
            this.delegate.setPosition(p);
            return null;
        }
        if (method.equals("moveUp")) {
            this.delegate.moveUp();
            return null;
        }
        if (method.equals("moveDown")) {
            this.delegate.moveDown();
            return null;
        }
        if (method.equals("moveTo[int]")) {
            int p = (Integer)request2.getParams()[0];
            this.delegate.setPosition(p);
            return null;
        }
        if (method.equals("requestTrackerAnnounce")) {
            this.delegate.requestTrackerAnnounce();
            return null;
        }
        if (method.equals("getDiskManagerFileInfo")) {
            DiskManagerFileInfo[] info = this.delegate.getDiskManagerFileInfo();
            RPDiskManagerFileInfo[] rp_info = new RPDiskManagerFileInfo[info.length];
            int i = 0;
            while (i < rp_info.length) {
                rp_info[i] = RPDiskManagerFileInfo.create(info[i]);
                ++i;
            }
            return new RPReply(rp_info);
        }
        throw new RPException("Unknown method: " + method);
    }

    @Override
    public int getState() {
        this.notSupported();
        return 0;
    }

    @Override
    public int getSubState() {
        this.notSupported();
        return 0;
    }

    @Override
    public String getErrorStateDetails() {
        this.notSupported();
        return null;
    }

    @Override
    public boolean getFlag(long flag) {
        this.notSupported();
        return false;
    }

    @Override
    public long getFlags() {
        this.notSupported();
        return 0L;
    }

    @Override
    public Torrent getTorrent() {
        return this.torrent;
    }

    @Override
    public byte[] getDownloadPeerId() {
        return this.delegate.getDownloadPeerId();
    }

    @Override
    public boolean isMessagingEnabled() {
        return this.delegate.isMessagingEnabled();
    }

    @Override
    public void setMessagingEnabled(boolean enabled) {
        this.delegate.setMessagingEnabled(enabled);
    }

    @Override
    public void initialize() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "initialize", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void start() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "start", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void stop() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "stop", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void setStopReason(String reason) {
        this.setUserData(UD_KEY_STOP_REASON, reason);
    }

    @Override
    public String getStopReason() {
        return (String)this.getUserData(UD_KEY_STOP_REASON);
    }

    @Override
    public void restart() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "restart", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean isStartStopLocked() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isPaused() {
        this.notSupported();
        return false;
    }

    @Override
    public void pause() {
        this.notSupported();
    }

    @Override
    public void resume() {
        this.notSupported();
    }

    @Override
    public void remove() throws DownloadException, DownloadRemovalVetoException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "remove", null)).getResponse();
        }
        catch (RPException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DownloadException) {
                throw (DownloadException)cause;
            }
            if (cause instanceof DownloadRemovalVetoException) {
                throw (DownloadRemovalVetoException)cause;
            }
            throw e;
        }
    }

    @Override
    public void stopAndRemove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "stopAndRemove", new Object[]{delete_torrent, delete_data})).getResponse();
        }
        catch (RPException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DownloadException) {
                throw (DownloadException)cause;
            }
            if (cause instanceof DownloadRemovalVetoException) {
                throw (DownloadRemovalVetoException)cause;
            }
            throw e;
        }
    }

    @Override
    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        this.notSupported();
    }

    @Override
    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        this.notSupported();
        return false;
    }

    @Override
    public DownloadAnnounceResult getLastAnnounceResult() {
        return this.announce_result;
    }

    @Override
    public DownloadScrapeResult getLastScrapeResult() {
        return this.scrape_result;
    }

    @Override
    public DownloadScrapeResult getAggregatedScrapeResult(boolean cache) {
        this.notSupported();
        return null;
    }

    @Override
    public DownloadStats getStats() {
        return this.stats;
    }

    @Override
    public void addListener(DownloadListener l) {
        this.notSupported();
    }

    @Override
    public void removeListener(DownloadListener l) {
        this.notSupported();
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener l) {
        this.notSupported();
    }

    @Override
    public void removeTrackerListener(DownloadTrackerListener l) {
        this.notSupported();
    }

    @Override
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    @Override
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean isForceStart() {
        return this.force_start;
    }

    @Override
    public void setForceStart(boolean _force_start) {
        this.force_start = _force_start;
        this._dispatcher.dispatch(new RPRequest(this, "setForceStart[boolean]", new Object[]{this.force_start})).getResponse();
    }

    @Override
    public void setPosition(int new_position) {
        this._dispatcher.dispatch(new RPRequest(this, "setPosition[int]", new Object[]{new Integer(new_position)})).getResponse();
    }

    @Override
    public void moveUp() {
        this._dispatcher.dispatch(new RPRequest(this, "moveUp", null)).getResponse();
    }

    @Override
    public void moveDown() {
        this._dispatcher.dispatch(new RPRequest(this, "moveDown", null)).getResponse();
    }

    @Override
    public void moveTo(int position) {
        this._dispatcher.dispatch(new RPRequest(this, "moveTo[int]", new Object[]{new Integer(position)})).getResponse();
    }

    @Override
    public void stopAndQueue() throws DownloadException {
        this.notSupported();
    }

    @Override
    public void recheckData() throws DownloadException {
        this.notSupported();
    }

    @Override
    public String getName() {
        this.notSupported();
        return "";
    }

    public void addListener(DownloadPeerListener l) {
        this.notSupported(l);
    }

    public void removeListener(DownloadPeerListener l) {
        this.notSupported(l);
    }

    @Override
    public void addPeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    @Override
    public void removePeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    @Override
    public String getTorrentFileName() {
        this.notSupported();
        return "";
    }

    @Override
    public String getAttribute(TorrentAttribute attribute) {
        this.notSupported();
        return null;
    }

    @Override
    public void setAttribute(TorrentAttribute attribute, String value) {
        this.notSupported();
    }

    @Override
    public String[] getListAttribute(TorrentAttribute attribute) {
        this.notSupported();
        return null;
    }

    @Override
    public void setMapAttribute(TorrentAttribute attribute, Map value) {
        this.notSupported();
    }

    @Override
    public Map getMapAttribute(TorrentAttribute attribute) {
        this.notSupported();
        return null;
    }

    @Override
    public String getCategoryName() {
        this.notSupported();
        return "";
    }

    @Override
    public void setCategory(String sName) {
        this.notSupported();
    }

    @Override
    public List<Tag> getTags() {
        this.notSupported();
        return null;
    }

    @Override
    public boolean isPersistent() {
        this.notSupported();
        return false;
    }

    @Override
    public void setMaximumDownloadKBPerSecond(int kb) {
        this.notSupported();
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        this.notSupported();
        return 0;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        this.notSupported();
        return 0;
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    @Override
    public int getMaximumDownloadKBPerSecond() {
        this.notSupported();
        return 0;
    }

    @Override
    public void addRateLimiter(RateLimiter limiter, boolean is_upload) {
        this.notSupported();
    }

    @Override
    public void removeRateLimiter(RateLimiter limiter, boolean is_upload) {
        this.notSupported();
    }

    @Override
    public boolean isComplete() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isComplete(boolean b) {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isChecking() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isMoving() {
        this.notSupported();
        return false;
    }

    @Override
    public PeerManager getPeerManager() {
        this.notSupported();
        return null;
    }

    @Override
    public DiskManager getDiskManager() {
        this.notSupported();
        return null;
    }

    @Override
    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        DiskManagerFileInfo[] resp = (RPDiskManagerFileInfo[])this._dispatcher.dispatch(new RPRequest(this, "getDiskManagerFileInfo", null)).getResponse();
        int i = 0;
        while (i < resp.length) {
            ((RPObject)((Object)resp[i]))._setRemote(this._dispatcher);
            ++i;
        }
        return resp;
    }

    @Override
    public DiskManagerFileInfo getDiskManagerFileInfo(int index) {
        RPDiskManagerFileInfo[] resp = (RPDiskManagerFileInfo[])this._dispatcher.dispatch(new RPRequest(this, "getDiskManagerFileInfo", null)).getResponse();
        if (index >= 0 && index < resp.length) {
            resp[index]._setRemote(this._dispatcher);
            return resp[index];
        }
        return null;
    }

    @Override
    public int getDiskManagerFileCount() {
        this.notSupported();
        return 0;
    }

    @Override
    public long getCreationTime() {
        this.notSupported();
        return 0L;
    }

    @Override
    public Download.SeedingRank getSeedingRank() {
        this.notSupported();
        return null;
    }

    @Override
    public String getSavePath() {
        this.notSupported();
        return null;
    }

    @Override
    public void moveDataFiles(File new_parent_dir) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void moveDataFiles(File new_parent_dir, String new_name) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void moveTorrentFile(File new_parent_dir) {
        this.notSupported();
    }

    @Override
    public void requestTrackerAnnounce() {
        this._dispatcher.dispatch(new RPRequest(this, "requestTrackerAnnounce", null)).getResponse();
    }

    @Override
    public void requestTrackerAnnounce(boolean immediate) {
        this.notSupported();
    }

    @Override
    public void requestTrackerScrape(boolean immediate) {
        this.notSupported();
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult result) {
        this.notSupported();
    }

    @Override
    public void setScrapeResult(DownloadScrapeResult result) {
        this.notSupported();
    }

    @Override
    public DownloadActivationEvent getActivationState() {
        this.notSupported();
        return null;
    }

    @Override
    public void addActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    @Override
    public void removeActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    @Override
    public void setSeedingRank(Download.SeedingRank rank) {
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener l, boolean immediateTrigger) {
        this.notSupported();
    }

    @Override
    public void renameDownload(String new_name) {
        this.notSupported();
    }

    @Override
    public boolean getBooleanAttribute(TorrentAttribute ta) {
        this.notSupported();
        return false;
    }

    @Override
    public int getIntAttribute(TorrentAttribute ta) {
        this.notSupported();
        return 0;
    }

    @Override
    public long getLongAttribute(TorrentAttribute ta) {
        this.notSupported();
        return 0L;
    }

    @Override
    public boolean hasAttribute(TorrentAttribute ta) {
        this.notSupported();
        return false;
    }

    @Override
    public void setBooleanAttribute(TorrentAttribute ta, boolean value) {
        this.notSupported();
    }

    @Override
    public void setIntAttribute(TorrentAttribute ta, int value) {
        this.notSupported();
    }

    @Override
    public void setListAttribute(TorrentAttribute ta, String[] value) {
        this.notSupported();
    }

    @Override
    public void setLongAttribute(TorrentAttribute ta, long value) {
        this.notSupported();
    }

    @Override
    public void setFlag(long flag, boolean set) {
        this.notSupported();
    }

    @Override
    public void addAttributeListener(DownloadAttributeListener l, TorrentAttribute a, int e) {
        this.notSupported();
    }

    @Override
    public void removeAttributeListener(DownloadAttributeListener l, TorrentAttribute a, int e) {
        this.notSupported();
    }

    @Override
    public void addCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    @Override
    public void removeCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    @Override
    public boolean isRemoved() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean canMoveDataFiles() {
        this.notSupported();
        return false;
    }

    @Override
    public SaveLocationChange calculateDefaultDownloadLocation() {
        this.notSupported();
        return null;
    }

    @Override
    public Object getUserData(Object key) {
        this.notSupported();
        return null;
    }

    @Override
    public void setUserData(Object key, Object data) {
        this.notSupported();
    }

    @Override
    public void startDownload(boolean force) {
        this.notSupported();
    }

    @Override
    public void stopDownload() {
        this.notSupported();
    }

    @Override
    public void changeLocation(SaveLocationChange slc) {
        this.notSupported();
    }

    @Override
    public boolean isStub() {
        return false;
    }

    @Override
    public boolean canStubbify() {
        return false;
    }

    @Override
    public DownloadStub stubbify() throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadException("Not Supported");
    }

    @Override
    public Download destubbify() throws DownloadException {
        throw new DownloadException("Not Supported");
    }

    @Override
    public List<DistributedDatabase> getDistributedDatabases() {
        this.notSupported();
        return null;
    }

    @Override
    public byte[] getTorrentHash() {
        this.notSupported();
        return null;
    }

    @Override
    public long getTorrentSize() {
        this.notSupported();
        return 0L;
    }

    @Override
    public DownloadStub.DownloadStubFile[] getStubFiles() {
        this.notSupported();
        return null;
    }

    @Override
    public DiskManagerFileInfo getPrimaryFile() {
        return this.getDiskManagerFileInfo(0);
    }
}

