/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.xml.rss;

import com.biglybt.core.util.Debug;
import com.biglybt.pif.utils.xml.rss.RSSItem;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import com.biglybt.pifimpl.local.utils.xml.rss.RSSChannelImpl;
import com.biglybt.pifimpl.local.utils.xml.rss.RSSUtils;
import java.net.URL;
import java.util.Date;

public class RSSItemImpl
implements RSSItem {
    private final RSSChannelImpl channel;
    private final boolean is_atom;
    private final SimpleXMLParserDocumentNode node;

    protected RSSItemImpl(RSSChannelImpl _channel, SimpleXMLParserDocumentNode _node, boolean _is_atom) {
        this.channel = _channel;
        this.is_atom = _is_atom;
        this.node = _node;
    }

    @Override
    public String getTitle() {
        if (this.node.getChild("title") != null) {
            return this.node.getChild("title").getValue();
        }
        return null;
    }

    @Override
    public String getDescription() {
        if (this.node.getChild("description") != null) {
            return this.node.getChild("description").getValue();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URL getLink() {
        SimpleXMLParserDocumentNode link_node = this.node.getChild("link");
        if (link_node == null) return null;
        try {
            String value = "";
            if (this.is_atom) {
                SimpleXMLParserDocumentAttribute attr = link_node.getAttribute("href");
                if (attr == null) {
                    return null;
                }
                value = attr.getValue().trim();
            } else {
                value = link_node.getValue().trim();
            }
            if (value.length() == 0) {
                return null;
            }
            if (value.startsWith("//")) {
                value = String.valueOf(this.channel.isHTTPS() ? "https:" : "http:") + value;
                return new URL(value);
            }
            if (!value.startsWith("/")) return new URL(value);
            String base = this.channel.getLinkRaw();
            if (base.endsWith("/")) {
                value = String.valueOf(base) + value.substring(1);
                return new URL(value);
            }
            value = String.valueOf(base) + value;
            return new URL(value);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    @Override
    public Date getPublicationDate() {
        SimpleXMLParserDocumentNode pd = this.node.getChild(this.is_atom ? "published" : "pubdate");
        if (pd != null) {
            if (this.is_atom) {
                return RSSUtils.parseAtomDate(pd.getValue());
            }
            return RSSUtils.parseRSSDate(pd.getValue());
        }
        return null;
    }

    @Override
    public String getUID() {
        String value;
        SimpleXMLParserDocumentNode uid = this.node.getChild(this.is_atom ? "id" : "guid");
        if (uid != null && (value = uid.getValue().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    @Override
    public SimpleXMLParserDocumentNode getNode() {
        return this.node;
    }
}

