/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.resourcedownloader;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HTTPUtils;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadWillBeAddedListener;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderCancelledException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderListener;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import com.biglybt.plugin.I2PHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;

public class ResourceDownloaderTorrentImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    public static final int MAX_FOLLOWS = 1;
    protected ResourceDownloaderBaseImpl delegate;
    protected boolean persistent;
    protected File download_dir;
    protected long size = -2L;
    protected TOTorrent[] torrent_holder = new TOTorrent[1];
    protected DownloadManager download_manager;
    protected Download download;
    protected boolean cancelled;
    protected boolean completed;
    protected ResourceDownloader current_downloader;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTorrent");

    public ResourceDownloaderTorrentImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloader _delegate, boolean _persistent, File _download_dir) {
        super(_parent);
        this.persistent = _persistent;
        this.download_dir = _download_dir;
        this.delegate = (ResourceDownloaderBaseImpl)_delegate;
        this.delegate.setParent(this);
        this.download_manager = PluginInitializer.getDefaultInterface().getDownloadManager();
    }

    @Override
    public String getName() {
        return String.valueOf(this.delegate.getName()) + ": torrent";
    }

    @Override
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                this.size = this.getSizeSupport();
            }
            finally {
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
            }
        }
        return this.size;
    }

    @Override
    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    @Override
    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
        this.delegate.setProperty(name, value);
    }

    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            if (this.torrent_holder[0] == null) {
                ResourceDownloaderBaseImpl x = this.delegate.getClone(this);
                this.addReportListener(x);
                InputStream is = x.download();
                try {
                    this.torrent_holder[0] = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!this.torrent_holder[0].isSimpleTorrent()) {
                    throw new ResourceDownloaderException(this, "Only simple torrents supported");
                }
            }
            try {
                String file_str = new String(this.torrent_holder[0].getName());
                int pos = file_str.lastIndexOf(".");
                String file_type = pos != -1 ? file_str.substring(pos + 1) : null;
                this.setProperty("ContentType", HTTPUtils.guessContentTypeFromFileType(file_type));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            return this.torrent_holder[0].getSize();
        }
        catch (TOTorrentException e) {
            throw new ResourceDownloaderException(this, "Torrent deserialisation failed", e);
        }
    }

    protected void setSizeAndTorrent(long _size, TOTorrent[] _torrent_holder) {
        this.size = _size;
        this.torrent_holder = _torrent_holder;
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderTorrentImpl c = new ResourceDownloaderTorrentImpl(parent, this.delegate.getClone(this), this.persistent, this.download_dir);
        c.setSizeAndTorrent(this.size, this.torrent_holder);
        c.setProperties(this);
        return c;
    }

    @Override
    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    @Override
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else if (this.torrent_holder[0] == null) {
                this.current_downloader = this.delegate.getClone(this);
                this.informActivity(String.valueOf(this.getLogIndent()) + "Downloading: " + this.getName());
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            } else {
                this.downloadTorrent();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void downloadTorrent() {
        try {
            File data_dir;
            File torrent_file;
            String name = new String(this.torrent_holder[0].getName(), Constants.DEFAULT_ENCODING_CHARSET);
            this.informActivity(String.valueOf(this.getLogIndent()) + "Downloading: " + name);
            final TOTorrent torrent = this.torrent_holder[0];
            byte[] torrent_hash = torrent.getHash();
            Download existing = null;
            try {
                int existing_state;
                existing = this.download_manager.getDownload(torrent_hash);
                if (existing != null && ((existing_state = existing.getState()) == 8 || existing_state == 7)) {
                    this.informActivity(String.valueOf(this.getLogIndent()) + "Deleting existing stopped/error state download for " + name);
                    existing.remove(true, true);
                    existing = null;
                }
            }
            catch (Throwable e) {
                this.informActivity(String.valueOf(this.getLogIndent()) + "Failed to tidy up: " + Debug.getNestedExceptionMessage(e));
            }
            if (existing == null) {
                torrent_file = AETemporaryFileHandler.createSemiTempFile(String.valueOf(name) + ".torrent");
                if (this.download_dir != null && !this.download_dir.exists()) {
                    FileUtil.mkdirs(this.download_dir);
                }
                data_dir = this.download_dir == null ? torrent_file.getParentFile() : this.download_dir;
                TorrentUtils.setFlag(torrent, 1, true);
                boolean anon = this.isAnonymous();
                torrent.serialiseToBEncodedFile(torrent_file);
                DownloadWillBeAddedListener dwbal = null;
                try {
                    Object networks_to_set;
                    TorrentImpl t = new TorrentImpl(torrent);
                    if (anon) {
                        networks_to_set = AENetworkClassifier.AT_NON_PUBLIC;
                    } else {
                        Set<String> hosts = TorrentUtils.getUniqueTrackerHosts(torrent);
                        boolean has_i2p = false;
                        for (String host : hosts) {
                            if (AENetworkClassifier.categoriseAddress(host) != "I2P") continue;
                            has_i2p = true;
                        }
                        networks_to_set = has_i2p && I2PHelpers.isI2PInstalled() ? new String[]{"Public", "I2P", "Tor"} : null;
                    }
                    dwbal = new DownloadWillBeAddedListener((String[])networks_to_set){
                        private final /* synthetic */ String[] val$networks_to_set;
                        {
                            this.val$networks_to_set = stringArray;
                        }

                        @Override
                        public void initialised(Download download) {
                            try {
                                if (Arrays.equals(download.getTorrentHash(), torrent.getHash())) {
                                    com.biglybt.core.download.DownloadManager dm = PluginCoreUtils.unwrap(download);
                                    if (this.val$networks_to_set != null) {
                                        dm.getDownloadState().setNetworks(this.val$networks_to_set);
                                    }
                                    try {
                                        TagManager tm = TagManagerFactory.getTagManager();
                                        TagType tt = tm.getTagType(3);
                                        String tag_name = "tag.name.product.updates";
                                        Tag tag = tt.getTag(tag_name, false);
                                        if (tag == null) {
                                            tag = tt.createTag(tag_name, false);
                                            tag.setImageID("logo16");
                                            tt.addTag(tag);
                                        }
                                        tag.addTaggable(dm);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    };
                    this.download_manager.addDownloadWillBeAddedListener(dwbal);
                    this.download = this.persistent ? this.download_manager.addDownload(t, torrent_file, data_dir) : this.download_manager.addNonPersistentDownload(t, torrent_file, data_dir);
                }
                catch (Throwable throwable) {
                    if (dwbal != null) {
                        this.download_manager.removeDownloadWillBeAddedListener(dwbal);
                    }
                    throw throwable;
                }
                if (dwbal != null) {
                    this.download_manager.removeDownloadWillBeAddedListener(dwbal);
                }
            } else {
                this.download = existing;
                torrent_file = FileUtil.newFile(this.download.getTorrentFileName(), new String[0]);
                data_dir = FileUtil.newFile(this.download.getSavePath(), new String[0]).getParentFile();
            }
            this.download.moveTo(1);
            this.download.setForceStart(true);
            this.download.setFlag(4L, true);
            this.download.setFlag(16384L, true);
            if (COConfigurationManager.getBooleanParameter("Ip Filter Disable For Updates")) {
                this.download.setFlag(256L, true);
            }
            this.download_manager.addListener(new DownloadManagerListener(){

                @Override
                public void downloadAdded(Download download) {
                }

                @Override
                public void downloadRemoved(Download _download) {
                    if (ResourceDownloaderTorrentImpl.this.download == _download) {
                        ResourceDownloaderTorrentImpl.this.downloadRemoved(torrent_file, data_dir);
                    }
                }
            });
            this.download.addListener(new DownloadListener(){

                @Override
                public void stateChanged(final Download download, int old_state, int new_state) {
                    if (new_state == 5) {
                        download.removeListener(this);
                        PluginInitializer.getDefaultInterface().getUtilities().createThread("resource complete event dispatcher", new Runnable(){

                            @Override
                            public void run() {
                                ResourceDownloaderTorrentImpl.this.downloadSucceeded(download, torrent_file, data_dir);
                            }
                        });
                    }
                }

                @Override
                public void positionChanged(Download download, int oldPosition, int newPosition) {
                }
            });
            AEThread t = new AEThread("RDTorrent percentage checker"){

                @Override
                public void runSupport() {
                    int last_percentage = 0;
                    while (ResourceDownloaderTorrentImpl.this.result == null) {
                        int this_percentage = ResourceDownloaderTorrentImpl.this.download.getStats().getDownloadCompleted(false) / 10;
                        long total = torrent.getSize();
                        if (this_percentage != last_percentage) {
                            ResourceDownloaderTorrentImpl.this.reportPercentComplete(ResourceDownloaderTorrentImpl.this, this_percentage);
                            last_percentage = this_percentage;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            };
            t.setDaemon(true);
            t.start();
            int state = this.download.getState();
            if (state == 7) {
                this.download.start();
            } else if (state == 5) {
                this.downloadSucceeded(this.download, torrent_file, data_dir);
            }
        }
        catch (Throwable e) {
            this.failed(this, new ResourceDownloaderException(this, "Torrent download failed", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadSucceeded(Download download, File torrent_file, File data_dir) {
        ResourceDownloaderTorrentImpl resourceDownloaderTorrentImpl = this;
        synchronized (resourceDownloaderTorrentImpl) {
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.reportActivity("Torrent download complete");
        File target_file = FileUtil.newFile(data_dir, new String(this.torrent_holder[0].getFiles()[0].getPathComponents()[0]));
        if (!target_file.exists()) {
            File actual_target_file = FileUtil.newFile(download.getSavePath(), new String[0]);
            try {
                if (this.download_dir != null && actual_target_file.exists()) {
                    FileUtil.copyFile(actual_target_file, target_file);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            target_file = actual_target_file;
        }
        try {
            if (!target_file.exists()) {
                throw new Exception("File '" + target_file.toString() + "' not found");
            }
            FileInputStream data = FileUtil.newFileInputStream(target_file);
            this.informComplete(data);
            this.result = data;
            this.done_sem.release();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.failed(this, new ResourceDownloaderException(this, "Failed to read downloaded torrent data: " + e.getMessage(), e));
        }
    }

    protected void downloadRemoved(File torrent_file, File data_dir) {
        this.reportActivity("Torrent removed");
        if (!(this.result instanceof InputStream)) {
            this.failed(this, new ResourceDownloaderException(this, "Download did not complete"));
        }
    }

    @Override
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderCancelledException(this);
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean completed(ResourceDownloader downloader, InputStream data) {
        block12: {
            try {
                try {
                    this.torrent_holder[0] = TOTorrentFactory.deserialiseFromBEncodedInputStream(data);
                    if (this.torrent_holder[0].isSimpleTorrent()) {
                        this.downloadTorrent();
                        break block12;
                    }
                    this.failed(this, new ResourceDownloaderException(this, "Only simple torrents supported"));
                }
                catch (TOTorrentException e) {
                    this.failed(downloader, new ResourceDownloaderException(this, "Torrent deserialisation failed", e));
                    try {
                        data.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    data.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.done_sem.release();
        this.informFailed(e);
    }

    @Override
    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
        if (downloader == this) {
            this.informPercentDone(percentage);
        }
    }
}

