/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.resourcedownloader;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderDelayedFactory;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderAlternateImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderDelayedImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFileImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderMetaRefreshImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderRetryImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderTimeoutImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderTorrentImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderURLImpl;
import java.io.File;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class ResourceDownloaderFactoryImpl
implements ResourceDownloaderFactory {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static ResourceDownloaderFactoryImpl singleton = new ResourceDownloaderFactoryImpl();

    public static ResourceDownloaderFactory getSingleton() {
        return singleton;
    }

    @Override
    public ResourceDownloader create(File file) {
        return new ResourceDownloaderFileImpl(null, file);
    }

    @Override
    public ResourceDownloader create(URL url) {
        if (url.getProtocol().equalsIgnoreCase("file")) {
            try {
                return new ResourceDownloaderFileImpl(null, FileUtil.newFile(new URI(url.toString())));
            }
            catch (Throwable e) {
                return new ResourceDownloaderURLImpl(null, url);
            }
        }
        return new ResourceDownloaderURLImpl(null, url);
    }

    @Override
    public ResourceDownloader createWithAutoPluginProxy(URL url, Map<String, Object> options) {
        ResourceDownloader rd = this.create(url);
        if (rd instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)rd).setAutoPluginProxy(options);
        }
        return rd;
    }

    @Override
    public ResourceDownloader create(URL url, boolean force_no_proxy) {
        ResourceDownloader rd = this.create(url);
        if (force_no_proxy && rd instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)rd).setForceNoProxy(force_no_proxy);
        }
        return rd;
    }

    @Override
    public ResourceDownloader create(URL url, Proxy proxy) {
        ResourceDownloader rd = this.create(url);
        if (proxy != null && rd instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)rd).setForceProxy(proxy);
        }
        return rd;
    }

    @Override
    public ResourceDownloader create(URL url, String postData) {
        return new ResourceDownloaderURLImpl(null, url, postData.getBytes(), false, null, null);
    }

    @Override
    public ResourceDownloader create(URL url, String postData, Proxy proxy) {
        ResourceDownloader rd = this.create(url, postData);
        if (proxy != null && rd instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)rd).setForceProxy(proxy);
        }
        return rd;
    }

    @Override
    public ResourceDownloader create(URL url, byte[] postData) {
        return new ResourceDownloaderURLImpl(null, url, postData, false, null, null);
    }

    @Override
    public ResourceDownloader create(URL url, String user_name, String password) {
        return new ResourceDownloaderURLImpl(null, url, user_name, password);
    }

    @Override
    public ResourceDownloader create(ResourceDownloaderDelayedFactory factory) {
        return new ResourceDownloaderDelayedImpl(null, factory);
    }

    @Override
    public ResourceDownloader getRetryDownloader(ResourceDownloader downloader, int retry_count) {
        ResourceDownloaderRetryImpl res = new ResourceDownloaderRetryImpl(null, downloader, retry_count);
        return res;
    }

    @Override
    public ResourceDownloader getTimeoutDownloader(ResourceDownloader downloader, int timeout_millis) {
        ResourceDownloaderTimeoutImpl res = new ResourceDownloaderTimeoutImpl(null, downloader, timeout_millis);
        return res;
    }

    @Override
    public ResourceDownloader getAlternateDownloader(ResourceDownloader[] downloaders) {
        return this.getAlternateDownloader(downloaders, -1, false);
    }

    @Override
    public ResourceDownloader getAlternateDownloader(ResourceDownloader[] downloaders, int max_to_try) {
        return this.getAlternateDownloader(downloaders, max_to_try, false);
    }

    @Override
    public ResourceDownloader getRandomDownloader(ResourceDownloader[] downloaders) {
        return this.getAlternateDownloader(downloaders, -1, true);
    }

    @Override
    public ResourceDownloader getRandomDownloader(ResourceDownloader[] downloaders, int max_to_try) {
        return this.getAlternateDownloader(downloaders, max_to_try, true);
    }

    protected ResourceDownloader getAlternateDownloader(ResourceDownloader[] downloaders, int max_to_try, boolean random) {
        ResourceDownloaderAlternateImpl res = new ResourceDownloaderAlternateImpl(null, downloaders, max_to_try, random);
        boolean anon = false;
        for (ResourceDownloaderBaseImpl kid : res.getChildren()) {
            if (!kid.isAnonymous()) continue;
            anon = true;
        }
        if (anon) {
            try {
                res.setPropertyRecursive("Anonymous", true);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return res;
    }

    @Override
    public ResourceDownloader getMetaRefreshDownloader(ResourceDownloader downloader) {
        ResourceDownloaderMetaRefreshImpl res = new ResourceDownloaderMetaRefreshImpl(null, downloader);
        return res;
    }

    @Override
    public ResourceDownloader getTorrentDownloader(ResourceDownloader downloader, boolean persistent) {
        return this.getTorrentDownloader(downloader, persistent, null);
    }

    @Override
    public ResourceDownloader getTorrentDownloader(ResourceDownloader downloader, boolean persistent, File download_directory) {
        return new ResourceDownloaderTorrentImpl(null, downloader, persistent, download_directory);
    }

    @Override
    public ResourceDownloader getSuffixBasedDownloader(ResourceDownloader _downloader) {
        ResourceDownloader result;
        ResourceDownloaderBaseImpl dl = (ResourceDownloaderBaseImpl)_downloader;
        URL target = null;
        while (true) {
            List<ResourceDownloaderBaseImpl> kids;
            if ((kids = dl.getChildren()).size() == 0) break;
            dl = kids.get(0);
        }
        target = ((ResourceDownloaderURLImpl)dl).getURL();
        if (target == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "ResourceDownloader: suffix based downloader failed to find leaf"));
            }
            result = _downloader;
        } else {
            result = target.getPath().toLowerCase().endsWith(".torrent") ? this.getTorrentDownloader(_downloader, true) : _downloader;
        }
        if (COConfigurationManager.getBooleanParameter("update.anonymous")) {
            try {
                ((ResourceDownloaderBaseImpl)result).setPropertyRecursive("Anonymous", true);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return result;
    }
}

