/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.resourcedownloader;

import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderCancelledException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderListener;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class ResourceDownloaderAlternateImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    protected ResourceDownloader[] delegates;
    protected int max_to_try;
    protected boolean random;
    protected boolean cancelled;
    protected ResourceDownloader current_downloader;
    protected int current_index;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDAlternate");
    protected long size = -2L;

    public ResourceDownloaderAlternateImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloader[] _delegates, int _max_to_try, boolean _random) {
        super(_parent);
        this.delegates = _delegates;
        this.max_to_try = _max_to_try;
        this.random = _random;
        int i = 0;
        while (i < this.delegates.length) {
            ((ResourceDownloaderBaseImpl)this.delegates[i]).setParent(this);
            ++i;
        }
        this.max_to_try = this.max_to_try < 0 ? this.delegates.length : Math.min(this.max_to_try, this.delegates.length);
        if (this.random) {
            ArrayList<ResourceDownloader> l = new ArrayList<ResourceDownloader>(Arrays.asList(this.delegates));
            this.delegates = new ResourceDownloader[this.delegates.length];
            int i2 = 0;
            while (i2 < this.delegates.length) {
                this.delegates[i2] = (ResourceDownloader)l.remove((int)(Math.random() * (double)l.size()));
                ++i2;
            }
        }
    }

    @Override
    public String getName() {
        String res = "[";
        int i = 0;
        while (i < this.delegates.length) {
            res = String.valueOf(res) + (i == 0 ? "" : ",") + this.delegates[i].getName();
            ++i;
        }
        return String.valueOf(res) + "]";
    }

    @Override
    public long getSize() throws ResourceDownloaderException {
        if (this.delegates.length == 0) {
            ResourceDownloaderException error = new ResourceDownloaderException(this, "Alternate download fails - 0 alteratives");
            this.informFailed(error);
            throw error;
        }
        if (this.size != -2L) {
            return this.size;
        }
        try {
            int i = 0;
            while (i < this.max_to_try) {
                try {
                    ResourceDownloaderBaseImpl c = ((ResourceDownloaderBaseImpl)this.delegates[i]).getClone(this);
                    this.addReportListener(c);
                    this.size = c.getSize();
                    this.setProperties(c);
                    break;
                }
                catch (ResourceDownloaderException e) {
                    if (i == this.delegates.length - 1) {
                        throw e;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (this.size == -2L) {
                this.size = -1L;
            }
            this.setSize(this.size);
        }
        return this.size;
    }

    @Override
    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            int i = 0;
            while (i < this.delegates.length) {
                ((ResourceDownloaderBaseImpl)this.delegates[i]).setSize(this.size);
                ++i;
            }
        }
    }

    @Override
    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
        int i = 0;
        while (i < this.delegates.length) {
            ((ResourceDownloaderBaseImpl)this.delegates[i]).setProperty(name, value);
            ++i;
        }
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloader[] clones = new ResourceDownloader[this.delegates.length];
        int i = 0;
        while (i < this.delegates.length) {
            clones[i] = ((ResourceDownloaderBaseImpl)this.delegates[i]).getClone(this);
            ++i;
        }
        ResourceDownloaderAlternateImpl c = new ResourceDownloaderAlternateImpl(parent, clones, this.max_to_try, this.random);
        c.setSize(this.size);
        c.setProperties(this);
        return c;
    }

    @Override
    public InputStream download() throws ResourceDownloaderException {
        if (this.delegates.length == 0) {
            ResourceDownloaderException error = new ResourceDownloaderException(this, "Alternate download fails - 0 alteratives");
            this.informFailed(error);
            throw error;
        }
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    @Override
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.current_index == this.max_to_try || this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else {
                this.current_downloader = ((ResourceDownloaderBaseImpl)this.delegates[this.current_index]).getClone(this);
                this.informActivity(String.valueOf(this.getLogIndent()) + "Downloading: " + this.getName());
                ++this.current_index;
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderCancelledException(this);
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean completed(ResourceDownloader downloader, InputStream data) {
        if (this.informComplete(data)) {
            this.result = data;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    @Override
    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.informActivity(String.valueOf(this.getLogIndent()) + "  failed: " + Debug.getNestedExceptionMessage(e));
        this.asyncDownload();
    }
}

