/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.config.ConfigParameterListener;
import com.biglybt.pif.ui.config.EnablerParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pif.ui.config.ParameterWithSuffix;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterImplListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public abstract class ParameterImpl
implements EnablerParameter,
ParameterListener {
    protected final String configKey;
    private String labelKey;
    private String label;
    private int mode = 0;
    private Boolean enabled = null;
    private boolean visible = true;
    private boolean generate_intermediate_events = false;
    private List<Parameter> toDisable;
    private List<Parameter> toEnable;
    private List change_listeners;
    private List<ParameterImplListener> impl_listeners;
    private List<ParameterValidator> validator_listeners = new ArrayList<ParameterValidator>();
    private ParameterGroupImpl parameter_group;
    private int indent;
    private boolean fancyIndent;
    private String refID;
    private String[] allowedUiTypes;

    public ParameterImpl(String coreConfigKey, String _labelKey) {
        this.configKey = coreConfigKey;
        this.labelKey = _labelKey;
        if ("_blank".equals(this.labelKey)) {
            this.labelKey = "!!";
        }
    }

    @Deprecated
    public String getKey() {
        return this.configKey;
    }

    @Override
    public void addDisabledOnSelection(Parameter parameter) {
        if (this.toDisable == null) {
            this.toDisable = new ArrayList<Parameter>(1);
        }
        if (parameter instanceof ParameterGroupImpl) {
            ParameterImpl[] parameters;
            ParameterImpl[] parameterImplArray = parameters = ((ParameterGroupImpl)parameter).getParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterImpl p = parameterImplArray[n2];
                this.addDisabledOnSelection((Parameter)p);
                ++n2;
            }
        }
        this.toDisable.add(parameter);
    }

    @Override
    public void addDisabledOnSelection(Parameter ... parameters) {
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            this.addDisabledOnSelection(parameter);
            ++n2;
        }
    }

    @Override
    public void addEnabledOnSelection(Parameter paramToEnable) {
        if (this.toEnable == null) {
            this.toEnable = new ArrayList<Parameter>(1);
        }
        if (paramToEnable instanceof ParameterGroupImpl) {
            ParameterImpl[] parameters;
            ParameterImpl[] parameterImplArray = parameters = ((ParameterGroupImpl)paramToEnable).getParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterImpl p = parameterImplArray[n2];
                this.addEnabledOnSelection((Parameter)p);
                ++n2;
            }
        }
        this.toEnable.add(paramToEnable);
    }

    @Override
    public void addEnabledOnSelection(Parameter ... parameters) {
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            this.addEnabledOnSelection(parameter);
            ++n2;
        }
    }

    public List<Parameter> getDisabledOnSelectionParameters() {
        return this.toDisable == null ? Collections.emptyList() : this.toDisable;
    }

    public List<Parameter> getEnabledOnSelectionParameters() {
        return this.toEnable == null ? Collections.emptyList() : this.toEnable;
    }

    @Override
    public void parameterChanged(String key) {
        this.fireParameterChanged();
    }

    public void fireParameterChanged() {
        if (this.change_listeners == null) {
            return;
        }
        Object[] listenerArray = this.change_listeners.toArray();
        int i = 0;
        while (i < listenerArray.length) {
            try {
                Object o = listenerArray[i];
                if (o instanceof com.biglybt.pif.ui.config.ParameterListener) {
                    ((com.biglybt.pif.ui.config.ParameterListener)o).parameterChanged(this);
                } else {
                    ((ConfigParameterListener)o).configParameterChanged(this);
                }
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    @Override
    public void setEnabled(boolean e) {
        if (this.enabled != null && this.enabled == e) {
            return;
        }
        this.enabled = e;
        if (this.impl_listeners == null) {
            return;
        }
        Object[] listenersArray = this.impl_listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            try {
                ParameterImplListener l = (ParameterImplListener)listenersArray[i];
                l.enabledChanged(this);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled == null ? true : this.enabled;
    }

    @Override
    public int getMinimumRequiredUserMode() {
        return this.mode;
    }

    @Override
    public void setMinimumRequiredUserMode(int _mode) {
        this.mode = _mode;
    }

    @Override
    public void setVisible(boolean _visible) {
        this.visible = _visible;
        this.refreshControl();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setGenerateIntermediateEvents(boolean b) {
        this.generate_intermediate_events = b;
    }

    @Override
    public boolean getGenerateIntermediateEvents() {
        return this.generate_intermediate_events;
    }

    public void setGroup(ParameterGroupImpl _group) {
        this.parameter_group = _group;
    }

    public ParameterGroupImpl getGroup() {
        return this.parameter_group;
    }

    @Override
    public void addListener(com.biglybt.pif.ui.config.ParameterListener l) {
        if (this.change_listeners == null) {
            this.change_listeners = new ArrayList(1);
        }
        this.change_listeners.add(l);
        if (this.configKey != null && this.change_listeners.size() == 1) {
            COConfigurationManager.addWeakParameterListener(this, false, this.configKey);
        }
    }

    @Override
    public void addAndFireListener(com.biglybt.pif.ui.config.ParameterListener l) {
        this.addListener(l);
        l.parameterChanged(this);
    }

    @Override
    public void removeListener(com.biglybt.pif.ui.config.ParameterListener l) {
        if (this.change_listeners == null) {
            return;
        }
        this.change_listeners.remove(l);
        if (this.configKey != null && this.change_listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.configKey, this);
        }
    }

    public void addImplListener(ParameterImplListener l) {
        if (this.impl_listeners == null) {
            this.impl_listeners = new ArrayList<ParameterImplListener>(1);
        }
        this.impl_listeners.add(l);
    }

    public void removeImplListener(ParameterImplListener l) {
        if (this.impl_listeners == null) {
            return;
        }
        this.impl_listeners.remove(l);
    }

    @Override
    public void addConfigParameterListener(ConfigParameterListener l) {
        if (this.change_listeners == null) {
            this.change_listeners = new ArrayList(1);
        }
        this.change_listeners.add(l);
        if (this.configKey != null && this.change_listeners.size() == 1) {
            COConfigurationManager.addWeakParameterListener(this, false, this.configKey);
        }
    }

    @Override
    public void removeConfigParameterListener(ConfigParameterListener l) {
        if (this.change_listeners == null) {
            return;
        }
        this.change_listeners.remove(l);
        if (this.configKey != null && this.change_listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.configKey, this);
        }
    }

    @Override
    public void addValidator(ParameterValidator validator) {
        this.validator_listeners.add(validator);
    }

    public ParameterValidator.ValidationInfo validate(Object newValue) {
        ParameterValidator[] validators;
        ParameterValidator.ValidationInfo resultValidation = new ParameterValidator.ValidationInfo(true);
        ParameterValidator[] parameterValidatorArray = validators = this.validator_listeners.toArray(new ParameterValidator[0]);
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterValidator validator = parameterValidatorArray[n2];
            ParameterValidator.ValidationInfo validationInfo = validator.isValidParameterValue(this, newValue);
            if (validationInfo != null) {
                if (!validationInfo.valid) {
                    resultValidation = validationInfo;
                    break;
                }
                if (validationInfo.info != null) {
                    resultValidation.info = resultValidation.info == null ? validationInfo.info : String.valueOf(resultValidation.info) + "\n" + validationInfo.info;
                }
            }
            ++n2;
        }
        return resultValidation;
    }

    @Override
    public String getLabelText() {
        if (this.label == null && this.labelKey != null) {
            this.label = MessageText.getString(this.labelKey);
        }
        return this.label;
    }

    @Override
    public void setLabelText(String sText) {
        this.labelKey = null;
        this.label = sText;
        this.triggerLabelChanged(sText, false);
    }

    @Override
    public String getLabelKey() {
        return this.labelKey == null ? (this.label == null ? null : "!" + this.label + "!") : this.labelKey;
    }

    @Override
    public void setLabelKey(String sLabelKey) {
        this.labelKey = sLabelKey;
        this.label = null;
        this.triggerLabelChanged(this.labelKey, true);
    }

    @Override
    public final String getConfigKeyName() {
        return this.configKey;
    }

    @Override
    public boolean hasBeenSet() {
        return this.configKey != null && COConfigurationManager.doesParameterNonDefaultExist(this.configKey);
    }

    private void triggerLabelChanged(String text, boolean isKey) {
        if (this.impl_listeners == null) {
            return;
        }
        Object[] listenersArray = this.impl_listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            try {
                ParameterImplListener l = (ParameterImplListener)listenersArray[i];
                l.labelChanged(this, text, isKey);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    public void refreshControl() {
        if (this.impl_listeners == null) {
            return;
        }
        Object[] listenersArray = this.impl_listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            try {
                ParameterImplListener l = (ParameterImplListener)listenersArray[i];
                l.refreshControl(this);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    public void destroy() {
        this.change_listeners = null;
        this.impl_listeners = null;
        this.toDisable = null;
        this.toEnable = null;
        if (this.configKey != null) {
            COConfigurationManager.removeParameterListener(this.configKey, this);
        }
    }

    @Override
    public void setIndent(int indent, boolean fancy) {
        this.indent = indent;
        this.fancyIndent = fancy;
    }

    public int getIndent() {
        return this.indent;
    }

    public boolean isIndentFancy() {
        return this.fancyIndent;
    }

    public void setReferenceID(String refID) {
        this.refID = refID;
    }

    public String getReferenceID() {
        return this.refID;
    }

    @Override
    public void setAllowedUiTypes(String ... uiTypes) {
        if (uiTypes != null) {
            Arrays.sort(uiTypes);
        }
        this.allowedUiTypes = uiTypes;
    }

    @Override
    public boolean isForUIType(String uiType) {
        if (this.allowedUiTypes == null) {
            return true;
        }
        return Arrays.binarySearch(this.allowedUiTypes, uiType) >= 0;
    }

    @Override
    public boolean resetToDefault() {
        if (this.configKey == null) {
            return false;
        }
        return COConfigurationManager.removeParameter(this.configKey);
    }

    @Override
    public Object getValueObject() {
        if (this.configKey == null) {
            return null;
        }
        return COConfigurationManager.getParameter(this.configKey);
    }

    public boolean search(Pattern regex) {
        String suffix;
        String suffixLabelKey;
        if (this.configKey != null && regex.matcher(this.configKey).find()) {
            return true;
        }
        String labelText = this.getLabelText();
        if (labelText != null && regex.matcher(labelText).find()) {
            return true;
        }
        return this instanceof ParameterWithSuffix && (suffixLabelKey = ((ParameterWithSuffix)((Object)this)).getSuffixLabelKey()) != null && !suffixLabelKey.isEmpty() && regex.matcher(suffix = MessageText.getString(suffixLabelKey)).find();
    }
}

