/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;

public class IntParameterImpl
extends ParameterImpl
implements IntParameter {
    private boolean limited = false;
    private int min_value;
    private int max_value = Integer.MAX_VALUE;
    private boolean storedAsString;
    private int valueWhenBlank;
    private String suffixLabelKey;

    public IntParameterImpl(String configKey, String labelKey) {
        super(configKey, labelKey);
    }

    public IntParameterImpl(String configKey, String labelKey, int min_value, int max_value) {
        this(configKey, labelKey);
        this.min_value = min_value;
        this.max_value = max_value;
        this.limited = true;
    }

    @Override
    public int getValue() {
        if (!this.storedAsString) {
            return COConfigurationManager.getIntParameter(this.configKey);
        }
        String valFromConfig = COConfigurationManager.getStringParameter(this.configKey);
        int val = this.valueWhenBlank;
        try {
            if (!valFromConfig.isEmpty()) {
                val = Integer.parseInt(valFromConfig);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    @Override
    public Object getValueObject() {
        return this.getValue();
    }

    @Override
    public void setValue(int value) {
        if (!this.storedAsString) {
            COConfigurationManager.setParameter(this.configKey, value);
        } else {
            COConfigurationManager.setParameter(this.configKey, "" + value);
        }
    }

    @Override
    public boolean isLimited() {
        return this.limited;
    }

    @Override
    public int getMinValue() {
        return this.min_value;
    }

    @Override
    public int getMaxValue() {
        return this.max_value;
    }

    @Override
    public void setMinValue(int min_value) {
        this.limited = true;
        this.min_value = min_value;
        this.refreshControl();
    }

    @Override
    public void setMaxValue(int max_value) {
        this.limited = true;
        this.max_value = max_value;
        this.refreshControl();
    }

    @Override
    public void addIntegerValidator(ParameterValidator<Integer> validator) {
        super.addValidator(validator);
    }

    public boolean isStoredAsString() {
        return this.storedAsString;
    }

    public void setStoredAsString(boolean storedAsString, int valueWhenBlank) {
        this.storedAsString = storedAsString;
        this.valueWhenBlank = valueWhenBlank;
    }

    public int getValueWhenBlank() {
        return this.valueWhenBlank;
    }

    @Override
    public String getSuffixLabelKey() {
        return this.suffixLabelKey;
    }

    @Override
    public void setSuffixLabelKey(String suffixLabelKey) {
        this.suffixLabelKey = suffixLabelKey;
        this.refreshControl();
    }

    @Override
    public void setSuffixLabelText(String text) {
        this.suffixLabelKey = "!" + text + "!";
        this.refreshControl();
    }
}

