/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.tracker;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.tracker.util.TRTrackerUtils;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AsyncController;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HTTPUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pifimpl.local.tracker.TrackerTorrentImpl;
import com.biglybt.pifimpl.local.tracker.TrackerWebPageRequestImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class TrackerWebPageResponseImpl
implements TrackerWebPageResponse {
    private static final String NL = "\r\n";
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private boolean baos_set = false;
    private String content_type = "text/html";
    private int reply_status = 200;
    private Map<String, Object> header_map = new LinkedHashMap<String, Object>();
    private TrackerWebPageRequestImpl request;
    private boolean raw_output;
    private boolean is_async;
    private int explicit_gzip = 0;
    private boolean is_gzipped;

    protected TrackerWebPageResponseImpl(TrackerWebPageRequestImpl _request) {
        this.request = _request;
        String formatted_date_now = TimeFormatter.getHTTPDate(SystemTime.getCurrentTime());
        this.setHeader("Last-Modified", formatted_date_now);
        this.setHeader("Expires", formatted_date_now);
    }

    @Override
    public void setLastModified(long time) {
        String formatted_date = TimeFormatter.getHTTPDate(time);
        this.setHeader("Last-Modified", formatted_date);
    }

    @Override
    public void setExpires(long time) {
        String formatted_date = TimeFormatter.getHTTPDate(time);
        this.setHeader("Expires", formatted_date);
    }

    @Override
    public void setContentType(String type) {
        this.content_type = type;
    }

    @Override
    public String getContentType() {
        return this.content_type;
    }

    @Override
    public void setReplyStatus(int status) {
        this.reply_status = status;
    }

    @Override
    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase("set-cookie")) {
            for (String key : this.header_map.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                Object existing = this.header_map.get(key);
                if (existing instanceof String) {
                    String old = (String)existing;
                    ArrayList<String> l = new ArrayList<String>(3);
                    l.add(old);
                    l.add(value);
                    this.header_map.put(name, l);
                } else {
                    List l = (List)existing;
                    if (!l.contains(value)) {
                        l.add(value);
                    }
                }
                return;
            }
            this.header_map.put(name, value);
        } else {
            this.addHeader(name, value, true);
        }
    }

    @Override
    public void setGZIP(boolean gzip) {
        this.explicit_gzip = gzip ? 1 : 2;
    }

    protected String addHeader(String name, String value, boolean replace) {
        Iterator<String> it = this.header_map.keySet().iterator();
        while (it.hasNext()) {
            List l;
            String key = it.next();
            if (!key.equalsIgnoreCase(name)) continue;
            if (replace) {
                it.remove();
                continue;
            }
            Object existing = this.header_map.get(key);
            if (existing instanceof String) {
                return (String)existing;
            }
            if (existing instanceof List && (l = (List)existing).size() > 0) {
                return (String)l.get(0);
            }
            return null;
        }
        this.header_map.put(name, value);
        return value;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.baos;
    }

    @Override
    public void setOutputStream(ByteArrayOutputStream _baos) {
        this.baos = _baos;
        this.baos_set = true;
    }

    @Override
    public OutputStream getRawOutputStream() throws IOException {
        if (this.baos_set) {
            throw new IOException("OutputStream already set");
        }
        this.raw_output = true;
        return this.request.getOutputStream();
    }

    @Override
    public boolean isActive() {
        return this.request.isActive();
    }

    protected void complete() throws IOException {
        Map headers;
        String accept_encoding;
        if (this.is_async || this.raw_output) {
            return;
        }
        byte[] reply_bytes = this.baos.toByteArray();
        String status_string = "BAD";
        if (this.reply_status == 200) {
            status_string = "OK";
        } else if (this.reply_status == 204) {
            status_string = "No Content";
        } else if (this.reply_status == 206) {
            status_string = "Partial Content";
        } else if (this.reply_status == 401) {
            status_string = "Unauthorized";
        } else if (this.reply_status == 404) {
            status_string = "Not Found";
        } else if (this.reply_status == 501) {
            status_string = "Not Implemented";
        }
        String reply_header = "HTTP/1.1 " + this.reply_status + " " + status_string + NL;
        this.addHeader("Server", "BiglyBT 3.4.0.0", false);
        if (this.request.canKeepAlive()) {
            String applied_value = this.addHeader("Connection", "keep-alive", false);
            if (applied_value.equalsIgnoreCase("keep-alive")) {
                this.request.setKeepAlive(true);
            }
        } else {
            this.addHeader("Connection", "close", true);
        }
        this.addHeader("Content-Type", this.content_type, false);
        boolean do_gzip = false;
        if (this.explicit_gzip == 1 && !this.is_gzipped && HTTPUtils.canGZIP(accept_encoding = (String)(headers = this.request.getHeaders()).get("accept-encoding"))) {
            do_gzip = true;
            this.is_gzipped = true;
            this.header_map.put("Content-Encoding", "gzip");
        }
        for (String name : this.header_map.keySet()) {
            Object value = this.header_map.get(name);
            if (value instanceof String) {
                reply_header = String.valueOf(reply_header) + name + ": " + value + NL;
                continue;
            }
            List l = (List)value;
            for (String v : l) {
                reply_header = String.valueOf(reply_header) + name + ": " + v + NL;
            }
        }
        if (do_gzip) {
            if (reply_bytes.length < 524288) {
                ByteArrayOutputStream temp = new ByteArrayOutputStream(reply_bytes.length);
                GZIPOutputStream gzos = new GZIPOutputStream(temp);
                gzos.write(reply_bytes);
                gzos.close();
                reply_bytes = temp.toByteArray();
            } else {
                int read;
                File post_file = AETemporaryFileHandler.createTempFile();
                post_file.deleteOnExit();
                FileOutputStream fos = FileUtil.newFileOutputStream(post_file);
                GZIPOutputStream gzos = new GZIPOutputStream(fos);
                gzos.write(reply_bytes);
                gzos.close();
                FileInputStream fis = FileUtil.newFileInputStream(post_file);
                reply_header = String.valueOf(reply_header) + "Content-Length: " + post_file.length() + NL + NL;
                OutputStream os = this.request.getOutputStream();
                os.write(reply_header.getBytes());
                byte[] buffer = new byte[16384];
                while ((read = fis.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.flush();
                fis.close();
                post_file.delete();
                return;
            }
        }
        reply_header = String.valueOf(reply_header) + "Content-Length: " + reply_bytes.length + NL + NL;
        OutputStream os = this.request.getOutputStream();
        os.write(reply_header.getBytes());
        os.write(reply_bytes);
        os.flush();
    }

    @Override
    public boolean useFile(String root_dir, String relative_url) throws IOException {
        int paramPos = relative_url.indexOf(63);
        if (paramPos >= 0) {
            relative_url = relative_url.substring(0, paramPos);
        }
        String target = String.valueOf(root_dir) + relative_url.replace('/', File.separatorChar);
        File canonical_file = FileUtil.newFile(target, new String[0]).getCanonicalFile();
        File canonical_root = FileUtil.newFile(root_dir, new String[0]).getCanonicalFile();
        if (!canonical_file.toString().toLowerCase().startsWith(canonical_root.toString().toLowerCase())) {
            return false;
        }
        if (canonical_file.isDirectory()) {
            return false;
        }
        if (canonical_file.canRead()) {
            String str = canonical_file.toString().toLowerCase();
            int pos = str.lastIndexOf(".");
            if (pos == -1) {
                return false;
            }
            String file_type = str.substring(pos + 1);
            try (FileInputStream fis = null;){
                fis = FileUtil.newFileInputStream(canonical_file);
                this.useStream(file_type, fis);
                return true;
            }
        }
        return false;
    }

    @Override
    public void useStream(String file_type, InputStream input_stream) throws IOException {
        int len;
        Map headers;
        String accept_encoding;
        OutputStream os = this.getOutputStream();
        String response_type = HTTPUtils.guessContentTypeFromFileType(file_type);
        if (this.explicit_gzip != 2 && HTTPUtils.useCompressionForFileType(response_type) && HTTPUtils.canGZIP(accept_encoding = (String)(headers = this.request.getHeaders()).get("accept-encoding"))) {
            this.is_gzipped = true;
            os = new GZIPOutputStream(os);
            this.header_map.put("Content-Encoding", "gzip");
        }
        this.setContentType(response_type);
        byte[] buffer = new byte[4096];
        while ((len = input_stream.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        if (os instanceof GZIPOutputStream) {
            ((GZIPOutputStream)os).finish();
        }
    }

    @Override
    public void writeTorrent(TrackerTorrent tracker_torrent) throws IOException {
        try {
            TRHostTorrent host_torrent = ((TrackerTorrentImpl)tracker_torrent).getHostTorrent();
            TOTorrent torrent = host_torrent.getTorrent();
            TOTorrent torrent_to_send = TOTorrentFactory.deserialiseFromMap(torrent.serialiseToMap());
            torrent_to_send.removeAdditionalProperties();
            if (!TorrentUtils.isDecentralised(torrent_to_send)) {
                URL[][] url_sets = TRTrackerUtils.getAnnounceURLs();
                if (host_torrent.getStatus() != 3 && url_sets.length > 0 && COConfigurationManager.getBooleanParameter("Tracker Host Add Our Announce URLs")) {
                    String protocol = torrent_to_send.getAnnounceURL().getProtocol();
                    int i = 0;
                    while (i < url_sets.length) {
                        URL[] urls = url_sets[i];
                        if (urls[0].getProtocol().equalsIgnoreCase(protocol)) {
                            torrent_to_send.setAnnounceURL(urls[0]);
                            torrent_to_send.getAnnounceURLGroup().setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                            int j = 1;
                            while (j < urls.length) {
                                TorrentUtils.announceGroupsInsertLast(torrent_to_send, new URL[]{urls[j]});
                                ++j;
                            }
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.baos.write(BEncoder.encode(torrent_to_send.serialiseToMap()));
            this.setContentType("application/x-bittorrent");
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            throw new IOException(e.toString());
        }
    }

    @Override
    public void setAsynchronous(boolean a) throws IOException {
        AsyncController async_control = this.request.getAsyncController();
        if (async_control == null) {
            throw new IOException("Request is not non-blocking");
        }
        if (a) {
            this.is_async = true;
            async_control.setAsyncStart();
        } else {
            this.is_async = false;
            this.complete();
            async_control.setAsyncComplete();
        }
    }

    @Override
    public boolean getAsynchronous() {
        return this.is_async;
    }
}

