/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.tracker;

import com.biglybt.core.tracker.host.TRHostAuthenticationListener;
import com.biglybt.core.tracker.server.TRTrackerServerListener2;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.tracker.Tracker;
import com.biglybt.pif.tracker.web.TrackerWebContext;
import com.biglybt.pif.tracker.web.TrackerWebPageGenerator;
import com.biglybt.pifimpl.local.tracker.TrackerWebPageRequestImpl;
import com.biglybt.pifimpl.local.tracker.TrackerWebPageResponseImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class TrackerWCHelper
implements TrackerWebContext,
TRHostAuthenticationListener {
    private PluginInterface plugin_interface;
    private Tracker tracker;
    private List generators = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TrackerWCHelper");

    protected TrackerWCHelper() {
        this.plugin_interface = UtilitiesImpl.getPluginThreadContext();
    }

    protected void setTracker(Tracker _tracker) {
        this.tracker = _tracker;
    }

    public boolean handleExternalRequest(final TRTrackerServerListener2.ExternalRequest external_request) throws IOException {
        return UtilitiesImpl.callWithPluginThreadContext(this.plugin_interface, new UtilitiesImpl.runnableWithReturnAndException<Boolean, IOException>(){

            @Override
            public Boolean run() throws IOException {
                TrackerWebPageRequestImpl request2 = new TrackerWebPageRequestImpl(TrackerWCHelper.this.tracker, TrackerWCHelper.this, external_request);
                TrackerWebPageResponseImpl reply = new TrackerWebPageResponseImpl(request2);
                int i = 0;
                while (i < TrackerWCHelper.this.generators.size()) {
                    TrackerWebPageGenerator generator;
                    try {
                        TrackerWCHelper.this.this_mon.enter();
                        if (i >= TrackerWCHelper.this.generators.size()) break;
                        generator = (TrackerWebPageGenerator)TrackerWCHelper.this.generators.get(i);
                    }
                    finally {
                        TrackerWCHelper.this.this_mon.exit();
                    }
                    if (generator.generate(request2, reply)) {
                        reply.complete();
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
    }

    @Override
    public TrackerWebPageGenerator[] getPageGenerators() {
        TrackerWebPageGenerator[] res = new TrackerWebPageGenerator[this.generators.size()];
        this.generators.toArray(res);
        return res;
    }

    @Override
    public void addPageGenerator(TrackerWebPageGenerator generator) {
        try {
            this.this_mon.enter();
            this.generators.add(generator);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removePageGenerator(TrackerWebPageGenerator generator) {
        try {
            this.this_mon.enter();
            this.generators.remove(generator);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void destroy() {
        this.generators.clear();
    }
}

