/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.peers;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerListener;
import com.biglybt.core.peer.PEPeerManagerListenerAdapter;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.peerdb.PeerItem;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.disk.DiskManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerDescriptor;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerManagerEvent;
import com.biglybt.pif.peers.PeerManagerListener2;
import com.biglybt.pif.peers.PeerManagerStats;
import com.biglybt.pif.peers.PeerReadRequest;
import com.biglybt.pif.peers.PeerStats;
import com.biglybt.pif.peers.Piece;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.disk.DiskManagerImpl;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.pifimpl.local.peers.PeerForeignDelegate;
import com.biglybt.pifimpl.local.peers.PeerImpl;
import com.biglybt.pifimpl.local.peers.PeerManagerStatsImpl;
import com.biglybt.pifimpl.local.peers.PeerStatsImpl;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class PeerManagerImpl
implements PeerManager {
    private static final String PEPEER_DATA_KEY = PeerManagerImpl.class.getName();
    private static final AtomicLong PEPEER_DATA_KEY_AL = new AtomicLong();
    protected PEPeerManager manager;
    protected static AEMonitor pm_map_mon = new AEMonitor("PeerManager:Map");
    private Map<Peer, PeerForeignDelegate> foreign_map = new HashMap<Peer, PeerForeignDelegate>();
    private Map<PeerManagerListener2, CoreListener> listener_map2 = new HashMap<PeerManagerListener2, CoreListener>();
    protected AEMonitor this_mon = new AEMonitor("PeerManager");
    private final DiskManagerPiece[] dm_pieces;
    private final PEPiece[] pe_pieces;
    private pieceFacade[] piece_facades;
    private boolean destroyed;

    public static PeerManagerImpl getPeerManager(PEPeerManager _manager) {
        try {
            pm_map_mon.enter();
            PeerManagerImpl res = (PeerManagerImpl)_manager.getData("PluginPeerManager");
            if (res == null) {
                res = new PeerManagerImpl(_manager);
                _manager.setData("PluginPeerManager", res);
            }
            PeerManagerImpl peerManagerImpl = res;
            return peerManagerImpl;
        }
        finally {
            pm_map_mon.exit();
        }
    }

    protected PeerManagerImpl(PEPeerManager _manager) {
        this.manager = _manager;
        this.dm_pieces = _manager.getDiskManager().getPieces();
        this.pe_pieces = _manager.getPieces();
        this.manager.addListener(new PEPeerManagerListenerAdapter(){

            @Override
            public void peerRemoved(PEPeerManager manager, PEPeer peer) {
                PeerImpl dele = PeerManagerImpl.getPeerForPEPeer(peer);
                if (dele != null) {
                    dele.closed();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyed(PEPeerManager manager) {
                Map map = PeerManagerImpl.this.foreign_map;
                synchronized (map) {
                    PeerManagerImpl.this.destroyed = true;
                    Iterator it = PeerManagerImpl.this.foreign_map.values().iterator();
                    while (it.hasNext()) {
                        try {
                            ((PeerForeignDelegate)it.next()).stop();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        });
    }

    public PEPeerManager getDelegate() {
        return this.manager;
    }

    @Override
    public DiskManager getDiskManager() {
        return new DiskManagerImpl(this.manager.getDiskManager());
    }

    @Override
    public PeerManagerStats getStats() {
        return new PeerManagerStatsImpl(this.manager);
    }

    @Override
    public boolean isSeeding() {
        return this.manager.getDiskManager().getRemainingExcludingDND() == 0L;
    }

    @Override
    public boolean isSuperSeeding() {
        return this.manager.isSuperSeedMode();
    }

    @Override
    public Download getDownload() throws DownloadException {
        return DownloadManagerImpl.getDownloadStatic(this.manager.getDiskManager().getTorrent());
    }

    @Override
    public Piece[] getPieces() {
        if (this.piece_facades == null) {
            pieceFacade[] pf = new pieceFacade[this.manager.getDiskManager().getNbPieces()];
            int i = 0;
            while (i < pf.length) {
                pf[i] = new pieceFacade(i);
                ++i;
            }
            this.piece_facades = pf;
        }
        return this.piece_facades;
    }

    @Override
    public PeerStats createPeerStats(Peer peer) {
        PEPeer delegate = this.mapForeignPeer(peer);
        return new PeerStatsImpl(this, peer, this.manager.createPeerStats(delegate));
    }

    @Override
    public void requestComplete(PeerReadRequest request2, PooledByteBuffer data, Peer sender) {
        this.manager.writeBlock(request2.getPieceNumber(), request2.getOffset(), ((PooledByteBufferImpl)data).getBuffer(), this.mapForeignPeer(sender), false);
        PeerForeignDelegate delegate = this.lookupForeignPeer(sender);
        if (delegate != null) {
            delegate.dataReceived();
        }
    }

    @Override
    public void requestCancelled(PeerReadRequest request2, Peer sender) {
        this.manager.requestCanceled((DiskManagerReadRequest)request2);
    }

    protected int getPartitionID() {
        return this.manager.getPartitionID();
    }

    @Override
    public void addPeer(Peer peer) {
        this.manager.addPeer(this.mapForeignPeer(peer));
    }

    @Override
    public void removePeer(Peer peer, String reason, int reason_code) {
        this.manager.removePeer(this.mapForeignPeer(peer), reason, reason_code);
    }

    @Override
    public void addPeer(String ip_address, int tcp_port) {
        this.addPeer(ip_address, tcp_port, 0, NetworkManager.getCryptoRequired(0));
    }

    @Override
    public void addPeer(String ip_address, int tcp_port, boolean use_crypto) {
        this.addPeer(ip_address, tcp_port, 0, use_crypto);
    }

    @Override
    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        this.addPeer(ip_address, tcp_port, udp_port, use_crypto, (Map)null);
    }

    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto, Map user_data) {
        this.checkIfPrivate();
        if (this.pluginPeerSourceEnabled()) {
            try {
                this.manager.addPeer(ip_address, tcp_port, udp_port, use_crypto, user_data);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void peerDiscovered(String peer_source, String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        this.checkIfPrivate();
        if (this.manager.isPeerSourceEnabled(peer_source)) {
            this.manager.peerDiscovered(peer_source, ip_address, tcp_port, udp_port, use_crypto);
        }
    }

    protected boolean pluginPeerSourceEnabled() {
        if (this.manager.isPeerSourceEnabled("Plugin")) {
            return true;
        }
        Debug.out("Plugin peer source disabled for " + this.manager.getDisplayName());
        return false;
    }

    protected void checkIfPrivate() {
        Download dl;
        try {
            dl = this.getDownload();
        }
        catch (Throwable e) {
            return;
        }
        Torrent t = dl.getTorrent();
        if (t != null && TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(t))) {
            throw new RuntimeException("Torrent is private, peer addition not permitted");
        }
    }

    @Override
    public Peer[] getPeers() {
        List<PEPeer> l = this.manager.getPeers();
        Peer[] res = new Peer[l.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = PeerManagerImpl.getPeerForPEPeer(l.get(i));
            ++i;
        }
        return res;
    }

    @Override
    public Peer[] getPeers(String address) {
        List<PEPeer> l = this.manager.getPeers(address);
        Peer[] res = new Peer[l.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = PeerManagerImpl.getPeerForPEPeer(l.get(i));
            ++i;
        }
        return res;
    }

    @Override
    public PeerDescriptor[] getPendingPeers() {
        return this.manager.getPendingPeers();
    }

    @Override
    public PeerDescriptor[] getPendingPeers(String address) {
        return this.manager.getPendingPeers(address);
    }

    public long getTimeSinceConnectionEstablished(Peer peer) {
        PeerForeignDelegate delegate;
        long mono_time = peer instanceof PeerImpl ? ((PeerImpl)peer).getDelegate().getConnectionEstablishedMonoTime() : ((delegate = this.lookupForeignPeer(peer)) != null ? delegate.getConnectionEstablishedMonoTime() : -1L);
        if (mono_time < 0L) {
            return 0L;
        }
        return SystemTime.getMonotonousTime() - mono_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PEPeer mapForeignPeer(Peer _foreign) {
        if (_foreign instanceof PeerImpl) {
            return ((PeerImpl)_foreign).getDelegate();
        }
        Map<Peer, PeerForeignDelegate> map = this.foreign_map;
        synchronized (map) {
            PeerForeignDelegate local = this.foreign_map.get(_foreign);
            if (local != null && local.isClosed()) {
                this.foreign_map.remove(_foreign);
                local = null;
            }
            if (local == null) {
                if (this.destroyed) {
                    Debug.out("Peer added to destroyed peer manager");
                    return null;
                }
                local = new PeerForeignDelegate(this, _foreign);
                _foreign.setUserData(PeerManagerImpl.class, local);
                this.foreign_map.put(_foreign, local);
            }
            return local;
        }
    }

    protected PeerForeignDelegate lookupForeignPeer(Peer _foreign) {
        return (PeerForeignDelegate)_foreign.getUserData(PeerManagerImpl.class);
    }

    public List<PEPeer> mapForeignPeers(Peer[] _foreigns) {
        ArrayList<PEPeer> res = new ArrayList<PEPeer>();
        int i = 0;
        while (i < _foreigns.length) {
            PEPeer local = this.mapForeignPeer(_foreigns[i]);
            if (!res.contains(local)) {
                res.add(local);
            }
            ++i;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerImpl getPeerForPEPeer(PEPeer pe_peer) {
        String string = PEPEER_DATA_KEY;
        synchronized (string) {
            PeerImpl peer = (PeerImpl)pe_peer.getData(PEPEER_DATA_KEY);
            if (peer == null) {
                peer = new PeerImpl(pe_peer);
                pe_peer.setData(PEPEER_DATA_KEY, peer);
            }
            return peer;
        }
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.manager.getUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.manager.getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public void addListener(PeerManagerListener2 l) {
        try {
            this.this_mon.enter();
            CoreListener core_listener = new CoreListener(l);
            this.listener_map2.put(l, core_listener);
            this.manager.addListener(core_listener);
            this.manager.getDiskManager().addListener(core_listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(PeerManagerListener2 l) {
        try {
            this.this_mon.enter();
            CoreListener core_listener = this.listener_map2.remove(l);
            if (core_listener != null) {
                this.manager.removeListener(core_listener);
                this.manager.getDiskManager().removeListener(core_listener);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    static /* synthetic */ String access$2() {
        return PEPEER_DATA_KEY;
    }

    static /* synthetic */ AtomicLong access$3() {
        return PEPEER_DATA_KEY_AL;
    }

    private class CoreListener
    implements PEPeerManagerListener,
    DiskManagerListener {
        private final String CL_KEY = String.valueOf(PeerManagerImpl.access$2()) + "." + PeerManagerImpl.access$3().incrementAndGet();
        private PeerManagerListener2 listener;

        private CoreListener(PeerManagerListener2 _listener) {
            this.listener = _listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void peerAdded(PEPeerManager manager, PEPeer peer) {
            PeerImpl pi = PeerManagerImpl.getPeerForPEPeer(peer);
            boolean fire = false;
            String string = this.CL_KEY;
            synchronized (string) {
                if (peer.getUserData(this.CL_KEY) == null) {
                    peer.setUserData(this.CL_KEY, 1);
                    fire = true;
                }
            }
            if (fire) {
                this.fireEvent(1, pi, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void peerRemoved(PEPeerManager manager, PEPeer peer) {
            PeerImpl pi = PeerManagerImpl.getPeerForPEPeer(peer);
            boolean fire = false;
            String string = this.CL_KEY;
            synchronized (string) {
                Integer i = (Integer)peer.getUserData(this.CL_KEY);
                if (i != null && i == 1) {
                    peer.setUserData(this.CL_KEY, 2);
                    fire = true;
                }
            }
            if (fire) {
                this.fireEvent(2, pi, null, null);
            }
        }

        @Override
        public void peerDiscovered(PEPeerManager manager, PeerItem peer_item, PEPeer finder) {
            PeerImpl pi = finder != null ? PeerManagerImpl.getPeerForPEPeer(finder) : null;
            this.fireEvent(3, pi, peer_item, null);
        }

        @Override
        public void pieceAdded(PEPeerManager manager, PEPiece piece, PEPeer for_peer) {
            PeerImpl pi = for_peer == null ? null : PeerManagerImpl.getPeerForPEPeer(for_peer);
            this.fireEvent(5, pi, null, new pieceFacade(piece.getPieceNumber()));
        }

        @Override
        public void pieceRemoved(PEPeerManager manager, PEPiece piece) {
            this.fireEvent(6, null, null, new pieceFacade(piece.getPieceNumber()));
        }

        @Override
        public void requestAdded(PEPeerManager manager, PEPiece piece, PEPeer peer, PeerReadRequest request2) {
        }

        @Override
        public void peerSentBadData(PEPeerManager manager, PEPeer peer, int pieceNumber) {
            PeerImpl pi = PeerManagerImpl.getPeerForPEPeer(peer);
            this.fireEvent(4, pi, null, new Integer(pieceNumber));
        }

        @Override
        public void pieceCorrupted(PEPeerManager manager, int piece_number) {
        }

        @Override
        public void stateChanged(com.biglybt.core.disk.DiskManager dm, int oldState, int newState) {
        }

        @Override
        public void filePriorityChanged(com.biglybt.core.disk.DiskManager dm, DiskManagerFileInfo file) {
        }

        @Override
        public void pieceDoneChanged(com.biglybt.core.disk.DiskManager dm, DiskManagerPiece piece) {
            this.fireEvent(7, null, null, new pieceFacade(piece.getPieceNumber()));
        }

        protected void fireEvent(final int type, final Peer peer, final PeerItem peer_item, final Object data) {
            this.listener.eventOccurred(new PeerManagerEvent(){

                @Override
                public PeerManager getPeerManager() {
                    return PeerManagerImpl.this;
                }

                @Override
                public int getType() {
                    return type;
                }

                @Override
                public Peer getPeer() {
                    return peer;
                }

                @Override
                public PeerDescriptor getPeerDescriptor() {
                    return peer_item;
                }

                @Override
                public Object getData() {
                    return data;
                }
            });
        }

        @Override
        public void destroyed(PEPeerManager manager) {
        }
    }

    protected class pieceFacade
    implements Piece {
        private final int index;

        protected pieceFacade(int _index) {
            this.index = _index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getLength() {
            return PeerManagerImpl.this.dm_pieces[this.index].getLength();
        }

        @Override
        public boolean isDone() {
            return PeerManagerImpl.this.dm_pieces[this.index].isDone();
        }

        @Override
        public boolean isNeeded() {
            return PeerManagerImpl.this.dm_pieces[this.index].isNeeded();
        }

        @Override
        public boolean isDownloading() {
            return PeerManagerImpl.this.pe_pieces[this.index] != null;
        }

        @Override
        public boolean isFullyAllocatable() {
            if (PeerManagerImpl.this.pe_pieces[this.index] != null) {
                return false;
            }
            return PeerManagerImpl.this.dm_pieces[this.index].isInteresting();
        }

        @Override
        public int getAllocatableRequestCount() {
            PEPiece pe_piece = PeerManagerImpl.this.pe_pieces[this.index];
            if (pe_piece != null) {
                return pe_piece.getNbUnrequested();
            }
            if (PeerManagerImpl.this.dm_pieces[this.index].isInteresting()) {
                return PeerManagerImpl.this.dm_pieces[this.index].getNbBlocks();
            }
            return 0;
        }

        @Override
        public Peer getReservedFor() {
            List<PEPeer> peers;
            String ip;
            PEPiece piece = PeerManagerImpl.this.pe_pieces[this.index];
            if (piece != null && (ip = piece.getReservedBy()) != null && (peers = PeerManagerImpl.this.manager.getPeers(ip)).size() > 0) {
                return PeerManagerImpl.getPeerForPEPeer(peers.get(0));
            }
            return null;
        }

        @Override
        public void setReservedFor(Peer peer) {
            PEPiece piece = PeerManagerImpl.this.pe_pieces[this.index];
            PEPeer mapped_peer = PeerManagerImpl.this.mapForeignPeer(peer);
            if (piece != null && mapped_peer != null) {
                piece.setReservedBy(peer.getIp());
                mapped_peer.addReservedPieceNumber(this.index);
            }
        }
    }
}

