/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.peers;

import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.peer.PEPeerListener;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.impl.PEPeerControl;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peermanager.peerdb.PeerItem;
import com.biglybt.core.peermanager.peerdb.PeerItemFactory;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.torrent.TOTorrentFileHashTree;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.messaging.Message;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.ConnectionStub;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerEvent;
import com.biglybt.pif.peers.PeerListener2;
import com.biglybt.pif.peers.PeerReadRequest;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pifimpl.local.messaging.MessageAdapter;
import com.biglybt.pifimpl.local.peers.PeerForeignNetworkConnection;
import com.biglybt.pifimpl.local.peers.PeerManagerImpl;
import com.biglybt.pifimpl.local.peers.PeerStatsImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PeerForeignDelegate
implements PEPeerTransport {
    protected volatile int _lastPiece = -1;
    private final PeerManagerImpl manager;
    private final Peer foreign;
    private final NetworkConnectionBase network_connection;
    private long create_time_mono = SystemTime.getMonotonousTime();
    private long last_data_received_time = -1L;
    private long last_data_message_received_time = -1L;
    private int[] reserved_pieces = null;
    private int consecutive_no_requests;
    private BitFlags bit_flags;
    private boolean priority_connection;
    private Map data;
    private HashMap<PEPeerListener, PeerListener2> peer_listeners;
    protected AEMonitor this_mon = new AEMonitor("PeerForeignDelegate");
    private Set<Object> download_disabled_set;
    private boolean is_download_disabled;
    private volatile boolean closed;

    protected PeerForeignDelegate(PeerManagerImpl _manager, Peer _foreign) {
        this.manager = _manager;
        this.foreign = _foreign;
        PEPeerManager pm = this.manager.getDelegate();
        this.network_connection = new PeerForeignNetworkConnection(this, this.foreign);
        this.network_connection.addRateLimiter(pm.getUploadLimitedRateGroup(), true);
        this.network_connection.addRateLimiter(pm.getDownloadLimitedRateGroup(), false);
        _foreign.bindConnection(new ConnectionStub(){

            @Override
            public void addRateLimiter(RateLimiter limiter, boolean is_upload) {
                PeerForeignDelegate.this.network_connection.addRateLimiter(UtilitiesImpl.wrapLimiter(limiter, false), is_upload);
            }

            @Override
            public void removeRateLimiter(RateLimiter limiter, boolean is_upload) {
                PeerForeignDelegate.this.network_connection.removeRateLimiter(UtilitiesImpl.wrapLimiter(limiter, false), is_upload);
            }

            @Override
            public RateLimiter[] getRateLimiters(boolean is_upload) {
                LimitedRateGroup[] limiters = PeerForeignDelegate.this.network_connection.getRateLimiters(is_upload);
                RateLimiter[] result = new RateLimiter[limiters.length];
                int pos = 0;
                LimitedRateGroup[] limitedRateGroupArray = limiters;
                int n = limiters.length;
                int n2 = 0;
                while (n2 < n) {
                    LimitedRateGroup l = limitedRateGroupArray[n2];
                    if (l instanceof UtilitiesImpl.PluginLimitedRateGroup) {
                        result[pos++] = UtilitiesImpl.unwrapLmiter((UtilitiesImpl.PluginLimitedRateGroup)l);
                    }
                    ++n2;
                }
                if (pos == result.length) {
                    return result;
                }
                RateLimiter[] result_mod = new RateLimiter[pos];
                System.arraycopy(result, 0, result_mod, 0, pos);
                return result_mod;
            }
        });
    }

    @Override
    public boolean isMyPeer() {
        return false;
    }

    @Override
    public int getOutboundConnectionProgress() {
        return 0;
    }

    @Override
    public void start() {
        NetworkManager.getSingleton().startTransferProcessing(this.network_connection);
        NetworkManager.getSingleton().upgradeTransferProcessing(this.network_connection, this.manager.getPartitionID());
    }

    protected void stop() {
        NetworkManager.getSingleton().stopTransferProcessing(this.network_connection);
    }

    @Override
    public void sendChoke() {
    }

    @Override
    public void sendHave(int piece) {
    }

    @Override
    public void sendUnChoke() {
    }

    @Override
    public InetAddress getAlternativeIPv6() {
        return null;
    }

    @Override
    public boolean transferAvailable() {
        return this.foreign.isTransferAvailable();
    }

    @Override
    public boolean isDownloadPossible() {
        if (this.is_download_disabled) {
            return false;
        }
        return this.foreign.isDownloadPossible();
    }

    @Override
    public void sendCancel(DiskManagerReadRequest request2) {
        this.foreign.cancelRequest(request2);
    }

    @Override
    public DiskManagerReadRequest request(int pieceNumber, int pieceOffset, int pieceLength, boolean return_duplicates) {
        DiskManagerReadRequest request2 = this.manager.getDelegate().getDiskManager().createReadRequest(pieceNumber, pieceOffset, pieceLength);
        if (this.foreign.addRequest(request2)) {
            return request2;
        }
        return null;
    }

    @Override
    public int getRequestIndex(DiskManagerReadRequest request2) {
        return this.foreign.getRequests().indexOf(request2);
    }

    protected void dataReceived() {
        this.last_data_received_time = SystemTime.getCurrentTime();
    }

    @Override
    public void closeConnection(String reason, int reason_code) {
        this.closed = true;
        try {
            this.foreign.close(reason, reason_code, false, false);
        }
        finally {
            this.stop();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public List getExpiredRequests() {
        return this.foreign.getExpiredRequests();
    }

    @Override
    public long getLastMessageSentTimeMono() {
        return -1L;
    }

    @Override
    public int getMaxNbRequests() {
        return this.foreign.getMaximumNumberOfRequests();
    }

    @Override
    public int getNbRequests() {
        return this.foreign.getNumberOfRequests();
    }

    @Override
    public int[] getPriorityOffsets() {
        return this.foreign.getPriorityOffsets();
    }

    @Override
    public boolean requestAllocationStarts(int[] base_priorities) {
        return this.foreign.requestAllocationStarts(base_priorities);
    }

    @Override
    public void requestAllocationComplete() {
        this.foreign.requestAllocationComplete();
    }

    @Override
    public PEPeerControl getControl() {
        return (PEPeerControl)this.manager.getDelegate();
    }

    @Override
    public void updatePeerExchange() {
    }

    @Override
    public PeerItem getPeerItemIdentity() {
        return PeerItemFactory.createPeerItem(this.foreign.getIp(), this.foreign.getTCPListenPort(), (byte)3, (byte)0, this.foreign.getUDPListenPort(), (byte)1, 0);
    }

    @Override
    public int getConnectionState() {
        int peer_state = this.getPeerState();
        if (peer_state == 10) {
            return 1;
        }
        if (peer_state == 20) {
            return 2;
        }
        if (peer_state == 30) {
            return 4;
        }
        return 4;
    }

    @Override
    public void doKeepAliveCheck() {
    }

    @Override
    public boolean doTimeoutChecks() {
        return false;
    }

    @Override
    public void doPerformanceTuningCheck() {
    }

    @Override
    public void setSuspendedLazyBitFieldEnabled(boolean enable) {
    }

    @Override
    public long getConnectionEstablishedMonoTime() {
        return this.create_time_mono;
    }

    @Override
    public long getTimeSinceLastDataMessageReceived() {
        if (this.last_data_message_received_time == -1L) {
            return -1L;
        }
        long now = SystemTime.getCurrentTime();
        if (this.last_data_message_received_time < now) {
            this.last_data_message_received_time = now;
        }
        return now - this.last_data_message_received_time;
    }

    @Override
    public long getTimeSinceGoodDataReceived() {
        if (this.last_data_received_time == -1L) {
            return -1L;
        }
        long now = SystemTime.getCurrentTime();
        long time_since = now - this.last_data_received_time;
        if (time_since < 0L) {
            this.last_data_received_time = now;
            time_since = 0L;
        }
        return time_since;
    }

    @Override
    public long getTimeSinceLastDataMessageSent() {
        return 0L;
    }

    @Override
    public long getUnchokedForMillis() {
        return 0L;
    }

    @Override
    public long getLatency() {
        return 0L;
    }

    @Override
    public int getConsecutiveNoRequestCount() {
        return this.consecutive_no_requests;
    }

    @Override
    public void setConsecutiveNoRequestCount(int num) {
        this.consecutive_no_requests = num;
    }

    @Override
    public PEPeerManager getManager() {
        return this.manager.getDelegate();
    }

    @Override
    public String getPeerSource() {
        return "Plugin";
    }

    @Override
    public int getPeerState() {
        int peer_state = this.foreign.getState();
        return peer_state;
    }

    @Override
    public byte[] getId() {
        return this.foreign.getId();
    }

    @Override
    public String getIp() {
        return this.foreign.getIp();
    }

    @Override
    public String getIPHostName() {
        return this.foreign.getIp();
    }

    @Override
    public int getPort() {
        return this.foreign.getPort();
    }

    @Override
    public int getTCPListenPort() {
        return this.foreign.getTCPListenPort();
    }

    @Override
    public int getUDPListenPort() {
        return this.foreign.getUDPListenPort();
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.foreign.getUDPNonDataListenPort();
    }

    @Override
    public BitFlags getAvailable() {
        boolean[] flags = this.foreign.getAvailable();
        if (flags != null && (this.bit_flags == null || this.bit_flags.flags != flags)) {
            this.bit_flags = new BitFlags(flags);
        }
        return this.bit_flags;
    }

    @Override
    public boolean hasReceivedBitField() {
        return true;
    }

    @Override
    public boolean isPieceAvailable(int pieceNumber) {
        return this.foreign.isPieceAvailable(pieceNumber);
    }

    @Override
    public void setSnubbed(boolean b) {
        this.foreign.setSnubbed(b);
    }

    @Override
    public boolean isChokingMe() {
        if (this.is_download_disabled) {
            return true;
        }
        return this.foreign.isChoked();
    }

    @Override
    public boolean isChokedByMe() {
        return this.foreign.isChoking();
    }

    @Override
    public boolean isUnchokeOverride() {
        return false;
    }

    @Override
    public boolean isInteresting() {
        if (this.is_download_disabled) {
            return false;
        }
        return this.foreign.isInteresting();
    }

    @Override
    public boolean isInterested() {
        return this.foreign.isInterested();
    }

    @Override
    public boolean isSeed() {
        return this.foreign.isSeed();
    }

    @Override
    public boolean isRelativeSeed() {
        return false;
    }

    @Override
    public boolean isSnubbed() {
        return this.foreign.isSnubbed();
    }

    @Override
    public long getSnubbedTime() {
        return this.foreign.getSnubbedTime();
    }

    @Override
    public boolean isLANLocal() {
        return AddressUtils.isLANLocalAddress(this.foreign.getIp()) == 1;
    }

    @Override
    public void resetLANLocalStatus() {
    }

    @Override
    public boolean sendRequestHint(int piece_number, int offset, int length, int life) {
        return false;
    }

    @Override
    public int[] getRequestHint() {
        return null;
    }

    @Override
    public void clearRequestHint() {
    }

    @Override
    public void sendRejectRequest(DiskManagerReadRequest request2) {
    }

    @Override
    public void sendBadPiece(int piece_number) {
    }

    @Override
    public void sendStatsRequest(Map request2) {
    }

    @Override
    public void sendStatsReply(Map reply) {
    }

    @Override
    public void sendHashRequest(TOTorrentFileHashTree.HashRequest req) {
    }

    @Override
    public boolean isTCP() {
        return true;
    }

    @Override
    public String getNetwork() {
        return AENetworkClassifier.categoriseAddress(this.getIp());
    }

    @Override
    public PEPeerStats getStats() {
        PeerStatsImpl ps = (PeerStatsImpl)this.foreign.getStats();
        if (ps == null) {
            return null;
        }
        return ps.getDelegate();
    }

    @Override
    public boolean isIncoming() {
        return this.foreign.isIncoming();
    }

    @Override
    public int getPercentDoneInThousandNotation() {
        return this.foreign.getPercentDoneInThousandNotation();
    }

    @Override
    public long getBytesRemaining() {
        int rem_pm = 1000 - this.getPercentDoneInThousandNotation();
        if (rem_pm == 0) {
            return 0L;
        }
        try {
            Torrent t = this.manager.getDownload().getTorrent();
            if (t == null) {
            }
            return t.getSize() * (long)rem_pm / 1000L;
        }
        finally {
            return Long.MAX_VALUE;
        }
    }

    @Override
    public String getClient() {
        return this.foreign.getClient();
    }

    @Override
    public byte[] getHandshakeReservedBytes() {
        return this.foreign.getHandshakeReservedBytes();
    }

    @Override
    public boolean isOptimisticUnchoke() {
        return this.foreign.isOptimisticUnchoke();
    }

    @Override
    public void setOptimisticUnchoke(boolean is_optimistic) {
        this.foreign.setOptimisticUnchoke(is_optimistic);
    }

    @Override
    public int getUniqueAnnounce() {
        return -1;
    }

    @Override
    public int getUploadHint() {
        return 0;
    }

    @Override
    public void setUniqueAnnounce(int uniquePieceNumber) {
    }

    @Override
    public void setUploadHint(int timeToSpread) {
    }

    @Override
    public boolean isStalledPendingLoad() {
        return false;
    }

    @Override
    public void addListener(final PEPeerListener l) {
        final PeerForeignDelegate self = this;
        PeerListener2 core_listener = new PeerListener2(){

            @Override
            public void eventOccurred(PeerEvent event2) {
                Object data = event2.getData();
                switch (event2.getType()) {
                    case 1: {
                        l.stateChanged(self, (Integer)data);
                        break;
                    }
                    case 2: {
                        Integer[] d = (Integer[])data;
                        l.sentBadChunk(self, d[0], d[1]);
                        break;
                    }
                    case 3: {
                        l.addAvailability(self, new BitFlags((boolean[])data));
                        break;
                    }
                    case 4: {
                        l.removeAvailability(self, new BitFlags((boolean[])data));
                    }
                }
            }
        };
        this.foreign.addListener(core_listener);
        if (this.peer_listeners == null) {
            this.peer_listeners = new HashMap();
        }
        this.peer_listeners.put(l, core_listener);
    }

    @Override
    public void removeListener(PEPeerListener l) {
        PeerListener2 core_listener;
        if (this.peer_listeners != null && (core_listener = this.peer_listeners.remove(l)) != null) {
            this.foreign.removeListener(core_listener);
        }
    }

    @Override
    public NetworkConnectionBase getNetworkConnection() {
        return this.network_connection;
    }

    @Override
    public Connection getPluginConnection() {
        return this.foreign.getConnection();
    }

    @Override
    public int[] getCurrentIncomingRequestProgress() {
        return this.foreign.getCurrentIncomingRequestProgress();
    }

    @Override
    public int[] getCurrentOutgoingRequestProgress() {
        return this.foreign.getCurrentOutgoingRequestProgress();
    }

    @Override
    public boolean supportsMessaging() {
        return this.foreign.supportsMessaging();
    }

    @Override
    public int getMessagingMode() {
        return 4;
    }

    @Override
    public String getEncryption() {
        return "";
    }

    @Override
    public String getProtocol() {
        String res = (String)this.foreign.getUserData(Peer.PR_PROTOCOL);
        if (res != null) {
            return res;
        }
        return "Plugin";
    }

    @Override
    public String getProtocolQualifier() {
        return (String)this.foreign.getUserData(Peer.PR_PROTOCOL_QUALIFIER);
    }

    @Override
    public com.biglybt.core.peermanager.messaging.Message[] getSupportedMessages() {
        Message[] plug_msgs = this.foreign.getSupportedMessages();
        com.biglybt.core.peermanager.messaging.Message[] core_msgs = new com.biglybt.core.peermanager.messaging.Message[plug_msgs.length];
        int i = 0;
        while (i < plug_msgs.length) {
            core_msgs[i] = new MessageAdapter(plug_msgs[i]);
            ++i;
        }
        return core_msgs;
    }

    @Override
    public Object getData(String key) {
        return this.getUserData(key);
    }

    @Override
    public void setData(String key, Object value) {
        this.setUserData(key, value);
    }

    @Override
    public Object getUserData(Object key) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                return null;
            }
            Object v = this.data.get(key);
            return v;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setUserData(Object key, Object value) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new LightHashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                    if (this.data.size() == 0) {
                        this.data = null;
                    }
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof PeerForeignDelegate) {
            return this.foreign.equals(((PeerForeignDelegate)other).foreign);
        }
        return false;
    }

    public int hashCode() {
        return this.foreign.hashCode();
    }

    @Override
    public int[] getReservedPieceNumbers() {
        return this.reserved_pieces;
    }

    @Override
    public void addReservedPieceNumber(int piece_number) {
        int[] existing = this.reserved_pieces;
        if (existing == null) {
            this.reserved_pieces = new int[]{piece_number};
        } else {
            int[] updated = new int[existing.length + 1];
            System.arraycopy(existing, 0, updated, 0, existing.length);
            updated[existing.length] = piece_number;
            this.reserved_pieces = updated;
        }
    }

    @Override
    public void removeReservedPieceNumber(int piece_number) {
        int[] existing = this.reserved_pieces;
        if (existing != null) {
            if (existing.length == 1) {
                if (existing[0] == piece_number) {
                    this.reserved_pieces = null;
                }
            } else {
                int[] updated = new int[existing.length - 1];
                int pos = 0;
                boolean found = false;
                int i = 0;
                while (i < existing.length) {
                    int pn = existing[i];
                    if (found || pn != piece_number) {
                        if (pos == updated.length) {
                            return;
                        }
                        updated[pos++] = pn;
                    } else {
                        found = true;
                    }
                    ++i;
                }
                this.reserved_pieces = updated;
            }
        }
    }

    @Override
    public int[] getIncomingRequestedPieceNumbers() {
        return new int[0];
    }

    @Override
    public int getIncomingRequestedPieceNumberCount() {
        return 0;
    }

    @Override
    public int getIncomingRequestCount() {
        return 0;
    }

    @Override
    public int getOutgoingRequestCount() {
        return this.foreign.getOutgoingRequestCount();
    }

    @Override
    public int[] getOutgoingRequestedPieceNumbers() {
        return this.foreign.getOutgoingRequestedPieceNumbers();
    }

    @Override
    public int getLastPiece() {
        return this._lastPiece;
    }

    @Override
    public void setLastPiece(int pieceNumber) {
        this._lastPiece = pieceNumber;
    }

    @Override
    public void checkInterested() {
    }

    public boolean isAvailabilityAdded() {
        return false;
    }

    public void clearAvailabilityAdded() {
    }

    @Override
    public PEPeerTransport reconnect(boolean tryUDP, boolean tryIPv6, Map userData) {
        return null;
    }

    @Override
    public boolean isReconnect() {
        return false;
    }

    @Override
    public boolean isSafeForReconnect() {
        return false;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int bytes) {
        this.network_connection.setUploadLimit(bytes);
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int bytes) {
        this.network_connection.setDownloadLimit(bytes);
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.network_connection.getUploadLimit();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.network_connection.getDownloadLimit();
    }

    @Override
    public void updateAutoUploadPriority(Object key, boolean inc) {
    }

    @Override
    public void addRateLimiter(LimitedRateGroup limiter, boolean upload) {
        this.network_connection.addRateLimiter(limiter, upload);
    }

    @Override
    public LimitedRateGroup[] getRateLimiters(boolean upload) {
        return this.network_connection.getRateLimiters(upload);
    }

    @Override
    public void removeRateLimiter(LimitedRateGroup limiter, boolean upload) {
        this.network_connection.removeRateLimiter(limiter, upload);
    }

    @Override
    public void setUploadDisabled(Object key, boolean disabled) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDownloadDisabled(Object key, boolean disabled) {
        PeerForeignDelegate peerForeignDelegate = this;
        synchronized (peerForeignDelegate) {
            List<PeerReadRequest> list;
            if (this.download_disabled_set == null) {
                if (disabled) {
                    this.download_disabled_set = new HashSet<Object>();
                    this.download_disabled_set.add(key);
                } else {
                    Debug.out("derp");
                }
            } else if (disabled) {
                if (!this.download_disabled_set.add(key)) {
                    Debug.out("derp");
                }
            } else {
                if (!this.download_disabled_set.remove(key)) {
                    Debug.out("derp");
                }
                if (this.download_disabled_set.size() == 0) {
                    this.download_disabled_set = null;
                }
            }
            boolean bl = this.is_download_disabled = this.download_disabled_set != null;
            if (this.is_download_disabled && (list = this.foreign.getRequests()) != null) {
                for (PeerReadRequest req : list) {
                    this.foreign.cancelRequest(req);
                }
            }
        }
    }

    @Override
    public boolean isUploadDisabled() {
        return true;
    }

    @Override
    public boolean isDownloadDisabled() {
        return this.is_download_disabled;
    }

    @Override
    public void setHaveAggregationEnabled(boolean enabled) {
    }

    @Override
    public void setPriorityConnection(boolean is_priority) {
        this.priority_connection = is_priority;
    }

    @Override
    public boolean isPriorityConnection() {
        return this.priority_connection;
    }

    @Override
    public boolean canSendHolePunch() {
        return false;
    }

    @Override
    public void sendHolePunch(InetAddress address, int port) {
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("delegate: ip=" + this.getIp() + ",tcp=" + this.getTCPListenPort() + ",udp=" + this.getUDPListenPort() + ",state=" + this.foreign.getState() + ",foreign=" + this.foreign);
    }

    @Override
    public String getClientNameFromExtensionHandshake() {
        return null;
    }

    @Override
    public String getClientNameFromPeerID() {
        return null;
    }

    @Override
    public int getTaggableType() {
        return 4;
    }

    @Override
    public String getTaggableID() {
        return null;
    }

    @Override
    public String getTaggableName() {
        return this.getIp();
    }

    @Override
    public TaggableResolver getTaggableResolver() {
        return null;
    }

    @Override
    public Object getTaggableTransientProperty(String key) {
        return null;
    }

    @Override
    public void setTaggableTransientProperty(String key, Object value) {
    }
}

