/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.network;

import com.biglybt.core.Core;
import com.biglybt.core.networkmanager.ConnectionEndpoint;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.ProtocolEndpointFactory;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.networkmanager.impl.TransportCipher;
import com.biglybt.core.networkmanager.impl.TransportHelper;
import com.biglybt.core.networkmanager.impl.TransportHelperFilter;
import com.biglybt.core.networkmanager.impl.TransportHelperFilterStreamCipher;
import com.biglybt.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.biglybt.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.biglybt.core.networkmanager.impl.udp.UDPNetworkManager;
import com.biglybt.core.networkmanager.impl.udp.UDPTransport;
import com.biglybt.core.networkmanager.impl.udp.UDPTransportHelper;
import com.biglybt.pif.messaging.MessageStreamDecoder;
import com.biglybt.pif.messaging.MessageStreamEncoder;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.ConnectionManager;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.network.TransportException;
import com.biglybt.pif.network.TransportFilter;
import com.biglybt.pifimpl.local.messaging.MessageStreamDecoderAdapter;
import com.biglybt.pifimpl.local.messaging.MessageStreamEncoderAdapter;
import com.biglybt.pifimpl.local.network.ConnectionImpl;
import com.biglybt.pifimpl.local.network.TransportCipherImpl;
import com.biglybt.pifimpl.local.network.TransportFilterImpl;
import com.biglybt.pifimpl.local.network.TransportImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ConnectionManagerImpl
implements ConnectionManager {
    private static ConnectionManagerImpl instance;
    private Core core;

    public static synchronized ConnectionManagerImpl getSingleton(Core core) {
        if (instance == null) {
            instance = new ConnectionManagerImpl(core);
        }
        return instance;
    }

    private ConnectionManagerImpl(Core _core) {
        this.core = _core;
    }

    @Override
    public Connection createConnection(InetSocketAddress remote_address, MessageStreamEncoder encoder, MessageStreamDecoder decoder) {
        ConnectionEndpoint connection_endpoint = new ConnectionEndpoint(remote_address);
        connection_endpoint.addProtocol(ProtocolEndpointFactory.createEndpoint(1, remote_address));
        NetworkConnection core_conn = NetworkManager.getSingleton().createConnection(connection_endpoint, new MessageStreamEncoderAdapter(encoder), new MessageStreamDecoderAdapter(decoder), false, false, null);
        return new ConnectionImpl(core_conn, false);
    }

    @Override
    public int getNATStatus() {
        return (Integer)this.core.getGlobalManager().getNATStatus()[0];
    }

    @Override
    public Object[] getNATStatusEx() {
        return this.core.getGlobalManager().getNATStatus();
    }

    @Override
    public com.biglybt.pif.network.TransportCipher createTransportCipher(String algorithm, int mode, SecretKeySpec key_spec, AlgorithmParameterSpec params) throws TransportException {
        try {
            TransportCipher cipher = new TransportCipher(algorithm, mode, key_spec, params);
            return new TransportCipherImpl(cipher);
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TransportFilter createTransportFilter(Connection connection, com.biglybt.pif.network.TransportCipher read_cipher, com.biglybt.pif.network.TransportCipher write_cipher) throws TransportException {
        TransportHelper helper;
        TransportHelperFilter hfilter;
        Transport core_transport;
        com.biglybt.pif.network.Transport transport = connection.getTransport();
        if (transport == null) {
            throw new TransportException("no transport available");
        }
        try {
            core_transport = ((TransportImpl)transport).coreTransport();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        if (core_transport instanceof TCPTransportImpl) {
            hfilter = ((TCPTransportImpl)core_transport).getFilter();
            helper = hfilter != null ? hfilter.getHelper() : new TCPTransportHelper(((TCPTransportImpl)core_transport).getSocketChannel());
        } else {
            if (!(core_transport instanceof UDPTransport)) throw new TransportException("transport type not supported - " + core_transport);
            hfilter = ((UDPTransport)core_transport).getFilter();
            if (hfilter != null) {
                helper = hfilter.getHelper();
            } else {
                helper = ((UDPTransport)core_transport).getFilter().getHelper();
                InetSocketAddress addr = core_transport.getTransportEndpoint().getProtocolEndpoint().getConnectionEndpoint().getNotionalAddress();
                if (connection.isIncoming()) throw new TransportException("udp incoming transport type not supported - " + core_transport);
                try {
                    helper = new UDPTransportHelper(UDPNetworkManager.getSingleton().getConnectionManager(), addr, (UDPTransport)core_transport);
                }
                catch (IOException ioe) {
                    throw new TransportException(ioe);
                }
            }
        }
        TransportHelperFilterStreamCipher core_filter = new TransportHelperFilterStreamCipher(helper, ((TransportCipherImpl)read_cipher).cipher, ((TransportCipherImpl)write_cipher).cipher);
        return new TransportFilterImpl(core_filter);
    }

    @Override
    public RateLimiter createRateLimiter(String name, int bps) {
        return new PluginRateLimiter(name, bps);
    }

    public static class PluginRateLimiter
    implements RateLimiter {
        private String name;
        private int rate;
        private long total;

        private PluginRateLimiter(String _name, int _bps) {
            this.name = _name;
            this.rate = _bps;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return this.rate;
        }

        @Override
        public void setRateLimitBytesPerSecond(int bytes_per_second) {
            this.rate = bytes_per_second;
        }

        @Override
        public long getRateLimitTotalByteCount() {
            return this.total;
        }

        public void updateBytesUsed(int used) {
            this.total += (long)used;
        }
    }
}

