/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.messaging;

import com.biglybt.core.networkmanager.ConnectionEndpoint;
import com.biglybt.core.networkmanager.IncomingMessageQueue;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.OutgoingMessageQueue;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.networkmanager.TransportStartpoint;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.pif.messaging.MessageException;
import com.biglybt.pif.messaging.generic.GenericMessageEndpoint;
import com.biglybt.pif.messaging.generic.GenericMessageStartpoint;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.messaging.GenericMessage;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionAdapter;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionImpl;
import com.biglybt.pifimpl.local.messaging.GenericMessageDecoder;
import com.biglybt.pifimpl.local.messaging.GenericMessageEncoder;
import com.biglybt.pifimpl.local.messaging.GenericMessageEndpointImpl;
import com.biglybt.pifimpl.local.messaging.MessageManagerImpl;
import com.biglybt.pifimpl.local.network.ConnectionImpl;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GenericMessageConnectionDirect
implements GenericMessageConnectionAdapter {
    public static final int MAX_MESSAGE_SIZE = 262144;
    private static AsyncDispatcher dispatcher = new AsyncDispatcher("GMReceiver");
    private GenericMessageConnectionImpl owner;
    private String msg_id;
    private String msg_desc;
    private int stream_crypto;
    private byte[][] shared_secrets;
    private GenericMessageEndpointImpl endpoint;
    private NetworkConnection connection;
    private ConnectionImpl plugin_connection;
    private volatile boolean connected;
    private boolean processing;
    private volatile boolean closed;
    private List<LimitedRateGroup> inbound_rls;
    private List<LimitedRateGroup> outbound_rls;

    protected static GenericMessageConnectionDirect receive(GenericMessageEndpointImpl endpoint, String msg_id, String msg_desc, int stream_crypto, byte[][] shared_secrets) {
        int crypto = MessageManagerImpl.adjustCrypto(endpoint, stream_crypto);
        GenericMessageConnectionDirect direct_connection = new GenericMessageConnectionDirect(msg_id, msg_desc, endpoint, crypto, shared_secrets);
        return direct_connection;
    }

    protected GenericMessageConnectionDirect(String _msg_id, String _msg_desc, GenericMessageEndpointImpl _endpoint, int _stream_crypto, byte[][] _shared_secrets) {
        this.msg_id = _msg_id;
        this.msg_desc = _msg_desc;
        this.endpoint = _endpoint;
        this.stream_crypto = _stream_crypto;
        this.shared_secrets = _shared_secrets;
    }

    @Override
    public void setOwner(GenericMessageConnectionImpl _owner) {
        this.owner = _owner;
    }

    @Override
    public int getMaximumMessageSize() {
        return 262144;
    }

    @Override
    public String getType() {
        if (this.connection == null) {
            return "";
        }
        Transport transport = this.connection.getTransport();
        if (transport == null) {
            return "";
        }
        return transport.getEncryption(true);
    }

    @Override
    public int getTransportType() {
        if (this.connection == null) {
            return 0;
        }
        Transport t = this.connection.getTransport();
        if (t == null) {
            return 0;
        }
        if (t.isTCP()) {
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInboundRateLimiter(RateLimiter _limiter) {
        UtilitiesImpl.PluginLimitedRateGroup limiter = UtilitiesImpl.wrapLimiter(_limiter, false);
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            if (this.processing) {
                this.connection.addRateLimiter(limiter, false);
            } else {
                if (this.inbound_rls == null) {
                    this.inbound_rls = new ArrayList<LimitedRateGroup>();
                }
                this.inbound_rls.add(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInboundRateLimiter(RateLimiter _limiter) {
        UtilitiesImpl.PluginLimitedRateGroup limiter = UtilitiesImpl.wrapLimiter(_limiter, false);
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            if (this.processing) {
                this.connection.removeRateLimiter(limiter, false);
            } else if (this.inbound_rls != null) {
                this.inbound_rls.remove(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutboundRateLimiter(RateLimiter _limiter) {
        UtilitiesImpl.PluginLimitedRateGroup limiter = UtilitiesImpl.wrapLimiter(_limiter, false);
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            if (this.processing) {
                this.connection.addRateLimiter(limiter, true);
            } else {
                if (this.outbound_rls == null) {
                    this.outbound_rls = new ArrayList<LimitedRateGroup>();
                }
                this.outbound_rls.add(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOutboundRateLimiter(RateLimiter _limiter) {
        UtilitiesImpl.PluginLimitedRateGroup limiter = UtilitiesImpl.wrapLimiter(_limiter, false);
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            if (this.processing) {
                this.connection.removeRateLimiter(limiter, true);
            } else if (this.outbound_rls != null) {
                this.outbound_rls.remove(limiter);
            }
        }
    }

    protected void connect(NetworkConnection _connection) {
        this.connection = _connection;
        this.plugin_connection = new ConnectionImpl(this.connection, true);
        this.connection.connect(3, new NetworkConnection.ConnectionListener(){

            @Override
            public int connectStarted(int default_connect_timeout) {
                return default_connect_timeout;
            }

            @Override
            public void connectSuccess(ByteBuffer remaining_initial_data) {
                GenericMessageConnectionDirect.this.connected = true;
            }

            @Override
            public void connectFailure(Throwable failure_msg) {
                GenericMessageConnectionDirect.this.owner.reportFailed(failure_msg);
                GenericMessageConnectionDirect.this.connection.close(failure_msg == null ? null : Debug.getNestedExceptionMessage(failure_msg));
            }

            @Override
            public void exceptionThrown(Throwable error) {
                GenericMessageConnectionDirect.this.owner.reportFailed(error);
                GenericMessageConnectionDirect.this.connection.close(error == null ? null : Debug.getNestedExceptionMessage(error));
            }

            @Override
            public Object getConnectionProperty(String property_name) {
                return null;
            }

            @Override
            public String getDescription() {
                return "generic connection: " + GenericMessageConnectionDirect.this.endpoint.getNotionalAddress();
            }
        });
    }

    @Override
    public void accepted() {
        this.startProcessing();
    }

    @Override
    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public GenericMessageStartpoint getStartpoint() {
        TransportStartpoint sp;
        if (this.connection != null && (sp = this.connection.getTransport().getTransportStartpoint()) != null) {
            InetSocketAddress address = sp.getProtocolStartpoint().getNotionalAddress();
            return () -> address;
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        return this.plugin_connection;
    }

    @Override
    public void connect(ByteBuffer upper_initial_data, final GenericMessageConnectionAdapter.ConnectionListener listener) {
        if (this.connected) {
            return;
        }
        ConnectionEndpoint cep = this.endpoint.getConnectionEndpoint();
        cep = cep.getLANAdjustedEndpoint();
        int crypto = MessageManagerImpl.adjustCrypto(cep, this.stream_crypto);
        this.connection = NetworkManager.getSingleton().createConnection(cep, new GenericMessageEncoder(), new GenericMessageDecoder(this.msg_id, this.msg_desc), crypto != 1, crypto != 3, this.shared_secrets);
        this.plugin_connection = new ConnectionImpl(this.connection, false);
        ByteBuffer initial_data = ByteBuffer.wrap(this.msg_id.getBytes());
        if (upper_initial_data != null) {
            GenericMessage gm = new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(upper_initial_data), false);
            DirectByteBuffer[] payload = new GenericMessageEncoder().encodeMessage(gm)[0].getRawData();
            int size = initial_data.remaining();
            int i = 0;
            while (i < payload.length) {
                size += payload[i].remaining((byte)11);
                ++i;
            }
            ByteBuffer temp = ByteBuffer.allocate(size);
            temp.put(initial_data);
            int i2 = 0;
            while (i2 < payload.length) {
                temp.put(payload[i2].getBuffer((byte)11));
                ++i2;
            }
            temp.rewind();
            initial_data = temp;
        }
        this.connection.connect(initial_data, 3, new NetworkConnection.ConnectionListener(){

            @Override
            public int connectStarted(int default_connect_timeout) {
                return default_connect_timeout;
            }

            @Override
            public void connectSuccess(ByteBuffer remaining_initial_data) {
                GenericMessageConnectionDirect.this.connected = true;
                try {
                    if (remaining_initial_data != null && remaining_initial_data.remaining() > 0) {
                        GenericMessageConnectionDirect.this.connection.getOutgoingMessageQueue().addMessage(new GenericMessage(GenericMessageConnectionDirect.this.msg_id, GenericMessageConnectionDirect.this.msg_desc, new DirectByteBuffer(remaining_initial_data), true), false);
                    }
                    listener.connectSuccess();
                    GenericMessageConnectionDirect.this.startProcessing();
                }
                catch (Throwable e) {
                    this.connectFailure(e);
                }
            }

            @Override
            public void connectFailure(Throwable failure_msg) {
                listener.connectFailure(failure_msg);
                GenericMessageConnectionDirect.this.connection.close(failure_msg == null ? null : Debug.getNestedExceptionMessage(failure_msg));
            }

            @Override
            public void exceptionThrown(Throwable error) {
                listener.connectFailure(error);
                GenericMessageConnectionDirect.this.connection.close(error == null ? null : Debug.getNestedExceptionMessage(error));
            }

            @Override
            public Object getConnectionProperty(String property_name) {
                return listener.getConnectionProperty(property_name);
            }

            @Override
            public String getDescription() {
                return "generic connection";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startProcessing() {
        this.connection.getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

            @Override
            public boolean messageReceived(Message _message) {
                final GenericMessage message = (GenericMessage)_message;
                dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (dispatcher.getQueueSize() > 10) {
                            try {
                                GenericMessageConnectionDirect.this.close();
                            }
                            catch (Throwable throwable) {}
                        } else {
                            GenericMessageConnectionDirect.this.owner.receive(message);
                        }
                    }
                });
                return true;
            }

            @Override
            public void protocolBytesReceived(int byte_count) {
            }

            @Override
            public void dataBytesReceived(int byte_count) {
            }

            @Override
            public boolean isPriority() {
                return false;
            }
        });
        this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            @Override
            public boolean messageAdded(Message message) {
                return true;
            }

            @Override
            public void messageQueued(Message message) {
            }

            @Override
            public void messageRemoved(Message message) {
            }

            @Override
            public void messageSent(Message message) {
            }

            @Override
            public void protocolBytesSent(int byte_count) {
            }

            @Override
            public void dataBytesSent(int byte_count) {
            }

            @Override
            public void flush() {
            }
        });
        this.connection.startMessageProcessing();
        this.connection.enableEnhancedMessageProcessing(true, -1);
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            int i;
            if (this.inbound_rls != null) {
                i = 0;
                while (i < this.inbound_rls.size()) {
                    this.connection.addRateLimiter(this.inbound_rls.get(i), false);
                    ++i;
                }
                this.inbound_rls = null;
            }
            if (this.outbound_rls != null) {
                i = 0;
                while (i < this.outbound_rls.size()) {
                    this.connection.addRateLimiter(this.outbound_rls.get(i), true);
                    ++i;
                }
                this.outbound_rls = null;
            }
            this.processing = true;
        }
    }

    @Override
    public void send(PooledByteBuffer data) throws MessageException {
        if (!this.connected) {
            throw new MessageException("not connected");
        }
        PooledByteBufferImpl impl = (PooledByteBufferImpl)data;
        try {
            this.connection.getOutgoingMessageQueue().addMessage(new GenericMessage(this.msg_id, this.msg_desc, impl.getBuffer(), false), false);
        }
        catch (Throwable e) {
            throw new MessageException("send failed", e);
        }
    }

    @Override
    public void close() throws MessageException {
        if (!this.connected) {
            throw new MessageException("not connected");
        }
        if (!this.closed) {
            this.closed = true;
            this.connection.close(null);
        }
    }
}

