/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.logging;

import com.biglybt.core.logging.ILogAlertListener;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.logging.impl.FileLogging;
import com.biglybt.core.logging.impl.FileLoggingAdapter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.FileLoggerAdapter;
import com.biglybt.pif.logging.LogAlertListener;
import com.biglybt.pif.logging.LoggerAlertListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pifimpl.local.logging.LoggerChannelImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LoggerImpl
implements com.biglybt.pif.logging.Logger {
    private PluginInterface pi;
    private List channels = new ArrayList();
    private Map alert_listeners_map = new HashMap();
    private Map alert_listeners_map2 = new HashMap();

    public LoggerImpl(PluginInterface _pi) {
        this.pi = _pi;
    }

    @Override
    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    @Override
    public LoggerChannel getChannel(String name) {
        LoggerChannelImpl channel2 = new LoggerChannelImpl(this, name, false, false);
        this.channels.add(channel2);
        return channel2;
    }

    @Override
    public LoggerChannel getTimeStampedChannel(String name) {
        LoggerChannelImpl channel2 = new LoggerChannelImpl(this, name, true, false);
        this.channels.add(channel2);
        return channel2;
    }

    @Override
    public LoggerChannel getNullChannel(String name) {
        LoggerChannelImpl channel2 = new LoggerChannelImpl(this, name, true, true);
        this.channels.add(channel2);
        return channel2;
    }

    @Override
    public LoggerChannel[] getChannels() {
        LoggerChannel[] res = new LoggerChannel[this.channels.size()];
        this.channels.toArray(res);
        return res;
    }

    @Override
    public void addAlertListener(final LoggerAlertListener listener) {
        ILogAlertListener lg_listener = new ILogAlertListener(){

            @Override
            public void alertRaised(LogAlert alert) {
                if (alert.err == null) {
                    int type = alert.entryType == 0 ? 1 : (alert.entryType == 1 ? 2 : 3);
                    listener.alertLogged(type, alert.text, alert.repeatable);
                } else {
                    listener.alertLogged(alert.text, alert.err, alert.repeatable);
                }
            }
        };
        this.alert_listeners_map.put(listener, lg_listener);
        Logger.addListener(lg_listener);
    }

    @Override
    public void removeAlertListener(LoggerAlertListener listener) {
        ILogAlertListener lg_listener = (ILogAlertListener)this.alert_listeners_map.remove(listener);
        if (lg_listener != null) {
            Logger.removeListener(lg_listener);
        }
    }

    @Override
    public void addAlertListener(final LogAlertListener listener) {
        ILogAlertListener lg_listener = new ILogAlertListener(){
            private HashSet set = new HashSet();

            @Override
            public void alertRaised(LogAlert alert) {
                if (!alert.repeatable) {
                    if (this.set.contains(alert.text)) {
                        return;
                    }
                    this.set.add(alert.text);
                }
                listener.alertRaised(alert);
            }
        };
        this.alert_listeners_map2.put(listener, lg_listener);
        Logger.addListener(lg_listener);
    }

    @Override
    public void removeAlertListener(LogAlertListener listener) {
        ILogAlertListener lg_listener = (ILogAlertListener)this.alert_listeners_map2.remove(listener);
        if (lg_listener != null) {
            Logger.removeListener(lg_listener);
        }
    }

    @Override
    public void addFileLoggingListener(FileLoggerAdapter listener) {
        FileLogging fileLogging = Logger.getFileLoggingInstance();
        if (fileLogging == null) {
            return;
        }
        fileLogging.addListener(new PluginFileLoggerAdapater(fileLogging, listener));
    }

    @Override
    public void removeFileLoggingListener(FileLoggerAdapter listener) {
        FileLogging fileLogging = Logger.getFileLoggingInstance();
        if (fileLogging == null) {
            return;
        }
        Object[] listeners = fileLogging.getListeners().toArray();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof PluginFileLoggerAdapater) {
                PluginFileLoggerAdapater l = (PluginFileLoggerAdapater)listeners[i];
                if (l.listener == listener) {
                    fileLogging.removeListener(l);
                }
            }
            ++i;
        }
    }

    private static class PluginFileLoggerAdapater
    extends FileLoggingAdapter {
        public FileLoggerAdapter listener;

        public PluginFileLoggerAdapater(FileLogging fileLogging, FileLoggerAdapter listener) {
            fileLogging.addListener(this);
            this.listener = listener;
        }

        @Override
        public boolean logToFile(LogEvent event2, StringBuffer lineOut) {
            return this.listener.logToFile(lineOut);
        }
    }
}

