/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.installer;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.installer.FilePluginInstaller;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.installer.InstallablePluginImpl;
import com.biglybt.pifimpl.local.installer.PluginInstallerImpl;
import com.biglybt.pifimpl.update.PluginUpdatePlugin;
import com.biglybt.pifimpl.update.sf.SFPluginDetailsLoader;
import com.biglybt.pifimpl.update.sf.SFPluginDetailsLoaderFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FilePluginInstallerImpl
extends InstallablePluginImpl
implements FilePluginInstaller {
    protected PluginInstallerImpl installer;
    protected File file;
    protected String id;
    protected String version;
    protected String name;
    protected boolean is_jar;

    protected FilePluginInstallerImpl(PluginInstallerImpl _installer, File _file) throws PluginException {
        super(_installer);
        this.installer = _installer;
        this.file = _file;
        String name = this.file.getName();
        int pos = name.lastIndexOf(".");
        boolean ok = false;
        if (pos != -1) {
            String prefix = name.substring(0, pos);
            String suffix = name.substring(pos + 1);
            if (prefix.lastIndexOf("_src") != -1) {
                if (prefix.endsWith("_src")) {
                    prefix = prefix.substring(0, prefix.length() - 4);
                } else {
                    int src_bit_pos = prefix.lastIndexOf("_src");
                    prefix = String.valueOf(prefix.substring(0, src_bit_pos)) + prefix.substring(src_bit_pos + 1);
                }
            }
            if (suffix.toLowerCase(MessageText.LOCALE_ENGLISH).equals("jar") || suffix.toLowerCase(MessageText.LOCALE_ENGLISH).equals("zip")) {
                String plugin_name;
                this.is_jar = suffix.toLowerCase(MessageText.LOCALE_ENGLISH).equals("jar");
                Properties properties = null;
                ZipInputStream zis = null;
                try {
                    try {
                        zis = new ZipInputStream(new BufferedInputStream(FileUtil.newFileInputStream(this.file)));
                        block13: while (properties == null) {
                            ZipEntry entry = zis.getNextEntry();
                            if (entry == null) {
                                break;
                            }
                            String zip_name = entry.getName().toLowerCase(MessageText.LOCALE_ENGLISH);
                            if (zip_name.equals("plugin.properties") || zip_name.endsWith("/plugin.properties")) {
                                properties = new Properties();
                                properties.load(zis);
                                continue;
                            }
                            if (!zip_name.endsWith(".jar")) continue;
                            ZipInputStream zis2 = new ZipInputStream(zis);
                            while (properties == null) {
                                ZipEntry entry2 = zis2.getNextEntry();
                                if (entry2 == null) continue block13;
                                String zip_name2 = entry2.getName().toLowerCase(MessageText.LOCALE_ENGLISH);
                                if (!zip_name2.equals("plugin.properties")) continue;
                                properties = new Properties();
                                properties.load(zis2);
                            }
                        }
                    }
                    catch (Throwable e) {
                        throw new PluginException("Failed to read plugin file", e);
                    }
                }
                finally {
                    if (zis != null) {
                        try {
                            zis.close();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                pos = prefix.lastIndexOf("_");
                String filename_id = null;
                String filename_version = null;
                if (pos != -1) {
                    filename_id = prefix.substring(0, pos);
                    filename_version = prefix.substring(pos + 1);
                }
                if (properties == null) {
                    if (filename_id != null) {
                        this.id = filename_id;
                        this.version = filename_version;
                        PluginInterface pi = this.installer.getPluginManager().getPluginInterfaceByID(this.id);
                        boolean bl = ok = pi != null && (pi.getPluginDirectoryName() == null || pi.getPluginDirectoryName().length() == 0);
                    }
                    if (!ok) {
                        throw new PluginException("Mandatory file 'plugin.properties' not found in plugin file");
                    }
                } else {
                    PluginInitializer.checkJDKVersion("", properties, false);
                    PluginInitializer.checkCoreAppVersion("", properties, false);
                    this.id = properties.getProperty("plugin.id");
                    String prop_version = this.version = properties.getProperty("plugin.version");
                    if (prop_version != null && filename_version != null && !filename_version.equals(prop_version)) {
                        throw new PluginException("inconsistent versions [file=" + filename_version + ", prop=" + prop_version + "]");
                    }
                }
                if (this.id == null) {
                    String plugin_classes;
                    String plugin_class = properties.getProperty("plugin.class");
                    if (plugin_class == null && (plugin_classes = properties.getProperty("plugin.classes")) != null) {
                        int semi_pos = plugin_classes.indexOf(";");
                        plugin_class = semi_pos == -1 ? plugin_classes : plugin_classes.substring(0, semi_pos);
                    }
                    if (plugin_class != null) {
                        try {
                            PluginInterface pi = this.installer.getPluginManager().getPluginInterfaceByClass(plugin_class);
                            if (pi != null) {
                                this.id = pi.getPluginID();
                            }
                        }
                        catch (Throwable pi) {
                            // empty catch block
                        }
                    }
                }
                if ((pos = prefix.lastIndexOf("_")) != -1) {
                    String string = this.id = this.id == null ? prefix.substring(0, pos) : this.id;
                    if (!this.id.equals("aznettor")) {
                        try {
                            SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
                            String[] ids = loader.getPluginIDs();
                            int i = 0;
                            while (i < ids.length) {
                                if (ids[i].equalsIgnoreCase(this.id)) {
                                    this.id = ids[i];
                                    break;
                                }
                                ++i;
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    this.version = this.version == null ? prefix.substring(pos + 1) : this.version;
                }
                this.name = this.id;
                if (properties != null && (plugin_name = properties.getProperty("plugin.name")) != null) {
                    this.name = plugin_name;
                }
                boolean bl = ok = this.id != null && this.version != null;
            }
        }
        if (!ok) {
            throw new PluginException("Invalid plugin file name: must be of form <pluginid>_<version>.[jar|zip]");
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.file.toString();
    }

    @Override
    public String getRelativeURLBase() {
        return "";
    }

    @Override
    public void addUpdate(UpdateCheckInstance inst, final PluginUpdatePlugin plugin_update_plugin, Plugin plugin, final PluginInterface plugin_interface) {
        inst.addUpdatableComponent(new UpdatableComponent(){

            @Override
            public String getName() {
                return FilePluginInstallerImpl.this.name;
            }

            @Override
            public int getMaximumCheckTime() {
                return 0;
            }

            @Override
            public void checkForUpdate(UpdateChecker checker) {
                try {
                    ResourceDownloader rd = plugin_interface.getUtilities().getResourceDownloaderFactory().create(FilePluginInstallerImpl.this.file);
                    plugin_update_plugin.addUpdate(plugin_interface, checker, this.getName(), new String[]{"Installation from file: " + FilePluginInstallerImpl.this.file.toString()}, "", FilePluginInstallerImpl.this.version, rd, FilePluginInstallerImpl.this.is_jar, plugin_interface.getPluginState().isUnloadable() ? 1 : 2, false);
                }
                finally {
                    checker.completed();
                }
            }
        }, false);
    }
}

