/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.clientid;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.clientid.ClientIDGenerator;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import java.util.Properties;

public class ClientIDPlugin
implements Plugin,
ClientIDGenerator {
    private static final String BIGLY_NAME = "BiglyBT";
    private static final String BIGLY_VERSION = "3.4.0.0";
    private static final String BIGLYBT_CLIENT_NAME = "BiglyBT 3.4.0.0";
    private static final String BIGLYBT_CLIENT_NAME_SM = "BiglyBT (Swarm Merging) 3.4.0.0";
    private static boolean send_os;
    private Core core;

    @Override
    public Properties getInitialProperties() {
        Properties properties = new Properties();
        properties.setProperty("plugin.version", "1.0");
        properties.setProperty("plugin.name", "Client Identification");
        properties.setProperty("plugin.is.configurable", "false");
        return properties;
    }

    public void initialize(Core _core) {
        this.core = _core;
        PluginManager.registerPlugin(this, "bgclientid", "bgclientid.plugin");
        String param = "Tracker Client Send OS and Java Version";
        COConfigurationManager.addAndFireParameterListener("Tracker Client Send OS and Java Version", new ParameterListener(){

            @Override
            public void parameterChanged(String param) {
                send_os = COConfigurationManager.getBooleanParameter(param);
            }
        });
        ClientIDManagerImpl.getSingleton().setGenerator(this, false);
    }

    @Override
    public byte[] generatePeerID(byte[] hash, boolean for_tracker) {
        byte[] id = PeerUtils.createPeerID();
        return id;
    }

    @Override
    public Object getProperty(byte[] hash, String property_name) {
        if (property_name == "Client-Name") {
            try {
                GlobalManager gm = this.core.getGlobalManager();
                DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash));
                if (dm != null && gm.isSwarmMerging(dm)) {
                    return BIGLYBT_CLIENT_NAME_SM;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return BIGLYBT_CLIENT_NAME;
        }
        if (property_name == "Messaging-Mode") {
            return 2;
        }
        return null;
    }

    protected void doHTTPProperties(Properties properties) {
        Boolean raw = (Boolean)properties.get("Raw-Request");
        if (raw != null && raw.booleanValue()) {
            return;
        }
        String version = BIGLY_VERSION;
        int pos = version.indexOf(95);
        if (pos != -1) {
            version = version.substring(0, pos);
        }
        String agent = "BiglyBT " + version;
        if (send_os) {
            agent = String.valueOf(agent) + ";" + Constants.OSName;
            agent = String.valueOf(agent) + ";Java " + Constants.JAVA_VERSION;
        }
        properties.put("User-Agent", agent);
    }

    @Override
    public void generateHTTPProperties(byte[] hash, Properties properties) {
        this.doHTTPProperties(properties);
    }

    @Override
    public String[] filterHTTP(byte[] hash, String[] lines_in) {
        return lines_in;
    }

    @Override
    public void initialize(final PluginInterface pi) {
        pi.addListener(new PluginAdapter(){

            @Override
            public void initializationComplete() {
                ClientIDPlugin.this.initializeSupport(pi);
            }
        });
    }

    private void initializeSupport(PluginInterface pi) {
        ClientIDGenerator gen = ClientIDManagerImpl.getSingleton().getGenerator();
        if (gen != this) {
            return;
        }
    }
}

