/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.utils;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.Locale;

public abstract class LocationProvider {
    public static final long CAP_COUNTY_BY_IP = 1L;
    public static final long CAP_COUNTRY_BY_IP = 1L;
    public static final long CAP_ISO3166_BY_IP = 2L;
    public static final long CAP_FLAG_BY_IP = 4L;
    public static final long CAP_FLAG_BY_CC = 8L;

    public abstract String getProviderName();

    public abstract long getCapabilities();

    public boolean hasCapability(long capability) {
        return (this.getCapabilities() & capability) != 0L;
    }

    public boolean hasCapabilities(long capabilities) {
        return (this.getCapabilities() & capabilities) == capabilities;
    }

    public String getCountryNameForIP(InetAddress address, Locale locale) {
        return null;
    }

    public String getISO3166CodeForIP(InetAddress address) {
        return null;
    }

    public int[][] getCountryFlagSizes() {
        return null;
    }

    public InputStream getCountryFlagForIP(InetAddress address, int size_index) {
        return null;
    }

    public InputStream getCountryFlagForISO3166Code(String cc, int size_index) {
        return null;
    }

    public abstract boolean isDestroyed();
}

