/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.download;

import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.disk.DiskManager;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.DownloadActivationEvent;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadEventNotifier;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadStats;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.download.savelocation.SaveLocationChange;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.tag.Tag;
import com.biglybt.pif.tag.Taggable;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import java.io.File;
import java.util.List;
import java.util.Map;

public interface Download
extends DownloadEventNotifier,
DownloadStub,
Taggable {
    public static final int ST_WAITING = 1;
    public static final int ST_PREPARING = 2;
    public static final int ST_READY = 3;
    public static final int ST_DOWNLOADING = 4;
    public static final int ST_SEEDING = 5;
    public static final int ST_STOPPING = 6;
    public static final int ST_STOPPED = 7;
    public static final int ST_ERROR = 8;
    public static final int ST_QUEUED = 9;
    public static final String[] ST_NAMES = new String[]{"", "Waiting", "Preparing", "Ready", "Downloading", "Seeding", "Stopping", "Stopped", "Error", "Queued"};
    public static final long FLAG_ONLY_EVER_SEEDED = 1L;
    public static final long FLAG_SCAN_INCOMPLETE_PIECES = 2L;
    public static final long FLAG_DISABLE_AUTO_FILE_MOVE = 4L;
    public static final long FLAG_MOVE_ON_COMPLETION_DONE = 8L;
    public static final long FLAG_LOW_NOISE = 16L;
    public static final long FLAG_ALLOW_PERMITTED_PEER_SOURCE_CHANGES = 32L;
    public static final long FLAG_DO_NOT_DELETE_DATA_ON_REMOVE = 64L;
    public static final long FLAG_FORCE_DIRECT_DELETE = 128L;
    public static final long FLAG_DISABLE_IP_FILTER = 256L;
    public static final long FLAG_METADATA_DOWNLOAD = 512L;
    public static final long FLAG_LIGHT_WEIGHT = 1024L;
    public static final long FLAG_ERROR_REPORTED = 2048L;
    public static final long FLAG_INITIAL_NETWORKS_SET = 4096L;
    public static final long FLAG_SEQUENTIAL_DOWNLOAD = 8192L;
    public static final long FLAG_DISABLE_STOP_AFTER_ALLOC = 16384L;
    public static final Object UD_KEY_STOP_REASON = new Object();

    public int getState();

    public int getSubState();

    public String getErrorStateDetails();

    public boolean getFlag(long var1);

    public void setFlag(long var1, boolean var3);

    public long getFlags();

    @Override
    public Torrent getTorrent();

    public void initialize() throws DownloadException;

    public void start() throws DownloadException;

    public void stop() throws DownloadException;

    public void setStopReason(String var1);

    public String getStopReason();

    public void stopAndQueue() throws DownloadException;

    public void stopAndRemove(boolean var1, boolean var2) throws DownloadException, DownloadRemovalVetoException;

    public void restart() throws DownloadException;

    public void recheckData() throws DownloadException;

    public boolean isStartStopLocked();

    public boolean isForceStart();

    public void setForceStart(boolean var1);

    public boolean isPaused();

    public void pause();

    public void resume();

    @Override
    public String getName();

    public String getTorrentFileName();

    public String getAttribute(TorrentAttribute var1);

    public void setAttribute(TorrentAttribute var1, String var2);

    public String[] getListAttribute(TorrentAttribute var1);

    public void setListAttribute(TorrentAttribute var1, String[] var2);

    public void setMapAttribute(TorrentAttribute var1, Map var2);

    public Map getMapAttribute(TorrentAttribute var1);

    public int getIntAttribute(TorrentAttribute var1);

    public void setIntAttribute(TorrentAttribute var1, int var2);

    @Override
    public long getLongAttribute(TorrentAttribute var1);

    @Override
    public void setLongAttribute(TorrentAttribute var1, long var2);

    public boolean getBooleanAttribute(TorrentAttribute var1);

    public void setBooleanAttribute(TorrentAttribute var1, boolean var2);

    public boolean hasAttribute(TorrentAttribute var1);

    public String getCategoryName();

    public void setCategory(String var1);

    public List<Tag> getTags();

    @Override
    public void remove() throws DownloadException, DownloadRemovalVetoException;

    public void remove(boolean var1, boolean var2) throws DownloadException, DownloadRemovalVetoException;

    public int getPosition();

    public long getCreationTime();

    public void setPosition(int var1);

    public void moveUp();

    public void moveDown();

    public void moveTo(int var1);

    public boolean canBeRemoved() throws DownloadRemovalVetoException;

    public void setAnnounceResult(DownloadAnnounceResult var1);

    public void setScrapeResult(DownloadScrapeResult var1);

    public DownloadAnnounceResult getLastAnnounceResult();

    public DownloadScrapeResult getLastScrapeResult();

    default public DownloadScrapeResult getAggregatedScrapeResult() {
        return this.getAggregatedScrapeResult(true);
    }

    public DownloadScrapeResult getAggregatedScrapeResult(boolean var1);

    public DownloadActivationEvent getActivationState();

    public DownloadStats getStats();

    public boolean isPersistent();

    public void setMaximumDownloadKBPerSecond(int var1);

    public int getMaximumDownloadKBPerSecond();

    public int getUploadRateLimitBytesPerSecond();

    public void setUploadRateLimitBytesPerSecond(int var1);

    public int getDownloadRateLimitBytesPerSecond();

    public void setDownloadRateLimitBytesPerSecond(int var1);

    public void addRateLimiter(RateLimiter var1, boolean var2);

    public void removeRateLimiter(RateLimiter var1, boolean var2);

    public boolean isComplete();

    public boolean isComplete(boolean var1);

    public boolean isChecking();

    public boolean isMoving();

    @Override
    public String getSavePath();

    public void moveDataFiles(File var1) throws DownloadException;

    public void moveDataFiles(File var1, String var2) throws DownloadException;

    public void moveTorrentFile(File var1) throws DownloadException;

    public void renameDownload(String var1) throws DownloadException;

    public PeerManager getPeerManager();

    public DiskManager getDiskManager();

    public DiskManagerFileInfo[] getDiskManagerFileInfo();

    public DiskManagerFileInfo getDiskManagerFileInfo(int var1);

    public int getDiskManagerFileCount();

    public void requestTrackerAnnounce();

    public void requestTrackerAnnounce(boolean var1);

    public void requestTrackerScrape(boolean var1);

    public SeedingRank getSeedingRank();

    public void setSeedingRank(SeedingRank var1);

    public byte[] getDownloadPeerId();

    public boolean isMessagingEnabled();

    public void setMessagingEnabled(boolean var1);

    public boolean isRemoved();

    public boolean canMoveDataFiles();

    public SaveLocationChange calculateDefaultDownloadLocation();

    public void changeLocation(SaveLocationChange var1) throws DownloadException;

    public Object getUserData(Object var1);

    public void setUserData(Object var1, Object var2);

    public void startDownload(boolean var1);

    public void stopDownload();

    public boolean canStubbify();

    public DownloadStub stubbify() throws DownloadException, DownloadRemovalVetoException;

    public List<DistributedDatabase> getDistributedDatabases();

    public DiskManagerFileInfo getPrimaryFile();

    public static interface SeedingRank {
        default public int getRank() {
            return 0;
        }

        default public long getLightSeedEligibility() {
            return Long.MAX_VALUE;
        }

        default public void setActivationStatus(String str) {
        }

        default public String[] getStatus(boolean verbose) {
            String[] stringArray = new String[2];
            stringArray[0] = "";
            return stringArray;
        }
    }
}

