/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.spi;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.I2PHelpers;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AENameServiceJava12 {
    private static boolean config_listener_added;
    private static volatile boolean tracker_dns_disabled;
    private static volatile boolean tracker_plugin_proxies_permit;
    private static boolean i2p_checked;

    static {
        i2p_checked = false;
    }

    public static boolean init() {
        try {
            Class<InetAddress> ia_class = InetAddress.class;
            Class<?> is_ns_class = Class.forName("java.net.InetAddress$NameService");
            Field ns_field = ia_class.getDeclaredField("nameService");
            NameServiceProxy my_proxy = new NameServiceProxy();
            Object ns_proxy = Proxy.newProxyInstance(is_ns_class.getClassLoader(), new Class[]{is_ns_class}, (InvocationHandler)my_proxy);
            ns_field.setAccessible(true);
            Object existing = ns_field.get(ia_class);
            if (existing == null) {
                throw new Exception("Existing name service is null");
            }
            my_proxy.setDelegate(existing);
            ns_field.set(ia_class, ns_proxy);
            return true;
        }
        catch (Throwable e) {
            if (!Constants.isAndroid) {
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkI2PInstall(final String host_name) {
        Class<AENameServiceJava12> clazz = AENameServiceJava12.class;
        synchronized (AENameServiceJava12.class) {
            if (i2p_checked) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                Core core = CoreFactory.getSingleton();
                if (core != null) {
                    i2p_checked = true;
                    PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
                    pi.addListener(new PluginAdapter(){

                        @Override
                        public void initializationComplete() {
                            if (I2PHelpers.isI2PInstalled()) {
                                return;
                            }
                            final boolean[] install_outcome = new boolean[1];
                            String enable_i2p_reason = MessageText.getString("azneti2phelper.install.reason.dns", new String[]{host_name});
                            I2PHelpers.installI2PHelper(enable_i2p_reason, "azneti2phelper.install.dns.resolve", install_outcome, new Runnable(){

                                @Override
                                public void run() {
                                    boolean cfr_ignored_0 = install_outcome[0];
                                }
                            });
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    private static class NameServiceProxy
    implements InvocationHandler {
        private Object delegate;

        private NameServiceProxy() {
        }

        private void setDelegate(Object _delegate) {
            this.delegate = _delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method delegate_method = this.delegate.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
            delegate_method.setAccessible(true);
            try {
                String method_name = method.getName();
                if (method_name.equals("lookupAllHostAddr")) {
                    boolean tracker_request;
                    String host_name = (String)args[0];
                    if (host_name.equals("http://dns.test.client.biglybittorrent.com/")) {
                        if (this.delegate == null) {
                            throw new RuntimeException("Delegate Name Service unavailable");
                        }
                        host_name = "www.google.com";
                        try {
                            Object object = delegate_method.invoke(this.delegate, host_name);
                        }
                        catch (Throwable e) {
                            if (e instanceof UnknownHostException) {
                                System.err.println("DNS resolution of " + host_name + " failed, DNS unavailable?");
                            }
                            throw new RuntimeException("Delegate lookup failed", e);
                        }
                        Class<?> ret_type = method.getReturnType();
                        if (ret_type.equals(byte[][].class)) {
                            byte[][] byArrayArray = new byte[1][];
                            byte[] byArray = new byte[4];
                            byArray[0] = 127;
                            byArray[3] = 1;
                            byArrayArray[0] = byArray;
                            return byArrayArray;
                        }
                        InetAddress[] inetAddressArray = new InetAddress[1];
                        byte[] byArray = new byte[4];
                        byArray[0] = 127;
                        byArray[3] = 1;
                        inetAddressArray[0] = InetAddress.getByAddress(byArray);
                        return inetAddressArray;
                    }
                    boolean bl = tracker_request = TorrentUtils.getTLSTorrentHash() != null;
                    if (tracker_request) {
                        NameServiceProxy nameServiceProxy = this;
                        synchronized (nameServiceProxy) {
                            if (!config_listener_added) {
                                config_listener_added = true;
                                COConfigurationManager.addAndFireListener(new COConfigurationListener(){

                                    @Override
                                    public void configurationSaved() {
                                        boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                                        boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                                        boolean prevent_dns = COConfigurationManager.getBooleanParameter("Proxy.SOCKS.Tracker.DNS.Disable");
                                        tracker_plugin_proxies_permit = enable_proxy && enable_socks && !COConfigurationManager.getBooleanParameter("Proxy.SOCKS.disable.plugin.proxies");
                                        tracker_dns_disabled = enable_proxy && enable_socks && prevent_dns;
                                    }
                                });
                            }
                        }
                        if (tracker_plugin_proxies_permit && AENetworkClassifier.categoriseAddress(host_name) != "Public") {
                            throw new RuntimeException("Plugin proxies enabled for SOCKS");
                        }
                        if (tracker_dns_disabled) {
                            throw new UnknownHostException(host_name);
                        }
                    }
                }
                return this.invokeSupport(delegate_method, method_name, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Object invokeSupport(Method delegate_method, String method_name, Object[] args) throws Throwable {
            if (method_name.equals("getHostByAddr")) {
                return delegate_method.invoke(this.delegate, args);
            }
            if (method_name.equals("lookupAllHostAddr")) {
                String host_name = (String)args[0];
                if (host_name != null && !host_name.equals("null")) {
                    if (host_name.endsWith(".i2p")) {
                        AENameServiceJava12.checkI2PInstall(host_name);
                        throw new UnknownHostException(host_name);
                    }
                    if (host_name.endsWith(".onion")) {
                        throw new UnknownHostException(host_name);
                    }
                }
                try {
                    return delegate_method.invoke(this.delegate, args);
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    if (target instanceof UnknownHostException) {
                        throw new InvocationTargetException(new UnknownHostException(host_name));
                    }
                    throw e;
                }
            }
            return delegate_method.invoke(this.delegate, args);
        }
    }
}

