/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.protocol.biglybt;

import com.biglybt.core.util.Constants;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pifimpl.update.sf.impl2.SFPluginDetailsLoaderImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BiglyBTURLConnection
extends HttpURLConnection {
    private static final boolean ONLY_VUZE_FILE = true;
    private final URL url;
    private int response_code = 200;
    private String response_msg = "OK";
    private InputStream input_stream;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    BiglyBTURLConnection(URL u) {
        super(u);
        this.url = u;
    }

    @Override
    public void connect() throws IOException {
        String str = this.url.toExternalForm();
        int pos = str.indexOf("body=");
        if (pos >= 0) {
            str = str.substring(pos + 5);
            byte[] bytes = str.getBytes(Constants.BYTE_ENCODING_CHARSET);
            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(bytes);
            if (vf == null) {
                throw new IOException("Invalid biglybt url");
            }
            this.input_stream = new ByteArrayInputStream(bytes);
        } else {
            String httpsURL;
            String host = this.url.getHost();
            if (host.equalsIgnoreCase("install-plugin") && this.url.getPath().length() > 1) {
                String plugin_id = this.url.getPath().substring(1);
                httpsURL = "https://plugins.biglybt.com/getplugin.php?plugin=" + plugin_id + "&" + SFPluginDetailsLoaderImpl.getBaseUrlParams();
            } else if (host.contains(".")) {
                httpsURL = "https" + str.substring("biglybt".length());
            } else {
                throw new IOException("Invalid biglybt url");
            }
            ResourceDownloader rd = StaticUtilities.getResourceDownloaderFactory().create(new URL(httpsURL));
            try {
                VuzeFileComponent[] components;
                VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(rd.download());
                if (vf == null) {
                    throw new IOException("Invalid biglybt url");
                }
                boolean hasPlugin = false;
                VuzeFileComponent[] vuzeFileComponentArray = components = vf.getComponents();
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    VuzeFileComponent component = vuzeFileComponentArray[n2];
                    if (component.getType() == 8) {
                        hasPlugin = true;
                        break;
                    }
                    ++n2;
                }
                if (!hasPlugin) {
                    throw new IOException("Biglybt url does not contain plugin");
                }
                this.input_stream = new ByteArrayInputStream(vf.exportToBytes());
            }
            catch (ResourceDownloaderException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public String getHeaderField(String name) {
        List<String> values = this.headers.get(name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(values.size() - 1);
    }

    public void setHeaderField(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.input_stream == null) {
            this.connect();
        }
        return this.input_stream;
    }

    public void setResponse(int _code, String _msg) {
        this.response_code = _code;
        this.response_msg = _msg;
    }

    @Override
    public int getResponseCode() {
        return this.response_code;
    }

    @Override
    public String getResponseMessage() {
        return this.response_msg;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void disconnect() {
    }
}

