/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.jar;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;

public class AEJarSigner2 {
    protected static Class JarSigner_class;
    protected final String keystore_name;
    protected final String keystore_password;
    protected final String alias;

    public AEJarSigner2(String _alias, String _keystore_name, String _keystore_password) {
        this.alias = _alias;
        this.keystore_name = _keystore_name;
        this.keystore_password = _keystore_password;
    }

    protected void loadJarSigner() throws IOException {
        File tools_dir;
        String manual_tools_dir = COConfigurationManager.getStringParameter("Security.JAR.tools.dir");
        if (manual_tools_dir.length() == 0) {
            String java_home = System.getProperty("java.home");
            File jh = new File(java_home);
            if (jh.getName().equalsIgnoreCase("jre")) {
                jh = jh.getParentFile();
            } else {
                String dir_name = jh.getName();
                if (dir_name.startsWith("jre")) {
                    dir_name = "jdk" + dir_name.substring(3);
                    jh = new File(jh.getParentFile(), dir_name);
                }
            }
            tools_dir = new File(jh, "lib");
        } else {
            tools_dir = new File(manual_tools_dir);
        }
        File tools_jar = new File(tools_dir, "tools.jar");
        if (tools_jar.exists()) {
            try {
                URLClassLoader cl = new URLClassLoader(new URL[]{tools_jar.toURI().toURL()}, AEJarSigner2.class.getClassLoader());
                JarSigner_class = cl.loadClass("sun.security.tools.JarSigner");
            }
            catch (Throwable e) {
                Logger.logTextResource(new LogAlert(false, 3, "Security.jar.signfail"), new String[]{e.getMessage()});
                Debug.printStackTrace(e);
                throw new IOException("JAR signing fails: " + e.getMessage());
            }
        } else {
            Logger.logTextResource(new LogAlert(false, 3, "Security.jar.tools_not_found"), new String[]{tools_dir.toString()});
            throw new IOException("JAR signing fails: tools.jar not found");
        }
    }

    protected void signJarFile(File input_file) throws IOException {
        String failure_msg;
        block13: {
            PrintStream old_out;
            PrintStream old_err;
            block12: {
                if (JarSigner_class == null) {
                    this.loadJarSigner();
                }
                old_err = null;
                old_out = null;
                failure_msg = null;
                try {
                    try {
                        Object jar_signer = JarSigner_class.newInstance();
                        String[] args = new String[]{"-keystore", this.keystore_name, "-storepass", this.keystore_password, input_file.toString(), this.alias};
                        old_err = System.err;
                        old_out = System.out;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(baos);
                        System.setErr(ps);
                        System.setOut(ps);
                        try {
                            JarSigner_class.getMethod("run", String[].class).invoke(jar_signer, new Object[]{args});
                        }
                        catch (Throwable e) {
                            ps.close();
                            String err_msg = baos.toString();
                            if (err_msg.length() > 0) {
                                failure_msg = err_msg;
                                break block12;
                            }
                            Debug.printStackTrace(e);
                            failure_msg = e.getMessage();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        failure_msg = e.getMessage();
                        if (old_err != null) {
                            System.setErr(old_err);
                            System.setOut(old_out);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (old_err != null) {
                        System.setErr(old_err);
                        System.setOut(old_out);
                    }
                    throw throwable;
                }
            }
            if (old_err != null) {
                System.setErr(old_err);
                System.setOut(old_out);
            }
        }
        if (failure_msg != null) {
            Debug.out("JAR signing fails '" + failure_msg + "'");
            Logger.logTextResource(new LogAlert(false, 3, "Security.jar.signfail"), new String[]{failure_msg});
            throw new IOException("JAR signing fails: " + failure_msg);
        }
    }

    public void signJarFile(File file, OutputStream os) throws IOException {
        this.signJarFile(file);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            FileUtil.copyFile(file, os, false);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void signJarStream(InputStream is, OutputStream os) throws IOException {
        File temp_file = AETemporaryFileHandler.createTempFile();
        FileOutputStream fos = null;
        try {
            int len;
            byte[] buffer = new byte[8192];
            fos = new FileOutputStream(temp_file);
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            fos = null;
            this.signJarFile(temp_file, os);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            temp_file.delete();
        }
    }
}

