/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeFormatter {
    public static final int TS_SECOND = 0;
    public static final int TS_MINUTE = 1;
    public static final int TS_HOUR = 2;
    public static final int TS_DAY = 3;
    public static final int TS_WEEK = 4;
    public static final int TS_MONTH = 5;
    public static final int TS_YEAR = 6;
    public static final String[] TIME_SUFFIXES = new String[]{"s", "m", "h", "d", "y"};
    public static final String[] TIME_SUFFIXES_2 = new String[]{"sec", "min", "hr", "day", "wk", "mo", "yr"};
    public static final String[] TIME_SUFFIXES_2_LONG = new String[]{"second", "minute", "hour", "day", "week", "month", "year"};
    public static final long[] TIME_SUFFIXES_2_MULT = new long[]{1L, 60L, 3600L, 86400L, 604800L, 2592000L, 31536000L};
    public static String MS_SUFFIX = " ms";
    public static final String[] DATEFORMATS_DESC;
    private static final SimpleDateFormat http_date_format;
    private static final SimpleDateFormat cookie_date_format;

    static {
        String[] defs = new String[]{"EEEE, MMMM d, yyyy GG", "EEEE, MMMM d, yyyy", "EEE, MMMM d, yyyy", "MMMM d, ''yy", "EEE, MMM d, ''yy", "MMM d, yyyy", "MMM d, ''yy", "yyyy/MM/dd", "''yy/MM/dd", "MMM dd", "MM/dd"};
        String formats = MessageText.getString("column.date.formats");
        if (formats != null) {
            String[] bits = formats.split(";");
            ArrayList<String> list = new ArrayList<String>(bits.length);
            String[] stringArray = bits;
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                if ((bit = bit.trim()).length() > 0) {
                    boolean added;
                    block9: {
                        added = false;
                        try {
                            new SimpleDateFormat(bit);
                            list.add(bit);
                            added = true;
                        }
                        catch (Throwable e) {
                            if (!bit.contains("'")) break block9;
                            bit = bit.replaceAll("'", "''");
                            try {
                                new SimpleDateFormat(bit);
                                list.add(bit);
                                added = true;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (!added) {
                        System.err.println("Invalid date format: " + bit);
                    }
                }
                ++n2;
            }
            DATEFORMATS_DESC = list.size() > 0 ? list.toArray(new String[list.size()]) : defs;
        } else {
            DATEFORMATS_DESC = defs;
        }
        http_date_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        http_date_format.setTimeZone(TimeZone.getTimeZone("GMT"));
        cookie_date_format = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        cookie_date_format.setTimeZone(TimeZone.getTimeZone("GMT"));
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                TimeFormatter.loadMessages();
            }
        });
    }

    public static String getShortSuffix(int unit) {
        return TIME_SUFFIXES[unit];
    }

    public static String getLongSuffix(int unit) {
        return TIME_SUFFIXES_2[unit];
    }

    private static void loadMessages() {
        TimeFormatter.TIME_SUFFIXES[0] = MessageText.getString("ConfigView.section.stats.seconds.short");
        TimeFormatter.TIME_SUFFIXES[1] = MessageText.getString("ConfigView.section.stats.minutes.short");
        TimeFormatter.TIME_SUFFIXES[2] = MessageText.getString("ConfigView.section.stats.hours.short");
        TimeFormatter.TIME_SUFFIXES[3] = MessageText.getString("ConfigView.section.stats.days.short");
        TimeFormatter.TIME_SUFFIXES[4] = MessageText.getString("ConfigView.section.stats.years.short");
        TimeFormatter.TIME_SUFFIXES_2[0] = MessageText.getString("ConfigView.section.stats.seconds");
        TimeFormatter.TIME_SUFFIXES_2[1] = MessageText.getString("ConfigView.section.stats.minutes");
        TimeFormatter.TIME_SUFFIXES_2[2] = MessageText.getString("ConfigView.section.stats.hours");
        TimeFormatter.TIME_SUFFIXES_2[3] = MessageText.getString("ConfigView.section.stats.days");
        TimeFormatter.TIME_SUFFIXES_2[4] = MessageText.getString("ConfigView.section.stats.weeks.medium");
        TimeFormatter.TIME_SUFFIXES_2[5] = MessageText.getString("ConfigView.section.stats.months.medium");
        TimeFormatter.TIME_SUFFIXES_2[6] = MessageText.getString("ConfigView.section.stats.years.medium");
        TimeFormatter.TIME_SUFFIXES_2_LONG[0] = MessageText.getString("ConfigView.section.stats.seconds.full");
        TimeFormatter.TIME_SUFFIXES_2_LONG[1] = MessageText.getString("ConfigView.section.stats.minutes.full");
        TimeFormatter.TIME_SUFFIXES_2_LONG[2] = MessageText.getString("ConfigView.section.stats.hours.full");
        TimeFormatter.TIME_SUFFIXES_2_LONG[3] = MessageText.getString("ConfigView.section.stats.days");
        TimeFormatter.TIME_SUFFIXES_2_LONG[4] = MessageText.getString("ConfigView.section.stats.weeks");
        TimeFormatter.TIME_SUFFIXES_2_LONG[5] = MessageText.getString("ConfigView.section.stats.months");
        TimeFormatter.TIME_SUFFIXES_2_LONG[6] = MessageText.getString("ConfigView.section.stats.years");
        MS_SUFFIX = " " + MessageText.getString("ConfigView.section.stats.millis.short");
    }

    public static String format(long time_secs) {
        if (time_secs == 31536000L || time_secs >= 1827387392L) {
            return "\u221e";
        }
        if (time_secs < 0L) {
            return "";
        }
        int[] vals = new int[]{(int)time_secs % 60, (int)(time_secs / 60L) % 60, (int)(time_secs / 3600L) % 24, (int)(time_secs / 86400L) % 365, (int)(time_secs / 31536000L)};
        int end = vals.length - 1;
        while (vals[end] == 0 && end > 0) {
            --end;
        }
        String result = String.valueOf(vals[end]) + TIME_SUFFIXES[end];
        if (--end >= 0) {
            result = String.valueOf(result) + " " + TimeFormatter.twoDigits(vals[end]) + TIME_SUFFIXES[end];
        }
        return result;
    }

    public static String format2(long time_secs, boolean do_seconds) {
        int end;
        if (time_secs == 31536000L || time_secs >= 1827387392L) {
            return "\u221e";
        }
        if (time_secs < 0L) {
            return "";
        }
        int[] vals = new int[]{(int)time_secs % 60, (int)(time_secs / 60L) % 60, (int)(time_secs / 3600L) % 24, (int)(time_secs / 86400L) % 365, (int)(time_secs / 31536000L)};
        int start = vals.length - 1;
        while (vals[start] == 0 && start > 0) {
            --start;
        }
        int n = end = do_seconds ? 0 : 1;
        if (start == 0 && !do_seconds) {
            start = 1;
        }
        String result = "";
        int i = start;
        while (i >= end) {
            result = String.valueOf(result) + (i == start ? Integer.valueOf(vals[i]) : " " + TimeFormatter.twoDigits(vals[i])) + TIME_SUFFIXES[i];
            --i;
        }
        return result;
    }

    public static String format3(long time_secs) {
        return TimeFormatter.format3(time_secs, null);
    }

    public static String format3(long time_secs, long[] sort_time) {
        return TimeFormatter.format3(time_secs, sort_time, false);
    }

    public static String format3(long time_secs, long[] sort_time, boolean flexible) {
        int[] temp = TimeFormatter.format3Support(time_secs, sort_time, flexible);
        int val = temp[0];
        if (val == -1) {
            return "\u221e";
        }
        if (val == -2) {
            return "";
        }
        String result = String.valueOf(val) + " " + TIME_SUFFIXES_2[temp[1]];
        return result;
    }

    public static int[] format3Support(long time_secs, long[] sort_time) {
        return TimeFormatter.format3Support(time_secs, sort_time, false);
    }

    public static int[] format3Support(long time_secs, long[] sort_time, boolean flexible) {
        int unit_val;
        int unit_index;
        if (time_secs == 31536000L || time_secs >= 1827387392L) {
            int[] nArray = new int[2];
            nArray[0] = -1;
            return nArray;
        }
        if (time_secs < 0L) {
            int[] nArray = new int[2];
            nArray[0] = -2;
            return nArray;
        }
        if (flexible) {
            long rem;
            long val;
            int[] vals = new int[]{(int)time_secs, (int)(time_secs / 60L), (int)(time_secs / 3600L), (int)(time_secs / 86400L), (int)(time_secs / 604800L), (int)(time_secs / 2592000L), (int)(time_secs / 31536000L)};
            int[] val_max = new int[]{60, 240, 96, 90, 104, Integer.MAX_VALUE};
            for (unit_index = TIME_SUFFIXES_2.length - 1; ((val = (long)vals[unit_index]) == 0L || (rem = time_secs - val * TIME_SUFFIXES_2_MULT[unit_index]) != 0L && (unit_index <= 0 || vals[unit_index - 1] < val_max[unit_index - 1])) && unit_index > 0; --unit_index) {
            }
            unit_val = vals[unit_index];
        } else {
            int[] vals = new int[]{(int)time_secs, (int)(time_secs / 60L), (int)(time_secs / 3600L), (int)(time_secs / 86400L), (int)(time_secs / 604800L), (int)(time_secs / 2592000L), (int)(time_secs / 31536000L)};
            while (vals[unit_index] == 0 && unit_index > 0) {
                --unit_index;
            }
            unit_val = vals[unit_index];
        }
        if (sort_time != null) {
            sort_time[0] = (long)unit_val * TIME_SUFFIXES_2_MULT[unit_index];
        }
        return new int[]{unit_val, unit_index};
    }

    public static String format100ths(long time_millis) {
        long time_secs = time_millis / 1000L;
        int hundredths = (int)(time_millis - time_secs * 1000L) / 10;
        if (time_millis == 0L || time_secs >= 60L) {
            return TimeFormatter.format(time_secs);
        }
        return String.valueOf(time_secs) + "." + TimeFormatter.twoDigits(hundredths) + TIME_SUFFIXES[0];
    }

    public static String formatColonMillis(long time) {
        String str;
        if (time > 0L) {
            time = time < 1000L ? 1L : (time /= 1000L);
        }
        if ((str = TimeFormatter.formatColon(time)).startsWith("00:")) {
            str = str.substring(3);
        }
        return str;
    }

    public static String formatColon(long time) {
        if (time == 31536000L || time >= 1827387392L) {
            return "\u221e";
        }
        if (time < 0L) {
            return "";
        }
        int secs = (int)time % 60;
        int mins = (int)(time / 60L) % 60;
        int hours = (int)(time / 3600L) % 24;
        int days = (int)(time / 86400L) % 365;
        int years = (int)(time / 31536000L);
        String result = "";
        if (years > 0) {
            result = String.valueOf(result) + years + "y ";
        }
        if (years > 0 || days > 0) {
            result = String.valueOf(result) + days + "d ";
        }
        result = String.valueOf(result) + TimeFormatter.twoDigits(hours) + ":" + TimeFormatter.twoDigits(mins) + ":" + TimeFormatter.twoDigits(secs);
        return result;
    }

    private static String twoDigits(int i) {
        return i < 10 ? "0" + i : String.valueOf(i);
    }

    public static int parseColon(String str) {
        int[] multipliers = new int[]{1, 60, 3600, 86400, 31536000};
        String[] bits = str.split(":");
        int result = 0;
        int i = 0;
        while (i < bits.length) {
            String bit = bits[bits.length - (i + 1)].trim();
            if (bit.length() > 0) {
                result += multipliers[i] * Integer.parseInt(bit);
            }
            ++i;
        }
        return result;
    }

    public static String formatNanoAsMilli(long nanos) {
        long truncator = 60000000000L;
        nanos -= nanos / 60000000000L * 60000000000L;
        return String.valueOf(String.valueOf((double)nanos / 1000000.0)) + MS_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHTTPDate(long millis) {
        SimpleDateFormat simpleDateFormat = http_date_format;
        synchronized (simpleDateFormat) {
            return http_date_format.format(new Date(millis));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseHTTPDate(String date) {
        try {
            SimpleDateFormat simpleDateFormat = http_date_format;
            synchronized (simpleDateFormat) {
                return http_date_format.parse(date).getTime();
            }
        }
        catch (Throwable e) {
            Debug.out("Failed to parse HTTP date '" + date + "'");
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCookieDate(long millis) {
        SimpleDateFormat simpleDateFormat = cookie_date_format;
        synchronized (simpleDateFormat) {
            return cookie_date_format.format(new Date(millis));
        }
    }

    public static String milliStamp() {
        long nanos = SystemTime.getHighPrecisionCounter();
        long truncator = 60000000000L;
        nanos -= nanos / 60000000000L * 60000000000L;
        String str = String.valueOf(nanos / 1000000L);
        while (str.length() < 5) {
            str = "0" + str;
        }
        return String.valueOf(str) + ": ";
    }

    public static void milliTrace(String str) {
        System.out.println(String.valueOf(TimeFormatter.milliStamp()) + str);
    }
}

