/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.SHA1;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class SHA1Hasher {
    private static final boolean use_digest;
    private final Impl impl;

    static {
        boolean ud;
        try {
            new DigestImpl();
            ud = true;
        }
        catch (Throwable e) {
            ud = false;
        }
        use_digest = ud;
    }

    public SHA1Hasher() {
        if (use_digest) {
            Impl i;
            try {
                i = new DigestImpl();
            }
            catch (Throwable e) {
                i = new LocalImpl();
            }
            this.impl = i;
        } else {
            this.impl = new LocalImpl();
        }
    }

    public byte[] calculateHash(byte[] bytes) {
        return this.impl.calculateHash(bytes);
    }

    public byte[] calculateHash(ByteBuffer buffer) {
        return this.impl.calculateHash(buffer);
    }

    public void update(byte[] data) {
        this.impl.update(data);
    }

    public void update(byte[] data, int pos, int len) {
        this.impl.update(data, pos, len);
    }

    public byte[] getDigest() {
        return this.impl.getDigest();
    }

    private static class DigestImpl
    implements Impl {
        private final MessageDigest md = MessageDigest.getInstance("SHA-1");

        private DigestImpl() throws NoSuchAlgorithmException {
        }

        @Override
        public byte[] calculateHash(byte[] bytes) {
            this.md.reset();
            this.md.update(bytes);
            return this.md.digest();
        }

        @Override
        public byte[] calculateHash(ByteBuffer buffer) {
            this.md.reset();
            this.md.update(buffer);
            return this.md.digest();
        }

        @Override
        public void update(byte[] data) {
            this.md.update(data);
        }

        @Override
        public void update(byte[] data, int pos, int len) {
            this.md.update(data, pos, len);
        }

        @Override
        public byte[] getDigest() {
            return this.md.digest();
        }
    }

    private static interface Impl {
        public byte[] calculateHash(byte[] var1);

        public byte[] calculateHash(ByteBuffer var1);

        public void update(byte[] var1);

        public void update(byte[] var1, int var2, int var3);

        public byte[] getDigest();
    }

    private static class LocalImpl
    implements Impl {
        private final SHA1 sha1 = new SHA1();

        private LocalImpl() {
        }

        @Override
        public byte[] calculateHash(byte[] bytes) {
            ByteBuffer buff = ByteBuffer.wrap(bytes);
            return this.calculateHash(buff);
        }

        @Override
        public byte[] calculateHash(ByteBuffer buffer) {
            this.sha1.reset();
            return this.sha1.digest(buffer);
        }

        @Override
        public void update(byte[] data) {
            this.update(ByteBuffer.wrap(data));
        }

        @Override
        public void update(byte[] data, int pos, int len) {
            this.update(ByteBuffer.wrap(data, pos, len));
        }

        public void update(ByteBuffer buffer) {
            this.sha1.update(buffer);
        }

        @Override
        public byte[] getDigest() {
            return this.sha1.digest();
        }
    }
}

