/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import java.nio.ByteBuffer;

public class ReferenceCountedDirectByteBuffer
extends DirectByteBuffer {
    private DirectByteBuffer basis;
    private int ref_count = 1;

    protected ReferenceCountedDirectByteBuffer(DirectByteBuffer _basis) {
        this(_basis.getBufferInternal());
        this.basis = _basis;
    }

    protected ReferenceCountedDirectByteBuffer(ByteBuffer _buffer) {
        super(_buffer);
    }

    public ReferenceCountedDirectByteBuffer duplicate(int offset, int length) {
        ByteBuffer duplicate = this.getBufferInternal().duplicate();
        duplicate.position(duplicate.position() + offset);
        duplicate.limit(duplicate.position() + length);
        ReferenceCountedDirectByteBufferDuplicate res = new ReferenceCountedDirectByteBufferDuplicate(duplicate);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReferenceCount() {
        ReferenceCountedDirectByteBuffer referenceCountedDirectByteBuffer = this;
        synchronized (referenceCountedDirectByteBuffer) {
            ++this.ref_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementReferenceCount() {
        ReferenceCountedDirectByteBuffer referenceCountedDirectByteBuffer = this;
        synchronized (referenceCountedDirectByteBuffer) {
            --this.ref_count;
            if (this.ref_count == 0) {
                this.basis.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReferenceCount() {
        ReferenceCountedDirectByteBuffer referenceCountedDirectByteBuffer = this;
        synchronized (referenceCountedDirectByteBuffer) {
            return this.ref_count;
        }
    }

    @Override
    public void returnToPool() {
        this.decrementReferenceCount();
    }

    protected class ReferenceCountedDirectByteBufferDuplicate
    extends ReferenceCountedDirectByteBuffer {
        protected ReferenceCountedDirectByteBufferDuplicate(ByteBuffer owner) {
            super(owner);
            this.incrementReferenceCount();
        }

        @Override
        public ReferenceCountedDirectByteBuffer duplicate(int offset, int length) {
            Debug.out("dup dup");
            return null;
        }

        @Override
        public void returnToPool() {
            this.decrementReferenceCount();
        }

        @Override
        public void incrementReferenceCount() {
            ReferenceCountedDirectByteBuffer.this.incrementReferenceCount();
        }

        @Override
        public void decrementReferenceCount() {
            ReferenceCountedDirectByteBuffer.this.decrementReferenceCount();
        }
    }
}

