/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.NonDaemonTask;
import java.util.ArrayList;
import java.util.List;

public class NonDaemonTaskRunner {
    public static final int LINGER_PERIOD = 2500;
    protected static NonDaemonTaskRunner singleton;
    protected static final AEMonitor class_mon;
    protected final List<taskWrapper> tasks = new ArrayList<taskWrapper>();
    protected final AEMonitor tasks_mon = new AEMonitor("NonDaemonTaskRunner:tasks");
    protected final AESemaphore task_sem = new AESemaphore("NonDaemonTaskRunner");
    protected final List<AESemaphore> wait_until_idle_list = new ArrayList<AESemaphore>();
    protected AEThread2 current_thread;

    static {
        class_mon = new AEMonitor("NonDaemonTaskRunner:class");
    }

    protected static NonDaemonTaskRunner getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new NonDaemonTaskRunner();
            }
            NonDaemonTaskRunner nonDaemonTaskRunner = singleton;
            return nonDaemonTaskRunner;
        }
        finally {
            class_mon.exit();
        }
    }

    public static Object run(NonDaemonTask target) throws Throwable {
        return NonDaemonTaskRunner.getSingleton().runSupport(target);
    }

    protected Object runSupport(NonDaemonTask target) throws Throwable {
        boolean run_now;
        try {
            this.tasks_mon.enter();
            run_now = this.current_thread != null && this.current_thread.isCurrentThread();
        }
        finally {
            this.tasks_mon.exit();
        }
        if (run_now) {
            return target.run();
        }
        taskWrapper wrapper2 = new taskWrapper(target);
        try {
            this.tasks_mon.enter();
            this.tasks.add(wrapper2);
            this.task_sem.release();
            if (this.current_thread == null) {
                final AESemaphore wait_sem = new AESemaphore("NonDaemonTaskRunnerTask: " + target.getName());
                this.current_thread = new AEThread2("NonDaemonTaskRunner", false){

                    @Override
                    public void run() {
                        wait_sem.release();
                        while (true) {
                            NonDaemonTaskRunner.this.task_sem.reserve(2500L);
                            taskWrapper t = null;
                            try {
                                NonDaemonTaskRunner.this.tasks_mon.enter();
                                if (NonDaemonTaskRunner.this.tasks.isEmpty()) {
                                    NonDaemonTaskRunner.this.current_thread = null;
                                    int i = 0;
                                    while (i < NonDaemonTaskRunner.this.wait_until_idle_list.size()) {
                                        NonDaemonTaskRunner.this.wait_until_idle_list.get(i).release();
                                        ++i;
                                    }
                                    NonDaemonTaskRunner.this.wait_until_idle_list.clear();
                                    break;
                                }
                                t = NonDaemonTaskRunner.this.tasks.remove(0);
                            }
                            finally {
                                NonDaemonTaskRunner.this.tasks_mon.exit();
                            }
                            t.run();
                        }
                    }
                };
                this.current_thread.start();
                wait_sem.reserve();
            }
        }
        finally {
            this.tasks_mon.exit();
        }
        return wrapper2.waitForResult();
    }

    public static void waitUntilIdle() {
        NonDaemonTaskRunner.getSingleton().waitUntilIdleSupport();
    }

    protected void waitUntilIdleSupport() {
        AESemaphore sem;
        String str;
        try {
            this.tasks_mon.enter();
            if (Logger.isEnabled()) {
                str = "";
                for (taskWrapper t : this.tasks) {
                    str = String.valueOf(str) + (str.isEmpty() ? "" : ",") + t.getName();
                }
                Logger.log(new LogEvent(LogIDs.CORE, "Non-daemon wait for idle: thread=" + this.current_thread + ", tasks=" + str));
            }
            if (this.current_thread == null) {
                return;
            }
            sem = new AESemaphore("NDTR::idleWaiter");
            this.wait_until_idle_list.add(sem);
        }
        finally {
            this.tasks_mon.exit();
        }
        while (!sem.reserve(2500L)) {
            if (!Logger.isEnabled()) continue;
            try {
                this.tasks_mon.enter();
                str = "";
                for (taskWrapper t : this.tasks) {
                    str = String.valueOf(str) + (str.isEmpty() ? "" : ",") + t.getName();
                }
                Logger.log(new LogEvent(LogIDs.CORE, "Non-daemon wait for idle 2: thread=" + this.current_thread + ", tasks=" + str));
                int i = 0;
                while (i < this.wait_until_idle_list.size()) {
                    AESemaphore pending = this.wait_until_idle_list.get(i);
                    if (pending != sem) {
                        Logger.log(new LogEvent(LogIDs.CORE, "Waiting for " + pending.getName() + " to complete"));
                    }
                    ++i;
                }
            }
            finally {
                this.tasks_mon.exit();
            }
        }
    }

    protected static class taskWrapper {
        protected final NonDaemonTask task;
        protected final AESemaphore sem;
        protected Object result;
        protected Throwable exception;

        protected taskWrapper(NonDaemonTask _task) {
            this.task = _task;
            this.sem = new AESemaphore("NonDaemonTaskRunner::taskWrapper");
        }

        protected void run() {
            try {
                try {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LogIDs.CORE, "Starting non-daemon task: " + this.task.getName()));
                    }
                    this.result = this.task.run();
                }
                catch (Throwable e) {
                    this.exception = e;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LogIDs.CORE, "Completed non-daemon task: " + this.task.getName()));
                    }
                    this.sem.release();
                }
            }
            finally {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LogIDs.CORE, "Completed non-daemon task: " + this.task.getName()));
                }
                this.sem.release();
            }
        }

        protected Object waitForResult() throws Throwable {
            this.sem.reserve();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        protected String getName() {
            return this.task.getName();
        }
    }
}

