/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DirectByteBufferPoolReal
extends DirectByteBufferPool {
    private static final boolean disable_gc;
    protected static final boolean DEBUG_TRACK_HANDEDOUT = false;
    protected static final boolean DEBUG_PRINT_MEM = false;
    protected static final int DEBUG_PRINT_TIME = 120000;
    protected static final boolean DEBUG_HANDOUT_SIZES = false;
    protected static final boolean DEBUG_FREE_SIZES = false;
    private static final int START_POWER = 12;
    private static final int END_POWER = 28;
    private static final int[] EXTRA_BUCKETS;
    public static final int MAX_SIZE;
    private final Map buffersMap = new LinkedHashMap(17);
    private final Object poolsLock = new Object();
    private static final int SLICE_END_SIZE = 2048;
    private static final int SLICE_ALLOC_CHUNK_SIZE = 4096;
    private static final short[] SLICE_ENTRY_SIZES;
    private static final short[] SLICE_ALLOC_MAXS;
    private static final short[] SLICE_ENTRY_ALLOC_SIZES;
    private static final List[] slice_entries;
    private static final boolean[][] slice_allocs;
    private static final boolean[] slice_alloc_fails;
    private static final long[] slice_use_count;
    private final Map handed_out = new IdentityHashMap();
    private final Map size_counts = new TreeMap();
    private static final long COMPACTION_CHECK_PERIOD = 120000L;
    private static final long MAX_FREE_BYTES = 0xA00000L;
    private static final long MIN_FREE_BYTES = 0x100000L;
    private long bytesIn = 0L;
    private long bytesOut = 0L;

    static {
        int i;
        disable_gc = System.getProperty("az.disable.explicit.gc", "0").equals("1");
        if (disable_gc) {
            System.out.println("Explicit GC disabled");
        }
        EXTRA_BUCKETS = new int[]{16512};
        MAX_SIZE = BigInteger.valueOf(2L).pow(28).intValue();
        SLICE_ENTRY_SIZES = new short[]{8, 16, 32, 64, 128, 256, 512, 1024, 2048};
        SLICE_ALLOC_MAXS = new short[]{256, 256, 128, 64, 64, 64, 64, 64, 64};
        SLICE_ENTRY_ALLOC_SIZES = new short[SLICE_ENTRY_SIZES.length];
        slice_entries = new List[SLICE_ENTRY_SIZES.length];
        slice_allocs = new boolean[SLICE_ENTRY_SIZES.length][];
        slice_alloc_fails = new boolean[SLICE_ENTRY_SIZES.length];
        int mult = COConfigurationManager.getIntParameter("memory.slice.limit.multiplier");
        if (mult > 1) {
            i = 0;
            while (i < SLICE_ALLOC_MAXS.length) {
                int n = i++;
                SLICE_ALLOC_MAXS[n] = (short)(SLICE_ALLOC_MAXS[n] * mult);
            }
        }
        i = 0;
        while (i < SLICE_ENTRY_SIZES.length) {
            DirectByteBufferPoolReal.SLICE_ENTRY_ALLOC_SIZES[i] = (short)(4096 / SLICE_ENTRY_SIZES[i]);
            DirectByteBufferPoolReal.slice_allocs[i] = new boolean[SLICE_ALLOC_MAXS[i]];
            DirectByteBufferPoolReal.slice_entries[i] = new LinkedList();
            ++i;
        }
        slice_use_count = new long[SLICE_ENTRY_SIZES.length];
    }

    protected DirectByteBufferPoolReal() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int p = 12;
        while (p <= 28) {
            list.add(new Integer(BigInteger.valueOf(2L).pow(p).intValue()));
            ++p;
        }
        int i = 0;
        while (i < EXTRA_BUCKETS.length) {
            list.add(new Integer(EXTRA_BUCKETS[i]));
            ++i;
        }
        Object[] sizes = new Integer[list.size()];
        list.toArray(sizes);
        Arrays.sort(sizes);
        int i2 = 0;
        while (i2 < sizes.length) {
            ArrayList bufferPool = new ArrayList();
            this.buffersMap.put(sizes[i2], bufferPool);
            ++i2;
        }
        SimpleTimer.addPeriodicEvent("DirectBB:compact", 120000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent ev) {
                DirectByteBufferPoolReal.this.compactBuffers();
            }
        });
    }

    private ByteBuffer allocateNewBuffer(int _size) {
        try {
            return ByteBuffer.allocateDirect(_size);
        }
        catch (OutOfMemoryError e) {
            this.clearBufferPools();
            this.runGarbageCollection();
            try {
                return ByteBuffer.allocateDirect(_size);
            }
            catch (OutOfMemoryError ex) {
                String msg = "Memory allocation failed: Out of direct memory space.\nTo fix: Use the -XX:MaxDirectMemorySize=512m command line option,\nor upgrade your Java JRE to version 1.4.2_05 or 1.5 series or newer.";
                Debug.out(msg);
                Logger.log(new LogAlert(false, 3, msg));
                this.printInUse(true);
                throw ex;
            }
        }
    }

    @Override
    protected DirectByteBuffer getBufferSupport(byte _allocator, int _length) {
        if (_length < 1) {
            Debug.out("requested length [" + _length + "] < 1");
            return null;
        }
        if (_length > MAX_SIZE) {
            Debug.out("requested length [" + _length + "] > MAX_SIZE [" + MAX_SIZE + "]");
            return null;
        }
        return this.getBufferHelper(_allocator, _length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectByteBuffer getBufferHelper(byte _allocator, int _length) {
        ByteBuffer buff;
        DirectByteBuffer res;
        if (_length <= 2048) {
            res = this.getSliceBuffer(_allocator, _length);
        } else {
            buff = null;
            Integer reqVal = new Integer(_length);
            block6: for (Integer keyVal : this.buffersMap.keySet()) {
                if (reqVal.compareTo(keyVal) > 0) continue;
                ArrayList bufferPool = (ArrayList)this.buffersMap.get(keyVal);
                while (true) {
                    Object object = this.poolsLock;
                    synchronized (object) {
                        if (bufferPool.isEmpty()) {
                            buff = this.allocateNewBuffer(keyVal);
                            if (buff == null) {
                                Debug.out("allocateNewBuffer for " + _length + " returned null");
                            }
                            break block6;
                        }
                        ArrayList arrayList = bufferPool;
                        synchronized (arrayList) {
                            buff = (ByteBuffer)bufferPool.remove(bufferPool.size() - 1);
                        }
                        if (buff != null) {
                            break block6;
                        }
                        Debug.out("buffer pool for " + _length + " contained null entry");
                    }
                }
            }
            if (buff == null) {
                String str = "Unable to find an appropriate buffer pool for " + _length;
                Debug.out(str);
                throw new RuntimeException(str);
            }
            res = new DirectByteBuffer(_allocator, buff, this);
        }
        buff = res.getBufferInternal();
        buff.clear();
        buff.limit(_length);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void returnBufferSupport(DirectByteBuffer ddb) {
        ByteBuffer buff = ddb.getBufferInternal();
        if (buff == null) {
            Debug.out("Returned dbb has null delegate");
            throw new RuntimeException("Returned dbb has null delegate");
        }
        int capacity = buff.capacity();
        if (capacity <= 2048) {
            this.freeSliceBuffer(ddb);
        } else {
            Integer buffSize = new Integer(capacity);
            ArrayList bufferPool = (ArrayList)this.buffersMap.get(buffSize);
            if (bufferPool != null) {
                ArrayList arrayList = bufferPool;
                synchronized (arrayList) {
                    bufferPool.add(buff);
                }
            } else {
                Debug.out("Invalid buffer given; could not find proper buffer pool");
            }
        }
    }

    private void clearBufferPools() {
        for (ArrayList bufferPool : this.buffersMap.values()) {
            bufferPool.clear();
        }
    }

    private void runGarbageCollection() {
        if (!disable_gc) {
            System.runFinalization();
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactBuffers() {
        Object object = this.poolsLock;
        synchronized (object) {
            long freeSize = this.bytesFree();
            if (freeSize < 0x100000L) {
            } else {
                float remainingFactor = freeSize > 0xA00000L ? 5242880.0f / (float)freeSize : 1.0f - 0.5f * (float)freeSize / 1.048576E7f;
                ArrayList pools = new ArrayList(this.buffersMap.values());
                int i = pools.size() - 1;
                while (i >= 0) {
                    ArrayList pool = (ArrayList)pools.get(i);
                    int limit = (int)((float)pool.size() * remainingFactor);
                    int j = pool.size() - 1;
                    while (j >= limit) {
                        pool.remove(j);
                        --j;
                    }
                    --i;
                }
                this.runGarbageCollection();
            }
        }
        this.compactSlices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long bytesFree() {
        long bytesUsed = 0L;
        Object object = this.poolsLock;
        synchronized (object) {
            for (Integer keyVal : this.buffersMap.keySet()) {
                ArrayList bufferPool = (ArrayList)this.buffersMap.get(keyVal);
                bytesUsed += (long)(keyVal * bufferPool.size());
            }
        }
        return bytesUsed;
    }

    private void printInUse(boolean verbose) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectByteBuffer getSliceBuffer(byte _allocator, int _length) {
        List my_slice_entries;
        int slice_index = this.getSliceIndex(_length);
        List list = my_slice_entries = slice_entries[slice_index];
        synchronized (list) {
            boolean[] my_allocs = slice_allocs[slice_index];
            sliceBuffer sb = null;
            if (my_slice_entries.size() > 0) {
                sb = (sliceBuffer)my_slice_entries.remove(0);
                int n = slice_index;
                slice_use_count[n] = slice_use_count[n] + 1L;
            } else {
                short slot = -1;
                short i = 0;
                while (i < my_allocs.length) {
                    if (!my_allocs[i]) {
                        slot = i;
                        break;
                    }
                    i = (short)(i + 1);
                }
                if (slot != -1) {
                    short slice_entry_size = SLICE_ENTRY_SIZES[slice_index];
                    short slice_entry_count = SLICE_ENTRY_ALLOC_SIZES[slice_index];
                    ByteBuffer chunk = ByteBuffer.allocateDirect(slice_entry_size * slice_entry_count);
                    my_allocs[slot] = true;
                    short i2 = 0;
                    while (i2 < slice_entry_count) {
                        chunk.limit((i2 + 1) * slice_entry_size);
                        chunk.position(i2 * slice_entry_size);
                        ByteBuffer slice = chunk.slice();
                        sliceBuffer new_buffer = new sliceBuffer(slice, slot, i2);
                        if (i2 == 0) {
                            sb = new_buffer;
                            int n = slice_index;
                            slice_use_count[n] = slice_use_count[n] + 1L;
                        } else {
                            my_slice_entries.add(new_buffer);
                        }
                        i2 = (short)(i2 + 1);
                    }
                } else {
                    if (!slice_alloc_fails[slice_index]) {
                        DirectByteBufferPoolReal.slice_alloc_fails[slice_index] = true;
                        Debug.out("Run out of slice space for '" + SLICE_ENTRY_SIZES[slice_index] + ", reverting to normal allocation");
                    }
                    ByteBuffer buff = ByteBuffer.allocate(_length);
                    return new DirectByteBuffer(_allocator, buff, this);
                }
            }
            sliceDBB dbb = new sliceDBB(this, _allocator, sb);
            return dbb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSliceBuffer(DirectByteBuffer ddb) {
        if (ddb instanceof sliceDBB) {
            List my_slice_entries;
            int slice_index = this.getSliceIndex(ddb.getBufferInternal().capacity());
            List list = my_slice_entries = slice_entries[slice_index];
            synchronized (list) {
                my_slice_entries.add(0, ((sliceDBB)ddb).getSliceBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactSlices() {
        int i = 0;
        while (i < slice_entries.length) {
            int entries_per_alloc = SLICE_ENTRY_ALLOC_SIZES[i];
            List l = slice_entries[i];
            if (l.size() >= entries_per_alloc) {
                List list = l;
                synchronized (list) {
                    sliceBuffer sb;
                    Collections.sort(l, new Comparator<sliceBuffer>(){

                        @Override
                        public int compare(sliceBuffer sb1, sliceBuffer sb2) {
                            int res = sb1.getAllocID() - sb2.getAllocID();
                            if (res == 0) {
                                res = sb1.getSliceID() - sb2.getSliceID();
                            }
                            return res;
                        }
                    });
                    boolean[] allocs = slice_allocs[i];
                    Iterator it = l.iterator();
                    short current_alloc = -1;
                    int entry_count = 0;
                    boolean freed_one = false;
                    while (it.hasNext()) {
                        sb = (sliceBuffer)it.next();
                        short aid = sb.getAllocID();
                        if (aid != current_alloc) {
                            if (entry_count == entries_per_alloc) {
                                freed_one = true;
                                allocs[aid] = false;
                            }
                            current_alloc = aid;
                            entry_count = 1;
                            continue;
                        }
                        ++entry_count;
                    }
                    if (entry_count == entries_per_alloc) {
                        freed_one = true;
                        allocs[current_alloc] = false;
                    }
                    if (freed_one) {
                        it = l.iterator();
                        while (it.hasNext()) {
                            sb = (sliceBuffer)it.next();
                            if (allocs[sb.getAllocID()]) continue;
                            it.remove();
                        }
                    }
                }
            }
            ++i;
        }
    }

    private int getSliceIndex(int _length) {
        int i = 0;
        while (i < SLICE_ENTRY_SIZES.length) {
            if (_length <= SLICE_ENTRY_SIZES[i]) {
                return i;
            }
            ++i;
        }
        Debug.out("eh?");
        return 0;
    }

    private static class myInteger {
        int value;

        private myInteger() {
        }
    }

    private static class sliceBuffer {
        private final ByteBuffer buffer;
        private final short alloc_id;
        private final short slice_id;

        protected sliceBuffer(ByteBuffer _buffer, short _alloc_id, short _slice_id) {
            this.buffer = _buffer;
            this.alloc_id = _alloc_id;
            this.slice_id = _slice_id;
        }

        protected ByteBuffer getBuffer() {
            return this.buffer;
        }

        protected short getAllocID() {
            return this.alloc_id;
        }

        protected short getSliceID() {
            return this.slice_id;
        }
    }

    private static class sliceDBB
    extends DirectByteBuffer {
        private final sliceBuffer slice_buffer;

        protected sliceDBB(DirectByteBufferPoolReal _pool, byte _allocator, sliceBuffer _sb) {
            super(_allocator, _sb.getBuffer(), _pool);
            this.slice_buffer = _sb;
        }

        protected sliceBuffer getSliceBuffer() {
            return this.slice_buffer;
        }
    }
}

