/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.IdentityHashSet;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CopyOnWriteSet<T>
implements Iterable<T> {
    private final boolean is_identify;
    private volatile Set<T> set;
    private boolean visible = false;

    public CopyOnWriteSet(boolean identity_hash_set) {
        this.is_identify = identity_hash_set;
        this.set = this.is_identify ? new IdentityHashSet<T>() : new HashSet<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T o) {
        boolean result;
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            block6: {
                if (!this.set.contains(o)) break block6;
                return false;
            }
            if (this.visible) {
                AbstractSet new_set = this.is_identify ? new IdentityHashSet<T>(this.set) : new HashSet<T>(this.set);
                result = new_set.add(o);
                this.set = new_set;
                this.visible = false;
            } else {
                result = this.set.add(o);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<T> to_add) {
        boolean result;
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            block6: {
                if (!this.set.containsAll(to_add)) break block6;
                return false;
            }
            if (this.visible) {
                AbstractSet new_set = this.is_identify ? new IdentityHashSet<T>(this.set) : new HashSet<T>(this.set);
                result = new_set.addAll(to_add);
                this.set = new_set;
                this.visible = false;
            } else {
                result = this.set.addAll(to_add);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(T o) {
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            if (!this.visible) {
                return this.set.remove(o);
            }
            if (!this.set.contains(o)) {
                return false;
            }
            AbstractSet new_set = this.is_identify ? new IdentityHashSet<T>(this.set) : new HashSet<T>(this.set);
            boolean res = new_set.remove(o);
            this.set = new_set;
            this.visible = false;
            return res;
        }
    }

    public boolean contains(T o) {
        return this.set.contains(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            if (this.visible) {
                AbstractSet new_set = this.is_identify ? new IdentityHashSet<T>(this.set) : new HashSet<T>(this.set);
                this.set = new_set;
                this.visible = false;
            } else {
                this.set.clear();
            }
        }
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public int size() {
        return this.set.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getSet() {
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            this.visible = true;
            return this.set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            this.visible = true;
            return new CopyOnWriteSetIterator(this.set.iterator());
        }
    }

    private class CopyOnWriteSetIterator
    implements Iterator<T> {
        private final Iterator<T> it;
        private T last;

        protected CopyOnWriteSetIterator(Iterator<T> _it) {
            this.it = _it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteSet.this.remove(this.last);
        }
    }
}

