/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.server.impl.tcp;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.tracker.server.TRTrackerServerException;
import com.biglybt.core.tracker.server.TRTrackerServerListener2;
import com.biglybt.core.tracker.server.impl.TRTrackerServerImpl;
import com.biglybt.core.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AsyncController;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class TRTrackerServerTCP
extends TRTrackerServerImpl {
    private static final int THREAD_POOL_SIZE = Math.max(1, COConfigurationManager.getIntParameter("Tracker Max Threads"));
    public static final long PROCESSING_GET_LIMIT = Math.max(0, COConfigurationManager.getIntParameter("Tracker Max GET Time") * 1000);
    public static final int PROCESSING_POST_MULTIPLIER = Math.max(0, COConfigurationManager.getIntParameter("Tracker Max POST Time Multiplier"));
    private final boolean ssl;
    private int port;
    private final boolean apply_ip_filter;
    private boolean restrict_non_blocking_requests = TRTrackerServerImpl.restrict_non_blocking_requests;
    private final ThreadPool thread_pool;
    static boolean LOG_DOS_TO_FILE = System.getProperty(SystemProperties.SYSPROP_LOG_DOS) != null;
    protected static File dos_log_file;
    protected static final AEMonitor class_mon;
    final Map DOS_map = new LinkedHashMap(1000, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return TRTrackerServerTCP.this.checkDOSRemove(eldest);
        }
    };
    final List dos_list = new ArrayList(128);
    long last_dos_check = 0L;
    static final long MAX_DOS_ENTRIES = 10000L;
    static final long MAX_DOS_RETENTION = 10000L;
    static final int DOS_CHECK_DEAD_WOOD_COUNT = 512;
    static final int DOS_MIN_INTERVAL = 1000;
    int dos_check_count = 0;

    static {
        class_mon = new AEMonitor("TRTrackerServerTCP:class");
    }

    public TRTrackerServerTCP(String _name, int _port, boolean _ssl, boolean _apply_ip_filter, boolean _start_up_ready) throws TRTrackerServerException {
        super(_name, _start_up_ready);
        this.port = _port;
        this.ssl = _ssl;
        this.apply_ip_filter = _apply_ip_filter;
        this.thread_pool = new ThreadPool("TrackerServer:TCP:" + this.port, THREAD_POOL_SIZE);
        if (PROCESSING_GET_LIMIT > 0L) {
            this.thread_pool.setExecutionLimit(PROCESSING_GET_LIMIT);
        }
    }

    public void runProcessor(TRTrackerServerProcessorTCP processor2) {
        this.thread_pool.run(processor2);
    }

    protected boolean isIPFilterEnabled() {
        return this.apply_ip_filter;
    }

    public boolean getRestrictNonBlocking() {
        return this.restrict_non_blocking_requests;
    }

    public void setRestrictNonBlocking(boolean restrict) {
        this.restrict_non_blocking_requests = restrict;
    }

    protected boolean checkDOS(String ip) throws UnknownHostException {
        boolean res;
        block24: {
            InetAddress inet_address = InetAddress.getByName(ip);
            if (inet_address.isLoopbackAddress() || InetAddress.getLocalHost().equals(inet_address)) {
                return false;
            }
            this.last_dos_check = SystemTime.getCurrentTime();
            DOSEntry entry = (DOSEntry)this.DOS_map.get(ip);
            if (entry == null) {
                entry = new DOSEntry(ip);
                this.DOS_map.put(ip, entry);
                res = false;
            } else {
                boolean bl = res = this.last_dos_check - entry.last_time < 1000L;
                if (res && LOG_DOS_TO_FILE) {
                    this.dos_list.add(entry);
                }
                entry.last_time = this.last_dos_check;
            }
            ++this.dos_check_count;
            if (this.dos_check_count == 512) {
                this.dos_check_count = 0;
                Iterator it = this.DOS_map.values().iterator();
                while (it.hasNext()) {
                    DOSEntry this_entry = (DOSEntry)it.next();
                    if (this.last_dos_check - this_entry.last_time <= 10000L) break;
                    it.remove();
                }
                if (this.dos_list.size() > 0) {
                    try {
                        class_mon.enter();
                        if (dos_log_file == null) {
                            dos_log_file = FileUtil.newFile(System.getProperty("user.dir"), "dos.log");
                        }
                        PrintWriter pw = null;
                        try {
                            try {
                                pw = new PrintWriter(new OutputStreamWriter(FileUtil.newFileOutputStream(dos_log_file, true)));
                                int i = 0;
                                while (i < this.dos_list.size()) {
                                    DOSEntry this_entry = (DOSEntry)this.dos_list.get(i);
                                    String ts = new SimpleDateFormat("HH:mm:ss - ").format(new Date(this_entry.last_time));
                                    pw.println(String.valueOf(ts) + this_entry.ip);
                                    ++i;
                                }
                            }
                            catch (Throwable throwable) {
                                this.dos_list.clear();
                                if (pw == null) break block24;
                                try {
                                    pw.close();
                                }
                                catch (Throwable throwable2) {}
                            }
                        }
                        finally {
                            this.dos_list.clear();
                            if (pw != null) {
                                try {
                                    pw.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }
                    finally {
                        class_mon.exit();
                    }
                }
            }
        }
        return res;
    }

    protected boolean checkDOSRemove(Map.Entry eldest) {
        boolean res = (long)this.DOS_map.size() > 10000L || this.last_dos_check - ((DOSEntry)eldest.getValue()).last_time > 10000L;
        return res;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected void setPort(int _port) {
        this.port = _port;
    }

    @Override
    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    @Override
    public boolean isSSL() {
        return this.ssl;
    }

    protected boolean handleExternalRequest(final TRTrackerServerProcessorTCP processor2, final InetSocketAddress local_address, final InetSocketAddress client_address, final String user, final String url, final URL absolute_url, final String header, final InputStream is, final OutputStream os, final AsyncController async, final boolean[] keep_alive) throws IOException {
        final boolean original_ka = keep_alive[0];
        keep_alive[0] = false;
        for (Object listener : this.listeners) {
            if (!listener.handleExternalRequest(client_address, user, url, absolute_url, header, is, os, async)) continue;
            return true;
        }
        for (Object listener : this.listeners2) {
            TRTrackerServerListener2.ExternalRequest request2;
            if (!listener.handleExternalRequest(request2 = new TRTrackerServerListener2.ExternalRequest(){

                @Override
                public InetSocketAddress getClientAddress() {
                    return client_address;
                }

                @Override
                public InetSocketAddress getLocalAddress() {
                    return local_address;
                }

                @Override
                public String getUser() {
                    return user;
                }

                @Override
                public String getURL() {
                    return url;
                }

                @Override
                public URL getAbsoluteURL() {
                    return absolute_url;
                }

                @Override
                public String getHeader() {
                    return header;
                }

                @Override
                public InputStream getInputStream() {
                    return is;
                }

                @Override
                public OutputStream getOutputStream() {
                    return os;
                }

                @Override
                public AsyncController getAsyncController() {
                    return async;
                }

                @Override
                public boolean canKeepAlive() {
                    return original_ka;
                }

                @Override
                public void setKeepAlive(boolean ka) {
                    keep_alive[0] = original_ka && ka;
                }

                @Override
                public boolean isActive() {
                    return processor2.isActive();
                }
            })) continue;
            return true;
        }
        return false;
    }

    protected class DOSEntry {
        final String ip;
        long last_time;

        protected DOSEntry(String _ip) {
            this.ip = _ip;
            this.last_time = TRTrackerServerTCP.this.last_dos_check;
        }
    }
}

