/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.server.impl;

import com.biglybt.core.tracker.server.TRTrackerServerTorrentStats;
import com.biglybt.core.tracker.server.impl.TRTrackerServerTorrentImpl;

public class TRTrackerServerTorrentStatsImpl
implements TRTrackerServerTorrentStats {
    private final TRTrackerServerTorrentImpl torrent;
    private long announce_count;
    private long scrape_count;
    private long completed_count;
    private long uploaded;
    private long downloaded;
    private long left;
    private long biased_uploaded;
    private long biased_downloaded;
    private long bytes_in;
    private long bytes_out;

    protected TRTrackerServerTorrentStatsImpl(TRTrackerServerTorrentImpl _torrent) {
        this.torrent = _torrent;
    }

    protected void addAnnounce(long ul_diff, long dl_diff, long le_diff, boolean biased_peer) {
        ++this.announce_count;
        this.uploaded += ul_diff < 0L ? 0L : ul_diff;
        this.downloaded += dl_diff < 0L ? 0L : dl_diff;
        this.left += le_diff;
        if (this.left < 0L) {
            this.left = 0L;
        }
        if (biased_peer) {
            this.biased_uploaded += ul_diff < 0L ? 0L : ul_diff;
            this.biased_downloaded += dl_diff < 0L ? 0L : dl_diff;
        }
    }

    protected void removeLeft(long _left) {
        this.left -= _left;
        if (this.left < 0L) {
            this.left = 0L;
        }
    }

    @Override
    public long getAnnounceCount() {
        return this.announce_count;
    }

    protected void addScrape() {
        ++this.scrape_count;
    }

    @Override
    public long getScrapeCount() {
        return this.scrape_count;
    }

    protected void addCompleted() {
        ++this.completed_count;
    }

    @Override
    public long getCompletedCount() {
        return this.completed_count;
    }

    @Override
    public long getUploaded() {
        return this.uploaded;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public long getBiasedUploaded() {
        return this.biased_uploaded;
    }

    @Override
    public long getBiasedDownloaded() {
        return this.biased_downloaded;
    }

    @Override
    public long getAmountLeft() {
        return this.left;
    }

    protected void addXferStats(int in, int out) {
        this.bytes_in += (long)in;
        this.bytes_out += (long)out;
    }

    @Override
    public long getBytesIn() {
        return this.bytes_in;
    }

    @Override
    public long getBytesOut() {
        return this.bytes_out;
    }

    @Override
    public int getSeedCount() {
        return this.torrent.getSeedCount();
    }

    @Override
    public int getLeecherCount() {
        return this.torrent.getLeecherCount();
    }

    @Override
    public int getQueuedCount() {
        return this.torrent.getQueuedCount();
    }

    @Override
    public int getBadNATPeerCount() {
        return this.torrent.getBadNATPeerCount();
    }

    @Override
    public String getString() {
        return "an=" + this.announce_count + ",sc=" + this.scrape_count + ",co=" + this.completed_count + ",le=" + this.getLeecherCount() + ",se=" + this.getSeedCount() + ",q=" + this.getQueuedCount() + ",bi=" + this.bytes_in + ",bo=" + this.bytes_out;
    }
}

