/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionDownloadListener;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.SubscriptionHistory;
import com.biglybt.core.subs.SubscriptionManagerListener;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.SubscriptionScheduler;
import com.biglybt.core.subs.impl.SubscriptionDownloader;
import com.biglybt.core.subs.impl.SubscriptionImpl;
import com.biglybt.core.subs.impl.SubscriptionManagerImpl;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pif.utils.search.SearchProvider;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubscriptionSchedulerImpl
implements SubscriptionScheduler,
SubscriptionManagerListener {
    private static final Object SCHEDULER_NEXT_SCAN_KEY = new Object();
    private static final Object SCHEDULER_FAILED_SCAN_CONSEC_KEY = new Object();
    private static final Object SCHEDULER_FAILED_SCAN_TIME_KEY = new Object();
    private static final int FAIL_INIT_DELAY = 600000;
    private static final int FAIL_MAX_DELAY = 28800000;
    private SubscriptionManagerImpl manager;
    private Map<Subscription, List<AESemaphore>> active_subscription_downloaders = new IdentityHashMap<Subscription, List<AESemaphore>>();
    private Map<String, Long> rate_limit_map = new HashMap<String, Long>();
    private Set<String> active_result_downloaders = new HashSet<String>();
    private ThreadPool result_downloader = new ThreadPool("SubscriptionDownloader", 5, true);
    private boolean schedulng_permitted;
    private TimerEvent schedule_event;
    private boolean schedule_in_progress;
    private long last_schedule;
    private String last_sched_str;

    protected SubscriptionSchedulerImpl(SubscriptionManagerImpl _manager) {
        this.manager = _manager;
        this.manager.addListener(this);
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("Subscriptions Scheduler", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                synchronized (subscriptionSchedulerImpl) {
                    SubscriptionSchedulerImpl.this.schedulng_permitted = true;
                }
                SubscriptionSchedulerImpl.this.calculateSchedule();
            }
        });
        delayed_task.queue();
    }

    @Override
    public void downloadAsync(Subscription subs, boolean is_auto) throws SubscriptionException {
        this.download(subs, is_auto, new SubscriptionDownloadListener(){

            @Override
            public void complete(Subscription subs) {
            }

            @Override
            public void failed(Subscription subs, SubscriptionException error) {
                SubscriptionSchedulerImpl.this.log("Async download of " + subs.getName() + " failed", error);
            }
        });
    }

    @Override
    public void download(final Subscription subs, final boolean is_auto, final SubscriptionDownloadListener listener) {
        new AEThread2("SS:download", true){

            @Override
            public void run() {
                try {
                    SubscriptionSchedulerImpl.this.download(subs, is_auto);
                    listener.complete(subs);
                }
                catch (SubscriptionException e) {
                    listener.failed(subs, e);
                }
                catch (Throwable e) {
                    listener.failed(subs, new SubscriptionException("Download failed", e));
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean download(Subscription subs, boolean is_auto) throws SubscriptionException {
        List<AESemaphore> waiting;
        SubscriptionDownloader downloader;
        AESemaphore sem;
        if (this.manager.isClosing()) {
            throw new SubscriptionException("Not downloading, application is closing");
        }
        String rate_limits = this.manager.getRateLimits().trim();
        Map<Subscription, List<AESemaphore>> map = this.active_subscription_downloaders;
        synchronized (map) {
            List<AESemaphore> waiting2;
            if (rate_limits.length() > 0) {
                try {
                    Engine engine = subs.getEngine();
                    if (engine instanceof WebEngine) {
                        String[] bits;
                        String url_str = ((WebEngine)engine).getSearchUrl(true);
                        String host = new URL(url_str).getHost();
                        String[] stringArray = bits = rate_limits.split(",");
                        int n = bits.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int mins;
                            String lhs;
                            String bit = stringArray[n2];
                            String[] temp = bit.trim().split("=");
                            if (temp.length == 2 && (lhs = temp[0].trim()).equals(host) && (mins = Integer.parseInt(temp[1].trim())) > 0) {
                                long now = SystemTime.getMonotonousTime();
                                Long last = this.rate_limit_map.get(host);
                                if (last != null && now - last < (long)(mins * 60 * 1000)) {
                                    if (!is_auto) throw new SubscriptionException("Rate limiting prevents download from " + host);
                                    return false;
                                }
                                this.rate_limit_map.put(host, now);
                            }
                            ++n2;
                        }
                    }
                }
                catch (SubscriptionException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if ((waiting2 = this.active_subscription_downloaders.get(subs)) != null) {
                sem = new AESemaphore("SS:waiter");
                waiting2.add(sem);
                downloader = null;
            } else {
                sem = null;
                this.active_subscription_downloaders.put(subs, new ArrayList());
                downloader = new SubscriptionDownloader(this.manager, (SubscriptionImpl)subs);
            }
        }
        try {
            if (downloader != null) {
                downloader.download();
            } else {
                sem.reserve();
            }
            if (downloader == null) return true;
        }
        catch (Throwable throwable) {
            if (downloader == null) throw throwable;
            try {
                ((SubscriptionImpl)subs).fireDownloaded();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            Map<Subscription, List<AESemaphore>> map2 = this.active_subscription_downloaders;
            synchronized (map2) {
                waiting = this.active_subscription_downloaders.remove(subs);
                if (waiting == null) throw throwable;
                Iterator<AESemaphore> iterator = waiting.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    AESemaphore waiter = iterator.next();
                    waiter.release();
                }
            }
        }
        try {
            ((SubscriptionImpl)subs).fireDownloaded();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        Map<Subscription, List<AESemaphore>> e = this.active_subscription_downloaders;
        synchronized (e) {
            waiting = this.active_subscription_downloaders.remove(subs);
            if (waiting == null) return true;
            for (AESemaphore waiter : waiting) {
                waiter.release();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(final Subscription subs, final SubscriptionResult original_result) {
        String download_link = original_result.getDownloadLink();
        if (download_link == null) {
            this.log(String.valueOf(subs.getName()) + ": can't download " + original_result.getID() + " as no direct download link available");
            return;
        }
        final String key = String.valueOf(subs.getID()) + ":" + original_result.getID();
        final String dl = download_link;
        Set<String> set = this.active_result_downloaders;
        synchronized (set) {
            if (this.active_result_downloaders.contains(key)) {
                return;
            }
            this.log(String.valueOf(subs.getName()) + ": queued result for download - " + original_result.getID() + "/" + download_link);
            this.active_result_downloaders.add(key);
            this.result_downloader.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    block79: {
                        SubscriptionResult result;
                        boolean success;
                        block72: {
                            success = false;
                            result = null;
                            try {
                                result = subs.getHistory().getResult(original_result.getID());
                                if (result == null) {
                                    SubscriptionSchedulerImpl.this.log(String.valueOf(subs.getName()) + ": result has been deleted - " + original_result.getID());
                                    success = true;
                                    break block72;
                                }
                                if (result.getRead()) {
                                    SubscriptionSchedulerImpl.this.log(String.valueOf(subs.getName()) + ": result already marked as read, skipping - " + result.getID());
                                    success = true;
                                    break block72;
                                }
                                boolean retry = true;
                                boolean use_ref = subs.getHistory().getDownloadWithReferer();
                                boolean tried_ref_switch = false;
                                while (retry) {
                                    retry = false;
                                    try {
                                        try {
                                            Download download;
                                            HashMap<String, Object> options;
                                            String target_resource;
                                            TorrentUtils.setTLSDescription("Subscription: " + subs.getName());
                                            URL original_url = new URL(dl);
                                            AEProxyFactory.PluginProxy plugin_proxy = null;
                                            if (dl.startsWith("tor:")) {
                                                target_resource = dl.substring(4);
                                                original_url = new URL(target_resource);
                                                options = new HashMap<String, Object>();
                                                options.put("peer_networks", new String[]{"Tor"});
                                                plugin_proxy = AEProxyFactory.getPluginProxy("Subscription result download of '" + target_resource + "'", original_url, options, true);
                                                if (plugin_proxy == null) {
                                                    throw new Exception("No Tor plugin proxy available for '" + dl + "'");
                                                }
                                            } else if (dl.startsWith("i2p:")) {
                                                target_resource = dl.substring(4);
                                                original_url = new URL(target_resource);
                                                options = new HashMap();
                                                options.put("peer_networks", new String[]{"I2P"});
                                                options.put("preferred_proxy_type", "HTTP");
                                                options.put("force_proxy", true);
                                                plugin_proxy = AEProxyFactory.getPluginProxy("Subscription result download of '" + target_resource + "'", original_url, options, true);
                                                if (plugin_proxy == null) {
                                                    throw new Exception("No I2P plugin proxy available for '" + dl + "'");
                                                }
                                            }
                                            URL current_url = plugin_proxy == null ? original_url : plugin_proxy.getURL();
                                            TorrentImpl torrent = null;
                                            try {
                                                while (true) {
                                                    try {
                                                        String cookies;
                                                        WebEngine we;
                                                        ResourceDownloaderFactory rdf = StaticUtilities.getResourceDownloaderFactory();
                                                        ResourceDownloader url_rd = rdf.create(current_url, plugin_proxy == null ? null : plugin_proxy.getProxy());
                                                        if (plugin_proxy != null) {
                                                            url_rd.setProperty("URL_HOST", String.valueOf(plugin_proxy.getURLHostRewrite()) + (current_url.getPort() == -1 ? "" : ":" + current_url.getPort()));
                                                        }
                                                        String referer = use_ref ? subs.getReferer() : null;
                                                        UrlUtils.setBrowserHeaders(url_rd, referer);
                                                        Engine engine = subs.getEngine();
                                                        if (engine instanceof WebEngine && (we = (WebEngine)engine).isNeedsAuth() && (cookies = we.getCookies()) != null && cookies.length() > 0) {
                                                            url_rd.setProperty("URL_Cookie", cookies);
                                                        }
                                                        ResourceDownloader mr_rd = rdf.getMetaRefreshDownloader(url_rd);
                                                        InputStream is = mr_rd.download();
                                                        torrent = new TorrentImpl(TOTorrentFactory.deserialiseFromBEncodedInputStream(is));
                                                    }
                                                    catch (Throwable e) {
                                                        if (plugin_proxy == null) {
                                                            HashMap<String, Object> options2 = new HashMap<String, Object>();
                                                            options2.put("preferred_proxy_type", "HTTP");
                                                            plugin_proxy = AEProxyFactory.getPluginProxy("Subscription result download", original_url, options2);
                                                            if (plugin_proxy != null) {
                                                                current_url = plugin_proxy.getURL();
                                                                continue;
                                                            }
                                                        }
                                                        throw e;
                                                    }
                                                    break;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                if (plugin_proxy != null) {
                                                    plugin_proxy.setOK(torrent != null);
                                                }
                                                throw throwable;
                                            }
                                            if (plugin_proxy != null) {
                                                plugin_proxy.setOK(torrent != null);
                                            }
                                            byte[] hash = torrent.getHash();
                                            DownloadManager dm = PluginInitializer.getDefaultInterface().getDownloadManager();
                                            boolean stop_override = subs.getTagID() >= 0L || subs.getHistory().getDownloadNetworks() != null;
                                            boolean auto_start = SubscriptionSchedulerImpl.this.manager.shouldAutoStart(torrent);
                                            SubscriptionSchedulerImpl.this.manager.addPrepareTrigger(hash, new Subscription[]{subs}, new SubscriptionResult[]{result});
                                            try {
                                                File data_location = null;
                                                File torrent_location = null;
                                                if (SubscriptionSchedulerImpl.this.manager.getAddHashDirs()) {
                                                    String torrent_dir;
                                                    String torrent_name = FileUtil.convertOSSpecificChars(torrent.getName(), false);
                                                    String hash_str = ByteFormatter.encodeString(hash).substring(0, 8);
                                                    String data_dir = COConfigurationManager.getStringParameter("Default save path");
                                                    if (data_dir != null && !data_dir.isEmpty()) {
                                                        data_location = FileUtil.newFile(data_dir, String.valueOf(torrent_name) + "_" + hash_str);
                                                    }
                                                    if (COConfigurationManager.getBooleanParameter("Save Torrent Files") && (torrent_dir = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory")) != null && !torrent_dir.isEmpty()) {
                                                        torrent_location = FileUtil.newFile(torrent_dir, String.valueOf(torrent_name) + "_" + hash_str + ".torrent");
                                                        try {
                                                            torrent.writeToFile(torrent_location);
                                                        }
                                                        catch (Throwable e) {
                                                            Debug.out(e);
                                                            torrent_location = null;
                                                        }
                                                    }
                                                }
                                                download = auto_start && !stop_override ? dm.addDownload(torrent, torrent_location, data_location) : dm.addDownloadStopped(torrent, torrent_location, data_location);
                                            }
                                            finally {
                                                SubscriptionSchedulerImpl.this.manager.removePrepareTrigger(hash);
                                            }
                                            SubscriptionSchedulerImpl.this.log(String.valueOf(subs.getName()) + ": added download " + download.getName() + ": auto-start=" + auto_start);
                                            SubscriptionSchedulerImpl.this.manager.prepareDownload(download, new Subscription[]{subs}, new SubscriptionResult[]{result});
                                            subs.addAssociation(hash);
                                            if (auto_start && stop_override) {
                                                download.restart();
                                            }
                                            result.setRead(true);
                                            success = true;
                                            if (tried_ref_switch) {
                                                subs.getHistory().setDownloadWithReferer(use_ref);
                                            }
                                        }
                                        catch (Throwable e) {
                                            SubscriptionSchedulerImpl.this.log(String.valueOf(subs.getName()) + ": Failed to download result " + dl, e);
                                            if (e instanceof TOTorrentException && !tried_ref_switch) {
                                                use_ref = !use_ref;
                                                tried_ref_switch = true;
                                                retry = true;
                                                SubscriptionSchedulerImpl.this.log(String.valueOf(subs.getName()) + ": Retrying " + (use_ref ? "with referer" : "without referer"));
                                            }
                                            TorrentUtils.setTLSDescription(null);
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        TorrentUtils.setTLSDescription(null);
                                        throw throwable;
                                    }
                                    TorrentUtils.setTLSDescription(null);
                                }
                            }
                            catch (Throwable throwable) {
                                block77: {
                                    try {
                                        try {
                                            if (result != null && !success) {
                                                if (dl.startsWith("azplug:") || dl.startsWith("chat:")) {
                                                    result.setRead(true);
                                                } else {
                                                    int rad = SubscriptionSchedulerImpl.this.manager.getAutoDownloadMarkReadAfterDays();
                                                    if (rad > 0) {
                                                        long rad_millis = (long)(rad * 24 * 60 * 60) * 1000L;
                                                        long time_found = result.getTimeFound();
                                                        if (time_found > 0L && time_found + rad_millis < SystemTime.getCurrentTime()) {
                                                            SubscriptionSchedulerImpl.this.log(String.valueOf(subs.getName()) + ": result expired, marking as read - " + result.getID());
                                                            result.setRead(true);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                            Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                                            synchronized (set) {
                                                SubscriptionSchedulerImpl.this.active_result_downloaders.remove(key);
                                            }
                                            SubscriptionSchedulerImpl.this.calculateSchedule();
                                            break block77;
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                                        synchronized (set) {
                                            SubscriptionSchedulerImpl.this.active_result_downloaders.remove(key);
                                        }
                                        SubscriptionSchedulerImpl.this.calculateSchedule();
                                        throw throwable2;
                                    }
                                    Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                                    synchronized (set) {
                                        SubscriptionSchedulerImpl.this.active_result_downloaders.remove(key);
                                    }
                                    SubscriptionSchedulerImpl.this.calculateSchedule();
                                }
                                throw throwable;
                            }
                        }
                        try {
                            try {
                                if (result != null && !success) {
                                    if (dl.startsWith("azplug:") || dl.startsWith("chat:")) {
                                        result.setRead(true);
                                    } else {
                                        int rad = SubscriptionSchedulerImpl.this.manager.getAutoDownloadMarkReadAfterDays();
                                        if (rad > 0) {
                                            long rad_millis = (long)(rad * 24 * 60 * 60) * 1000L;
                                            long time_found = result.getTimeFound();
                                            if (time_found > 0L && time_found + rad_millis < SystemTime.getCurrentTime()) {
                                                SubscriptionSchedulerImpl.this.log(String.valueOf(subs.getName()) + ": result expired, marking as read - " + result.getID());
                                                result.setRead(true);
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                                synchronized (set) {
                                    SubscriptionSchedulerImpl.this.active_result_downloaders.remove(key);
                                }
                                SubscriptionSchedulerImpl.this.calculateSchedule();
                                break block79;
                            }
                        }
                        catch (Throwable throwable) {
                            Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                            synchronized (set) {
                                SubscriptionSchedulerImpl.this.active_result_downloaders.remove(key);
                            }
                            SubscriptionSchedulerImpl.this.calculateSchedule();
                            throw throwable;
                        }
                        Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                        synchronized (set) {
                            SubscriptionSchedulerImpl.this.active_result_downloaders.remove(key);
                        }
                        SubscriptionSchedulerImpl.this.calculateSchedule();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateSchedule() {
        SubscriptionSchedulerImpl subscriptionSchedulerImpl = this;
        synchronized (subscriptionSchedulerImpl) {
            if (!this.schedulng_permitted) {
                return;
            }
            if (this.schedule_in_progress) {
                return;
            }
        }
        SubscriptionImpl[] subs = this.manager.getSubscriptions(true);
        SubscriptionSchedulerImpl subscriptionSchedulerImpl2 = this;
        synchronized (subscriptionSchedulerImpl2) {
            if (!this.schedulng_permitted) {
                return;
            }
            if (this.schedule_in_progress) {
                return;
            }
            long next_ready_time = Long.MAX_VALUE;
            SubscriptionImpl next_ready_subs = null;
            int i = 0;
            while (i < subs.length) {
                SubscriptionImpl sub = subs[i];
                SubscriptionHistory history = sub.getHistory();
                if (history.isEnabled()) {
                    long next_scan = this.getNextScan(sub);
                    sub.setUserData(SCHEDULER_NEXT_SCAN_KEY, new Long(next_scan));
                    if (next_scan < next_ready_time) {
                        next_ready_time = next_scan;
                        next_ready_subs = sub;
                    }
                }
                ++i;
            }
            long old_when = 0L;
            if (this.schedule_event != null) {
                old_when = this.schedule_event.getWhen();
                this.schedule_event.cancel();
                this.schedule_event = null;
            }
            if (next_ready_time < Long.MAX_VALUE) {
                long now = SystemTime.getCurrentTime();
                if ((now < this.last_schedule || now - this.last_schedule < 30000L) && next_ready_time - now < 30000L) {
                    next_ready_time = now + 30000L;
                }
                if (next_ready_time < now) {
                    next_ready_time = now;
                }
                String sched_str = "Calculate : old_time=" + (old_when == 0L ? "none" : new SimpleDateFormat().format(new Date(old_when))) + ", new_time=" + new SimpleDateFormat().format(new Date(next_ready_time)) + ", next_sub=" + next_ready_subs.getName();
                if (this.last_sched_str == null || !sched_str.equals(this.last_sched_str)) {
                    this.last_sched_str = sched_str;
                    this.log(sched_str);
                }
                this.schedule_event = SimpleTimer.addEvent("SS:Scheduler", next_ready_time, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                        synchronized (subscriptionSchedulerImpl) {
                            if (SubscriptionSchedulerImpl.this.schedule_in_progress) {
                                return;
                            }
                            SubscriptionSchedulerImpl.this.schedule_in_progress = true;
                            SubscriptionSchedulerImpl.this.last_schedule = SystemTime.getCurrentTime();
                            SubscriptionSchedulerImpl.this.schedule_event = null;
                        }
                        new AEThread2("SS:Sched", true){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    SubscriptionSchedulerImpl.this.schedule();
                                }
                                catch (Throwable throwable) {
                                    SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                                    synchronized (subscriptionSchedulerImpl) {
                                        SubscriptionSchedulerImpl.this.schedule_in_progress = false;
                                    }
                                    SubscriptionSchedulerImpl.this.calculateSchedule();
                                    throw throwable;
                                }
                                SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                                synchronized (subscriptionSchedulerImpl) {
                                    SubscriptionSchedulerImpl.this.schedule_in_progress = false;
                                }
                                SubscriptionSchedulerImpl.this.calculateSchedule();
                            }
                        }.start();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        Subscription[] subs = this.manager.getSubscriptions(true);
        long now = SystemTime.getCurrentTime();
        subs = (Subscription[])subs.clone();
        SubscriptionSchedulerImpl subscriptionSchedulerImpl = this;
        synchronized (subscriptionSchedulerImpl) {
            Arrays.sort(subs, new Comparator<Subscription>(){

                @Override
                public int compare(Subscription s1, Subscription s2) {
                    Long l2;
                    Long l1 = (Long)s1.getUserData(SCHEDULER_NEXT_SCAN_KEY);
                    if (l1 == (l2 = (Long)s2.getUserData(SCHEDULER_NEXT_SCAN_KEY))) {
                        return 0;
                    }
                    if (l1 == null) {
                        return 1;
                    }
                    if (l2 == null) {
                        return -1;
                    }
                    long diff = l1 - l2;
                    if (diff < 0L) {
                        return -1;
                    }
                    if (diff > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        int i = 0;
        while (i < subs.length) {
            block24: {
                if (this.manager.isClosing()) {
                    return;
                }
                Subscription sub = subs[i];
                SubscriptionHistory history = sub.getHistory();
                if (history.isEnabled()) {
                    long new_last_scan;
                    SubscriptionSchedulerImpl subscriptionSchedulerImpl2 = this;
                    synchronized (subscriptionSchedulerImpl2) {
                        Long scan_due = (Long)sub.getUserData(SCHEDULER_NEXT_SCAN_KEY);
                        if (scan_due == null) {
                            break block24;
                        }
                        long diff = now - scan_due;
                        if (diff < -10000L) {
                            break block24;
                        }
                        sub.setUserData(SCHEDULER_NEXT_SCAN_KEY, null);
                    }
                    long last_scan = history.getLastScanTime();
                    boolean download_attempted = true;
                    try {
                        try {
                            download_attempted = this.download(sub, true);
                        }
                        catch (Throwable throwable) {
                            if (download_attempted) {
                                new_last_scan = history.getLastScanTime();
                                if (new_last_scan == last_scan) {
                                    this.scanFailed(sub);
                                } else {
                                    this.scanSuccess(sub);
                                }
                            }
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        if (download_attempted) {
                            new_last_scan = history.getLastScanTime();
                            if (new_last_scan == last_scan) {
                                this.scanFailed(sub);
                            } else {
                                this.scanSuccess(sub);
                            }
                        }
                        throw throwable;
                    }
                    if (download_attempted) {
                        new_last_scan = history.getLastScanTime();
                        if (new_last_scan == last_scan) {
                            this.scanFailed(sub);
                        } else {
                            this.scanSuccess(sub);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected long getNextScan(Subscription sub) {
        SubscriptionHistory history = sub.getHistory();
        Long fail_count = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY);
        if (fail_count != null) {
            long fail_time = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_TIME_KEY);
            long fails = fail_count;
            long backoff = 600000L;
            int i = 1;
            while ((long)i < fails) {
                if ((backoff <<= 1) > 28800000L) {
                    backoff = 28800000L;
                    break;
                }
                ++i;
            }
            return fail_time + backoff;
        }
        return history.getNextScanTime();
    }

    @Override
    public long getNextUpdateTime(Subscription subs) {
        if (subs.isSubscriptionTemplate() || subs.isSearchTemplate()) {
            return 0L;
        }
        Long next = (Long)subs.getUserData(SCHEDULER_NEXT_SCAN_KEY);
        if (next != null) {
            return next;
        }
        return this.getNextScan(subs);
    }

    protected void scanSuccess(Subscription sub) {
        sub.setUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY, null);
    }

    protected void scanFailed(Subscription sub) {
        sub.setUserData(SCHEDULER_FAILED_SCAN_TIME_KEY, new Long(SystemTime.getCurrentTime()));
        Long fail_count = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY);
        fail_count = fail_count == null ? new Long(1L) : new Long(fail_count + 1L);
        sub.setUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY, fail_count);
    }

    protected void log(String str) {
        this.manager.log("Scheduler: " + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log("Scheduler: " + str, e);
    }

    @Override
    public void subscriptionAdded(Subscription subscription) {
        this.calculateSchedule();
    }

    @Override
    public void subscriptionChanged(Subscription subscription, int reason) {
        this.calculateSchedule();
    }

    @Override
    public void subscriptionSelected(Subscription subscription) {
    }

    @Override
    public void subscriptionRemoved(Subscription subscription) {
        this.calculateSchedule();
    }

    @Override
    public void associationsChanged(byte[] association_hash) {
    }

    @Override
    public void subscriptionRequested(URL url, Map<String, Object> options) {
    }

    public void subscriptionRequested(SearchProvider sp, Map<String, Object> properties) throws SubscriptionException {
    }
}

