/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.impl.SubscriptionHistoryImpl;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SystemTime;
import com.biglybt.util.JSONUtils;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SubscriptionResultImpl
implements SubscriptionResult {
    private static final int TIME_FOUND_DEFAULT_SECS;
    private final SubscriptionHistoryImpl history;
    private byte[] key1;
    private byte[] key2;
    private boolean read;
    private boolean deleted;
    private int deleted_last_seen_day;
    private int time_found_secs;
    private String result_json;
    private WeakReference<Map<Integer, Object>> props_ref = null;

    static {
        int tfd = COConfigurationManager.getIntParameter("subscription.result.time.found.default", 0);
        if (tfd == 0) {
            tfd = (int)(SystemTime.getCurrentTime() / 1000L);
            COConfigurationManager.setParameter("subscription.result.time.found.default", tfd);
        }
        TIME_FOUND_DEFAULT_SECS = tfd;
    }

    protected SubscriptionResultImpl(SubscriptionHistoryImpl _history, Result result) {
        this.history = _history;
        Map map = result.toJSONMap();
        this.result_json = JSONUtils.encodeToJSON(map);
        this.read = false;
        String key1_str = String.valueOf(result.getEngine().getId()) + ":" + result.getName();
        try {
            byte[] sha1 = new SHA1Simple().calculateHash(key1_str.getBytes("UTF-8"));
            this.key1 = new byte[10];
            System.arraycopy(sha1, 0, this.key1, 0, 10);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        String uid = result.getUID();
        if (uid != null && uid.length() > 0) {
            String key2_str = String.valueOf(result.getEngine().getId()) + ":" + uid;
            try {
                byte[] sha1 = new SHA1Simple().calculateHash(key2_str.getBytes("UTF-8"));
                this.key2 = new byte[10];
                System.arraycopy(sha1, 0, this.key2, 0, 10);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        try {
            String tf = (String)map.get("tf");
            this.time_found_secs = tf != null ? Integer.parseInt(tf) : TIME_FOUND_DEFAULT_SECS;
        }
        catch (Throwable e) {
            this.time_found_secs = TIME_FOUND_DEFAULT_SECS;
        }
    }

    protected SubscriptionResultImpl(SubscriptionHistoryImpl _history, SearchSubsResultBase _base) {
        this.history = _history;
        byte[] hash = _base.getHash();
        String name = _base.getName();
        long size = _base.getSize();
        String key1_str = hash != null ? Base32.encode(hash) : String.valueOf(name) + ":" + size;
        try {
            byte[] sha1 = new SHA1Simple().calculateHash(key1_str.getBytes("UTF-8"));
            this.key1 = new byte[10];
            System.arraycopy(sha1, 0, this.key1, 0, 10);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("lb", String.valueOf(size));
        map.put("n", name);
        if (hash != null) {
            map.put("h", Base32.encode(hash));
        }
        this.time_found_secs = (int)(SystemTime.getCurrentTime() / 1000L);
        map.put("tf", String.valueOf(this.time_found_secs));
        this.result_json = JSONUtils.encodeToJSON(map);
        this.read = true;
    }

    protected SubscriptionResultImpl(SubscriptionHistoryImpl _history, Map map) {
        this.history = _history;
        this.key1 = (byte[])map.get("key");
        this.key2 = (byte[])map.get("key2");
        this.read = ((Long)map.get("read")).intValue() == 1;
        Long l_deleted = (Long)map.get("deleted");
        if (l_deleted != null) {
            this.deleted = true;
            Number l_dls = (Number)map.get("dls");
            this.deleted_last_seen_day = l_dls != null ? l_dls.intValue() : (int)(SystemTime.getCurrentTime() / 86400000L);
        } else {
            try {
                this.result_json = new String((byte[])map.get("result_json"), "UTF-8");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                Number tfs = (Number)map.get("tz");
                if (tfs != null) {
                    this.time_found_secs = tfs.intValue();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateFrom(SubscriptionResultImpl other, boolean allow_reincarnation) {
        String my_ts;
        List my_tags;
        String other_json_str;
        if (this.deleted) {
            if (allow_reincarnation) {
                this.deleted = false;
                this.deleted_last_seen_day = 0;
                this.key2 = other.getKey2();
                this.result_json = other.getJSON();
                this.time_found_secs = other.time_found_secs;
                SubscriptionResultImpl subscriptionResultImpl = this;
                synchronized (subscriptionResultImpl) {
                    this.props_ref = null;
                }
                return true;
            }
            this.deleted_last_seen_day = (int)(SystemTime.getCurrentTime() / 86400000L);
            return false;
        }
        String my_json_str = this.getJSON();
        if (my_json_str.equals(other_json_str = other.getJSON())) {
            return false;
        }
        Map my_json_map = JSONUtils.decodeJSON(my_json_str);
        String my_tf = (String)my_json_map.get("tf");
        Map other_json_map = null;
        boolean other_json_map_updated = false;
        if (my_tf != null) {
            other_json_map = JSONUtils.decodeJSON(other_json_str);
            other_json_map.put("tf", my_tf);
            other_json_map_updated = true;
        }
        if ((my_tags = (List)my_json_map.get("tgs")) != null && !my_tags.isEmpty()) {
            boolean other_has_tgs = other_json_str.contains("\"tgs\"");
            if (other_has_tgs) {
                boolean updated = false;
                if (other_json_map == null) {
                    other_json_map = JSONUtils.decodeJSON(other_json_str);
                }
                List other_tags = (List)other_json_map.get("tgs");
                for (String t : my_tags) {
                    if (other_tags.contains(t)) continue;
                    other_tags.add(t);
                    updated = true;
                }
                if (updated) {
                    other_json_map.put("tgs", other_tags);
                    other_json_map_updated = true;
                }
            } else {
                if (other_json_map == null) {
                    other_json_map = JSONUtils.decodeJSON(other_json_str);
                }
                other_json_map.put("tgs", my_tags);
                other_json_map_updated = true;
            }
        }
        if ((my_ts = (String)my_json_map.get("ts")) != null) {
            if (other_json_map == null) {
                other_json_map = JSONUtils.decodeJSON(other_json_str);
            }
            String other_ts = (String)other_json_map.get("ts");
            boolean keep = false;
            if (other_ts == null) {
                keep = true;
            } else {
                try {
                    long l_my_ts = Long.parseLong(my_ts);
                    long l_other_ts = Long.parseLong(other_ts);
                    keep = l_my_ts != 0L && (l_other_ts == 0L || l_my_ts < l_other_ts);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (keep) {
                other_json_map.put("ts", my_ts);
                other_json_map_updated = true;
            }
        }
        if (other_json_map_updated) {
            other_json_str = JSONUtils.encodeToJSON(other_json_map);
        }
        if (my_json_str.equals(other_json_str)) {
            return false;
        }
        this.key2 = other.getKey2();
        this.result_json = other_json_str;
        SubscriptionResultImpl subscriptionResultImpl = this;
        synchronized (subscriptionResultImpl) {
            this.props_ref = null;
        }
        return true;
    }

    @Override
    public String getID() {
        return Base32.encode(this.key1);
    }

    protected byte[] getKey1() {
        return this.key1;
    }

    protected byte[] getKey2() {
        return this.key2;
    }

    @Override
    public boolean getRead() {
        return this.read;
    }

    @Override
    public void setRead(boolean _read) {
        if (this.read != _read) {
            this.read = _read;
            this.history.updateResult(this);
        }
    }

    protected void setReadInternal(boolean _read) {
        this.read = _read;
    }

    @Override
    public void delete() {
        if (!this.deleted) {
            this.deleted = true;
            this.deleted_last_seen_day = (int)(SystemTime.getCurrentTime() / 86400000L);
            this.history.updateResult(this);
        }
    }

    protected void deleteInternal() {
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    protected int getDeletedLastSeen() {
        return this.deleted_last_seen_day;
    }

    protected Map toBEncodedMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", this.key1);
        if (this.key2 != null) {
            map.put("key2", this.key2);
        }
        map.put("read", new Long(this.read ? 1 : 0));
        if (this.deleted) {
            map.put("deleted", new Long(1L));
            if (this.deleted_last_seen_day == 0) {
                this.deleted_last_seen_day = (int)(SystemTime.getCurrentTime() / 86400000L);
            }
            map.put("dls", this.deleted_last_seen_day);
        } else {
            try {
                map.put("result_json", this.result_json.getBytes("UTF-8"));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            if (this.time_found_secs == 0) {
                this.getTimeFound();
            }
            if (this.time_found_secs > 0) {
                map.put("tz", new Long(this.time_found_secs));
            }
        }
        return map;
    }

    @Override
    public Map toJSONMap() {
        Map map = JSONUtils.decodeJSON(this.result_json);
        map.put("subs_is_read", this.read);
        map.put("subs_id", this.getID());
        Result.adjustRelativeTerms(map);
        String size = (String)map.get("l");
        if (size != null) {
            size = DisplayFormatters.trimDigits(size, 3);
            map.put("l", size);
        }
        return map;
    }

    private String getJSON() {
        return this.result_json;
    }

    @Override
    public String getDownloadLink() {
        String dl_link;
        Map map = this.toJSONMap();
        String link = (String)map.get("dbl");
        if (link != null && link.toLowerCase(Locale.US).startsWith("magnet:") && (dl_link = (String)map.get("dl")) != null) {
            link = dl_link;
        }
        if (link == null) {
            link = (String)map.get("dl");
        }
        return Result.adjustLink(link);
    }

    @Override
    public String getPlayLink() {
        return Result.adjustLink((String)this.toJSONMap().get("pl"));
    }

    @Override
    public String getAssetHash() {
        return (String)this.toJSONMap().get("h");
    }

    @Override
    public long getTimeFound() {
        if (this.time_found_secs == 0) {
            String tfs = (String)this.toJSONMap().get("tf");
            this.time_found_secs = tfs == null ? TIME_FOUND_DEFAULT_SECS : Integer.parseInt(tfs);
        }
        return (long)this.time_found_secs * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Object> toPropertyMap() {
        SubscriptionResultImpl subscriptionResultImpl = this;
        synchronized (subscriptionResultImpl) {
            String ad;
            String contentType;
            List tags;
            String hash;
            String cdp_link;
            String size;
            Map cached;
            if (this.props_ref != null && (cached = (Map)this.props_ref.get()) != null) {
                return cached;
            }
            Map map = this.toJSONMap();
            HashMap<Integer, Object> result = new HashMap<Integer, Object>();
            String title = (String)map.get("n");
            result.put(20, this.getID());
            result.put(1, title);
            String pub_date = (String)map.get("ts");
            if (pub_date != null) {
                result.put(2, new Date(Long.parseLong(pub_date)));
            }
            if ((size = (String)map.get("lb")) != null) {
                result.put(3, Long.parseLong(size));
            }
            String dbl_link = (String)map.get("dbl");
            String dl_link = (String)map.get("dl");
            if (dbl_link == null) {
                dbl_link = dl_link;
            }
            if (dbl_link != null) {
                result.put(12, Result.adjustLink(dbl_link));
            }
            if (dl_link != null) {
                result.put(23, Result.adjustLink(dl_link));
            }
            if ((cdp_link = (String)map.get("cdp")) != null) {
                result.put(11, Result.adjustLink(cdp_link));
            }
            if ((hash = (String)map.get("h")) != null) {
                result.put(21, Base32.decode(hash));
            }
            String seeds = (String)map.get("s");
            result.put(5, seeds == null ? -1L : Long.parseLong(seeds));
            String peers = (String)map.get("p");
            result.put(4, peers == null ? -1L : Long.parseLong(peers));
            String votes = (String)map.get("v");
            result.put(9, votes == null ? -1L : Long.parseLong(votes));
            String comments = (String)map.get("co");
            result.put(8, comments == null ? -1L : Long.parseLong(comments));
            String rank = (String)map.get("r");
            result.put(17, rank == null ? -1L : (long)(100.0f * Float.parseFloat(rank)));
            String category = (String)map.get("c");
            if (category != null) {
                result.put(7, category);
            }
            if ((tags = (List)map.get("tgs")) != null && !tags.isEmpty()) {
                result.put(25, tags.toArray(new String[tags.size()]));
            }
            if ((contentType = (String)map.get("ct")) != null) {
                result.put(10, contentType);
            }
            if ((ad = (String)map.get("ad")) != null) {
                result.put(24, new Date(Long.parseLong(ad)));
            }
            this.props_ref = new WeakReference(result);
            return result;
        }
    }
}

